/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.GLMTargetValuesPanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.ExceptionDialog;

public class ModelGLMBuildSettingsPanel
extends AbstractPropertiesDialogPanel {
    private JButton jBtnEdit;
    private JCheckBox jChkDiagnosticTable;
    private JCheckBox jChkEnableRidgeRegr;
    private JCheckBox jChkProduceVIF;
    private JCheckBox jChkRowWeights;
    private JComboBox jCmbMissValueTreatment;
    private JComboBox jCmbRowWeights;
    private JLabel jLabel1;
    private JLabel jLabelRidgeValue;
    private JLabel jLblConfLevel;
    private JLabel jLblMissigValueTreat;
    private JLabel jLblRefClassName;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTxtConfidenceLevel;
    private JTextField jTxtRidgeValue;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private static String _empty = DialogsLrb.get("GLM_ROW_WEIGHT_COLUMN_NAME_EMPTY");
    private static String _meanMode = DialogsLrb.get("GLM_MISSING_VALUES_COLUMN_MEAN_MODE");
    private static String _deleteRow = DialogsLrb.get("GLM_MISSING_VALUES_COLUMN_DELETE_ROW");
    private static HashMap<String, String> _missingValTreatmentDef = new HashMap();

    public ModelGLMBuildSettingsPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jLblConfLevel = new JLabel();
        this.jTxtConfidenceLevel = new NumberTextField();
        this.jLblRefClassName = new JLabel();
        this.jChkEnableRidgeRegr = new JCheckBox();
        this.jLabelRidgeValue = new JLabel();
        this.jTxtRidgeValue = new NumberTextField();
        this.jChkProduceVIF = new JCheckBox();
        this.jScrollPaneTitle = new JScrollPane();
        this.jBtnEdit = new JButton();
        this.jLabel1 = new JLabel();
        this.jLblMissigValueTreat = new JLabel();
        this.jCmbMissValueTreatment = new JComboBox();
        this.jCmbRowWeights = new JComboBox();
        this.jChkRowWeights = new JCheckBox();
        this.jChkDiagnosticTable = new JCheckBox();
        this.jLblConfLevel.setText("Confidence Level:");
        this.jTxtConfidenceLevel.setText("0.95");
        this.jLblRefClassName.setText("Reference Class name:");
        this.jChkEnableRidgeRegr.setText("Enable Ridge Regression");
        this.jChkEnableRidgeRegr.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkEnableRidgeRegr.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelRidgeValue.setText("Ridge Value:");
        this.jChkProduceVIF.setText("Produce Variance Inflation Factor");
        this.jChkProduceVIF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkProduceVIF.setMargin(new Insets(0, 0, 0, 0));
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jBtnEdit.setText("Edit");
        this.jLabel1.setText("<System defined>");
        this.jLblMissigValueTreat.setText("Missing Value Treatment:");
        this.jCmbMissValueTreatment.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCmbRowWeights.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jChkRowWeights.setText("Specify Row Weight");
        this.jChkRowWeights.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jChkDiagnosticTable.setText("Diagnostic Table Name");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jCmbRowWeights, -2, 209, -2)).addGroup(groupLayout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jLabelRidgeValue, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtRidgeValue, -2, 149, -2)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jChkEnableRidgeRegr, -2, 147, -2)).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jChkRowWeights, -2, 181, -2)).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jChkDiagnosticTable, -2, 159, -2)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jChkProduceVIF, -2, 215, -2)).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblConfLevel, -2, 141, -2).addComponent(this.jLblRefClassName).addComponent(this.jLblMissigValueTreat, -2, 130, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnEdit)).addComponent(this.jTxtConfidenceLevel, -2, 129, -2).addComponent(this.jCmbMissValueTreatment, 0, -1, Short.MAX_VALUE)).addGap(34, 34, 34)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -1, 351, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jChkDiagnosticTable, this.jChkRowWeights);
        groupLayout.linkSize(0, this.jLblConfLevel, this.jLblRefClassName);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkDiagnosticTable).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblConfLevel).addComponent(this.jTxtConfidenceLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblRefClassName).addComponent(this.jLabel1).addComponent(this.jBtnEdit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblMissigValueTreat).addComponent(this.jCmbMissValueTreatment, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkRowWeights).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCmbRowWeights, -2, -1, -2).addGap(16, 16, 16).addComponent(this.jChkEnableRidgeRegr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRidgeValue).addComponent(this.jTxtRidgeValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkProduceVIF).addContainerGap(20, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jChkDiagnosticTable, this.jChkRowWeights, this.jLblConfLevel, this.jLblMissigValueTreat, this.jLblRefClassName);
    }

    @Override
    protected final ModelPropertiesState getState() {
        return (ModelPropertiesState)super.getState();
    }

    private void initUI() {
        boolean bl;
        Object object;
        Serializable serializable;
        final ModelPropertiesState modelPropertiesState = this.getState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        this.jChkDiagnosticTable.setText(DialogsLrb.get("GLM_DIAGNOSTIC_TABLE_NAME"));
        this.jLblConfLevel.setText(DialogsLrb.get("GLM_CONFIDENCE_LEVEL"));
        this.jLblRefClassName.setText(DialogsLrb.get("GLM_REFERENCE_CLASS_NAME"));
        this.jLabelRidgeValue.setText(DialogsLrb.get("GLM_RIDGE_VALUE"));
        this.jChkEnableRidgeRegr.setText(DialogsLrb.get("GLM_ENABLE_RIDGE_REGRESSION"));
        this.jChkProduceVIF.setText(DialogsLrb.get("GLM_PRODUCE_VIF"));
        this.jLblMissigValueTreat.setText(DialogsLrb.get("GLM_MISSING_VALUES_COLUMN_LABEL"));
        this.jCmbMissValueTreatment.setModel(new DefaultComboBoxModel<String>(new String[]{_meanMode, _deleteRow}));
        String string = modelPropertiesState.getModelSettingStringValue("ODMS_MISSING_VALUE_TREATMENT");
        this.jCmbMissValueTreatment.setSelectedItem(string);
        modelPropertiesState.setBackupValue("ODMS_MISSING_VALUE_TREATMENT", string);
        this.jLblMissigValueTreat.setLabelFor(this.jCmbMissValueTreatment);
        this.jCmbMissValueTreatment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.jChkRowWeights.setText(DialogsLrb.get("GLM_ROW_WIGHTS_COLUMN_LABEL"));
        List<AttributeType> list = modelPropertiesState.getAttributes();
        if (list != null && list.size() > 0) {
            boolean bl2;
            serializable = new HashMap<String, AttributeType>();
            object = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                AttributeType attributeType = list.get(i);
                ((HashMap)serializable).put(attributeType.getName(), attributeType);
                object[i] = attributeType.getName();
            }
            this.jCmbRowWeights.setModel(new DefaultComboBoxModel<String>((E[])object));
            String string2 = modelPropertiesState.getModelSettingStringValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
            boolean bl3 = bl2 = string2 == null || string2.isEmpty();
            if (bl2) {
                modelPropertiesState.setBackupNullValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
            } else {
                modelPropertiesState.setBackupValue("ODMS_ROW_WEIGHT_COLUMN_NAME", string2);
                this.jCmbRowWeights.setSelectedItem(string2);
            }
            this.jCmbRowWeights.setEnabled(!bl2);
            this.jChkRowWeights.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelGLMBuildSettingsPanel.this.jCmbRowWeights.setEnabled(ModelGLMBuildSettingsPanel.this.jChkRowWeights.isSelected());
                }
            });
        } else {
            this.jChkRowWeights.setEnabled(false);
            this.jCmbRowWeights.setModel(new DefaultComboBoxModel<String>(new String[]{_empty}));
            this.jCmbRowWeights.setEnabled(false);
        }
        this.jLblConfLevel.setLabelFor(this.jTxtConfidenceLevel);
        this.jTxtConfidenceLevel.setToolTipText(DialogsLrb.get("GLM_CONFIDENCE_LEVEL_TOOLTIP"));
        this.setDataType(this.jTxtConfidenceLevel, Double.class);
        this.setSigned(this.jTxtConfidenceLevel, true);
        this.setLocale(this.jTxtConfidenceLevel, Locale.getDefault());
        serializable = modelPropertiesState.getModelSettingNumValue("GLMS_CONF_LEVEL");
        object = new Double(((BigDecimal)serializable).doubleValue());
        modelPropertiesState.setBackupValue("GLMS_CONF_LEVEL", object);
        this.setNumber(this.jTxtConfidenceLevel, (Number)object);
        boolean bl4 = false;
        String string3 = modelPropertiesState.getModelSettingStringValue("GLMS_DIAGNOSTICS_TABLE_NAME");
        try {
            bl4 = Boolean.valueOf(string3);
        }
        catch (Exception exception) {
            bl4 = false;
        }
        modelPropertiesState.setBackupValue("GLMS_DIAGNOSTICS_TABLE_NAME", bl4);
        if (modelPropertiesState.isCaseIdSelected()) {
            this.jChkDiagnosticTable.setSelected(bl4);
        } else {
            this.jChkDiagnosticTable.setEnabled(false);
        }
        String string4 = modelPropertiesState.getModelSettingStringValue("GLMS_REFERENCE_CLASS_NAME");
        if (string4 != null) {
            modelPropertiesState.setBackupValue("GLMS_REFERENCE_CLASS_NAME", string4);
            this.jLabel1.setText(string4);
        } else {
            modelPropertiesState.setBackupNullValue("GLMS_REFERENCE_CLASS_NAME");
            this.jLabel1.setText(ModelPropertiesState.DEFAULT_CLASS_REF_NAME);
        }
        this.jBtnEdit.setText(DialogsLrb.get("GLM_REFERENCE_CLASS_NAME_EDIT"));
        this.jBtnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferenceClassDialog referenceClassDialog = new ReferenceClassDialog();
                if (referenceClassDialog.invoke()) {
                    ModelGLMBuildSettingsPanel.this.jLabel1.setText(modelPropertiesState.getCurClassRefValue());
                }
            }
        });
        string3 = modelPropertiesState.getModelSettingStringValue("GLMS_RIDGE_REGRESSION");
        modelPropertiesState.setBackupValue("GLMS_RIDGE_REGRESSION", string3);
        this.setDataType(this.jTxtRidgeValue, Double.class);
        this.setSigned(this.jTxtRidgeValue, true);
        this.setLocale(this.jTxtRidgeValue, Locale.getDefault());
        boolean bl5 = string3.equals("GLMS_RIDGE_REG_ENABLE");
        this.jChkEnableRidgeRegr.setEnabled(true);
        this.jChkEnableRidgeRegr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Number number = null;
                if (ModelGLMBuildSettingsPanel.this.jChkEnableRidgeRegr.isSelected()) {
                    number = ModelGLMBuildSettingsPanel.this.getNumber(ModelGLMBuildSettingsPanel.this.jTxtRidgeValue);
                    if (number == null) {
                        number = modelPropertiesState.getModelSettingNumValue("GLMS_RIDGE_VALUE");
                    }
                    ModelGLMBuildSettingsPanel.this.setNumber(ModelGLMBuildSettingsPanel.this.jTxtRidgeValue, number);
                    ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(true);
                    ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(true);
                } else {
                    ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(false);
                    ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(false);
                }
                if (number != null) {
                    modelPropertiesState.setBackupValue("GLMS_RIDGE_VALUE", number);
                }
            }
        });
        BigDecimal bigDecimal = null;
        if (bl5) {
            bigDecimal = modelPropertiesState.getModelSettingNumValue("GLMS_RIDGE_VALUE");
            if (bigDecimal != null) {
                this.setNumber(this.jTxtRidgeValue, bigDecimal);
                modelPropertiesState.setBackupValue("GLMS_RIDGE_VALUE", bigDecimal);
            } else {
                modelPropertiesState.setBackupNullValue("GLMS_RIDGE_VALUE");
            }
            bl = bigDecimal != null;
            this.jChkEnableRidgeRegr.setSelected(bl5 && bl);
            this.jTxtRidgeValue.setEnabled(bl5 && bl);
            this.jLabelRidgeValue.setEnabled(bl5 && bl);
        }
        string3 = modelPropertiesState.getModelSettingStringValue("GLMS_VIF_FOR_RIDGE");
        modelPropertiesState.setBackupValue("GLMS_VIF_FOR_RIDGE", string3);
        bl = string3.equals("GLMS_VIF_RIDGE_ENABLE");
        this.jChkProduceVIF.setSelected(bl);
    }

    @Override
    public void processInput() {
        ModelPropertiesState modelPropertiesState = this.getState();
        Boolean bl = this.jChkDiagnosticTable.isSelected();
        modelPropertiesState.setValue("GLMS_DIAGNOSTICS_TABLE_NAME", bl);
        Number number = this.getNumber(this.jTxtConfidenceLevel);
        if (null == number || number.intValue() < 0 || number.intValue() > 1) {
            modelPropertiesState.setValidationError(DialogsLrb.get("GLM_CONFIDENCE_LEVEL_INVALID"));
            return;
        }
        modelPropertiesState.setValue("GLMS_CONF_LEVEL", number);
        String string = this.jLabel1.getText();
        if (string.equals(ModelPropertiesState.DEFAULT_CLASS_REF_NAME)) {
            modelPropertiesState.setNullValue("GLMS_REFERENCE_CLASS_NAME");
        } else {
            modelPropertiesState.setValue("GLMS_REFERENCE_CLASS_NAME", string);
        }
        boolean bl2 = this.jChkEnableRidgeRegr.isSelected();
        String string2 = bl2 ? "GLMS_RIDGE_REG_ENABLE" : "GLMS_RIDGE_REG_DISABLE";
        modelPropertiesState.setValue("GLMS_RIDGE_REGRESSION", string2);
        if (bl2) {
            number = this.getNumber(this.jTxtRidgeValue);
            if (number == null || number.doubleValue() < 0.0) {
                modelPropertiesState.setValidationError(DialogsLrb.get("GLM_RIDGE_VALUE_INVALID"));
                return;
            }
            if (number != null) {
                modelPropertiesState.setValue("GLMS_RIDGE_VALUE", number);
            } else {
                modelPropertiesState.setNullValue("GLMS_RIDGE_VALUE");
            }
        } else {
            modelPropertiesState.setNullValue("GLMS_RIDGE_VALUE");
        }
        string2 = this.jChkProduceVIF.isSelected() ? "GLMS_VIF_RIDGE_ENABLE" : "GLMS_VIF_RIDGE_DISABLE";
        modelPropertiesState.setValue("GLMS_VIF_FOR_RIDGE", string2);
        string2 = (String)this.jCmbMissValueTreatment.getSelectedItem();
        modelPropertiesState.setValue("ODMS_MISSING_VALUE_TREATMENT", _missingValTreatmentDef.get(string2));
        if (this.jChkRowWeights.isSelected()) {
            string2 = (String)this.jCmbRowWeights.getSelectedItem();
            modelPropertiesState.setValue("ODMS_ROW_WEIGHT_COLUMN_NAME", string2);
        } else {
            modelPropertiesState.setNullValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
        }
    }

    static {
        _missingValTreatmentDef.put(_meanMode, "ODMS_MISSING_VALUE_MEAN_MODE");
        _missingValTreatmentDef.put(_deleteRow, "ODMS_MISSING_VALUE_DELETE_ROW");
    }

    class ReferenceClassDialog {
        protected String wizName = "Reference value in a logistic regression model";

        protected JEWTDialog buildDialog() {
            GLMTargetValuesPanel gLMTargetValuesPanel = new GLMTargetValuesPanel(ModelGLMBuildSettingsPanel.this.getState());
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)gLMTargetValuesPanel);
            jEWTDialog.setTitle(this.getDialogTitle());
            return jEWTDialog;
        }

        private String getDialogTitle() {
            return DialogsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_TITLE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                final GLMTargetValuesPanel gLMTargetValuesPanel = (GLMTargetValuesPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !gLMTargetValuesPanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_TITLE"), (String)DialogsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }
    }
}

