/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.SchemaChooserTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.MiningFunctionOptions;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelTableModel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelNodeEditorPreferenceSettings;
import oracle.dmt.dataminer.workflow.dialog.model.TargetValuesDialog;
import oracle.dmt.dataminer.workflow.inspect.ModelNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class EditModelNodePanel
extends AbstractDialogPanel {
    private Context _context;
    private PropertyModel _model;
    private AbstractModelNode _node;
    private boolean _dirty = false;
    private boolean _selectionsBusy = false;
    private Component _findPane;
    private GenericTable jSelectedModels = new GenericTable();
    private GenericTable jAvailModels = new GenericTable();
    private EditModelTableModel _availModelsTableModel;
    private EditModelTableModel _filteredAvailModelsTableModel;
    private EditModelTableModel _selectedModelsTableModel;
    private Connection _dbConn;
    private String _ownerName;
    private ArrayList<String> _targetValuesStrings = new ArrayList();
    private ArrayList<Double> _targetValuesNumbers = new ArrayList();
    private static Icon _built_icon;
    private static Icon _invalid_icon;
    private static Preferences _p;
    private ModelNodeEditorPreferenceSettings _modelNodeEditorPreferenceSettings = ModelNodeEditorPreferenceSettings.getInstance((PropertyStorage)_p);
    public static final int SEARCH_FULL_NAME = 0;
    public static final int SEARCH_MODEL_NAME = 1;
    public static final int SEARCH_SCHEMA_NAME = 2;
    public static final int SEARCH_FUNCTION = 3;
    public static final int SEARCH_ALGORITHM = 4;
    public static final int SEARCH_TARGET_NAME = 5;
    public static final int SEARCH_TARGET_DATA_TYPE = 6;
    public static final int SEARCH_COMMENTS = 7;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_MODEL"));
    private SearchField _jFilterCtl = new SearchField();
    private static Icon _select;
    private static Icon _selectAll;
    private static Icon _remove;
    private static Icon _removeAll;
    private MiningFunctionOptions _currentFunctionOption = MiningFunctionOptions.ALL;
    private ComponentWithTitlebar<JComponent> _jAvailableModelsComponent;
    private JCheckBox _jChkIncludeAllSchemas;
    private JLabel _jComboFunctionLabel;
    private JComboBox _jComboModelFunctions;
    private PropertyLabel _jMiningFunctionLabel;
    private JTextField _jMiningFunctionValue;
    private ComponentWithTitlebar<JComponent> _jSelectedModelsComponent;
    private PropertyLabel _jTargetAttributeLabel;
    private JTextField _jTargetAttributeValue;
    private JLabel _jTargetDataTypeLabel;
    private JTextField _jTargetDataTypeValue;
    private JButton _jTargetValuesButton;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;

    public EditModelNodePanel(JEWTDialog jEWTDialog, Context context, AbstractModelNode abstractModelNode, PropertyModel propertyModel) {
        super(context, abstractModelNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractModelNode != null) : "Model Node must not be null.";
        assert (abstractModelNode instanceof ModelNode) : "Must be an instance of model node.";
        this._context = context;
        this._model = propertyModel;
        this._node = abstractModelNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jComboFunctionLabel = new JLabel();
        this._jComboModelFunctions = new JComboBox();
        this._jMiningFunctionLabel = new PropertyLabel();
        this._jMiningFunctionValue = new JTextField();
        this._jTargetAttributeLabel = new PropertyLabel();
        this._jTargetAttributeValue = new JTextField();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this._jChkIncludeAllSchemas = new JCheckBox();
        this._jTargetDataTypeLabel = new JLabel();
        this._jTargetDataTypeValue = new JTextField();
        this._jAvailableModelsComponent = new ComponentWithTitlebar();
        this._jSelectedModelsComponent = new ComponentWithTitlebar();
        this._jTargetValuesButton = new JButton();
        this._jComboFunctionLabel.setText("Model Function:");
        this._jComboModelFunctions.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jMiningFunctionLabel.setText("Function:");
        this._jMiningFunctionValue.setEditable(false);
        this._jMiningFunctionValue.setText("Classification");
        this._jMiningFunctionValue.setBorder(null);
        this._jTargetAttributeLabel.setText("Target:");
        this._jTargetAttributeValue.setEditable(false);
        this._jTargetAttributeValue.setText("Churn");
        this._jTargetAttributeValue.setBorder(null);
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this._jChkIncludeAllSchemas.setText("Include Models from Other Schemas");
        this._jChkIncludeAllSchemas.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jChkIncludeAllSchemas.setMargin(new Insets(0, 0, 0, 0));
        this._jTargetDataTypeLabel.setText("Data Type:");
        this._jTargetDataTypeValue.setEditable(false);
        this._jTargetDataTypeValue.setText("VARCHAR2");
        this._jTargetDataTypeValue.setBorder(null);
        this._jTargetValuesButton.setText("Values...");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jComboFunctionLabel, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jComboModelFunctions, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this._jAvailableModelsComponent, -1, 572, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -2, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -2, 49, -2)).addGap(9, 9, 9))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jTargetDataTypeLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this._jTargetAttributeLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this._jMiningFunctionLabel, -2, 72, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jMiningFunctionValue, -1, 235, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jTargetAttributeValue, -1, 145, Short.MAX_VALUE).addComponent(this._jTargetDataTypeValue, GroupLayout.Alignment.TRAILING, -1, 145, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetValuesButton)))).addComponent((Component)this._jSelectedModelsComponent, -1, 312, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this._jChkIncludeAllSchemas, -2, 288, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jComboFunctionLabel).addComponent(this._jComboModelFunctions, -2, -1, -2)).addGap(14, 14, 14)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this._jMiningFunctionLabel, -2, 15, Short.MAX_VALUE).addComponent(this._jMiningFunctionValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this._jTargetAttributeLabel, -2, 15, -2).addComponent(this._jTargetValuesButton).addComponent(this._jTargetAttributeValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetDataTypeLabel).addComponent(this._jTargetDataTypeValue, -2, -1, -2)))).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this._jAvailableModelsComponent, -1, 330, Short.MAX_VALUE).addComponent((Component)this._jSelectedModelsComponent, -1, 330, Short.MAX_VALUE)).addGap(17, 17, 17).addComponent(this._jChkIncludeAllSchemas, -2, 15, -2)).addGroup(groupLayout.createSequentialGroup().addGap(155, 155, 155).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn))).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jComboFunctionLabel, (Component)this._jComboModelFunctions, (String)DialogsLrb.get("MODEL_NODE_MODEL_FUNCTION"));
        this._jComboModelFunctions.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_MODEL_FUNCTION_ADA"));
        this._jComboModelFunctions.setToolTipText(DialogsLrb.get("MODEL_NODE_MODEL_FUNCTION_ADA"));
        this._jComboModelFunctions.setModel(new DefaultComboBoxModel<MiningFunctionOptions>(MiningFunctionOptions.values()));
        this.jAvailModels.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_AVAILABLE_MODELS_ADA"));
        this.jAvailModels.setToolTipText(DialogsLrb.get("MODEL_NODE_AVAILABLE_MODELS_ADA"));
        this.jSelectedModels.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_SELECTED_MODELS_ADA"));
        this.jSelectedModels.setToolTipText(DialogsLrb.get("MODEL_NODE_SELECTED_MODELS_ADA"));
        this._jFilterCtl.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_FILTER_ADA"));
        this._jFilterCtl.setToolTipText(DialogsLrb.get("MODEL_NODE_FILTER_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jChkIncludeAllSchemas, (String)DialogsLrb.get("MODEL_NODE_INCLUDE_FROM_SCHEMAS"));
        this._jChkIncludeAllSchemas.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_INCLUDE_FROM_SCHEMAS_ADA"));
        this._jFilterCtl.setToolTipText(DialogsLrb.get("MODEL_NODE_INCLUDE_FROM_SCHEMAS_ADA"));
        ResourceUtils.resLabel((JLabel)this._jMiningFunctionLabel, (Component)this._jMiningFunctionValue, (String)DialogsLrb.get("MODEL_NODE_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this._jTargetAttributeLabel, (Component)this._jTargetAttributeValue, (String)(DialogsLrb.get("MODEL_NODE_TARGET") + ":"));
        ResourceUtils.resLabel((JLabel)this._jTargetDataTypeLabel, (Component)this._jTargetDataTypeValue, (String)(DialogsLrb.get("MODEL_NODE_TARGET_DATA_TYPE") + ":"));
        ResourceUtils.resButton((AbstractButton)this._jTargetValuesButton, (String)DialogsLrb.get("MODEL_NODE_MODEL_TARGET_VALUES"));
        this.jSelectedModels.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_SELECTED_MODELS_ADA"));
        this.jSelectBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this._jTargetAttributeValue.setFocusable(false);
        this._jTargetAttributeValue.setText("");
        this._jTargetDataTypeValue.setText("");
        this._jTargetDataTypeValue.setFocusable(false);
        this._jMiningFunctionValue.setText("");
        this._jMiningFunctionValue.setFocusable(false);
        this._jTargetValuesButton.setEnabled(false);
        this._jChkIncludeAllSchemas.setSelected(this._modelNodeEditorPreferenceSettings.getIncludeModelsFromOtherSchemas());
    }

    @Override
    public void initUI() {
        try {
            this._dbConn = Connections.getSharedConnection(this._context);
            this._ownerName = Connections.getUserAccountName(this._context);
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
            return;
        }
        this.initIcons();
        HelpUtils.setHelpID((JComponent)this, (String)"model_selection_dialog");
        EditModelTableModel editModelTableModel = new EditModelTableModel(this._context);
        editModelTableModel.setLoadingStatus();
        this.jSelectedModels.setModel((TableModel)((Object)editModelTableModel));
        JScrollPane jScrollPane = new JScrollPane((Component)this.jSelectedModels);
        this._jSelectedModelsComponent.setComponent((JComponent)jScrollPane);
        this._jSelectedModelsComponent.setLabel(new JLabel(DialogsLrb.get("MODEL_NODE_SELECTED_MODELS")));
        SchemaChooserTableModel schemaChooserTableModel = new SchemaChooserTableModel();
        schemaChooserTableModel.setLoadingStatus();
        this.jAvailModels.setModel((TableModel)((Object)schemaChooserTableModel));
        jScrollPane = new JScrollPane((Component)this.jAvailModels);
        this._jAvailableModelsComponent.setComponent((JComponent)jScrollPane);
        this._jAvailableModelsComponent.setLabel(new JLabel(DialogsLrb.get("MODEL_NODE_AVAILABLE_MODELS")));
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this._jAvailableModelsComponent.setControlBar(controlBar);
        this.enableControls(false);
        this.jSelectBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditModelNodePanel.this._selectionsBusy) {
                    return;
                }
                try {
                    EditModelNodePanel.this._dirty = true;
                    EditModelNodePanel.this._selectionsBusy = true;
                    EditModelNodePanel.this.moveAvailableRows(actionEvent);
                }
                finally {
                    EditModelNodePanel.this._selectionsBusy = false;
                }
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditModelNodePanel.this._selectionsBusy) {
                    return;
                }
                try {
                    EditModelNodePanel.this._dirty = true;
                    EditModelNodePanel.this._selectionsBusy = true;
                    EditModelNodePanel.this.jAvailModels.selectAll();
                    EditModelNodePanel.this.moveAvailableRows(actionEvent);
                }
                finally {
                    EditModelNodePanel.this._selectionsBusy = false;
                }
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditModelNodePanel.this._selectionsBusy) {
                    return;
                }
                try {
                    EditModelNodePanel.this._dirty = true;
                    EditModelNodePanel.this._selectionsBusy = true;
                    EditModelNodePanel.this.moveSelectedRows();
                }
                finally {
                    EditModelNodePanel.this._selectionsBusy = false;
                }
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditModelNodePanel.this._selectionsBusy) {
                    return;
                }
                try {
                    EditModelNodePanel.this._dirty = true;
                    EditModelNodePanel.this._selectionsBusy = true;
                    EditModelNodePanel.this.jSelectedModels.selectAll();
                    EditModelNodePanel.this.moveSelectedRows();
                }
                finally {
                    EditModelNodePanel.this._selectionsBusy = false;
                }
            }
        });
        this._jChkIncludeAllSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelNodePanel.this._modelNodeEditorPreferenceSettings.setIncludeModelsFromOtherSchemas(EditModelNodePanel.this._jChkIncludeAllSchemas.isSelected());
                if (EditModelNodePanel.this.jAvailModels.getModel() != null) {
                    ((EditModelTableModel)((Object)EditModelNodePanel.this.jAvailModels.getModel())).setOwnerOnly(!EditModelNodePanel.this._jChkIncludeAllSchemas.isSelected());
                    EditModelNodePanel.this.processFilter(EditModelNodePanel.this._jFilterCtl.getText());
                }
            }
        });
        this._jTargetValuesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeType attributeType = EditModelNodePanel.this.createAttributeType(EditModelNodePanel.this._jTargetAttributeValue.getText(), EditModelNodePanel.this._jTargetDataTypeValue.getText());
                TargetValues targetValues = EditModelNodePanel.this.createTargetValues(attributeType);
                TargetValuesDialog targetValuesDialog = new TargetValuesDialog();
                targetValuesDialog.invoke(EditModelNodePanel.this._context, EditModelNodePanel.this._node, attributeType.getName(), attributeType.getDataType(), targetValues);
            }
        });
        this._jComboModelFunctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelNodePanel.this.processComboAction(false);
            }
        });
        this.jAvailModels.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (EditModelNodePanel.this._selectionsBusy) {
                    return;
                }
                int[] nArray = EditModelNodePanel.this.jAvailModels.getSelectedRowsInModel();
                try {
                    boolean bl = ((EditModelTableModel)((Object)EditModelNodePanel.this.jAvailModels.getModel())).validateSelectionIsCompatible(nArray, EditModelNodePanel.this._context, false);
                    if (!bl) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                }
            }
        });
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void setupFilterCtl() {
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_FULL_NAME")));
        this._jFilterCtl.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_SCHEMA")));
        this._jFilterCtl.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_FUNCTION")));
        this._jFilterCtl.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_ALGORITHM")));
        this._jFilterCtl.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_TARGET")));
        this._jFilterCtl.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_TARGET_DATA_TYPE")));
        this._jFilterCtl.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_COMMENTS")));
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                EditModelNodePanel.this.translateSearchCategoryToConstant(EditModelNodePanel.this._jFilterCtl.getSelectedCategory());
                EditModelNodePanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                EditModelNodePanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                EditModelNodePanel.this.processFilter(string);
            }
        });
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 250);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void processComboAction(boolean bl) {
        MiningFunctionOptions miningFunctionOptions = (MiningFunctionOptions)((Object)this._jComboModelFunctions.getSelectedItem());
        if (this._currentFunctionOption != miningFunctionOptions || bl) {
            this._currentFunctionOption = miningFunctionOptions;
            this.processFilter(this._jFilterCtl.getText());
        }
    }

    private void moveAvailableRows(ActionEvent actionEvent) {
        try {
            int[] nArray = this.jAvailModels.getSelectedRowsInModel();
            if (nArray.length == 0) {
                return;
            }
            ValidateSelectionIsCompatible validateSelectionIsCompatible = new ValidateSelectionIsCompatible(nArray);
            validateSelectionIsCompatible.setTitle(DialogsLrb.get("MODEL_NODE_CHOOSER_VALIDATING_COMPATIBILITY_TITLE"));
            validateSelectionIsCompatible.setMessage(DialogsLrb.get("MODEL_NODE_CHOOSER_VALIDATING_COMPATIBILITY_DESC"));
            validateSelectionIsCompatible.setCancelable(true);
            validateSelectionIsCompatible.start(true);
            if (validateSelectionIsCompatible.getException() != null) {
                if (validateSelectionIsCompatible.getException() instanceof EditModelTableModel.MisMatchedTargetValues) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS_TARGET_VALUES"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                } else {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateSelectionIsCompatible.getException(), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                }
                return;
            }
            if (validateSelectionIsCompatible.isCanceled()) {
                return;
            }
            if (!validateSelectionIsCompatible.isCompatible()) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
            } else if (this.isSelectionCompatibleWithCurrentSelected()) {
                Object object;
                EditModelTableModel editModelTableModel = (EditModelTableModel)((Object)this.jSelectedModels.getModel());
                if (editModelTableModel.getDataVector().size() == 0) {
                    object = ((EditModelTableModel)((Object)this.jAvailModels.getModel())).getDataVector();
                    EditModelTableModel.TableRow tableRow = (EditModelTableModel.TableRow)((Vector)object).elementAt(nArray[0]);
                    if (MiningFunctions.CLASSIFICATION.toString().compareTo(tableRow.getFunction()) == 0) {
                        String string = Model.getCombinedUserNameModelName(tableRow.getSchema(), tableRow.getModelName(), false);
                        if (DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, tableRow.getTarget_data_type())) {
                            this.loadTargetValues(string, false);
                        } else if (DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, tableRow.getTarget_data_type())) {
                            this.loadTargetValues(string, true);
                        } else {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Unsupported target data type encountered: " + tableRow.getTarget_data_type()), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                            return;
                        }
                    }
                }
                object = this.jAvailModels.getSelectedRowsInModel();
                this.moveItems(this.jAvailModels, this.jSelectedModels);
                editModelTableModel.setOwnerOnly(!editModelTableModel.isModelsFromOtherSchemas());
                this.setSelectionOnInsertedRows(this.jSelectedModels, ((Object)object).length);
                this.filterAvailableBasedOnSelected();
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_WITH_SELECTED"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
            }
        }
        catch (EditModelTableModel.MisMatchedTargetValues misMatchedTargetValues) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS_TARGET_VALUES_WITH_SELECTED"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
        }
    }

    private void filterAvailableBasedOnSelected() {
        EditModelTableModel editModelTableModel = (EditModelTableModel)((Object)this.jSelectedModels.getModel());
        if (editModelTableModel.getRowCount() > 0) {
            Vector<EditModelTableModel.TableRow> vector = editModelTableModel.getDataVector();
            EditModelTableModel.TableRow tableRow = vector.elementAt(0);
            if (this._jMiningFunctionValue.getText().length() == 0) {
                this._jMiningFunctionValue.setText(tableRow.getFunction());
                boolean bl = true;
                if (this._jTargetAttributeValue.getText().compareTo(tableRow.getTarget_name()) == 0 && this._jTargetDataTypeValue.getText().compareTo(tableRow.getTarget_data_type()) == 0) {
                    bl = false;
                }
                this._jTargetAttributeValue.setText(tableRow.getTarget_name());
                this._jTargetDataTypeValue.setText(tableRow.getTarget_data_type());
                this._jComboModelFunctions.setSelectedItem((Object)MiningFunctionOptions.fromString(tableRow.getFunction()));
                this._jComboModelFunctions.setEnabled(false);
                this.processComboAction(bl);
            }
        }
    }

    private boolean isSelectionCompatibleWithCurrentSelected() throws EditModelTableModel.MisMatchedTargetValues {
        boolean bl = false;
        EditModelTableModel editModelTableModel = (EditModelTableModel)((Object)this.jSelectedModels.getModel());
        int[] nArray = this.jAvailModels.getSelectedRowsInModel();
        EditModelTableModel editModelTableModel2 = (EditModelTableModel)((Object)this.jAvailModels.getModel());
        Vector<EditModelTableModel.TableRow> vector = editModelTableModel2.getDataVector();
        EditModelTableModel.TableRow tableRow = vector.elementAt(nArray[0]);
        if (this._jMiningFunctionValue.getText().length() == 0) {
            bl = true;
        } else if (tableRow.getFunction().compareTo(this._jMiningFunctionValue.getText()) == 0 && tableRow.getTarget_name().compareTo(this._jTargetAttributeValue.getText()) == 0 && editModelTableModel.isDataTypeCompatible(tableRow.getTarget_data_type(), this._jTargetDataTypeValue.getText())) {
            try {
                if (MiningFunctions.CLASSIFICATION.toString().compareTo(this._jMiningFunctionValue.getText()) == 0) {
                    EditModelTableModel.TableRow tableRow2 = editModelTableModel.getDataVector().get(0);
                    String string = Model.getCombinedUserNameModelName(tableRow2.getSchema(), tableRow2.getModelName(), false);
                    ValidateSelectionHasSameTargetValues validateSelectionHasSameTargetValues = new ValidateSelectionHasSameTargetValues(nArray, string);
                    validateSelectionHasSameTargetValues.setTitle(DialogsLrb.get("MODEL_NODE_CHOOSER_VALIDATING_COMPATIBILITY_TITLE"));
                    validateSelectionHasSameTargetValues.setMessage(DialogsLrb.get("MODEL_NODE_CHOOSER_VALIDATING_COMPATIBILITY_DESC"));
                    validateSelectionHasSameTargetValues.setCancelable(true);
                    validateSelectionHasSameTargetValues.start(true);
                    if (validateSelectionHasSameTargetValues.getException() != null) {
                        if (validateSelectionHasSameTargetValues.getException() instanceof EditModelTableModel.MisMatchedTargetValues) {
                            throw validateSelectionHasSameTargetValues.getException();
                        }
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateSelectionHasSameTargetValues.getException(), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                        return false;
                    }
                    if (validateSelectionHasSameTargetValues.isCanceled()) {
                        return false;
                    }
                    if (!validateSelectionHasSameTargetValues.isCompatible()) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS_TARGET_VALUES_WITH_SELECTED"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                        return false;
                    }
                }
            }
            catch (EditModelTableModel.MisMatchedTargetValues misMatchedTargetValues) {
                throw misMatchedTargetValues;
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                return false;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void moveSelectedRows() {
        int[] nArray = this.jSelectedModels.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        this.moveItems(this.jSelectedModels, this.jAvailModels);
        EditModelTableModel editModelTableModel = (EditModelTableModel)((Object)this.jSelectedModels.getModel());
        editModelTableModel.setOwnerOnly(!editModelTableModel.isModelsFromOtherSchemas());
        if (editModelTableModel.getRowCount() == 0) {
            this._jMiningFunctionValue.setText("");
            this._jTargetAttributeValue.setText("");
            this._jTargetDataTypeValue.setText("");
            this._jComboModelFunctions.setEnabled(true);
            this._targetValuesStrings.clear();
            this._targetValuesNumbers.clear();
            this._jTargetValuesButton.setEnabled(false);
            this.processComboAction(true);
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_FULL_NAME"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_SCHEMA"))) {
            this._currentSearchCategory = 2;
        } else if (searchCategory.getLabel().equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_MODEL"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_FUNCTION"))) {
            this._currentSearchCategory = 3;
        } else if (searchCategory.getLabel().equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_ALGORITHM"))) {
            this._currentSearchCategory = 4;
        } else if (searchCategory.getLabel().equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_TARGET"))) {
            this._currentSearchCategory = 5;
        } else if (searchCategory.getLabel().equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_TARGET_DATA_TYPE"))) {
            this._currentSearchCategory = 6;
        } else if (searchCategory.getLabel().equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_COMMENTS"))) {
            this._currentSearchCategory = 7;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilter(String string) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        try {
            ideMainWindow.setCursor(new Cursor(3));
            this.enableControls(false);
            String string2 = null;
            String string3 = null;
            if ((this._currentFunctionOption == MiningFunctionOptions.CLASSIFICATION || this._currentFunctionOption == MiningFunctionOptions.REGRESSION) && this._jTargetAttributeValue.getText().length() > 0 && this._jTargetDataTypeValue.getText().length() > 0) {
                string2 = this._jTargetAttributeValue.getText();
                string3 = this._jTargetDataTypeValue.getText();
            }
            this._filteredAvailModelsTableModel = this._availModelsTableModel.getfilteredCopy(string, this._currentSearchCategory, this._jChkIncludeAllSchemas.isSelected(), this._currentFunctionOption, string2, string3);
            this.setupTables(this._filteredAvailModelsTableModel, this._selectedModelsTableModel);
            this.enableControls(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
        }
        finally {
            ideMainWindow.setCursor(new Cursor(0));
        }
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2) {
        int[] nArray = genericTable.getSelectedRowsInModel();
        EditModelTableModel editModelTableModel = (EditModelTableModel)((Object)genericTable.getModel());
        EditModelTableModel editModelTableModel2 = (EditModelTableModel)((Object)genericTable2.getModel());
        editModelTableModel2.addSelection(editModelTableModel, nArray);
        if (editModelTableModel2.isFilteredTableModel()) {
            this._availModelsTableModel.addSelection(editModelTableModel, nArray);
        }
        if (genericTable2.equals(this.jSelectedModels)) {
            this.setSelectionOnInsertedRows(genericTable2, nArray.length);
        }
        if (editModelTableModel.isFilteredTableModel()) {
            this._availModelsTableModel.removeDuplicateRows(editModelTableModel.getDataVector(), nArray);
        }
        editModelTableModel.removeSelectedRows(nArray);
    }

    private void setSelectionOnInsertedRows(GenericTable genericTable, int n) {
        genericTable.setRowSelectionInterval(genericTable.getModel().getRowCount() - n, genericTable.getModel().getRowCount() - 1);
        genericTable.scrollToSelection();
    }

    public EditModelTableModel getModel() {
        if (this._filteredAvailModelsTableModel != null) {
            return this._filteredAvailModelsTableModel;
        }
        return this._availModelsTableModel;
    }

    private void enableControls(boolean bl) {
        this.jRemoveAllBtn.setEnabled(bl);
        this.jRemoveBtn.setEnabled(bl);
        this.jSelectAllBtn.setEnabled(bl);
        this.jSelectBtn.setEnabled(bl);
        this._jChkIncludeAllSchemas.setEnabled(bl);
        if (this._jMiningFunctionValue.getText().length() == 0) {
            this._jComboModelFunctions.setEnabled(bl);
        }
    }

    public Vector<EditModelTableModel.TableRow> loadSelectedModelsFromNode() {
        AbstractModelNode abstractModelNode = (AbstractModelNode)this.getData();
        ModelNodeType modelNodeType = (ModelNodeType)abstractModelNode.getData();
        List list = modelNodeType.getModels().getModel();
        if (list != null) {
            if (list.size() == 0) {
                return new Vector<EditModelTableModel.TableRow>();
            }
        } else {
            return new Vector<EditModelTableModel.TableRow>();
        }
        Vector<EditModelTableModel.TableRow> vector = new Vector<EditModelTableModel.TableRow>();
        String string = MetaDataHelper.getFunctionName(modelNodeType.getMiningFunction());
        this._currentFunctionOption = MiningFunctionOptions.fromString(string);
        String string2 = null;
        String string3 = null;
        if (modelNodeType.getTargetAttribute() != null) {
            string2 = modelNodeType.getTargetAttribute().getName();
            string3 = modelNodeType.getTargetAttribute().getDataType();
        }
        String string4 = "";
        for (ModelNodeType.Models.Model model : list) {
            string4 = MiningAlgorithms.translateFromODMServerAlgorithm(model.getMiningAlgorithm().value());
            EditModelTableModel.TableRow tableRow = new EditModelTableModel.TableRow(model.getSchema(), model.getName(), string, string4, string2, string3, null, null, model.getStatus(), model.getModelId(), new ModelSettingsODM(), model.isUseForOutput());
            vector.add(tableRow);
        }
        try {
            if (this._currentFunctionOption == MiningFunctionOptions.CLASSIFICATION && string3 != null) {
                if (DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, string3)) {
                    this._targetValuesStrings.addAll(modelNodeType.getTargetValues().getTargetValueString());
                } else if (DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, string3)) {
                    this._targetValuesNumbers.addAll(modelNodeType.getTargetValues().getTargetValueNumber());
                }
                this._jTargetValuesButton.setEnabled(true);
            } else {
                this._jTargetValuesButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
            return null;
        }
        return vector;
    }

    private void initIcons() {
        if (_select == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _select = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHT"));
            _selectAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHTALL"));
            _remove = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFT"));
            _removeAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFTALL"));
            Class<PropertyLrb> clazz2 = PropertyLrb.class;
            _built_icon = UIResourceHelper.getImageIcon(clazz2, PropertyLrb.get("PI_BUILD_GROUP_MODEL_BUILT_ICON"));
            _invalid_icon = UIResourceHelper.getImageIcon(clazz2, PropertyLrb.get("PI_BUILD_GROUP_MODEL_INVALID_ICON"));
        }
        this.jSelectBtn.setIcon(_select);
        this.jSelectAllBtn.setIcon(_selectAll);
        this.jRemoveBtn.setIcon(_remove);
        this.jRemoveAllBtn.setIcon(_removeAll);
    }

    private void setupTables(EditModelTableModel editModelTableModel, EditModelTableModel editModelTableModel2) {
        Object object;
        Object object2;
        this.jAvailModels.setModel((TableModel)((Object)editModelTableModel));
        this.jSelectedModels.setModel((TableModel)((Object)editModelTableModel2));
        if (editModelTableModel2.getRowCount() > 0) {
            object2 = editModelTableModel2.getDataVector();
            object = ((Vector)object2).elementAt(0);
            this._jMiningFunctionValue.setText(((EditModelTableModel.TableRow)object).getFunction());
            this._jTargetAttributeValue.setText(((EditModelTableModel.TableRow)object).getTarget_name());
            this._jTargetDataTypeValue.setText(((EditModelTableModel.TableRow)object).getTarget_data_type());
            this._jComboModelFunctions.setSelectedItem((Object)MiningFunctionOptions.fromString(((EditModelTableModel.TableRow)object).getFunction()));
            this._jComboModelFunctions.setEnabled(false);
            this.processComboAction(false);
        }
        this.jSelectedModels.setAutoResizeMode(0);
        this.jAvailModels.setAutoResizeMode(0);
        this.jSelectedModels.getTableHeader().setReorderingAllowed(true);
        this.jAvailModels.getTableHeader().setReorderingAllowed(true);
        object2 = new int[]{1, 3, 4, 5, 6};
        this.jSelectedModels.setColumnSelectorAvailable(false);
        this.jAvailModels.setColumnSelectorAvailable(false);
        this.jAvailModels.setSorted(true);
        this.jAvailModels.setSortColumn(0, true);
        this.jSelectedModels.setSorted(false);
        if (this.jSelectedModels.getColumnModel().getColumnCount() > 2) {
            this.jSelectedModels.setHiddenColumns((int[])object2);
        }
        this.jSelectedModels.setColumnSelectorAvailable(false);
        object = this.jAvailModels.getColumnModel();
        object.getColumn(0).setPreferredWidth(200);
        object.getColumn(1).setPreferredWidth(100);
        object.getColumn(2).setPreferredWidth(100);
        object.getColumn(3).setPreferredWidth(120);
        object.getColumn(4).setPreferredWidth(90);
        object.getColumn(5).setPreferredWidth(90);
        object.getColumn(6).setPreferredWidth(400);
        object = this.jSelectedModels.getColumnModel();
        object.getColumn(0).setPreferredWidth(200);
        object.getColumn(1).setPreferredWidth(100);
        TableColumn tableColumn = this.jSelectedModels.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        tableColumn = this.jAvailModels.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        TargetValues targetValues;
        ModelNodeType.Models models;
        AttributeType attributeType;
        MiningFunctionType miningFunctionType;
        boolean bl = true;
        if (this._selectedModelsTableModel.getRowCount() == 0) {
            miningFunctionType = null;
            attributeType = null;
            models = new ModelNodeType.Models();
            targetValues = new TargetValues();
        } else {
            miningFunctionType = MiningFunctionOptions.translateToODMServerMiningFunction(this._currentFunctionOption);
            attributeType = this.createAttributeType(this._jTargetAttributeValue.getText(), this._jTargetDataTypeValue.getText());
            models = this.createModelsCollection(miningFunctionType);
            targetValues = this.createTargetValues(attributeType);
            try {
                this.loadModelSettings(models);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
                return false;
            }
        }
        CommandProcessor.getInstance().beginTrans(DialogsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
        try {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            if (this._model == null) {
                odmrSDMUndoFilter.prepareUndo(this._node, this.getContext(), "miningFunctionType", miningFunctionType);
                odmrSDMUndoFilter.prepareUndo(this._node, this.getContext(), "targetAttribute", attributeType);
                odmrSDMUndoFilter.prepareUndo(this._node, this.getContext(), "modelsGroup", models);
                odmrSDMUndoFilter.prepareUndo(this._node, this.getContext(), "targetValues", targetValues);
                this._node.validate(true);
            } else {
                this._model.setValueAt((Object)miningFunctionType, ModelNodePropertyModel.RowIndex.MINING_FUNCTION, 0);
                this._model.setValueAt((Object)attributeType, ModelNodePropertyModel.RowIndex.TARGET_ATTRIBUTE, 0);
                this._model.setValueAt((Object)models, ModelNodePropertyModel.RowIndex.MODELS, 0);
                this._model.setValueAt((Object)targetValues, ModelNodePropertyModel.RowIndex.TARGET_VALUES, 0);
                Element[] elementArray = this._context.getSelection();
                WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                workflowNodeInspectorElement.validate(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        return bl;
    }

    private TargetValues createTargetValues(AttributeType attributeType) {
        attributeType = this.createAttributeType(this._jTargetAttributeValue.getText(), this._jTargetDataTypeValue.getText());
        TargetValues targetValues = new TargetValues();
        try {
            if (attributeType != null) {
                if (DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, attributeType.getDataType())) {
                    targetValues.getTargetValueNumber().addAll(this._targetValuesNumbers);
                } else if (DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, attributeType.getDataType())) {
                    targetValues.getTargetValueString().addAll(this._targetValuesStrings);
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
            return null;
        }
        return targetValues;
    }

    private void loadTargetValues(String string, boolean bl) throws CanceledTargetValues, Exception {
        GetTargetValues getTargetValues = new GetTargetValues(string, bl);
        getTargetValues.setTitle(DialogsLrb.get("MODEL_NODE_CHOOSER_LOADING_TARGET_VALUES_TITLE"));
        getTargetValues.setMessage(DialogsLrb.get("MODEL_NODE_CHOOSER_LOADING_TARGET_VALUES_DESC"));
        getTargetValues.setCancelable(false);
        getTargetValues.start(true);
        if (getTargetValues.getException() != null) {
            throw getTargetValues.getException();
        }
        if (getTargetValues.isCanceled()) {
            throw new CanceledTargetValues();
        }
        if (bl) {
            this._targetValuesStrings = getTargetValues.getTargetValuesStrings();
        } else {
            this._targetValuesNumbers = getTargetValues.getTargetValuesNumbers();
        }
        this._jTargetValuesButton.setEnabled(true);
    }

    private void loadModelSettings(ModelNodeType.Models models) throws Exception {
        GetModelSettings getModelSettings = new GetModelSettings(models);
        getModelSettings.setTitle(DialogsLrb.get("MODEL_NODE_UPDATING_TITLE"));
        getModelSettings.setMessage(DialogsLrb.get("MODEL_NODE_UPDATING_DESC"));
        getModelSettings.setCancelable(false);
        getModelSettings.start(true);
        if (getModelSettings.getException() != null) {
            throw getModelSettings.getException();
        }
    }

    private ModelNodeType.Models createModelsCollection(MiningFunctionType miningFunctionType) {
        ModelNodeType.Models models = new ModelNodeType.Models();
        List list = models.getModel();
        ModelNodeType.Models.Model model = null;
        for (EditModelTableModel.TableRow tableRow : this._selectedModelsTableModel.getDataVector()) {
            model = new ModelNodeType.Models.Model();
            model.setName(tableRow.getModelName());
            model.setSchema(tableRow.getSchema());
            model.setMiningAlgorithm(MiningAlgorithms.translateToODMServerMiningAlgorithm(MiningAlgorithms.fromString(tableRow.getAlgorithm())));
            model.setMiningFunction(miningFunctionType);
            model.setStatus(tableRow.getStatus());
            model.setUseForOutput(tableRow.isUseForOutput());
            model.setModelSettingsODM(new ModelSettingsODM());
            if (tableRow.getModelId().length() == 0) {
                try {
                    String string = this._node.getModel().getNextNewIdString();
                    model.setModelId(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                model.setModelId(tableRow.getModelId());
            }
            list.add(model);
        }
        return models;
    }

    private AttributeType createAttributeType(String string, String string2) {
        AttributeType attributeType = null;
        if (string.length() > 0) {
            attributeType = new AttributeType();
            attributeType.setDataType(string2);
            attributeType.setName(string);
            attributeType.setStatus(AttributeStatus.VALID);
        }
        return attributeType;
    }

    static {
        _p = Preferences.getPreferences();
    }

    public class CanceledTargetValues
    extends Exception {
    }

    class GetModelSettings
    extends ProgressRunnable {
        private Exception _exception;
        private boolean _canceled = false;
        private ModelNodeType.Models _models;

        public GetModelSettings(ModelNodeType.Models models) {
            this._models = models;
        }

        public Exception getException() {
            return this._exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWork() throws Exception {
            Object var2_1 = null;
            try {
                Connection connection = Connections.getSharedConnection(EditModelNodePanel.this._context);
                Vector<String> vector = new Vector<String>();
                for (ModelNodeType.Models.Model model : this._models.getModel()) {
                    String string = Model.getCombinedUserNameModelName(model.getSchema(), model.getName(), true);
                    vector.add(string);
                }
                Vector<MiningModelSettings> vector2 = Model.getModelSettings(connection, vector);
                for (ModelNodeType.Models.Model model : this._models.getModel()) {
                    for (MiningModelSettings miningModelSettings : vector2) {
                        if (miningModelSettings.getModelName().compareTo(model.getName()) != 0 || miningModelSettings.getOwner().compareTo(model.getSchema()) != 0) continue;
                        ModelSettingODMType modelSettingODMType = new ModelSettingODMType();
                        modelSettingODMType.setName(miningModelSettings.getSettingName());
                        modelSettingODMType.setValue(miningModelSettings.getSettingValue());
                        modelSettingODMType.setType(miningModelSettings.getSettingType());
                        model.getModelSettingsODM().getModelSettingODM().add(modelSettingODMType);
                    }
                }
            }
            catch (Exception exception) {
                this._exception = exception;
            }
            return var2_1;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    class GetTargetValues
    extends ProgressRunnable {
        private Exception _exception;
        private boolean _canceled = false;
        private String _currentModelName;
        private ArrayList<String> _targetValuesStrings;
        private ArrayList<Double> _targetValuesNumbers;
        private boolean _dataTypeIsString;

        public GetTargetValues(String string, boolean bl) {
            this._currentModelName = string;
            this._dataTypeIsString = bl;
        }

        public Exception getException() {
            return this._exception;
        }

        public ArrayList<String> getTargetValuesStrings() {
            return this._targetValuesStrings;
        }

        public ArrayList<Double> getTargetValuesNumbers() {
            return this._targetValuesNumbers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWork() throws Exception {
            ArrayList<Object> arrayList;
            block5: {
                arrayList = null;
                try {
                    Connection connection = Connections.getSharedConnection(EditModelNodePanel.this._context);
                    if (this._dataTypeIsString) {
                        arrayList = this._targetValuesStrings = Classification.getTargetValueStrings(connection, this._currentModelName);
                        break block5;
                    }
                    this._targetValuesNumbers = Classification.getTargetValueNumbers(connection, this._currentModelName);
                    arrayList = this._targetValuesNumbers;
                }
                catch (Exception exception) {
                    this._exception = exception;
                }
            }
            return arrayList;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    class ValidateSelectionHasSameTargetValues
    extends ProgressRunnable {
        private Exception _exception;
        private boolean _canceled = false;
        private int[] _selected;
        private boolean _compatible = false;
        private String _currentModelName;

        public ValidateSelectionHasSameTargetValues(int[] nArray, String string) {
            this._selected = nArray;
            this._currentModelName = string;
        }

        public Exception getException() {
            return this._exception;
        }

        public boolean isCompatible() {
            return this._compatible;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWork() throws Exception {
            try {
                this._compatible = ((EditModelTableModel)((Object)EditModelNodePanel.this.jAvailModels.getModel())).areTargetValuesTheSame(this._selected, EditModelNodePanel.this._context, this._currentModelName);
            }
            catch (Exception exception) {
                this._exception = exception;
            }
            return this._compatible;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    class ValidateSelectionIsCompatible
    extends ProgressRunnable {
        private Exception _exception;
        private boolean _canceled = false;
        private int[] _selected;
        private boolean _compatible = false;

        public ValidateSelectionIsCompatible(int[] nArray) {
            this._selected = nArray;
        }

        public Exception getException() {
            return this._exception;
        }

        public boolean isCompatible() {
            return this._compatible;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWork() throws Exception {
            try {
                boolean bl = EditModelNodePanel.this._jMiningFunctionValue.getText().length() == 0;
                this._compatible = ((EditModelTableModel)((Object)EditModelNodePanel.this.jAvailModels.getModel())).validateSelectionIsCompatible(this._selected, EditModelNodePanel.this._context, bl);
            }
            catch (Exception exception) {
                this._exception = exception;
            }
            return this._compatible;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
        }

        public Object construct() {
            try {
                EditModelNodePanel.this._availModelsTableModel = new EditModelTableModel(EditModelNodePanel.this._context);
                Vector<EditModelTableModel.TableRow> vector = EditModelNodePanel.this.loadSelectedModelsFromNode();
                EditModelNodePanel.this._selectedModelsTableModel = new EditModelTableModel(EditModelNodePanel.this._ownerName, vector, EditModelNodePanel.this._context);
                EditModelNodePanel.this._availModelsTableModel.load(EditModelNodePanel.this._dbConn);
                Vector<EditModelTableModel.TableRow> vector2 = EditModelNodePanel.this._availModelsTableModel.createMissingRowsBasedOnMatch(EditModelNodePanel.this._selectedModelsTableModel.getDataVector());
                EditModelNodePanel.this._selectedModelsTableModel.refreshModelStatus(vector2);
                EditModelNodePanel.this._availModelsTableModel.removeDuplicateRowsBasedOnMatch(EditModelNodePanel.this._selectedModelsTableModel.getDataVector());
                String string = null;
                String string2 = null;
                if (EditModelNodePanel.this._selectedModelsTableModel.getRowCount() > 0) {
                    Vector<EditModelTableModel.TableRow> vector3 = EditModelNodePanel.this._selectedModelsTableModel.getDataVector();
                    EditModelTableModel.TableRow tableRow = vector3.elementAt(0);
                    string = tableRow.getTarget_name();
                    string2 = tableRow.getTarget_data_type();
                }
                EditModelNodePanel.this._filteredAvailModelsTableModel = EditModelNodePanel.this._availModelsTableModel.getfilteredCopy("", EditModelNodePanel.this._currentSearchCategory, EditModelNodePanel.this._jChkIncludeAllSchemas.isSelected(), EditModelNodePanel.this._currentFunctionOption, string, string2);
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            this._success = true;
            return this._success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    EditModelNodePanel.this.setupTables(EditModelNodePanel.this._filteredAvailModelsTableModel, EditModelNodePanel.this._selectedModelsTableModel);
                } else {
                    EditModelTableModel editModelTableModel = new EditModelTableModel(EditModelNodePanel.this._context);
                    editModelTableModel.setFailedStatus();
                    EditModelNodePanel.this.setupTables(editModelTableModel, EditModelNodePanel.this._selectedModelsTableModel);
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
            }
            finally {
                EditModelNodePanel.this.enableControls(true);
            }
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            GenericTable genericTable = (GenericTable)jTable;
            int n3 = genericTable.convertRowIndexToModel(n);
            EditModelTableModel editModelTableModel = (EditModelTableModel)((Object)genericTable.getModel());
            try {
                EditModelTableModel.TableRow tableRow = editModelTableModel.getDataVector().get(n3);
                if (tableRow.getStatus() != null) {
                    if (tableRow.getStatus() == RefModelStatusType.VALID) {
                        this.setIcon(_built_icon);
                    } else {
                        this.setIcon(_invalid_icon);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return component;
        }
    }
}

