/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.CostBenefitsInfo;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogState;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;

public class CostBenefitsPanel
extends AbstractPropertiesDialogPanel
implements ActionListener {
    private JButton jBtnApply;
    private JComboBox jCmbBoxTarget;
    private JLabel jLabelTitle;
    private JLabel jLblTable;
    private JLabel jLblTarget;
    private JLabel jLblWeight;
    private JScrollPane jScrollPaneDescription;
    private JScrollPane jScrollPaneTable;
    private JTextField jTxtFldWeight;
    private GenericTable niceTableCosts;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private static final int COLUMN_COUNT = 2;
    private static final int TARGET_VALUE = 0;
    private static final int BENEFIT_VALUE = 1;
    private static String[] _benefits_columnNames = new String[]{DialogsLrb.get("COST_BENEFIT_TARGET_TABLE_FIRST_COLUMN"), DialogsLrb.get("COST_BENEFIT_TARGET_TABLE_SECOND_COLUMN")};

    public CostBenefitsPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jLblTarget = new JLabel();
        this.jCmbBoxTarget = new JComboBox();
        this.jScrollPaneDescription = new JScrollPane();
        this.jLblTable = new JLabel();
        this.jScrollPaneTable = new JScrollPane();
        this.niceTableCosts = new GenericTable();
        this.jLblWeight = new JLabel();
        this.jTxtFldWeight = new NumberTextField();
        this.jBtnApply = new JButton();
        this.jLabelTitle.setText("Use this screen to define costs for your target values for scoring purposes.");
        this.jLblTarget.setText("Target:");
        this.jScrollPaneDescription.setBorder(null);
        this.jScrollPaneDescription.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneDescription.setVerticalScrollBarPolicy(21);
        this.jLblTable.setText("Cost Benefit  Weights:");
        this.niceTableCosts.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPaneTable.setViewportView((Component)this.niceTableCosts);
        this.jLblWeight.setText("Weight:");
        this.jTxtFldWeight.setToolTipText("Range > 0");
        this.jBtnApply.setText("Apply");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneTable, -1, 435, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblTable, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 312, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTitle, -1, 441, Short.MAX_VALUE).addComponent(this.jScrollPaneDescription, -1, 441, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLblTarget, -2, 65, -2).addGap(18, 18, 18).addComponent(this.jCmbBoxTarget, 0, 358, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblWeight, -2, 75, -2).addGap(13, 13, 13).addComponent(this.jTxtFldWeight, -2, 82, -2).addGap(58, 58, 58).addComponent(this.jBtnApply))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitle).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCmbBoxTarget, -2, -1, -2).addComponent(this.jLblTarget)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneDescription, -2, 39, -2).addGap(14, 14, 14).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblWeight).addComponent(this.jTxtFldWeight, -2, -1, -2).addComponent(this.jBtnApply)).addGap(20, 20, 20).addComponent(this.jLblTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneTable, -1, 346, Short.MAX_VALUE).addGap(24, 24, 24)));
    }

    private void loadDescription() {
        this._jDescription.setText(DialogsLrb.get("COST_BENEFIT_WEIGHTING_DESCRIPTION"));
        this.jScrollPaneDescription.getViewport().add((Component)this._jDescription);
    }

    @Override
    protected final ModelPropertiesState getState() {
        return (ModelPropertiesState)super.getState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton;
        if (actionEvent.getSource() instanceof JComboBox) {
            Object object = this.jCmbBoxTarget.getSelectedItem();
            this.getState().setSelectedTargetValue(object);
        } else if (actionEvent.getSource() instanceof JButton && (jButton = (JButton)actionEvent.getSource()).equals(this.jBtnApply) && null != this.getState().getResultCostBenefitInfo()) {
            Object object = this.getState().getSelectedTargetValue();
            ArrayList<NameValuePair> arrayList = this.getState().getResultCostBenefitInfo().getValues();
            for (NameValuePair nameValuePair : arrayList) {
                if (!nameValuePair.getName().equals(object.toString())) continue;
                nameValuePair.setValue(new BigDecimal(this.getNumber(this.jTxtFldWeight).toString()));
            }
            this.niceTableCosts.setModel((TableModel)((Object)new WeightSettingsModel(this.getState().getResultCostBenefitInfo())));
            ((DefaultTableModel)this.niceTableCosts.getModel()).fireTableDataChanged();
        }
    }

    @Override
    public void processInput() {
        CostBenefitsInfo costBenefitsInfo = this.getState().getResultCostBenefitInfo();
        if (costBenefitsInfo != null && costBenefitsInfo.isCostBenefitTrue() && costBenefitsInfo.isEmpty()) {
            this.getState().setValidationError(DialogsLrb.get("COST_MATRIX_SETTINGS_EMPTY"));
            return;
        }
        this.getState().setValue("BUILD_SETTING_COST_BENEFITS_OPTION", costBenefitsInfo.getOptionValue());
    }

    private void initUI() {
        this.jLabelTitle.setText(DialogsLrb.get("COST_BENEFIT_DIALOG_DETAILED_DESCRIPTION"));
        this.loadDescription();
        this.jLblTable.setText(DialogsLrb.get("COST_BENEFIT_MATRIX_TARGET_TABLE_TITLE"));
        this.jLblTarget.setText(DialogsLrb.get("COST_MATRIX_MATRIX_TARGET"));
        this.jCmbBoxTarget.addActionListener(this);
        this.jLblTarget.setLabelFor(this.jCmbBoxTarget);
        this.setComponentsEnabled(false);
        this.jLblWeight.setText(DialogsLrb.get("COST_BENEFIT_DIALOG_BENEFIT_LBL"));
        this.jLblWeight.setLabelFor(this.jTxtFldWeight);
        this.setDataType(this.jTxtFldWeight, Double.class);
        this.setSigned(this.jTxtFldWeight, true);
        this.setLocale(this.jTxtFldWeight, this.getState().getLocale());
        this.setNumber(this.jTxtFldWeight, ModelPropertiesState.DEFAULT_BENEFIT);
        this.jBtnApply.setText(DialogsLrb.get("COST_MATRIX_WEIGHT_APPLY"));
        this.jBtnApply.addActionListener(this);
        AbstractPropertiesDialogPanel.LoadUI loadUI = new AbstractPropertiesDialogPanel.LoadUI(SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"));
        loadUI.start();
    }

    @Override
    public void initializeFromState(AbstractPropertiesDialogState abstractPropertiesDialogState) {
        Object[] objectArray;
        String string;
        CostBenefitsInfo costBenefitsInfo = this.getState().getResultCostBenefitInfo();
        if (costBenefitsInfo == null) {
            return;
        }
        boolean bl = costBenefitsInfo != null && costBenefitsInfo.isCostBenefitTrue();
        Object[] objectArray2 = this.getState().getTargetValues();
        String string2 = string = objectArray2 != null && objectArray2.length > 0 ? objectArray2[0] : "";
        if (objectArray2 != null && objectArray2.length > 0) {
            objectArray = objectArray2;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string;
        }
        this.jCmbBoxTarget.setModel(new DefaultListComboBoxModel(objectArray));
        this.jCmbBoxTarget.setSelectedItem(string);
        this.getState().setSelectedTargetValue(string);
        this.niceTableCosts.setModel((TableModel)((Object)new WeightSettingsModel(costBenefitsInfo)));
        this.setComponentsEnabled(bl);
        this.getState().setBackupValue("BUILD_SETTING_COST_BENEFITS_OPTION", this.getState().getOriginalCostBenefitInfo().getOptionValue());
    }

    private void setComponentsEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
        this.niceTableCosts.setEnabled(bl);
        this._jDescription.setEnabled(bl);
    }

    class WeightSettingsModel
    extends GenericBaseTableModel {
        CostBenefitsInfo _cbInfo;

        public WeightSettingsModel(CostBenefitsInfo costBenefitsInfo) {
            this.setColumnIdentifiers(_benefits_columnNames);
            this.setRowCount(costBenefitsInfo != null ? costBenefitsInfo.getRowCount() : 0);
            this.setColumnCount(2);
            this._cbInfo = costBenefitsInfo;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            String string = null;
            ArrayList<NameValuePair> arrayList = this._cbInfo.getValues();
            if (arrayList == null) {
                return string;
            }
            switch (n2) {
                case 0: {
                    string = arrayList.get(n).getName();
                    break;
                }
                case 1: {
                    string = NumericFormat.format(((BigDecimal)arrayList.get(n).getValue()).doubleValue(), true, 8) + "";
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            ArrayList<NameValuePair> arrayList = this._cbInfo.getValues();
            NameValuePair nameValuePair = arrayList.get(n);
            nameValuePair.setValue(new BigDecimal(object.toString()));
        }
    }
}

