/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.join.JoinColumnDialog;
import oracle.dmt.dataminer.workflow.dialog.join.JoinEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.join.ResolverDialog;
import oracle.dmt.dataminer.workflow.inspect.JoinNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowJoinNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinKeyColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinSourceNodesType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefDBColumnType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class JoinColumnPanel
extends AbstractDialogPanel {
    private WorkflowJoinNodePropertyProxyModel _propertyModel;
    private JoinEditorPanel _parent;
    private JEWTDialog _parentDlg;
    private boolean _isCartesianJoin;
    private JoinSourceNodesType _sourceNodes;
    private JoinKeyColumnsType _keyColumns;
    private JoinOutputColumnsType _outputColumns;
    private AbstractNode _selectSrcNode1;
    private AbstractNode _selectSrcNode2;
    private AttributeType _selAttr1;
    private AttributeType _selAttr2;
    private NiceTableWithToolbar _tableWithToolbar1;
    private NiceTableWithToolbar _tableWithToolbar2;
    private NiceTableWithToolbar _tableWithToolbarKey;
    private List<AbstractNode> _dataNodes;
    private boolean _loading = false;
    private boolean _dirty;
    private boolean _updateOutputColumn;
    private boolean _isEditMode;
    private static Icon _validAttrIcon;
    private static Icon _invalidAttrIcon;
    private JButton _addBtn;
    private JButton _removeBtn;
    private HyperlinkButton _resolveIssuesLink;
    private JoinNode.JoinOutputColumnNameGenerator _outputColumnNameGenerator;
    private static final String SELECT_A_NODE;
    private JButton jAddButton;
    private JCheckBox jCartesianChkBox;
    private JLabel jFillerLabel1;
    private JLabel jFillerLabel2;
    private JComboBox jSrcComboBox1;
    private JComboBox jSrcComboBox2;
    private JLabel jSrcLabel1;
    private JLabel jSrcLabel2;
    private ComponentWithTitlebar<JComponent> keysToolbar;
    private TransparentPanel keysTransPanel;
    private ComponentWithTitlebar<JComponent> sourceToolbar1;
    private ComponentWithTitlebar<JComponent> sourceToolbar2;
    private TransparentPanel sourceTransPanel1;
    private TransparentPanel sourceTransPanel2;

    public JoinColumnPanel(JEWTDialog jEWTDialog, Context context, JoinNode joinNode, PropertyModel propertyModel) {
        super(null, null);
        this._parentDlg = jEWTDialog;
        assert (propertyModel != null) : "PropertyModel for join node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((JoinNode)this._data, propertyModel);
    }

    public JoinColumnPanel(JEWTDialog jEWTDialog, Context context, JoinNode joinNode, JoinEditorPanel joinEditorPanel) {
        super(context, joinNode);
        this._parentDlg = jEWTDialog;
        assert (context != null) : "Context must not be null.";
        assert (joinNode != null) : "Join node must not be null.";
        assert (joinNode instanceof JoinNode) : "Must be an instance of join node.";
        this._parent = joinEditorPanel;
        this.init(joinNode, this._parent.getModel());
    }

    public JoinColumnPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for join node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.init((JoinNode)this._data, propertyModel);
    }

    public JoinColumnPanel(Context context, JoinNode joinNode, JoinEditorPanel joinEditorPanel) {
        super(context, joinNode);
        assert (context != null) : "Context must not be null.";
        assert (joinNode != null) : "Join node must not be null.";
        assert (joinNode instanceof JoinNode) : "Must be an instance of join node.";
        this._parent = joinEditorPanel;
        this.init(joinNode, this._parent.getModel());
    }

    private boolean isPIMode() {
        return this._propertyModel != null && this._parentDlg == null;
    }

    private boolean isPIDialogMode() {
        return this._propertyModel != null && this._parentDlg != null;
    }

    private boolean isEditMode() {
        return this._propertyModel == null && this._isEditMode && this._parentDlg == null;
    }

    private void init(JoinNode joinNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        this._updateOutputColumn = false;
        this._dataNodes = joinNode.findJoinDataNode();
        if (this.isPIMode() || this.isPIDialogMode()) {
            this._isCartesianJoin = ((JoinNodeType)joinNode.getData()).isUseCartesian();
            this._sourceNodes = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(((JoinNodeType)joinNode.getData()).getSourceNodes());
            this._keyColumns = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(((JoinNodeType)joinNode.getData()).getKeyColumns());
            this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(((JoinNodeType)joinNode.getData()).getOutputColumns());
            this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(this._outputColumns);
        } else if (this._parentDlg == null) {
            this._isCartesianJoin = this._parent.isCartesianJoin();
            this._sourceNodes = this._parent.getSourceNodes();
            this._keyColumns = this._parent.getKeyColumns();
            this._outputColumns = this._parent.getOutputColumns();
            this._outputColumnNameGenerator = this._parent.getOutputColumnNameGenerator();
            this._isEditMode = true;
        } else {
            this._isCartesianJoin = this._parent.getKeyPanel().isCartesianJoin();
            this._sourceNodes = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(this._parent.getKeyPanel().getKeyNodes());
            this._keyColumns = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(this._parent.getKeyPanel().getKeyColumns());
            this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(this._parent.getKeyPanel().getJoinOutputColumns());
            this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(this._outputColumns);
        }
        this._selectSrcNode1 = null;
        this._selectSrcNode2 = null;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        JoinNode joinNode = (JoinNode)workflowNodeInspectorElement.getNode();
        if (joinNode == null) {
            return;
        }
        this._propertyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = joinNode;
        this._dirty = false;
        this._updateOutputColumn = false;
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        this._isCartesianJoin = joinNodeType.isUseCartesian();
        this._sourceNodes = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(joinNodeType.getSourceNodes());
        this._keyColumns = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getKeyColumns());
        this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getOutputColumns());
        this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(joinNodeType.getOutputColumns());
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowJoinNodePropertyProxyModel)) {
            return null;
        }
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private JoinNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowJoinNodePropertyProxyModel)) {
            return null;
        }
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof JoinNodeType) {
            return (JoinNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        JoinNode joinNode = (JoinNode)this.getData();
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        ComplexProperty complexProperty = new ComplexProperty("joinKeyColumns", this._keyColumns);
        complexProperty.setOldData(joinNodeType.getKeyColumns());
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(JoinNodePropertyModel.RowIndex.JOIN_KEY_COLUMNS), null, complexProperty, null, null));
        ComplexProperty complexProperty2 = new ComplexProperty("joinKeyNodes", this._sourceNodes);
        complexProperty2.setOldData(joinNodeType.getSourceNodes());
        arrayList.add(new Property(String.valueOf(JoinNodePropertyModel.RowIndex.JOIN_KEY_NODES), null, complexProperty2, null, null));
        if (this._updateOutputColumn) {
            ComplexProperty complexProperty3 = new ComplexProperty("joinOutputColumns", this._outputColumns);
            complexProperty3.setOldData(joinNodeType.getOutputColumns());
            arrayList.add(new Property(String.valueOf(JoinNodePropertyModel.RowIndex.JOIN_OUTPUT_COLUMNS), null, complexProperty3, null, null));
        }
        this._propertyModel.setValueAt(PropertyLrb.get("PI_JOIN_GROUP_COLUMNS_ATTRIBUTE_OUTPUT_COLUMN_CHANGED"), this.getData(), arrayList);
    }

    public boolean doWork() {
        boolean bl = true;
        if (!(this._isCartesianJoin || JoinNode.areAllNodesUsedInKeys((JoinNode)this.getData(), this._keyColumns) || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_NODE_NOT_USED_IN_KEY"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true))) {
            return false;
        }
        if (this.isDirty()) {
            if (this.isPIMode() || this.isPIDialogMode()) {
                this.updateNode();
            } else {
                if (this._isCartesianJoin) {
                    this._parent.getKeyPanel().setKeyNodes(this._sourceNodes);
                    this._parent.getKeyPanel().setKeyColumns(null);
                } else {
                    this._parent.getKeyPanel().setKeyNodes(null);
                    this._parent.getKeyPanel().setKeyColumns(this._keyColumns);
                }
                this._parent.getKeyPanel().setDirty(true);
                this._parent.getKeyPanel().initUI();
                this._parent.getDataPanel().setOutputColumns(this._outputColumns);
                this._parent.getDataPanel().setDirty(true);
                this._parent.getDataPanel().initUI();
            }
        }
        return bl;
    }

    @Override
    public void initRes() {
        Class<WorkflowEditor> clazz = WorkflowEditor.class;
        _invalidAttrIcon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
        _validAttrIcon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("JOIN_KEY_SOURCE_NAME1"), this.jSrcLabel1);
        hashMap.put(DialogsLrb.get("JOIN_KEY_SOURCE_NAME2"), this.jSrcLabel2);
        hashMap.put(DialogsLrb.get("JOIN_KEY_ADD_BTN"), this.jAddButton);
        hashMap.put(DialogsLrb.get("JOIN_KEY_CARTESIAN_SETTING"), this.jCartesianChkBox);
        UIResourceHelper.setComponentText(hashMap);
        this.jSrcLabel1.setLabelFor(this.jSrcComboBox1);
        this.jSrcLabel2.setLabelFor(this.jSrcComboBox2);
    }

    @Override
    public void initUI() {
        Object object;
        Object object2;
        Object object4;
        HelpUtils.setHelpID((JComponent)this, (String)"join_keys");
        this._loading = true;
        this.jSrcLabel1.setVisible(!this.isPIMode() && !this.isEditMode());
        this.jSrcComboBox1.setVisible(!this.isPIMode() && !this.isEditMode());
        this.sourceToolbar1.setVisible(!this.isPIMode() && !this.isEditMode());
        this.sourceTransPanel1.setVisible(!this.isPIMode() && !this.isEditMode());
        this.jSrcLabel2.setVisible(!this.isPIMode() && !this.isEditMode());
        this.jSrcComboBox2.setVisible(!this.isPIMode() && !this.isEditMode());
        this.sourceToolbar2.setVisible(!this.isPIMode() && !this.isEditMode());
        this.sourceTransPanel2.setVisible(!this.isPIMode() && !this.isEditMode());
        this.jFillerLabel1.setVisible(!this.isPIMode() && !this.isEditMode());
        this.jFillerLabel2.setVisible(!this.isPIMode() && !this.isEditMode());
        this.jAddButton.setIcon(UIResourceHelper.getImageIcon(this.getClass(), DialogsLrb.get("JOIN_ICON")));
        this.jAddButton.setVisible(!this.isPIMode() && !this.isEditMode());
        this.jCartesianChkBox.setVisible(this.isPIMode() || this.isEditMode());
        if (!this.isPIMode() && !this.isEditMode()) {
            object4 = new DefaultComboBoxModel();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            ((DefaultComboBoxModel)object4).addElement(SELECT_A_NODE);
            defaultComboBoxModel.addElement(SELECT_A_NODE);
            for (AbstractNode object32 : this._dataNodes) {
                ((DefaultComboBoxModel)object4).addElement(object32.getData().getName());
                defaultComboBoxModel.addElement(object32.getData().getName());
            }
            this.jSrcComboBox1.setModel(object4);
            this.jSrcComboBox1.setSelectedItem(SELECT_A_NODE);
            this.jSrcComboBox2.setModel(defaultComboBoxModel);
            this.jSrcComboBox2.setSelectedItem(SELECT_A_NODE);
            AttrsTableModel attrsTableModel = new AttrsTableModel(null);
            object2 = new ControlBar();
            this._tableWithToolbar1 = new NiceTableWithToolbar(this.sourceToolbar1, (ControlBar)object2, AttrsTableModel._columnNames, attrsTableModel);
            this._tableWithToolbar1.getNiceTable().setSortColumn(0, true);
            this._tableWithToolbar1.getNiceTable().setSelectionMode(0);
            this._tableWithToolbar1.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("JOIN_SOURCE_TABLE_TITLE")));
            this._tableWithToolbar1.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JoinColumnPanel.this.enableControls();
                }
            });
            TableColumn tableColumn = this._tableWithToolbar1.getNiceTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new CustomCellRenderer(this._tableWithToolbar1, _validAttrIcon, _invalidAttrIcon));
            ControlBar controlBar = new ControlBar();
            this._tableWithToolbar2 = new NiceTableWithToolbar(this.sourceToolbar2, controlBar, AttrsTableModel._columnNames, attrsTableModel);
            this._tableWithToolbar2.getNiceTable().setSortColumn(0, true);
            this._tableWithToolbar2.getNiceTable().setSelectionMode(0);
            this._tableWithToolbar2.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("JOIN_SOURCE_TABLE_TITLE")));
            this._tableWithToolbar2.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JoinColumnPanel.this.enableControls();
                }
            });
            tableColumn = this._tableWithToolbar2.getNiceTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new CustomCellRenderer(this._tableWithToolbar2, _validAttrIcon, _invalidAttrIcon));
        }
        object4 = new ControlBar();
        int n = 0;
        n = this._isCartesianJoin ? JoinNode.getUnResolveNodes(this._sourceNodes).size() : JoinNode.getUnResolveNodes(this._keyColumns).size();
        if (n > 0) {
            this._resolveIssuesLink = new HyperlinkButton();
            this._resolveIssuesLink.setText(DialogsLrb.get("JOIN_RESOLVE_ISSUES"));
            this._resolveIssuesLink.setToolTipText(DialogsLrb.get("JOIN_RESOLVE_TOOLTIP"));
            this._resolveIssuesLink.setAlwaysUnderlined(true);
            this._resolveIssuesLink.setIcon(_invalidAttrIcon);
            object4.add((Component)this._resolveIssuesLink);
            this._resolveIssuesLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResolverDialog resolverDialog = new ResolverDialog();
                    JoinNode joinNode = (JoinNode)JoinColumnPanel.this.getData();
                    JoinNodeType joinNodeType = (JoinNodeType)MetaDataHelper.copyMetadataObject(joinNode.getData());
                    joinNodeType.setKeyColumns(JoinColumnPanel.this._keyColumns);
                    joinNodeType.setSourceNodes(JoinColumnPanel.this._sourceNodes);
                    joinNodeType.setOutputColumns(JoinColumnPanel.this._outputColumns);
                    if (resolverDialog.invoke(JoinColumnPanel.this.getContext(), joinNode, joinNodeType)) {
                        JoinColumnPanel.this._sourceNodes = joinNodeType.getSourceNodes();
                        JoinColumnPanel.this._keyColumns = joinNodeType.getKeyColumns();
                        JoinColumnPanel.this._outputColumns = joinNodeType.getOutputColumns();
                        if (JoinColumnPanel.this.isPIMode()) {
                            JoinColumnPanel.this._updateOutputColumn = true;
                            JoinColumnPanel.this.updateNode();
                        } else if (JoinColumnPanel.this._parentDlg == null) {
                            if (JoinColumnPanel.this._isCartesianJoin) {
                                JoinColumnPanel.this._parent.getKeyPanel().setKeyNodes(JoinColumnPanel.this._sourceNodes);
                                JoinColumnPanel.this._parent.getKeyPanel().setKeyColumns(null);
                            } else {
                                JoinColumnPanel.this._parent.getKeyPanel().setKeyNodes(null);
                                JoinColumnPanel.this._parent.getKeyPanel().setKeyColumns(JoinColumnPanel.this._keyColumns);
                            }
                            JoinColumnPanel.this._parent.getKeyPanel().setDirty(true);
                            JoinColumnPanel.this._parent.getKeyPanel().initUI();
                            JoinColumnPanel.this._parent.getDataPanel().setOutputColumns(JoinColumnPanel.this._outputColumns);
                            JoinColumnPanel.this._parent.getDataPanel().setDirty(true);
                            JoinColumnPanel.this._parent.getDataPanel().initUI();
                        }
                    }
                }
            });
        }
        if (this._isCartesianJoin) {
            object = new KeyNodeTableModel(this, this._sourceNodes);
            this._tableWithToolbarKey = new NiceTableWithToolbar(this.keysToolbar, (ControlBar)object4, KeyNodeTableModel._columnNames, (GenericBaseTableModel)object);
            this._tableWithToolbarKey.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("JOIN_NODE_TABLE_TITLE")));
            this._tableWithToolbarKey.getCompToolbar().repaint();
            TableColumn tableColumn = this._tableWithToolbarKey.getNiceTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new CustomCellRenderer(this._tableWithToolbarKey, _validAttrIcon, _invalidAttrIcon));
        } else {
            object = new KeyColumnTableModel(this, this._keyColumns, true);
            if (this.isPIMode() || this.isEditMode()) {
                this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
                this._addBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JoinColumnPanel.this.processAdd();
                    }
                });
                this._addBtn.setEnabled(true);
                this._addBtn.setToolTipText(DialogsLrb.get("JOIN_ADD_BTN_TOOLTIP"));
                object4.add((Component)this._addBtn);
            }
            this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
            this._removeBtn.setEnabled(false);
            this._removeBtn.setToolTipText(DialogsLrb.get("JOIN_REMOVE_BTN_TOOLTIP"));
            object4.add((Component)this._removeBtn);
            this._tableWithToolbarKey = new NiceTableWithToolbar(this.keysToolbar, (ControlBar)object4, KeyColumnTableModel._columnNames, (GenericBaseTableModel)object);
            this._tableWithToolbarKey.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("JOIN_KEY_TABLE_TITLE")));
            this._tableWithToolbarKey.getCompToolbar().repaint();
            TableColumn tableColumn = this._tableWithToolbarKey.getNiceTable().getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new CustomCellRenderer(this._tableWithToolbarKey, _validAttrIcon, _invalidAttrIcon));
            TableColumn tableColumn2 = this._tableWithToolbarKey.getNiceTable().getColumnModel().getColumn(1);
            tableColumn2.setCellRenderer(new CustomCellRenderer(this._tableWithToolbarKey, _validAttrIcon, _invalidAttrIcon));
            object2 = this._tableWithToolbarKey.getNiceTable().getColumnModel().getColumn(2);
            ((TableColumn)object2).setCellEditor(new JoinTypeEditor());
            this._removeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_REMOVE_KEY"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                        return;
                    }
                    JoinColumnPanel.this.processRemove();
                }
            });
            this._tableWithToolbarKey.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JoinColumnPanel.this.enableControls();
                }
            });
        }
        this.enableControls();
        this._loading = false;
    }

    private void enableControls() {
        this.jCartesianChkBox.setSelected(this._isCartesianJoin);
        this.jCartesianChkBox.setEnabled(this.isWritable());
        if (this._removeBtn != null) {
            this._removeBtn.setEnabled(this.isWritable() && this._tableWithToolbarKey.getNiceTable().getSelectedRowCount() > 0);
        }
        if (this._addBtn != null) {
            this._addBtn.setEnabled(this.isWritable());
        }
        if (this._resolveIssuesLink != null) {
            int n = 0;
            n = this._isCartesianJoin ? JoinNode.getUnResolveNodes(this._sourceNodes).size() : JoinNode.getUnResolveNodes(this._keyColumns).size();
            this._resolveIssuesLink.setVisible(n > 0);
            this._resolveIssuesLink.setEnabled(n > 0 && this.isWritable());
        }
        if (this._tableWithToolbar1 != null && this._tableWithToolbar2 != null) {
            this.jAddButton.setEnabled(this._tableWithToolbar1.getSelectedRowsInModel().length > 0 && this._tableWithToolbar2.getSelectedRowsInModel().length > 0);
        }
    }

    private void processAdd() {
        JoinColumnDialog joinColumnDialog = new JoinColumnDialog();
        if (this.isPIMode()) {
            joinColumnDialog.invoke(this._context, (JoinNode)this._data, (PropertyModel)this._propertyModel);
        } else {
            joinColumnDialog.invoke(this._context, (JoinNode)this._data, this._parent);
        }
    }

    private void processRemove() {
        int[] nArray = this._tableWithToolbarKey.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<JoinKeyColumnsType.JoinColumn> arrayList = new ArrayList<JoinKeyColumnsType.JoinColumn>();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)this._keyColumns.getJoinColumn().get(n);
            arrayList.add(joinColumn);
        }
        JoinNode.removeKey(this._keyColumns, arrayList);
        if (this.isPIMode() || this.isPIDialogMode()) {
            this._updateOutputColumn = true;
        } else {
            this._parent.getDataPanel().setDirty(true);
            this._parent.getDataPanel().initUI();
        }
        KeyColumnTableModel keyColumnTableModel = new KeyColumnTableModel(this, this._keyColumns, true);
        this._tableWithToolbarKey.resetNiceTableModel(keyColumnTableModel);
        this._dirty = true;
        if (this.isPIMode()) {
            this.updateNode();
        }
    }

    private void initComponents() {
        this.jSrcLabel1 = new JLabel();
        this.jSrcComboBox1 = new JComboBox();
        this.sourceTransPanel1 = new TransparentPanel();
        this.sourceToolbar1 = new ComponentWithTitlebar();
        this.jFillerLabel1 = new JLabel();
        this.jSrcLabel2 = new JLabel();
        this.jSrcComboBox2 = new JComboBox();
        this.sourceTransPanel2 = new TransparentPanel();
        this.sourceToolbar2 = new ComponentWithTitlebar();
        this.jFillerLabel2 = new JLabel();
        this.jAddButton = new JButton();
        this.jCartesianChkBox = new JCheckBox();
        this.keysTransPanel = new TransparentPanel();
        this.keysToolbar = new ComponentWithTitlebar();
        this.jSrcLabel1.setText("Source:");
        this.jSrcLabel1.setName("jSrcLabel1");
        this.jSrcComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"src 11", "src 12", "src 13", "src 14"}));
        this.jSrcComboBox1.setName("jSrcComboBox1");
        this.jSrcComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinColumnPanel.this.jSrcComboBox1ActionPerformed(actionEvent);
            }
        });
        this.sourceTransPanel1.setName("sourceTransPanel1");
        this.sourceToolbar1.setName("sourceToolbar1");
        GroupLayout groupLayout = new GroupLayout((Container)this.sourceTransPanel1);
        this.sourceTransPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.sourceToolbar1, -1, 324, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.sourceToolbar1, -1, 218, Short.MAX_VALUE));
        this.jFillerLabel1.setName("jFillerLabel1");
        this.jSrcLabel2.setText("Source:");
        this.jSrcLabel2.setName("jSrcLabel2");
        this.jSrcComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"src 21", "src 22", "src 23", "src 24"}));
        this.jSrcComboBox2.setName("jSrcComboBox2");
        this.jSrcComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinColumnPanel.this.jSrcComboBox2ActionPerformed(actionEvent);
            }
        });
        this.sourceTransPanel2.setName("sourceTransPanel2");
        this.sourceToolbar2.setName("sourceToolbar2");
        GroupLayout groupLayout2 = new GroupLayout((Container)this.sourceTransPanel2);
        this.sourceTransPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.sourceToolbar2, -1, 324, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.sourceToolbar2, -1, 218, Short.MAX_VALUE));
        this.jFillerLabel2.setName("jFillerLabel2");
        this.jAddButton.setText("Add");
        this.jAddButton.setName("jAddButton");
        this.jAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinColumnPanel.this.jAddButtonActionPerformed(actionEvent);
            }
        });
        this.jCartesianChkBox.setText("Cartesian Join");
        this.jCartesianChkBox.setName("jCartesianChkBox");
        this.jCartesianChkBox.setOpaque(false);
        this.jCartesianChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JoinColumnPanel.this.jCartesianChkBoxActionPerformed(actionEvent);
            }
        });
        this.keysTransPanel.setName("keysTransPanel");
        this.keysToolbar.setAutoscrolls(true);
        this.keysToolbar.setName("keysToolbar");
        GroupLayout groupLayout3 = new GroupLayout((Container)this.keysTransPanel);
        this.keysTransPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.keysToolbar, -1, 788, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.keysToolbar, -1, 240, Short.MAX_VALUE));
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent((Component)this.keysTransPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jCartesianChkBox, -2, 364, -2).addContainerGap()).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFillerLabel1, -1, 324, Short.MAX_VALUE).addComponent((Component)this.sourceTransPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jSrcLabel1).addComponent(this.jSrcComboBox1, 0, 324, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAddButton, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.sourceTransPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jSrcLabel2).addComponent(this.jSrcComboBox2, 0, 324, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jFillerLabel2, -1, 334, Short.MAX_VALUE))))));
        groupLayout4.linkSize(0, this.jSrcComboBox1, this.jSrcComboBox2);
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, groupLayout4.createSequentialGroup().addComponent(this.jSrcLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSrcComboBox2, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.sourceTransPanel2, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout4.createSequentialGroup().addComponent(this.jSrcLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSrcComboBox1, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.sourceTransPanel1, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFillerLabel2, -2, 29, -2).addComponent(this.jFillerLabel1, -2, 29, -2)).addComponent(this.jAddButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCartesianChkBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.keysTransPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jSrcComboBox1ActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jSrcComboBox1.getSelectedItem();
        if (string != SELECT_A_NODE) {
            this.jSrcComboBox1.removeItem(SELECT_A_NODE);
        }
        for (AbstractNode object2 : this._dataNodes) {
            if (object2.getData().getName().compareTo(string) != 0) continue;
            this._selectSrcNode1 = object2;
        }
        DataProvider dataProvider = (DataProvider)((Object)this._selectSrcNode1);
        List list = dataProvider.getAttributes().getAttribute();
        AttrsTableModel attrsTableModel = new AttrsTableModel(list);
        this._tableWithToolbar1.resetNiceTableModel(attrsTableModel);
        this._tableWithToolbar1.getNiceTable().setSortColumn(0, true);
    }

    private void jSrcComboBox2ActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jSrcComboBox2.getSelectedItem();
        if (string != SELECT_A_NODE) {
            this.jSrcComboBox2.removeItem(SELECT_A_NODE);
        }
        for (AbstractNode object2 : this._dataNodes) {
            if (object2.getData().getName().compareTo(string) != 0) continue;
            this._selectSrcNode2 = object2;
        }
        DataProvider dataProvider = (DataProvider)((Object)this._selectSrcNode2);
        List list = dataProvider.getAttributes().getAttribute();
        AttrsTableModel attrsTableModel = new AttrsTableModel(list);
        this._tableWithToolbar2.resetNiceTableModel(attrsTableModel);
        this._tableWithToolbar2.getNiceTable().setSortColumn(0, true);
    }

    private void jAddButtonActionPerformed(ActionEvent actionEvent) {
        DataProvider dataProvider = (DataProvider)((Object)this._selectSrcNode1);
        List list = dataProvider.getAttributes().getAttribute();
        int[] nArray = this._tableWithToolbar1.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        this._selAttr1 = (AttributeType)list.get(nArray[0]);
        dataProvider = (DataProvider)((Object)this._selectSrcNode2);
        list = dataProvider.getAttributes().getAttribute();
        nArray = this._tableWithToolbar2.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        this._selAttr2 = (AttributeType)list.get(nArray[0]);
        if (this.validateKeys()) {
            JoinType joinType = null;
            int n = this._tableWithToolbarKey.getNiceTableModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)this._keyColumns.getJoinColumn().get(i);
                if (joinColumn.getLeftColumn().getNodeId().compareTo(this._selectSrcNode1.getMetadataId()) != 0 || joinColumn.getRightColumn().getNodeId().compareTo(this._selectSrcNode2.getMetadataId()) != 0) continue;
                joinType = joinColumn.getType();
                break;
            }
            if (joinType == null) {
                joinType = JoinType.INNER;
            }
            JoinNode.addKey(this._keyColumns, this._selectSrcNode1, this._selAttr1, this._selectSrcNode2, this._selAttr2, joinType);
            if (this._outputColumns.getAutoSpec().equals((Object)AutoSpecType.YES)) {
                JoinNode.addOutputAttrs(this._outputColumns, this._selectSrcNode1, this._outputColumnNameGenerator);
                JoinNode.addOutputAttrs(this._outputColumns, this._selectSrcNode2, this._outputColumnNameGenerator);
                if (this.isPIMode() || this.isPIDialogMode()) {
                    this._updateOutputColumn = true;
                } else {
                    this._parent.getDataPanel().setDirty(true);
                    this._parent.getDataPanel().initUI();
                }
            }
            KeyColumnTableModel keyColumnTableModel = new KeyColumnTableModel(this, this._keyColumns, true);
            this._tableWithToolbarKey.resetNiceTableModel(keyColumnTableModel);
            this._dirty = true;
        }
    }

    private boolean validateKeys() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this._selectSrcNode1.getID().compareTo(this._selectSrcNode2.getID()) == 0) {
            bl3 = true;
        } else if (this._selAttr1.getDataType().compareTo(this._selAttr2.getDataType()) != 0) {
            boolean bl4;
            boolean bl5 = this._selAttr1.getDataType().indexOf("CHAR") >= 0;
            boolean bl6 = this._selAttr2.getDataType().indexOf("CHAR") >= 0;
            boolean bl7 = this._selAttr1.getDataType().equals("FLOAT") || this._selAttr1.getDataType().equals("LONG") || this._selAttr1.getDataType().equals("INTEGER") || this._selAttr1.getDataType().equals("NUMBER");
            boolean bl8 = bl4 = this._selAttr2.getDataType().equals("FLOAT") || this._selAttr2.getDataType().equals("LONG") || this._selAttr2.getDataType().equals("INTEGER") || this._selAttr2.getDataType().equals("NUMBER");
            bl2 = bl5 && bl6 ? false : !bl7 || !bl4;
        }
        if (!bl2 && !bl3) {
            for (JoinKeyColumnsType.JoinColumn joinColumn : this._keyColumns.getJoinColumn()) {
                RefDBColumnType refDBColumnType = joinColumn.getLeftColumn();
                RefDBColumnType refDBColumnType2 = joinColumn.getRightColumn();
                if (refDBColumnType.getNodeId().compareTo(this._selectSrcNode1.getMetadataId()) == 0 && refDBColumnType.getName().compareTo(this._selAttr1.getName()) == 0 && refDBColumnType2.getNodeId().compareTo(this._selectSrcNode2.getMetadataId()) == 0 && refDBColumnType2.getName().compareTo(this._selAttr2.getName()) == 0) {
                    bl = true;
                    break;
                }
                if (refDBColumnType.getNodeId().compareTo(this._selectSrcNode2.getMetadataId()) != 0 || refDBColumnType.getName().compareTo(this._selAttr2.getName()) != 0 || refDBColumnType2.getNodeId().compareTo(this._selectSrcNode1.getMetadataId()) != 0 || refDBColumnType2.getName().compareTo(this._selAttr1.getName()) != 0) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_KEY_DUPLICATE"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (bl2) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_KEY_INCOMPATIBLE"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (bl3) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_KEY_NO_SELF_JOIN"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        return true;
    }

    private void jCartesianChkBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jCartesianChkBox.isSelected();
        if (bl) {
            if (this._keyColumns != null && this._keyColumns.getJoinColumn().size() > 0 && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_CARTESIAN_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jCartesianChkBox.setSelected(false);
                return;
            }
            this._isCartesianJoin = true;
            this._keyColumns = null;
            this._sourceNodes = new JoinSourceNodesType();
            JoinNode.removeOutputAttrsFromNodes(this._outputColumns, null, this._outputColumnNameGenerator);
            JoinNode.addKey(this._sourceNodes, ((JoinNode)this.getData()).findJoinDataNode());
            if (this._outputColumns.getAutoSpec().equals((Object)AutoSpecType.YES)) {
                for (AbstractNode abstractNode : ((JoinNode)this.getData()).findJoinDataNode()) {
                    JoinNode.addOutputAttrs(this._outputColumns, abstractNode, this._outputColumnNameGenerator);
                }
            }
        } else {
            if (this._sourceNodes != null && this._sourceNodes.getSourceNode().size() > 0 && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_CARTESIAN_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jCartesianChkBox.setSelected(false);
                return;
            }
            this._isCartesianJoin = false;
            this._sourceNodes = null;
            this._keyColumns = new JoinKeyColumnsType();
            JoinNode.removeOutputAttrsFromNodes(this._outputColumns, null, this._outputColumnNameGenerator);
        }
        if (this.isPIMode() || this.isPIDialogMode()) {
            this._updateOutputColumn = true;
        } else {
            this._parent.getDataPanel().setOutputColumns(this._outputColumns);
            this._parent.getDataPanel().setDirty(true);
            this._parent.getDataPanel().initUI();
        }
        this._dirty = true;
        if (this.isPIMode()) {
            this.updateNode();
        } else {
            this.initUI();
        }
        this.enableControls();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public JoinKeyColumnsType getKeyColumns() {
        return this._keyColumns;
    }

    public JoinOutputColumnsType getJoinOutputColumns() {
        return this._outputColumns;
    }

    public void setKeyColumns(JoinKeyColumnsType joinKeyColumnsType) {
        this._keyColumns = joinKeyColumnsType;
    }

    public JoinSourceNodesType getKeyNodes() {
        return this._sourceNodes;
    }

    public void setKeyNodes(JoinSourceNodesType joinSourceNodesType) {
        this._sourceNodes = joinSourceNodesType;
    }

    public boolean isCartesianJoin() {
        return this._isCartesianJoin;
    }

    static {
        SELECT_A_NODE = DialogsLrb.get("JOIN_SELECT_NODE");
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private Icon validIcon;
        private Icon invalidIcon;
        private NiceTableWithToolbar _tableWithToolbar;

        public CustomCellRenderer(NiceTableWithToolbar niceTableWithToolbar, Icon icon, Icon icon2) {
            this._tableWithToolbar = niceTableWithToolbar;
            this.validIcon = icon;
            this.invalidIcon = icon2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = this._tableWithToolbar.convertRowToModelIndex(n);
            GenericBaseTableModel genericBaseTableModel = this._tableWithToolbar.getNiceTableModel();
            AttributeStatus attributeStatus = AttributeStatus.VALID;
            if (genericBaseTableModel instanceof AttrsTableModel) {
                attributeStatus = (AttributeStatus)((AttrsTableModel)genericBaseTableModel).getValueAt(n3, 3);
            } else if (genericBaseTableModel instanceof KeyNodeTableModel) {
                if (n2 == 0) {
                    attributeStatus = (AttributeStatus)((KeyNodeTableModel)genericBaseTableModel).getValueAt(n3, 2);
                }
            } else if (genericBaseTableModel instanceof KeyColumnTableModel) {
                if (n2 == 0) {
                    attributeStatus = (AttributeStatus)((KeyColumnTableModel)genericBaseTableModel).getValueAt(n3, 4);
                } else if (n2 == 1) {
                    attributeStatus = (AttributeStatus)((KeyColumnTableModel)genericBaseTableModel).getValueAt(n3, 5);
                }
            }
            if (attributeStatus == AttributeStatus.VALID) {
                this.setIcon(this.validIcon);
            } else {
                this.setIcon(this.invalidIcon);
            }
            return component;
        }
    }

    private class JoinTypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        String currentValue;
        JComboBox comboComponent = new JComboBox();
        protected static final String EDIT = "edit";

        public JoinTypeEditor() {
            this.comboComponent.setActionCommand(EDIT);
            this.comboComponent.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.currentValue = (String)this.comboComponent.getSelectedItem();
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)object;
            this.comboComponent.removeAllItems();
            JoinType joinType = null;
            JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)JoinColumnPanel.this._keyColumns.getJoinColumn().get(n);
            for (int i = 0; i < JoinColumnPanel.this._keyColumns.getJoinColumn().size(); ++i) {
                JoinKeyColumnsType.JoinColumn joinColumn2 = (JoinKeyColumnsType.JoinColumn)JoinColumnPanel.this._keyColumns.getJoinColumn().get(i);
                if (i == n || joinColumn2.getLeftColumn().getNodeId().compareTo(joinColumn.getLeftColumn().getNodeId()) != 0 || joinColumn2.getRightColumn().getNodeId().compareTo(joinColumn.getRightColumn().getNodeId()) != 0) continue;
                joinType = joinColumn2.getType();
                break;
            }
            if (joinType != null) {
                if (joinType.equals((Object)JoinType.INNER)) {
                    this.comboComponent.addItem(JoinType.INNER.value());
                    this.comboComponent.addItem(JoinType.LEFT_OUTER.value());
                    this.comboComponent.addItem(JoinType.RIGHT_OUTER.value());
                    this.comboComponent.addItem(JoinType.FULL_OUTER.value());
                } else if (joinType.equals((Object)JoinType.LEFT_OUTER)) {
                    this.comboComponent.addItem(JoinType.INNER.value());
                    this.comboComponent.addItem(JoinType.LEFT_OUTER.value());
                    this.comboComponent.addItem(JoinType.RIGHT_OUTER.value());
                    this.comboComponent.addItem(JoinType.FULL_OUTER.value());
                } else if (joinType.equals((Object)JoinType.RIGHT_OUTER)) {
                    this.comboComponent.addItem(JoinType.INNER.value());
                    this.comboComponent.addItem(JoinType.LEFT_OUTER.value());
                    this.comboComponent.addItem(JoinType.RIGHT_OUTER.value());
                    this.comboComponent.addItem(JoinType.FULL_OUTER.value());
                }
            } else {
                this.comboComponent.addItem(JoinType.INNER.value());
                this.comboComponent.addItem(JoinType.LEFT_OUTER.value());
                this.comboComponent.addItem(JoinType.RIGHT_OUTER.value());
                this.comboComponent.addItem(JoinType.FULL_OUTER.value());
            }
            this.comboComponent.setSelectedItem(string);
            return this.comboComponent;
        }
    }

    private static class KeyColumnTableModel
    extends GenericBaseTableModel {
        public static String[] _columnNames = new String[]{DialogsLrb.get("JOIN_KEY_COLUMN_NAME1"), DialogsLrb.get("JOIN_KEY_COLUMN_NAME2"), DialogsLrb.get("JOIN_KEY_COLUMN_JOIN")};
        public static final int LEFT_ATTR_NAME = 0;
        public static final int RIGHT_ATTR_NAME = 1;
        public static final int KEY_JOIN = 2;
        public static final int COLUMN_COUNT = 3;
        public static final int LEFT_ATTR_STATUS = 4;
        public static final int RIGHT_ATTR_STATUS = 5;
        private JoinKeyColumnsType _srcData;
        private JoinColumnPanel _parent;
        private boolean _allowEdit;

        public KeyColumnTableModel(JoinColumnPanel joinColumnPanel, JoinKeyColumnsType joinKeyColumnsType, boolean bl) {
            this._parent = joinColumnPanel;
            this._srcData = joinKeyColumnsType;
            this._allowEdit = bl;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.getJoinColumn().size() : 0;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2 ? this._allowEdit : false;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (n2 != 2) {
                return;
            }
            JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)this._srcData.getJoinColumn().get(n);
            joinColumn.setType(JoinType.fromValue((String)((String)object)));
            this._parent.setDirty(true);
            if (this._parent.isPIMode()) {
                this._parent._updateOutputColumn = true;
                this._parent.updateNode();
            }
        }

        public Object getValueAt(int n, int n2) {
            if (n >= this.getRowCount()) {
                return null;
            }
            JoinKeyColumnsType.JoinColumn joinColumn = (JoinKeyColumnsType.JoinColumn)this._srcData.getJoinColumn().get(n);
            String string = null;
            String string2 = null;
            switch (n2) {
                case 0: {
                    string = ((JoinNode)this._parent.getData()).getDataNodeName(joinColumn.getLeftColumn().getNodeId());
                    string = string == null ? joinColumn.getLeftColumn().getNodeName() : string;
                    string2 = string + "." + joinColumn.getLeftColumn().getName();
                    break;
                }
                case 1: {
                    string = ((JoinNode)this._parent.getData()).getDataNodeName(joinColumn.getRightColumn().getNodeId());
                    string = string == null ? joinColumn.getRightColumn().getNodeName() : string;
                    string2 = string + "." + joinColumn.getRightColumn().getName();
                    break;
                }
                case 2: {
                    string2 = joinColumn.getType().value();
                    break;
                }
                case 4: {
                    string2 = joinColumn.getLeftColumn().getStatus();
                    break;
                }
                case 5: {
                    string2 = joinColumn.getRightColumn().getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string2;
        }
    }

    private static class KeyNodeTableModel
    extends GenericBaseTableModel {
        public static String[] _columnNames = new String[]{DialogsLrb.get("JOIN_KEY_NODE_NAME")};
        public static final int NODE_NAME = 0;
        public static final int COLUMN_COUNT = 1;
        public static final int NODE_STATUS = 2;
        private JoinSourceNodesType _srcData;
        private JoinColumnPanel _parent;

        public KeyNodeTableModel(JoinColumnPanel joinColumnPanel, JoinSourceNodesType joinSourceNodesType) {
            this._parent = joinColumnPanel;
            this._srcData = joinSourceNodesType;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(1);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.getSourceNode().size() : 0;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            JoinSourceNodesType.SourceNode sourceNode = (JoinSourceNodesType.SourceNode)this._srcData.getSourceNode().get(n);
            String string = null;
            Object object = null;
            switch (n2) {
                case 0: {
                    string = ((JoinNode)this._parent.getData()).getDataNodeName(sourceNode.getNodeId());
                    string = string == null ? sourceNode.getNodeName() : string;
                    object = string;
                    break;
                }
                case 2: {
                    object = sourceNode.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private static class AttrsTableModel
    extends GenericBaseTableModel {
        public static String[] _columnNames = new String[]{DialogsLrb.get("JOIN_ATTR_NAME"), DialogsLrb.get("JOIN_DATA_TYPE")};
        public static final int ATTR_COLUMN = 0;
        public static final int DATA_TYPE = 1;
        public static final int COLUMN_COUNT = 2;
        public static final int ATTR_STATUS = 3;
        private List<AttributeType> _srcData;

        public AttrsTableModel(List<AttributeType> list) {
            this._srcData = list;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AttributeType attributeType = this._srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = attributeType.getName();
                    break;
                }
                case 1: {
                    string = attributeType.getDataType();
                    break;
                }
                case 3: {
                    string = attributeType.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }
}

