/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.join.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.RefDBColumnType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;

public class AttrsPanel
extends AbstractDialogPanel {
    private List<RefDBColumnType> availAttrsCache;
    private List<RefDBColumnType> selectedAttrsCache;
    private OutputColumnPanel _parent;
    private boolean _dirty = false;
    private GenericTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private GenericTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;
    private JLabel jSelectedLabel;
    private static Icon _validAttrIcon;
    private static Icon _invalidAttrIcon;
    private static Icon _select;
    private static Icon _selectAll;
    private static Icon _remove;
    private static Icon _removeAll;

    public AttrsPanel(Context context, OutputColumnPanel outputColumnPanel, List<AbstractNode> list, JoinOutputColumnsType joinOutputColumnsType) {
        super(context, outputColumnPanel.getData());
        this._parent = outputColumnPanel;
        this.availAttrsCache = new ArrayList<RefDBColumnType>();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            List list2 = dataProvider.getAttributes().getAttribute();
            for (AttributeType attributeType : list2) {
                RefDBColumnType refDBColumnType = new RefDBColumnType();
                String string = attributeType.getAlias() == null ? attributeType.getName() : attributeType.getAlias();
                refDBColumnType.setName(string);
                refDBColumnType.setNodeId(abstractNode.getMetadataId());
                refDBColumnType.setNodeName(abstractNode.getData().getName());
                refDBColumnType.setDataType(attributeType.getDataType());
                refDBColumnType.setStatus(attributeType.getStatus());
                this.availAttrsCache.add(refDBColumnType);
            }
        }
        JoinOutputColumnsType joinOutputColumnsType2 = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinOutputColumnsType);
        this.selectedAttrsCache = joinOutputColumnsType2.getRefDBColumn();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new GenericTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new GenericTable();
        this.jSelectedAttrsScrollPane.setName("jSelectedAttrsScrollPane");
        this.jSelectedAttrs.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrs.setName("jSelectedAttrs");
        this.jSelectedAttrsScrollPane.setViewportView((Component)this.jSelectedAttrs);
        this.jSelectBtn.setText(">");
        this.jSelectBtn.setName("jSelectBtn");
        this.jSelectAllBtn.setText(">>");
        this.jSelectAllBtn.setName("jSelectAllBtn");
        this.jRemoveBtn.setText("<");
        this.jRemoveBtn.setName("jRemoveBtn");
        this.jRemoveAllBtn.setText("<<");
        this.jRemoveAllBtn.setName("jRemoveAllBtn");
        this.jAvailableLabel.setText("Available Attributes");
        this.jAvailableLabel.setName("jAvailableLabel");
        this.jSelectedLabel.setText("Selected Attributes");
        this.jSelectedLabel.setName("jSelectedLabel");
        this.jAvailAttrsScrollPane.setName("jAvailAttrsScrollPane");
        this.jAvailAttrs.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrs.setName("jAvailAttrs");
        this.jAvailAttrsScrollPane.setViewportView((Component)this.jAvailAttrs);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -1, 375, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, GroupLayout.Alignment.TRAILING, -1, 375, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 383, Short.MAX_VALUE).addComponent(this.jSelectedLabel, -1, 383, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedLabel).addComponent(this.jAvailableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 275, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addComponent(this.jAvailAttrsScrollPane, -1, 275, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DataDialogsLrb.get("AVAILABLE_LABEL"), this.jAvailableLabel);
        hashMap.put(DataDialogsLrb.get("SELECTED_LABEL"), this.jSelectedLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.initIcons();
    }

    private void initIcons() {
        if (_invalidAttrIcon == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _invalidAttrIcon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _validAttrIcon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
            _select = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHT"));
            _selectAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHTALL"));
            _remove = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFT"));
            _removeAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFTALL"));
        }
        this.jSelectBtn.setIcon(_select);
        this.jSelectAllBtn.setIcon(_selectAll);
        this.jRemoveBtn.setIcon(_remove);
        this.jRemoveAllBtn.setIcon(_removeAll);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"join_attributes");
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        String[] stringArray = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        AttrTableModel attrTableModel = new AttrTableModel(this.availAttrsCache, stringArray);
        this.jAvailAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(this.availAttrsCache, _validAttrIcon, _invalidAttrIcon);
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        AttrTableModel attrTableModel2 = new AttrTableModel(this.selectedAttrsCache, stringArray);
        this.jSelectedAttrs.setModel((TableModel)((Object)attrTableModel2));
        this.jSelectedAttrs.setSorted(true);
        tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        attributeNameCellRenderer = new AttributeNameCellRenderer(this.selectedAttrsCache, _validAttrIcon, _invalidAttrIcon);
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttrsPanel.this.moveItems(AttrsPanel.this.jAvailAttrs, AttrsPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttrsPanel.this.moveItems(AttrsPanel.this.jAvailAttrs, AttrsPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttrsPanel.this.moveItems(AttrsPanel.this.jSelectedAttrs, AttrsPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttrsPanel.this.moveItems(AttrsPanel.this.jSelectedAttrs, AttrsPanel.this.jAvailAttrs, true);
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<RefDBColumnType> list = ((AttrTableModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<RefDBColumnType> arrayList = new ArrayList<RefDBColumnType>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = list.get(nArray[n2]);
                arrayList.add((RefDBColumnType)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List<RefDBColumnType> list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (RefDBColumnType)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this._dirty = true;
    }

    private void removeSelectedAttrs(List<RefDBColumnType> list, List<RefDBColumnType> list2) {
        HashMap<String, RefDBColumnType> hashMap = new HashMap<String, RefDBColumnType>();
        for (RefDBColumnType refDBColumnType : list2) {
            hashMap.put(refDBColumnType.getNodeId() + "." + refDBColumnType.getName(), refDBColumnType);
        }
        Iterator<RefDBColumnType> iterator = list.iterator();
        while (iterator.hasNext()) {
            RefDBColumnType refDBColumnType;
            refDBColumnType = iterator.next();
            RefDBColumnType refDBColumnType2 = (RefDBColumnType)hashMap.get(refDBColumnType.getNodeId() + "." + refDBColumnType.getName());
            if (refDBColumnType2 == null || !refDBColumnType2.getName().equals(refDBColumnType.getName()) || !refDBColumnType2.getDataType().equals(refDBColumnType.getDataType())) continue;
            iterator.remove();
        }
    }

    public boolean doWork() {
        boolean bl = true;
        return bl;
    }

    public List<RefDBColumnType> getSelectedAttrsCache() {
        return this.selectedAttrsCache;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    private class AttributeNameCellRenderer
    extends DefaultTableCellRenderer {
        private Icon validIcon;
        private Icon invalidIcon;
        private List<RefDBColumnType> _cache;

        public AttributeNameCellRenderer(List<RefDBColumnType> list, Icon icon, Icon icon2) {
            this._cache = list;
            this.validIcon = icon;
            this.invalidIcon = icon2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            RefDBColumnType refDBColumnType = this._cache.get(n);
            AttributeStatus attributeStatus = refDBColumnType.getStatus();
            if (attributeStatus == AttributeStatus.VALID) {
                this.setIcon(this.validIcon);
            } else {
                this.setIcon(this.invalidIcon);
            }
            return component;
        }
    }

    class AttrTableModel
    extends GenericBaseTableModel {
        private List<RefDBColumnType> _data;
        private final int NAME = 0;
        private final int DATA_TYPE = 1;
        private final int COLUMN_COUNT = 2;

        public AttrTableModel(List<RefDBColumnType> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            RefDBColumnType refDBColumnType = this._data.get(n);
            if (0 == n2) {
                string = ((JoinNode)AttrsPanel.this._parent.getData()).getDataNodeName(refDBColumnType.getNodeId()) + "." + refDBColumnType.getName();
            } else if (1 == n2) {
                assert (n2 > 0 && n2 < this.getColumnCount()) : "Column out of bounds";
                string = refDBColumnType.getDataType();
            }
            return string;
        }

        public List<RefDBColumnType> getDataList() {
            return this._data;
        }
    }
}

