/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.GenericTableTooltip;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableCreateNewTableAttributesDialog;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DBAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class UpdateTableNodeCreateTablePanel
extends AbstractDialogPanel
implements DataConsumerPanel {
    private Vector<AttributeType> allDataProviderAttributes = new Vector();
    private JButton _removeBtn;
    private JButton _editBtn;
    private String _originalTableName;
    private DBAttributes dbAttributes = new DBAttributes();
    private AbstractDataNode.TablePropertyValue tablePropertyValue;
    private static Icon _editIcon;
    private static Icon _valid_attribue_icon;
    private static Icon _invalid_attribue_icon;
    private static final int COLUMN_COUNT_TABLE = 5;
    private static final int NAME = 0;
    private static final int DATA_TYPE = 1;
    private static final int ISKEY = 2;
    private static final int ISINDEX = 3;
    private static final int ALIAS_TABLE = 4;
    private String[] _columnNames_table = new String[]{TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_NAME_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_TYPE_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_KEY_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_INDEX_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_ALIAS_COLUMN")};
    private GenericTable _jAttributesTable = new GenericTableTooltipCustom();
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JLabel jLabelName;
    private JTextField jTextFieldName;

    public UpdateTableNodeCreateTablePanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
        super(context, abstractNode);
        if (list != null) {
            this.allDataProviderAttributes.addAll(list);
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelName.setText("Name:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, -1, 404, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelName).addGap(18, 18, 18).addComponent(this.jTextFieldName, -2, 185, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextFieldName, -2, -1, -2)).addGap(18, 18, 18).addComponent((Component)this.jAttributesComponent, -1, 240, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.jLabelName.setText(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_NAME"));
        if (_valid_attribue_icon == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _invalid_attribue_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _valid_attribue_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
            _editIcon = InspectorArb.getIcon((int)24);
        }
        this.jTextFieldName.setDocument(new TextFieldLimit(32));
    }

    @Override
    public void initUI() {
        DBColumnType dBColumnType;
        Object object2;
        for (Object object2 : this.allDataProviderAttributes) {
            dBColumnType = new DBColumnType();
            dBColumnType.setAlias(object2.getAlias());
            dBColumnType.setAnnotation(object2.getAnnotation());
            dBColumnType.setDataType(object2.getDataType());
            dBColumnType.setName(object2.getName());
            dBColumnType.setStatus(object2.getStatus());
            if (object2 instanceof DBColumnType) {
                dBColumnType.setKey(((DBColumnType)object2).getKey());
                dBColumnType.setIndex(((DBColumnType)object2).getIndex());
            } else {
                dBColumnType.setKey("No");
                dBColumnType.setIndex("No");
            }
            this.dbAttributes.getDBAttribute().add(dBColumnType);
        }
        Object object3 = new TableAttributes(this.dbAttributes.getDBAttribute());
        this.setupItemsTable((GeneralAttributesTableModel)((Object)object3));
        object2 = new JScrollPane((Component)this._jAttributesTable);
        this.jAttributesComponent.setComponent((JComponent)object2);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        dBColumnType = new ControlBar();
        this.installItemFilterActions((ControlBar)dBColumnType);
        this._editBtn.setEnabled(true);
        this._removeBtn.setEnabled(true);
        this.jAttributesComponent.setControlBar((ControlBar)dBColumnType);
        this._jAttributesTable.setFillsViewportHeight(true);
        try {
            this._originalTableName = WorkflowUtils.getNewOutputTableNameWfid(this.getContext());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._originalTableName = null;
        }
        this.jTextFieldName.setText(this._originalTableName);
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._editBtn = new JButton(_editIcon);
        String string = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl;
                    UpdateTableNode updateTableNode = (UpdateTableNode)UpdateTableNodeCreateTablePanel.this.getData();
                    UpdateTableCreateNewTableAttributesDialog updateTableCreateNewTableAttributesDialog = new UpdateTableCreateNewTableAttributesDialog(UpdateTableNodeCreateTablePanel.this.dbAttributes);
                    AbstractNode abstractNode = updateTableNode.findParentNode();
                    if (abstractNode != null && abstractNode instanceof AbstractDataNode && (bl = updateTableCreateNewTableAttributesDialog.invoke(UpdateTableNodeCreateTablePanel.this._context, updateTableNode, (AbstractDataNode)abstractNode))) {
                        GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)UpdateTableNodeCreateTablePanel.this._jAttributesTable.getModel());
                        generalAttributesTableModel.fireTableDataChanged();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = UpdateTableNodeCreateTablePanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)UpdateTableNodeCreateTablePanel.this._jAttributesTable.getModel());
                    ArrayList<DBColumnType> arrayList = new ArrayList<DBColumnType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        DBColumnType dBColumnType = generalAttributesTableModel.getDataVector().get(nArray[i]);
                        if (!UpdateTableNodeCreateTablePanel.this.dbAttributes.getDBAttribute().contains(dBColumnType)) continue;
                        arrayList.add(dBColumnType);
                    }
                    if (!arrayList.isEmpty()) {
                        UpdateTableNodeCreateTablePanel.this.dbAttributes.getDBAttribute().removeAll(arrayList);
                        generalAttributesTableModel.fireTableDataChanged();
                    }
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        this._jAttributesTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor();
        TableColumn tableColumn2 = this._jAttributesTable.getColumnModel().getColumn(4);
        tableColumn2.setCellEditor(dBObjectNameEditor);
    }

    @Override
    public boolean doWork() {
        String string;
        Object object2;
        boolean bl = true;
        String string2 = this.jTextFieldName.getText().trim();
        if (string2.length() == 0) {
            MessageDialog.error((Component)this, (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_MISSING"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR_TITLE"), null);
            return false;
        }
        if (!StringUtils.isDoubleQuotedString(string2)) {
            string2 = string2.toUpperCase();
        }
        if (!TableNameValidator.validateTableName(string2, null, this._context, true)) {
            return false;
        }
        string2 = StringUtils.trimDoubleQuotes(string2);
        if (this._originalTableName != null && !this._originalTableName.equals(string2) && !TableNameValidator.isTableNameUnique(this._context, string2)) {
            String string3 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_DUPLICATE"), string2);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null);
            return false;
        }
        String string4 = null;
        Connection connection = null;
        try {
            connection = Connections.getSharedConnection(this._context);
            string4 = Connections.getUserAccountName(this._context);
            string4 = StringUtils.isDoubleQuotedString(string4) ? StringUtils.trimDoubleQuotes(string4) : string4.toUpperCase();
            ConnectionFolder.setConnectionAlterSessionFixes(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        if (this.dbAttributes.getDBAttribute().isEmpty()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = new String[this.dbAttributes.getDBAttribute().size()];
        String[] stringArray2 = new String[this.dbAttributes.getDBAttribute().size()];
        int n = 0;
        for (Object object2 : this.dbAttributes.getDBAttribute()) {
            hashMap.put(object2.getName(), (AttributeType)object2);
            string = "\"" + object2.getName() + "\"";
            String string5 = "\"" + (object2.getAlias() != null && !object2.getAlias().isEmpty() ? object2.getAlias() : object2.getName()) + "\"";
            stringArray[n] = string;
            stringArray2[n++] = string5;
            if (object2.getKey().equals("Yes")) {
                arrayList.add(string5);
            }
            if (!object2.getIndex().equals("Yes")) continue;
            arrayList2.add(string5);
        }
        this.tablePropertyValue = new AbstractDataNode.TablePropertyValue(string4, string2, hashMap);
        UpdateTableNode updateTableNode = (UpdateTableNode)this.getData();
        object2 = updateTableNode.findParentNode();
        assert (object2 instanceof AbstractDataNode);
        string = ((AbstractDataNode)object2).getInputSQL();
        int n2 = -1;
        try {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"ODMR_OBJECT_NAMES", (Connection)connection);
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)stringArray);
            ARRAY aRRAY2 = new ARRAY(arrayDescriptor, connection, (Object)stringArray2);
            ARRAY aRRAY3 = new ARRAY(arrayDescriptor, connection, (Object)arrayList.toArray(new String[arrayList.size()]));
            ARRAY aRRAY4 = new ARRAY(arrayDescriptor, connection, (Object)arrayList2.toArray(new String[arrayList2.size()]));
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{? = call ODMR_UTIL.CREATE_TABLE_EXTERNAL2(?, ?, ?, ?, ?, ?)}");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setString(2, "\"" + string2 + "\"");
            oracleCallableStatement.setARRAY(3, aRRAY3);
            oracleCallableStatement.setARRAY(4, aRRAY4);
            oracleCallableStatement.setARRAY(5, aRRAY);
            oracleCallableStatement.setARRAY(6, aRRAY2);
            oracleCallableStatement.setString(7, string);
            oracleCallableStatement.execute();
            n2 = oracleCallableStatement.getInt(1);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("DIALOG_CREATE_TABLE_FAIL_TITLE"), (String)DataDialogsLrb.get("DIALOG_CREATE_TABLE_FAIL_MSG"), null);
            bl = false;
        }
        if (bl) {
            this.updateColumnNames(this.tablePropertyValue.getColumns());
        }
        return bl;
    }

    public AbstractDataNode.TablePropertyValue getTablePropertyValue() {
        return this.tablePropertyValue;
    }

    private void updateColumnNames(Map<String, AttributeType> map) {
        Collection<AttributeType> collection = map.values();
        for (AttributeType attributeType : collection) {
            if (attributeType.getAlias() == null || attributeType.getAlias().equals(attributeType.getName())) continue;
            attributeType.setName(attributeType.getAlias());
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            UpdateTableNodeCreateTablePanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            for (DBColumnType dBColumnType : UpdateTableNodeCreateTablePanel.this.dbAttributes.getDBAttribute()) {
                if (!dBColumnType.getName().equals(object.toString()) || 0 != dBColumnType.getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                bl3 = true;
                break;
            }
            this.setIcon(bl3 ? _valid_attribue_icon : _invalid_attribue_icon);
            return component;
        }
    }

    private class TableAttributes
    extends GeneralAttributesTableModel {
        TableAttributes(List<DBColumnType> list) {
            super(list);
            this.setColumnIdentifiers(UpdateTableNodeCreateTablePanel.this._columnNames_table);
            this.setColumnCount(5);
        }

        @Override
        protected int getAliasColumn() {
            return 4;
        }
    }

    private abstract class GeneralAttributesTableModel
    extends GenericBaseTableModel {
        protected List<DBColumnType> _srcData;

        protected abstract int getAliasColumn();

        GeneralAttributesTableModel(List<DBColumnType> list) {
            this._srcData = list;
            this.setRowCount(this._srcData.size());
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Vector<DBColumnType> getDataVector() {
            Vector<DBColumnType> vector = new Vector<DBColumnType>();
            vector.addAll(this._srcData);
            return vector;
        }

        public void clearRows() {
            this._srcData.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != this.getAliasColumn() && n2 != 3 && n2 != 2) {
                return;
            }
            DBColumnType dBColumnType = this._srcData.get(n);
            if (n2 == this.getAliasColumn()) {
                Vector<DBColumnType> vector = new Vector<DBColumnType>();
                vector.addAll(this._srcData);
                vector.remove(dBColumnType);
                String string = null;
                String string2 = dBColumnType.getAlias();
                String string3 = dBColumnType.getName();
                if (object != null) {
                    string = ((String)object).trim();
                }
                if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                    string2 = StringUtils.addDoubleQuotes(string2);
                }
                if (string.length() != 0) {
                    if (!StringUtils.isDoubleQuotedString(string)) {
                        string = string.toUpperCase();
                    }
                    if (string2 != null && string2.compareTo(string) == 0) {
                        return;
                    }
                    if (!AttributeNameValidator.validateAttributeName(string, vector, UpdateTableNodeCreateTablePanel.this._context, true)) {
                        return;
                    }
                } else if (string2 != null && string2.length() != 0 && !AttributeNameValidator.validateAttributeName(string3, vector, UpdateTableNodeCreateTablePanel.this._context, true)) {
                    return;
                }
                if (string2 != null && string2.compareTo(string) == 0) {
                    return;
                }
                string = StringUtils.trimDoubleQuotes(string);
                dBColumnType.setAlias(string);
            } else if (n2 == 2) {
                dBColumnType.setKey(object.equals(true) ? "Yes" : "No");
                if (object.equals(true) && dBColumnType.getIndex().equals("Yes")) {
                    dBColumnType.setIndex("No");
                }
            } else if (n2 == 3) {
                dBColumnType.setIndex(object.equals(true) ? "Yes" : "No");
                if (object.equals(true) && dBColumnType.getKey().equals("Yes")) {
                    dBColumnType.setKey("No");
                }
            }
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            DBColumnType dBColumnType = this._srcData.get(n);
            Object object = null;
            if (n2 == 0) {
                object = dBColumnType.getName();
            } else if (n2 == this.getAliasColumn()) {
                object = dBColumnType.getAlias();
            } else if (n2 == 1) {
                object = dBColumnType.getDataType();
            } else if (n2 == 3) {
                String string = dBColumnType.getIndex();
                object = string != null ? Boolean.valueOf(string.equals("Yes")) : "";
            } else if (n2 == 2) {
                String string = dBColumnType.getKey();
                object = string != null ? Boolean.valueOf(string.equals("Yes")) : "";
            } else assert (false) : "Out of bounds column when accessing items";
            return object != null ? object : "";
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<DBColumnType> vector = new Vector<DBColumnType>();
            DBColumnType dBColumnType = null;
            for (int i = 0; i < nArray.length; ++i) {
                dBColumnType = this._srcData.get(nArray[i]);
                vector.add(dBColumnType);
            }
            this._srcData.removeAll(vector);
            this.setRowCount(this._srcData.size());
            this.fireTableDataChanged();
        }

        public TableModel getModel() {
            return this;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == this.getAliasColumn()) {
                return true;
            }
            return n2 == 3 || n2 == 2;
        }
    }

    class GenericTableTooltipCustom
    extends GenericTableTooltip {
        GenericTableTooltipCustom() {
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            this.repaint();
        }
    }
}

