/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.teditor.structure.StructureViewState;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableNodeAttributesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTargetSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;

public class UpdateTableNodeAttributesDialog
extends DataConsumerAttributesDialog<UpdateTableNode> {
    UpdateTableNodeAttributesPanel content;

    @Override
    protected JEWTDialog buildDialog(Context context, UpdateTableNode updateTableNode, AbstractDataNode abstractDataNode) {
        this.content = new UpdateTableNodeAttributesPanel(context, updateTableNode, this.getAvailableUpdateNodeColumnInfo(updateTableNode));
        return super.buildDialog(context, this.content);
    }

    @Override
    protected List<AttributeType> getAvailableAttributes(AbstractDataNode abstractDataNode) {
        if (abstractDataNode != null) {
            return super.getAvailableAttributes(abstractDataNode);
        }
        return null;
    }

    @Override
    protected void cancel() {
        if (this.content != null) {
            this.content.cleanUp(true);
        }
    }

    @Override
    protected void registerHelp(JEWTDialog jEWTDialog) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "updatetable_node_edit");
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("UPDATE_TABLE_DIALOG_TITLE");
    }

    protected UpdateNodeColumnInfo getAvailableUpdateNodeColumnInfo(final UpdateTableNode updateTableNode) {
        UpdateNodeColumnInfo updateNodeColumnInfo = new UpdateNodeColumnInfo();
        class GetAttrs
        extends ProgressRunnable {
            List<MapTargetSourceType> availAttrs = new ArrayList<MapTargetSourceType>();
            Map<String, String> requiredColumns = new HashMap<String, String>();

            GetAttrs() {
            }

            protected Object doWork() throws Exception {
                UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)updateTableNode.getData();
                Boolean bl = Boolean.TRUE;
                this.requiredColumns = UpdateTableNode.getRequiredColumns(UpdateTableNodeAttributesDialog.this.context, StringUtils.escapeSingleQuotesForSQL(updateTableNodeType.getUpdateTargetTable().getSchema()), StringUtils.escapeSingleQuotesForSQL(updateTableNodeType.getUpdateTargetTable().getName()));
                StructureViewState structureViewState = new StructureViewState(UpdateTableNodeAttributesDialog.this.context, false);
                structureViewState.setTableName(updateTableNodeType.getUpdateTargetTable().getSchema(), updateTableNodeType.getUpdateTargetTable().getName());
                try {
                    structureViewState.load();
                    Vector<ColumnDataRow> vector = structureViewState.getTableModel().getDataVector();
                    for (ColumnDataRow columnDataRow : vector) {
                        UpdateTableColumnType updateTableColumnType = new UpdateTableColumnType();
                        updateTableColumnType.setName(columnDataRow.getName());
                        updateTableColumnType.setDataType(columnDataRow.getDataType());
                        updateTableColumnType.setStatus(AttributeStatus.VALID);
                        updateTableColumnType.setAlias(columnDataRow.getName());
                        MapTargetSourceType mapTargetSourceType = new MapTargetSourceType();
                        mapTargetSourceType.setKey(updateTableColumnType);
                        if (!this.requiredColumns.isEmpty() && null != this.requiredColumns.get(updateTableColumnType.getName())) {
                            mapTargetSourceType.getKey().setRequiredColumn(true);
                        }
                        mapTargetSourceType.setValue(UpdateTableNode.getEmptyAttributeType());
                        this.availAttrs.add(mapTargetSourceType);
                    }
                    AbstractNode abstractNode = updateTableNode.findParentNode();
                    if (abstractNode != null) {
                        updateTableNode.validateAttributes(this.availAttrs, abstractNode, true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bl = Boolean.FALSE;
                }
                return bl;
            }

            public List<MapTargetSourceType> getAvailAttrs() {
                return this.availAttrs;
            }

            public Map<String, String> getRequiredColumns() {
                return this.requiredColumns;
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
            updateNodeColumnInfo.requiredColumns = getAttrs.getRequiredColumns();
            updateNodeColumnInfo.availAttrs = getAttrs.getAvailAttrs();
        }
        catch (ProgressException progressException) {
            progressException.printStackTrace();
        }
        return updateNodeColumnInfo;
    }

    public static class UpdateNodeColumnInfo {
        List<MapTargetSourceType> availAttrs = new ArrayList<MapTargetSourceType>();
        Map<String, String> requiredColumns = new HashMap<String, String>();
    }
}

