/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileInputType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.dialogs.ExceptionDialog;

public class DataProfileAttributesPanel
extends AbstractDialogPanel
implements DataConsumerPanel {
    protected List<AttributeType> availAttrsCache;
    protected List<AttributeType> selectedAttrsCache;
    private List<String> _allowedAttributes = new ArrayList<String>();
    private HashMap<String, AttributeType> _allAttributesMap = new HashMap();
    private static String _defaultGroupByValue = DataDialogsLrb.get("PROFILE_GROUP_BY_DEFAULT_VALUE");
    private static AttributeTypeHelper.AttributeTypeComparator _comparator = new AttributeTypeHelper.AttributeTypeComparator();
    private GenericTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JCheckBox jChkBoxAuto;
    private JComboBox jCmblGroupBy;
    private JLabel jLblGroupBy;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private GenericTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;
    private JLabel jSelectedLabel;
    private static Icon _valid_attribue_icon;
    private static Icon _invalid_attribue_icon;
    private static Icon _select;
    private static Icon _selectAll;
    private static Icon _remove;
    private static Icon _removeAll;

    public DataProfileAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
        super(context, abstractNode);
        this.availAttrsCache = list;
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        for (AttributeType attributeType : this.availAttrsCache) {
            this._allAttributesMap.put(attributeType.getName(), attributeType);
            try {
                if (DatabaseMetadataUtils.isACustomDataType(this._context, attributeType.getDataType())) {
                    continue;
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
            String string = DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType());
            if (!string.equals("Numerical") && !string.equals("Categorical")) continue;
            this._allowedAttributes.add(attributeType.getName());
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblGroupBy = new JLabel();
        this.jCmblGroupBy = new JComboBox();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new GenericTable();
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new GenericTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jChkBoxAuto = new JCheckBox();
        this.jLblGroupBy.setText("Group By:");
        this.jCmblGroupBy.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jAvailableLabel.setText("Available Attributes");
        this.jSelectedLabel.setText("Selected Attributes");
        this.jAvailAttrs.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrsScrollPane.setViewportView((Component)this.jAvailAttrs);
        this.jSelectedAttrs.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrsScrollPane.setViewportView((Component)this.jSelectedAttrs);
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jChkBoxAuto.setText("Auto Input Columns Selection");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblGroupBy, -1, 105, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmblGroupBy, 0, 218, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jAvailAttrsScrollPane, 0, 265, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jRemoveAllBtn, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, GroupLayout.Alignment.LEADING, -1, 51, Short.MAX_VALUE).addComponent(this.jSelectBtn, GroupLayout.Alignment.LEADING, -1, 51, Short.MAX_VALUE).addComponent(this.jSelectAllBtn)))).addGap(16, 16, 16).addComponent(this.jSelectedAttrsScrollPane, -1, 265, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jChkBoxAuto, GroupLayout.Alignment.LEADING, -1, 267, Short.MAX_VALUE).addComponent(this.jAvailableLabel, GroupLayout.Alignment.LEADING, -1, 267, Short.MAX_VALUE)).addGap(75, 75, 75).addComponent(this.jSelectedLabel, -1, 267, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jRemoveAllBtn, this.jRemoveBtn, this.jSelectAllBtn, this.jSelectBtn);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblGroupBy).addComponent(this.jCmblGroupBy, -2, 20, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jChkBoxAuto).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAvailableLabel).addComponent(this.jSelectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSelectedAttrsScrollPane, -1, 239, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, -1, 239, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRemoveAllBtn).addGap(72, 72, 72)))));
        groupLayout.linkSize(1, this.jRemoveAllBtn, this.jRemoveBtn, this.jSelectAllBtn, this.jSelectBtn);
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DataDialogsLrb.get("AVAILABLE_LABEL"), this.jAvailableLabel);
        hashMap.put(DataDialogsLrb.get("SELECTED_LABEL"), this.jSelectedLabel);
        this.jChkBoxAuto.setText(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        this.jChkBoxAuto.setOpaque(false);
        this.jLblGroupBy.setText(DataDialogsLrb.get("PROFILE_GROUP_BY_LABEL"));
        UIResourceHelper.setComponentText(hashMap);
        this.initIcons();
    }

    private void initIcons() {
        if (_invalid_attribue_icon == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _invalid_attribue_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _valid_attribue_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
            _select = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHT"));
            _selectAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHTALL"));
            _remove = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFT"));
            _removeAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFTALL"));
        }
        this.jSelectBtn.setIcon(_select);
        this.jSelectAllBtn.setIcon(_selectAll);
        this.jRemoveBtn.setIcon(_remove);
        this.jRemoveAllBtn.setIcon(_removeAll);
    }

    protected List<AttributeType> getSelectedAttributes() {
        AbstractNode abstractNode = this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractNode.getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        List<Object> list = new ArrayList<AttributeType>();
        if (null != dataProfileInputType.getAttributes()) {
            list = dataProfileInputType.getAttributes().getAttribute();
        }
        return list;
    }

    @Override
    public void initUI() {
        Object object;
        Object object22;
        List<AttributeType> list = this.getSelectedAttributes();
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        for (Object object22 : list) {
            object = (AttributeType)MetaDataHelper.copyMetadataObject(object22);
            this.selectedAttrsCache.add((AttributeType)object);
        }
        String[] stringArray = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        object22 = new AttrTableModel(this.availAttrsCache, stringArray);
        this.jAvailAttrs.setModel((TableModel)object22);
        this.jAvailAttrs.setSorted(true);
        object = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(_valid_attribue_icon, _invalid_attribue_icon);
        ((TableColumn)object).setCellRenderer(attributeNameCellRenderer);
        AttrTableModel attrTableModel = new AttrTableModel(this.selectedAttrsCache, stringArray);
        this.jSelectedAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jSelectedAttrs.setSorted(true);
        object = this.jSelectedAttrs.getColumnModel().getColumn(0);
        attributeNameCellRenderer = new AttributeNameCellRenderer(_valid_attribue_icon, _invalid_attribue_icon);
        ((TableColumn)object).setCellRenderer(attributeNameCellRenderer);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.jAvailAttrs, DataProfileAttributesPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.jAvailAttrs, DataProfileAttributesPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.jSelectedAttrs, DataProfileAttributesPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.jSelectedAttrs, DataProfileAttributesPanel.this.jAvailAttrs, true);
            }
        });
        this.jLblGroupBy.setLabelFor(this.jCmblGroupBy);
        Collections.sort(this._allowedAttributes);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new Vector<String>(this._allowedAttributes));
        defaultComboBoxModel.addElement(_defaultGroupByValue);
        String string = _defaultGroupByValue;
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractDataNode.getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        AttributeType attributeType = dataProfileInputType.getGroupByAttribute();
        if (null != attributeType) {
            string = attributeType.getName();
            if (-1 == this._allowedAttributes.indexOf(string)) {
                defaultComboBoxModel.addElement(string);
            }
            if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jLblGroupBy.setIcon(_invalid_attribue_icon);
            }
        } else {
            this.jLblGroupBy.setIcon(null);
        }
        this.jCmblGroupBy.setModel(defaultComboBoxModel);
        this.jCmblGroupBy.setSelectedItem(string);
        this.jCmblGroupBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)DataProfileAttributesPanel.this.jCmblGroupBy.getSelectedItem();
                if (string.equals(_defaultGroupByValue)) {
                    DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                    return;
                }
                AttributeType attributeType = (AttributeType)DataProfileAttributesPanel.this._allAttributesMap.get(string);
                if (attributeType == null) {
                    DataProfileAttributesPanel.this.jLblGroupBy.setIcon(_invalid_attribue_icon);
                    return;
                }
                boolean bl = attributeType.getStatus().equals((Object)AttributeStatus.VALID);
                DataProfileAttributesPanel.this.jLblGroupBy.setIcon(bl ? null : _invalid_attribue_icon);
            }
        });
        boolean bl = 0 == dataProfileNodeType.getAutoSpec().value().compareTo("Yes");
        this.jChkBoxAuto.setSelected(bl);
        this.jSelectBtn.setEnabled(!bl);
        this.jSelectAllBtn.setEnabled(!bl);
        this.jRemoveBtn.setEnabled(!bl);
        this.jRemoveAllBtn.setEnabled(!bl);
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataProfileAttributesPanel.this.jChkBoxAuto.isSelected();
                DataProfileAttributesPanel.this.jSelectBtn.setEnabled(!bl);
                DataProfileAttributesPanel.this.jSelectAllBtn.setEnabled(!bl);
                DataProfileAttributesPanel.this.jRemoveBtn.setEnabled(!bl);
                DataProfileAttributesPanel.this.jRemoveAllBtn.setEnabled(!bl);
                if (bl) {
                    DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.jAvailAttrs, DataProfileAttributesPanel.this.jSelectedAttrs, true);
                    String string = (String)DataProfileAttributesPanel.this.jCmblGroupBy.getSelectedItem();
                    if (string.equals(_defaultGroupByValue)) {
                        DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                    } else {
                        AttributeType attributeType = (AttributeType)DataProfileAttributesPanel.this._allAttributesMap.get(string);
                        if (attributeType == null) {
                            DataProfileAttributesPanel.this.jCmblGroupBy.setSelectedItem(_defaultGroupByValue);
                            DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                        }
                    }
                }
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<AttributeType> list = ((AttrTableModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = list.get(nArray[n2]);
                arrayList.add((AttributeType)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List<AttributeType> list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            object2[n] = (AttributeType)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        DataProfileNode dataProfileNode = (DataProfileNode)this.getData();
        DataProfileInputType dataProfileInputType = new DataProfileInputType();
        Attributes attributes = new Attributes();
        dataProfileInputType.setAttributes(attributes);
        String string = this.jCmblGroupBy.getSelectedItem().toString();
        AttributeType attributeType = this._allAttributesMap.get(string);
        dataProfileInputType.setGroupByAttribute(attributeType);
        List list = attributes.getAttribute();
        list.addAll(this.selectedAttrsCache);
        try {
            CommandProcessor.getInstance().beginTrans(DataProfileNode.DATAPROFILE_INPUT);
            dataProfileNode.setState(NodeStatusType.READY);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(DataProfileNode.DATAPROFILE_INPUT, null, dataProfileInputType, null, null));
            String string2 = this.jChkBoxAuto.isSelected() ? "Yes" : "No";
            AutoSpecType autoSpecType = AutoSpecType.fromValue((String)string2);
            arrayList.add(new Property(String.valueOf("autoSpec"), null, autoSpecType, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            odmrSDMUndoFilter.prepareUndoPropertyList(dataProfileNode, this.getContext(), arrayList);
            dataProfileNode.validate(true);
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            CommandProcessor.getInstance().abortTrans();
            bl = false;
        }
        return bl;
    }

    class AttrTableModel
    extends GenericBaseTableModel {
        private List<AttributeType> _data;
        private final int NAME = 0;
        private final int DATA_TYPE = 1;
        private final int COLUMN_COUNT = 2;

        public AttrTableModel(List<AttributeType> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this._data.size());
            this.setColumnCount(2);
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            AttributeType attributeType = this._data.get(n);
            if (0 == n2) {
                object = attributeType;
            } else if (1 == n2) {
                object = attributeType.getDataType();
            }
            return object;
        }

        public List<AttributeType> getDataList() {
            return this._data;
        }

        public Comparator getColumnSortComparator(int n) {
            if (0 == n) {
                return _comparator;
            }
            return super.getColumnSortComparator(n);
        }
    }
}

