/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.WorkflowColumnFilterNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.preferences.ColumnFilterPreferencesPanel;
import oracle.dmt.dataminer.workflow.xmlschema.AttrImportantSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DataQualitySettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;

public class SettingsPanel
extends AbstractDialogPanel {
    private OutputColumnPanel _parent;
    private WorkflowColumnFilterNodePropertyProxyModel _propertyModel;
    private ColumnFilterSettingsType _columnFilterSettings;
    private static Icon _invalid_icon;
    private boolean _dirty;
    private boolean _isAdjusting;
    private String _generatedAITableName = "NULL";
    private AttributeItem SELECT_A_TARGET;
    private JCheckBox jAttrImportanceCheckBox;
    private JCheckBox jConstantPercentCheckBox;
    private JSpinner jConstantPercentSpinner;
    private JCheckBox jDataQualityCheckBox;
    private JCheckBox jImportanceCheckBox;
    private JSpinner jImportanceSpinner;
    private JCheckBox jNullPercentCheckBox;
    private JSpinner jNullPercentSpinner;
    private JLabel jSampleSizeLabel;
    private JSpinner jSampleSizeSpinner;
    private JCheckBox jSamplingCheckBox;
    private JLabel jSamplingTypeLabel;
    private JComboBox jTargetComboBox;
    private JLabel jTargetLabel;
    private JCheckBox jTopNCheckBox;
    private JSpinner jTopNSpinner;
    private JCheckBox jUniquePercentCheckBox;
    private JSpinner jUniquePercentSpinner;

    public SettingsPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.init((ColumnFilterNode)this._data, propertyModel);
    }

    public SettingsPanel(Context context, ColumnFilterNode columnFilterNode, OutputColumnPanel outputColumnPanel) {
        super(context, columnFilterNode);
        assert (context != null) : "Context must not be null.";
        assert (columnFilterNode != null) : "ColumnFilter node must not be null.";
        assert (columnFilterNode instanceof ColumnFilterNode) : "Must be an instance of ColumnFilter node.";
        this._parent = outputColumnPanel;
        this.init(columnFilterNode, null);
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private void init(ColumnFilterNode columnFilterNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        if (this._parent == null) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
            this._columnFilterSettings = (ColumnFilterSettingsType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterSettings());
        } else {
            this._columnFilterSettings = this._parent.getColumnFilterSettings();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_DATA_QUALITY"), this.jDataQualityCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_NULL_PERCENT"), this.jNullPercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_UNIQUE_PERCENT"), this.jUniquePercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_CONSTANT_PERCENT"), this.jConstantPercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_ATTR_IMPORTANCE"), this.jAttrImportanceCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_AI_CUT_OFF"), this.jImportanceCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_AI_TOPN"), this.jTopNCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_TYPE_RANDOM"), this.jSamplingCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_SIZE"), this.jSampleSizeLabel);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_TARGET"), this.jTargetLabel);
        this.jTargetLabel.setText("Target");
        UIResourceHelper.setComponentText(hashMap);
        Class<WorkflowEditor> clazz = WorkflowEditor.class;
        _invalid_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"columnfilter_settings");
        this._isAdjusting = true;
        ColumnFilterPreferencesPanel.ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.ColumnFilterPreferenceSettings.getInstance();
        DataQualitySettingsType dataQualitySettingsType = this._columnFilterSettings.getDataQualitySettings();
        this.jNullPercentCheckBox.setSelected(dataQualitySettingsType.getNullsPercent() != null);
        if (dataQualitySettingsType.getNullsPercent() != null) {
            this.jNullPercentSpinner.setValue(dataQualitySettingsType.getNullsPercent());
        } else {
            this.jNullPercentSpinner.setValue(columnFilterPreferenceSettings.getNullsPercentValue());
        }
        this.jUniquePercentCheckBox.setSelected(dataQualitySettingsType.getUniquePercent() != null);
        if (dataQualitySettingsType.getUniquePercent() != null) {
            this.jUniquePercentSpinner.setValue(dataQualitySettingsType.getUniquePercent());
        } else {
            this.jUniquePercentSpinner.setValue(columnFilterPreferenceSettings.getUniquePercentValue());
        }
        this.jConstantPercentCheckBox.setSelected(dataQualitySettingsType.getConstantPercent() != null);
        if (dataQualitySettingsType.getConstantPercent() != null) {
            this.jConstantPercentSpinner.setValue(dataQualitySettingsType.getConstantPercent());
        } else {
            this.jConstantPercentSpinner.setValue(columnFilterPreferenceSettings.getConstantPercentValue());
        }
        boolean bl = this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected();
        this.jDataQualityCheckBox.setSelected(bl);
        AttrImportantSettingsType attrImportantSettingsType = this._columnFilterSettings.getAttrImportantSettings();
        this.jImportanceCheckBox.setSelected(attrImportantSettingsType.getCutOff() != null);
        if (attrImportantSettingsType.getCutOff() != null) {
            this.jImportanceSpinner.setValue(attrImportantSettingsType.getCutOff());
        } else {
            this.jImportanceSpinner.setValue(columnFilterPreferenceSettings.getCutOffValue());
        }
        this.jTopNCheckBox.setSelected(attrImportantSettingsType.getTopN() != null);
        if (attrImportantSettingsType.getTopN() != null) {
            this.jTopNSpinner.setValue(attrImportantSettingsType.getTopN());
        } else {
            this.jTopNSpinner.setValue(columnFilterPreferenceSettings.getTopNValue());
        }
        bl = this.jImportanceCheckBox.isSelected() || this.jTopNCheckBox.isSelected();
        this.jAttrImportanceCheckBox.setSelected(bl);
        this.jSamplingCheckBox.setSelected(this._columnFilterSettings.getNumberOfRows() != null);
        if (this._columnFilterSettings.getNumberOfRows() != null) {
            this.jSampleSizeSpinner.setValue(this._columnFilterSettings.getNumberOfRows());
        } else {
            this.jSampleSizeSpinner.setValue(columnFilterPreferenceSettings.getSamplingNumberOfRows());
        }
        AttributeType attributeType = new AttributeType();
        attributeType.setName(DialogsLrb.get("COLUMN_FILTER_SETTING_SELECT_A_TARGET"));
        attributeType.setDataType("String");
        this.SELECT_A_TARGET = new AttributeItem(attributeType);
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
        List<AttributeType> list = columnFilterNode.getTargetAttributes();
        Collections.sort(list, new AttributeTypeComparator());
        this.jTargetComboBox.removeAllItems();
        this.jTargetComboBox.addItem(this.SELECT_A_TARGET);
        for (AttributeType attributeType2 : list) {
            this.jTargetComboBox.addItem(new AttributeItem(attributeType2));
        }
        AttributeType attributeType3 = attrImportantSettingsType.getTargetAttribute();
        if (attributeType3 != null) {
            AttributeItem attributeItem;
            boolean bl2 = false;
            for (int i = 0; i < this.jTargetComboBox.getItemCount(); ++i) {
                attributeItem = (AttributeItem)this.jTargetComboBox.getItemAt(i);
                if (!attributeType3.getName().equals(attributeItem.getAttribute().getName())) continue;
                this.jTargetComboBox.setSelectedItem(attributeItem);
                bl2 = true;
                break;
            }
            if (!bl2) {
                AttributeType attributeType4 = new AttributeType();
                attributeType4.setName(attributeType3.getName());
                attributeType4.setDataType(attributeType3.getDataType());
                attributeType4.setStatus(attributeType3.getStatus());
                attributeItem = new AttributeItem(attributeType4);
                this.jTargetComboBox.addItem(attributeItem);
                this.jTargetComboBox.setSelectedItem(attributeItem);
            }
        }
        this._isAdjusting = false;
        this.jSamplingTypeLabel.setVisible(false);
        this.remove(this.jSamplingTypeLabel);
        this.enableControls();
    }

    private void enableControls() {
        this.jDataQualityCheckBox.setEnabled(this.isWritable());
        this.jAttrImportanceCheckBox.setEnabled(this.isWritable());
        this.jSamplingCheckBox.setEnabled(this.isWritable());
        this.jNullPercentCheckBox.setEnabled(this.isWritable() && this.jDataQualityCheckBox.isSelected());
        this.jUniquePercentCheckBox.setEnabled(this.isWritable() && this.jDataQualityCheckBox.isSelected());
        this.jConstantPercentCheckBox.setEnabled(this.isWritable() && this.jDataQualityCheckBox.isSelected());
        this.jNullPercentSpinner.setEnabled(this.isWritable() && this.jDataQualityCheckBox.isSelected() && this.jNullPercentCheckBox.isSelected());
        this.jUniquePercentSpinner.setEnabled(this.isWritable() && this.jDataQualityCheckBox.isSelected() && this.jUniquePercentCheckBox.isSelected());
        this.jConstantPercentSpinner.setEnabled(this.isWritable() && this.jDataQualityCheckBox.isSelected() && this.jConstantPercentCheckBox.isSelected());
        this.jImportanceCheckBox.setEnabled(this.isWritable() && this.jAttrImportanceCheckBox.isSelected());
        this.jTopNCheckBox.setEnabled(this.isWritable() && this.jAttrImportanceCheckBox.isSelected());
        this.jImportanceSpinner.setEnabled(this.isWritable() && this.jAttrImportanceCheckBox.isSelected() && this.jImportanceCheckBox.isSelected());
        this.jTopNSpinner.setEnabled(this.isWritable() && this.jAttrImportanceCheckBox.isSelected() && this.jTopNCheckBox.isSelected());
        this.jTargetComboBox.setEnabled(this.isWritable() && this.jAttrImportanceCheckBox.isSelected());
        this.jSampleSizeSpinner.setEnabled(this.isWritable() && this.jSamplingCheckBox.isSelected());
        if (this.jAttrImportanceCheckBox.isSelected()) {
            this.jSamplingCheckBox.setText(DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_TYPE_STRATIFIED"));
        } else {
            this.jSamplingCheckBox.setText(DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_TYPE_RANDOM"));
        }
        if (this.jAttrImportanceCheckBox.isSelected()) {
            AttributeItem attributeItem = (AttributeItem)this.jTargetComboBox.getSelectedItem();
            if (attributeItem.equals(this.SELECT_A_TARGET) || !attributeItem.getAttribute().getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jTargetLabel.setIcon(_invalid_icon);
            } else {
                this.jTargetLabel.setIcon(null);
            }
        } else {
            this.jTargetLabel.setIcon(null);
        }
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        if (columnFilterNode == null) {
            return;
        }
        this._propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = columnFilterNode;
        this._dirty = false;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        this._columnFilterSettings = (ColumnFilterSettingsType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterSettings());
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ColumnFilterNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ColumnFilterNodeType) {
            return (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        if (this._parent != null) {
            this._parent.setColumnFilterSettings(this._columnFilterSettings);
            this._parent.setAIResultTable(this._generatedAITableName);
            this._parent.setDirty(true);
        }
    }

    public ColumnFilterSettingsType getColumnFilterSettings() {
        return this._columnFilterSettings;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public boolean doWork() {
        boolean bl = true;
        if (this.isDirty() && !this.isPIMode()) {
            this.updateNode();
        }
        return bl;
    }

    private void initComponents() {
        this.jDataQualityCheckBox = new JCheckBox();
        this.jNullPercentCheckBox = new JCheckBox();
        this.jNullPercentSpinner = new JSpinner();
        this.jUniquePercentCheckBox = new JCheckBox();
        this.jUniquePercentSpinner = new JSpinner();
        this.jConstantPercentCheckBox = new JCheckBox();
        this.jConstantPercentSpinner = new JSpinner();
        this.jAttrImportanceCheckBox = new JCheckBox();
        this.jTargetLabel = new JLabel();
        this.jTargetComboBox = new JComboBox();
        this.jImportanceCheckBox = new JCheckBox();
        this.jTopNCheckBox = new JCheckBox();
        this.jImportanceSpinner = new JSpinner();
        this.jTopNSpinner = new JSpinner();
        this.jSamplingCheckBox = new JCheckBox();
        this.jSamplingTypeLabel = new JLabel();
        this.jSampleSizeLabel = new JLabel();
        this.jSampleSizeSpinner = new JSpinner();
        this.jDataQualityCheckBox.setText("Data Quality");
        this.jDataQualityCheckBox.setName("jDataQualityCheckBox");
        this.jDataQualityCheckBox.setOpaque(false);
        this.jDataQualityCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jDataQualityCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentCheckBox.setText("% Nulls less than or equal");
        this.jNullPercentCheckBox.setName("jNullPercentCheckBox");
        this.jNullPercentCheckBox.setOpaque(false);
        this.jNullPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jNullPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jNullPercentSpinner.setName("jNullPercentSpinner");
        this.jNullPercentSpinner.setOpaque(false);
        this.jNullPercentSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jNullPercentSpinnerStateChanged(changeEvent);
            }
        });
        this.jUniquePercentCheckBox.setText("% Unique less than or equal");
        this.jUniquePercentCheckBox.setName("jUniquePercentCheckBox");
        this.jUniquePercentCheckBox.setOpaque(false);
        this.jUniquePercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jUniquePercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jUniquePercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jUniquePercentSpinner.setName("jUniquePercentSpinner");
        this.jUniquePercentSpinner.setOpaque(false);
        this.jUniquePercentSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jUniquePercentSpinnerStateChanged(changeEvent);
            }
        });
        this.jConstantPercentCheckBox.setText("% Constant less than or equal");
        this.jConstantPercentCheckBox.setName("jConstantPercentCheckBox");
        this.jConstantPercentCheckBox.setOpaque(false);
        this.jConstantPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jConstantPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jConstantPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jConstantPercentSpinner.setName("jConstantPercentSpinner");
        this.jConstantPercentSpinner.setOpaque(false);
        this.jConstantPercentSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jConstantPercentSpinnerStateChanged(changeEvent);
            }
        });
        this.jAttrImportanceCheckBox.setText("Attribute Importance");
        this.jAttrImportanceCheckBox.setName("jAttrImportanceCheckBox");
        this.jAttrImportanceCheckBox.setOpaque(false);
        this.jAttrImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jAttrImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTargetLabel.setText("Target");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<Select a Target>"}));
        this.jTargetComboBox.setName("jTargetComboBox");
        this.jTargetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jTargetComboBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceCheckBox.setText("Importance Cutoff");
        this.jImportanceCheckBox.setName("jImportanceCheckBox");
        this.jImportanceCheckBox.setOpaque(false);
        this.jImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTopNCheckBox.setText("Top N");
        this.jTopNCheckBox.setName("jTopNCheckBox");
        this.jTopNCheckBox.setOpaque(false);
        this.jTopNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jTopNCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceSpinner.setModel(new SpinnerNumberModel(0.1, 0.0, 1.0, 0.1));
        this.jImportanceSpinner.setName("jImportanceSpinner");
        this.jImportanceSpinner.setOpaque(false);
        this.jImportanceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jImportanceSpinnerStateChanged(changeEvent);
            }
        });
        this.jTopNSpinner.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(1), null, (Number)1));
        this.jTopNSpinner.setName("jTopNSpinner");
        this.jTopNSpinner.setOpaque(false);
        this.jTopNSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jTopNSpinnerStateChanged(changeEvent);
            }
        });
        this.jSamplingCheckBox.setText("Sampling");
        this.jSamplingCheckBox.setName("jSamplingCheckBox");
        this.jSamplingCheckBox.setOpaque(false);
        this.jSamplingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jSamplingCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSamplingTypeLabel.setText("Type of Sampling: Stratified (AI)");
        this.jSamplingTypeLabel.setName("jSamplingTypeLabel");
        this.jSampleSizeLabel.setText("Sample Size");
        this.jSampleSizeLabel.setName("jSampleSizeLabel");
        this.jSampleSizeSpinner.setModel(new SpinnerNumberModel((Number)2000, Integer.valueOf(1), null, (Number)1000));
        this.jSampleSizeSpinner.setName("jSampleSizeSpinner");
        this.jSampleSizeSpinner.setOpaque(false);
        this.jSampleSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jSampleSizeSpinnerStateChanged(changeEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAttrImportanceCheckBox, -2, 292, -2).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetLabel, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComboBox, -2, 208, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTopNCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jImportanceCheckBox, -1, 183, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jImportanceSpinner, -2, 86, -2).addComponent(this.jTopNSpinner, GroupLayout.Alignment.TRAILING, -2, 86, -2))))))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSamplingTypeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jSampleSizeLabel, -2, 181, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSampleSizeSpinner, -2, 86, -2)).addComponent(this.jSamplingCheckBox, -2, 292, -2))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jDataQualityCheckBox, -1, 296, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(27, 27, 27).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jConstantPercentCheckBox, -1, 183, Short.MAX_VALUE).addComponent(this.jNullPercentCheckBox, -1, 183, Short.MAX_VALUE).addComponent(this.jUniquePercentCheckBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNullPercentSpinner, -2, 86, -2).addComponent(this.jUniquePercentSpinner, -2, 86, -2).addComponent(this.jConstantPercentSpinner, -2, 86, -2)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jDataQualityCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNullPercentSpinner, -2, -1, -2).addComponent(this.jNullPercentCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUniquePercentSpinner, -2, -1, -2).addComponent(this.jUniquePercentCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConstantPercentSpinner, -2, -1, -2).addComponent(this.jConstantPercentCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jAttrImportanceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTargetLabel).addComponent(this.jTargetComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jImportanceCheckBox).addComponent(this.jImportanceSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTopNCheckBox).addComponent(this.jTopNSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSamplingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSamplingTypeLabel).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleSizeLabel).addComponent(this.jSampleSizeSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jDataQualityCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jDataQualityCheckBox.isSelected();
        this.jNullPercentCheckBox.setSelected(bl);
        this.jUniquePercentCheckBox.setSelected(bl);
        this.jConstantPercentCheckBox.setSelected(bl);
        this.jNullPercentCheckBoxActionPerformed(null);
        this.jUniquePercentCheckBoxActionPerformed(null);
        this.jConstantPercentCheckBoxActionPerformed(null);
    }

    private void jAttrImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jAttrImportanceCheckBox.isSelected();
        if (!bl) {
            this._generatedAITableName = "NULL";
            this.jTargetComboBox.setSelectedItem(this.SELECT_A_TARGET);
        }
        this.jImportanceCheckBox.setSelected(bl);
        this.jTopNCheckBox.setSelected(bl);
        this.jTargetComboBoxActionPerformed(null);
        this.jImportanceCheckBoxActionPerformed(null);
        this.jTopNCheckBoxActionPerformed(null);
    }

    private void jNullPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        Double d = null;
        if (this.jNullPercentCheckBox.isSelected()) {
            d = (Double)this.jNullPercentSpinner.getValue();
        }
        this._columnFilterSettings.getDataQualitySettings().setNullsPercent(d);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData().getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("nullPercent", d);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getNullsPercent());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.NULL_PERCENT), null, complexProperty, null, null));
            this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_NULL_PERCENT_CHANGED_DESCRIPTION"), this.getData(), arrayList);
        }
        this.enableControls();
    }

    private void jUniquePercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        Double d = null;
        if (this.jUniquePercentCheckBox.isSelected()) {
            d = (Double)this.jUniquePercentSpinner.getValue();
        }
        this._columnFilterSettings.getDataQualitySettings().setUniquePercent(d);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData().getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("uniquePercent", d);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getUniquePercent());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.UNIQUE_PERCENT), null, complexProperty, null, null));
            this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_UNIQUE_PERCENT_CHANGED_DESCRIPTION"), this.getData(), arrayList);
        }
        this.enableControls();
    }

    private void jConstantPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        Double d = null;
        if (this.jConstantPercentCheckBox.isSelected()) {
            d = (Double)this.jConstantPercentSpinner.getValue();
        }
        this._columnFilterSettings.getDataQualitySettings().setConstantPercent(d);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData().getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("constantPercent", d);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getConstantPercent());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.CONSTANT_PERCENT), null, complexProperty, null, null));
            this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_CONSTANT_PERCENT_CHANGED_DESCRIPTION"), this.getData(), arrayList);
        }
        this.enableControls();
    }

    private void jTargetComboBoxActionPerformed(ActionEvent actionEvent) {
        AITableNameGen aITableNameGen;
        if (this._isAdjusting) {
            return;
        }
        AttributeItem attributeItem = (AttributeItem)this.jTargetComboBox.getSelectedItem();
        if (!attributeItem.equals(this.SELECT_A_TARGET)) {
            this.jTargetComboBox.removeItem(this.SELECT_A_TARGET);
            this._dirty = true;
        }
        if (this.jAttrImportanceCheckBox.isSelected() && !attributeItem.equals(this.SELECT_A_TARGET)) {
            if (this._generatedAITableName.equals("NULL")) {
                aITableNameGen = new AITableNameGen();
                aITableNameGen.setTitle(DialogsLrb.get("COLUMN_FILTER_AI_TABLE_GEN_TITLE"));
                aITableNameGen.setMessage(DialogsLrb.get("COLUMN_FILTER_AI_TABLE_GEN_DESC"));
                aITableNameGen.setCancelable(true);
                try {
                    aITableNameGen.start(true);
                    if (!aITableNameGen.isCanceled()) {
                        this._generatedAITableName = aITableNameGen.getTableName();
                    }
                }
                catch (ProgressException progressException) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
                }
            }
        } else {
            this._generatedAITableName = "NULL";
            attributeItem = new AttributeItem(null);
        }
        if (this.isPIMode()) {
            aITableNameGen = (ColumnFilterNodeType)this.getData().getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("AttrImportanceTable", this._generatedAITableName);
            complexProperty.setOldData(aITableNameGen.getColumnFilterResults().getAttrImportanceOutput());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.AI_TABLE), null, complexProperty, null, null));
            complexProperty = new ComplexProperty("target", attributeItem.getAttribute());
            complexProperty.setOldData(aITableNameGen.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.TARGET), null, complexProperty, null, null));
            this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_TARGET_CHANGED_DESCRIPTION"), this.getData(), arrayList);
        } else {
            this._columnFilterSettings.getAttrImportantSettings().setTargetAttribute(attributeItem.getAttribute());
        }
        this.enableControls();
    }

    private void jImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this._generatedAITableName = "NULL";
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        Double d = null;
        if (this.jImportanceCheckBox.isSelected()) {
            d = (Double)this.jImportanceSpinner.getValue();
        }
        this._columnFilterSettings.getAttrImportantSettings().setCutOff(d);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData().getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("importance", d);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getCutOff());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.IMPORTANCE), null, complexProperty, null, null));
            this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_IMPORTANCE_CHANGED_DESCRIPTION"), this.getData(), arrayList);
        }
        this.enableControls();
    }

    private void jTopNCheckBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this._generatedAITableName = "NULL";
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        BigInteger bigInteger = null;
        Object object = this.jTopNSpinner.getValue();
        if (this.jTopNCheckBox.isSelected()) {
            bigInteger = object instanceof Integer ? BigInteger.valueOf(((Integer)object).intValue()) : (BigInteger)object;
        }
        this._columnFilterSettings.getAttrImportantSettings().setTopN(bigInteger);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData().getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("rank", bigInteger);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTopN());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.RANK), null, complexProperty, null, null));
            this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_RANK_CHANGED_DESCRIPTION"), this.getData(), arrayList);
        }
        this.enableControls();
    }

    private void jSamplingCheckBoxActionPerformed(ActionEvent actionEvent) {
        this._dirty = true;
        BigInteger bigInteger = null;
        Object object = this.jSampleSizeSpinner.getValue();
        if (this.jSamplingCheckBox.isSelected()) {
            bigInteger = object instanceof Integer ? BigInteger.valueOf(((Integer)object).intValue()) : (BigInteger)object;
        }
        this._columnFilterSettings.setNumberOfRows(bigInteger);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)this.getData().getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("sampleSize", bigInteger);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getNumberOfRows());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.SAMPLE_SIZE), null, complexProperty, null, null));
            this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_SAMPLE_SIZE_CHANGED_DESCRIPTION"), this.getData(), arrayList);
        }
        this.enableControls();
    }

    private void jNullPercentSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.jNullPercentCheckBox.isSelected()) {
            this.jNullPercentCheckBoxActionPerformed(null);
        }
    }

    private void jUniquePercentSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.jUniquePercentCheckBox.isSelected()) {
            this.jUniquePercentCheckBoxActionPerformed(null);
        }
    }

    private void jConstantPercentSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.jConstantPercentCheckBox.isSelected()) {
            this.jConstantPercentCheckBoxActionPerformed(null);
        }
    }

    private void jImportanceSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.jImportanceCheckBox.isSelected()) {
            this.jImportanceCheckBoxActionPerformed(null);
        }
    }

    private void jTopNSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.jTopNCheckBox.isSelected()) {
            this.jTopNCheckBoxActionPerformed(null);
        }
    }

    private void jSampleSizeSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.jSamplingCheckBox.isSelected()) {
            this.jSamplingCheckBoxActionPerformed(null);
        }
    }

    private class AttributeItem {
        AttributeType _attribute;

        public AttributeItem(AttributeType attributeType) {
            this._attribute = attributeType;
        }

        public String toString() {
            return this._attribute.getAlias() == null ? this._attribute.getName() : this._attribute.getAlias();
        }

        public boolean equals(AttributeItem attributeItem) {
            return this._attribute.getName().equals(attributeItem.getAttribute().getName()) && this._attribute.getDataType().equals(attributeItem.getAttribute().getDataType());
        }

        public AttributeType getAttribute() {
            return this._attribute;
        }
    }

    class AITableNameGen
    extends ProgressRunnable {
        private boolean _canceled;
        private String _tableName;
        private String AI_SUFFIX = "_AI";

        AITableNameGen() {
        }

        public String getTableName() {
            return this._tableName;
        }

        protected Object doWork() throws Exception {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)SettingsPanel.this.getData().getData();
            String string = columnFilterNodeType.getName().replace(' ', '_').toUpperCase();
            if (string.length() > 20) {
                string = string.substring(0, 20);
            }
            this._tableName = WorkflowUtils.getNewTableName(SettingsPanel.this._context, "ODMR$" + string + this.AI_SUFFIX);
            return this._tableName;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    private class AttributeTypeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object != null && object instanceof AttributeType && object2 != null && object2 instanceof AttributeType) {
                return ((AttributeType)object).getName().compareTo(((AttributeType)object2).getName());
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object instanceof AttributeTypeComparator;
        }
    }
}

