/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.OutputColumnDialog;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.SettingsDialog;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowPIComponent;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.WorkflowColumnFilterNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class OutputColumnPanel
extends AbstractDialogPanel {
    private OutputColumnPanel _parent;
    private JEWTDialog _parentDlg;
    private WorkflowColumnFilterNodePropertyProxyModel _propertyModel;
    private AttrsTableModel _models;
    private NiceTableWithToolbar _tableWithToolbar;
    private static Icon _ready_icon;
    private static Icon _built_icon;
    private static NullIcon _nullIcon;
    private static Icon _error_icon;
    private static Icon _valid_icon;
    private static Icon _invalid_icon;
    private static Icon _editIcon;
    private static Icon _applyIcon;
    private static Icon _out_icon;
    private static Icon _ignore_icon;
    private static Icon _unknown_icon;
    private static Icon _info_icon;
    private static Icon _warning_icon;
    private JButton _editBtn;
    private JButton _applyBtn;
    private ColumnFilterAttributeType _columnFilterAttribute;
    private ColumnFilterSettingsType _columnFilterSettings;
    private String _generatedAITableName;
    private boolean _dirty;
    private boolean _DQResultGen = false;
    private boolean _AIResultGen = false;
    private TableColumn _rankTableColumn;
    private TableColumn _importanceTableColumn;
    private TableColumn _nullPercentTableColumn;
    private TableColumn _uniquePercentTableColumn;
    private TableColumn _constantPercentTableColumn;
    private boolean _expandedDialog;
    private String ATTRIBUTE_MAYBE_GOOD = DialogsLrb.get("COLUMN_FILTER_GOOD_ATTRIBUTE_INFO");
    private String[] _columnNames = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_OUTPUT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private String[] _columnFilters = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private String[] _columnNamesEx = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_OUTPUT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_RANK"), DialogsLrb.get("COLUMN_FILTER_COLUMN_IMPORTANCE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_NULL_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_UNIQUE_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_CONSTANT_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private String[] _columnFiltersEx = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_RANK"), DialogsLrb.get("COLUMN_FILTER_COLUMN_IMPORTANCE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_NULL_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_UNIQUE_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_CONSTANT_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private int[] _columnWidths = new int[]{180, 80, 60, 200};
    private int[] _columnWidthsEx = new int[]{180, 80, 60, 50, 80, 60, 80, 90, 200};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int OUTPUT = 2;
    private static final int REASON_HINT = 3;
    private static final int COLUMN_COUNT = 4;
    private static final int RANK = 3;
    private static final int IMPORTANCE = 4;
    private static final int NULLS_PERCENT = 5;
    private static final int UNIQUE_PERCENT = 6;
    private static final int CONSTANT_PERCENT = 7;
    private static final int REASON_HINT_EX = 8;
    private static final int COLUMN_COUNT_EX = 9;
    private static final int ATTR_STATUS = 99;
    private ComponentWithTitlebar<JComponent> columnComponentWithTitlebar;
    private JButton jSettingsButton;
    private JCheckBox jShowAICheckBox;
    private JCheckBox jShowDQCheckBox;

    public OutputColumnPanel(JEWTDialog jEWTDialog, Context context, ColumnFilterNode columnFilterNode, PropertyModel propertyModel) {
        super(context, columnFilterNode);
        this._parentDlg = jEWTDialog;
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this._expandedDialog = true;
        this.init((ColumnFilterNode)this._data, propertyModel);
    }

    public OutputColumnPanel(JEWTDialog jEWTDialog, Context context, ColumnFilterNode columnFilterNode, OutputColumnPanel outputColumnPanel) {
        super(context, columnFilterNode);
        this._parentDlg = jEWTDialog;
        assert (context != null) : "Context must not be null.";
        assert (columnFilterNode != null) : "ColumnFilter node must not be null.";
        assert (columnFilterNode instanceof ColumnFilterNode) : "Must be an instance of ColumnFilter node.";
        this._parent = outputColumnPanel;
        this._expandedDialog = outputColumnPanel != null;
        this.init(columnFilterNode, null);
    }

    public OutputColumnPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._expandedDialog = false;
        this.init((ColumnFilterNode)this._data, propertyModel);
    }

    private boolean isPIMode() {
        return this._propertyModel != null && this._parentDlg == null;
    }

    private boolean isPIDialogMode() {
        return this._propertyModel != null && this._parentDlg != null;
    }

    private void init(ColumnFilterNode columnFilterNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        if (this._parent == null) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
            this._columnFilterAttribute = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterAttributes());
            this._columnFilterSettings = (ColumnFilterSettingsType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterSettings());
            this._generatedAITableName = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput();
        } else {
            this._columnFilterAttribute = this._parent.getColumnFilterAttribute();
            this._columnFilterSettings = this._parent.getColumnFilterSettings();
            this._generatedAITableName = this._parent.getAIResultTable();
        }
        this.initComponents();
        this.initRes();
        if (this._expandedDialog) {
            this.initUIEx();
        } else {
            this.initUI();
        }
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        if (columnFilterNode == null) {
            return;
        }
        this._propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = columnFilterNode;
        this._dirty = false;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        this._columnFilterAttribute = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterAttributes());
        this.refreshUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ColumnFilterNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ColumnFilterNodeType) {
            return (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        try {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_TRANSACTION_NAME"));
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
            ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
            ComplexProperty complexProperty = new ComplexProperty("ColumnFilterAttributes", this._columnFilterAttribute);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterAttributes());
            arrayList.add(complexProperty);
            complexProperty = new ComplexProperty("ColumnFilterSettings", this._columnFilterSettings);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings());
            arrayList.add(complexProperty);
            complexProperty = new ComplexProperty("AttrImportanceTable", this._generatedAITableName);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput());
            arrayList.add(complexProperty);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(columnFilterNode, this.getContext(), arrayList);
            columnFilterNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    public boolean doWork() {
        boolean bl = true;
        if (this.isDirty() && !this.isPIMode()) {
            if (this.isPIDialogMode()) {
                this.updateNode();
            } else if (this._parent != null) {
                this._parent.setOutputColumns(this._columnFilterAttribute);
                this._parent.setColumnFilterSettings(this._columnFilterSettings);
                this._parent.setAIResultTable(this._generatedAITableName);
                this._parent.setDirty(true);
                this._parent.refreshUI();
            } else {
                this.updateNode();
            }
        }
        return bl;
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_COLUMN_SETTINGS"), this.jSettingsButton);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_COLUMN_SHOW_DQ"), this.jShowDQCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_COLUMN_SHOW_AI"), this.jShowAICheckBox);
        UIResourceHelper.setComponentText(hashMap);
        Class<WorkflowPIComponent> clazz = WorkflowPIComponent.class;
        if (_ready_icon == null) {
            _ready_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_READY_ICON"));
        }
        if (_built_icon == null) {
            _built_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_BUILT_ICON"));
        }
        if (_error_icon == null) {
            _error_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_ERROR_ICON"));
        }
        if (_nullIcon == null) {
            _nullIcon = new NullIcon(_built_icon.getIconWidth(), _built_icon.getIconHeight());
        }
        _editIcon = InspectorArb.getIcon((int)24);
        Class<WorkflowUtils> clazz2 = WorkflowUtils.class;
        _applyIcon = UIResourceHelper.getImageIcon(clazz2, PropertyLrb.get("PI_ATTRIBUTES_GROUP_PROP_COMPARE_TESTS"));
        Class<WorkflowEditor> clazz3 = WorkflowEditor.class;
        _invalid_icon = UIResourceHelper.getImageIcon(clazz3, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
        _valid_icon = UIResourceHelper.getImageIcon(clazz3, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
        _out_icon = UIResourceHelper.getImageIcon(clazz3, WorkflowEditorLrb.get("FILTER_ATTR_OUTPUT_ICON"));
        _ignore_icon = UIResourceHelper.getImageIcon(clazz3, WorkflowEditorLrb.get("FILTER_ATTR_IGNORE_ICON"));
        _unknown_icon = UIResourceHelper.getImageIcon(clazz3, WorkflowEditorLrb.get("FILTER_ATTR_UNKNOWN_ICON"));
        _info_icon = UIResourceHelper.getImageIcon(clazz3, WorkflowEditorLrb.get("FILTER_HINT_WARN_ICON"));
        _warning_icon = UIResourceHelper.getImageIcon(clazz3, WorkflowEditorLrb.get("FILTER_HINT_WARN_ICON"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"columnfilter_columns");
        List list = this._columnFilterAttribute.getAttribute();
        Collections.sort(list, new AttributeTypeComparator());
        this._models = new AttrsTableModel(list);
        ControlBar controlBar = new ControlBar();
        this._editBtn = new JButton(_editIcon);
        this._editBtn.setEnabled(false);
        this._applyBtn = new JButton(_applyIcon);
        controlBar.add((Component)this._editBtn);
        controlBar.add((Component)this._applyBtn);
        this._tableWithToolbar = new NiceTableWithToolbar(this.columnComponentWithTitlebar, controlBar, this._columnNames, this._columnFilters, this._models);
        this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("COLUMN_FILTER_COLUMN_TABLE_TITLE")));
        this._editBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_DETAILS"));
        this._applyBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_APPLY_RECOMM"));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.processEdit();
            }
        });
        this._applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.processApply();
            }
        });
        TableColumn tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new NameCellRenderer(this._tableWithToolbar));
        tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(new HintCellRenderer(this._tableWithToolbar));
        this._tableWithToolbar.getNiceTable().setAutoResizeMode(0);
        this._tableWithToolbar.getNiceTable().setSelectionMode(2);
        this._tableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._tableWithToolbar.getNiceTable().setShowToolTips(true);
        this._tableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._tableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        int n = 0;
        for (int n2 : this._columnWidths) {
            this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                OutputColumnPanel.this.handleModelSelectionChanged();
            }
        });
        this.enableControls();
    }

    public void initUIEx() {
        HelpUtils.setHelpID((JComponent)this, (String)"columnfilter_columns_ex");
        this._models = new AttrsTableModelEx();
        ControlBar controlBar = new ControlBar();
        this._applyBtn = new JButton(_applyIcon);
        controlBar.add((Component)this._applyBtn);
        this._tableWithToolbar = new NiceTableWithToolbar(this.columnComponentWithTitlebar, controlBar, this._columnNamesEx, this._columnFiltersEx, this._models);
        this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("COLUMN_FILTER_COLUMN_TABLE_TITLE")));
        this._applyBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_APPLY_RECOMM"));
        this._applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.processApply();
            }
        });
        TableColumn tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new NameCellRenderer(this._tableWithToolbar));
        tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new OutputCellEditor());
        this._rankTableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(3);
        this._rankTableColumn.setCellRenderer(new NumberCellRenderer());
        this._importanceTableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(4);
        Preferences preferences = Preferences.getPreferences();
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)preferences);
        NumberFormat numberFormat = NumericFormat.getInstance(true, modelViewerPreferenceSettings.getPercentagePrecisionLevel(), 0, 0);
        numberFormat.setMaximumFractionDigits(modelViewerPreferenceSettings.getPercentagePrecisionLevel());
        numberFormat.setMinimumIntegerDigits(1);
        this._importanceTableColumn.setCellRenderer(new HistogramBarRenderer(1L, true, numberFormat));
        this._nullPercentTableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(5);
        this._nullPercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        this._uniquePercentTableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(6);
        this._uniquePercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        this._constantPercentTableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(7);
        this._constantPercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(8);
        tableColumn.setCellRenderer(new HintCellRenderer(this._tableWithToolbar));
        this._tableWithToolbar.getNiceTable().setAutoResizeMode(0);
        this._tableWithToolbar.getNiceTable().setSelectionMode(2);
        this._tableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._tableWithToolbar.getNiceTable().setShowToolTips(true);
        this._tableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._tableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        int n = 0;
        for (int n2 : this._columnWidthsEx) {
            this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                OutputColumnPanel.this.handleModelSelectionChanged();
            }
        });
        this._AIResultGen = false;
        this._DQResultGen = false;
        Object object = (ColumnFilterNode)this.getData();
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((AbstractNode)object).getData();
        this._AIResultGen = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput() != null && !((ColumnFilterNode)object).isNew();
        this._DQResultGen = columnFilterNodeType.getColumnFilterResults().getDataQualityOutput() != null && !((ColumnFilterNode)object).isNew();
        this.jShowAICheckBox.setSelected(this._AIResultGen);
        this.jShowAICheckBox.setEnabled(this._AIResultGen);
        if (!this._AIResultGen) {
            this._tableWithToolbar.getNiceTable().removeColumn(this._rankTableColumn);
            this._tableWithToolbar.getNiceTable().removeColumn(this._importanceTableColumn);
        }
        this.jShowDQCheckBox.setSelected(this._DQResultGen);
        this.jShowDQCheckBox.setEnabled(this._DQResultGen);
        if (!this._DQResultGen) {
            this._tableWithToolbar.getNiceTable().removeColumn(this._nullPercentTableColumn);
            this._tableWithToolbar.getNiceTable().removeColumn(this._uniquePercentTableColumn);
            this._tableWithToolbar.getNiceTable().removeColumn(this._constantPercentTableColumn);
        }
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    public ColumnFilterAttributeType getColumnFilterAttribute() {
        return this._columnFilterAttribute;
    }

    public ColumnFilterSettingsType getColumnFilterSettings() {
        return this._columnFilterSettings;
    }

    public void refreshUI() {
        List list = this._columnFilterAttribute.getAttribute();
        Collections.sort(list, new AttributeTypeComparator());
        this._models = new AttrsTableModel(list);
        this._tableWithToolbar.resetNiceTableModel(this._models);
        this.enableControls();
    }

    private void enableControls() {
        this.jSettingsButton.setVisible(!this.isPIMode() && !this.isPIDialogMode());
        if (!this._expandedDialog) {
            this.jShowAICheckBox.setVisible(false);
            this.jShowDQCheckBox.setVisible(false);
        }
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
        if (this._editBtn != null) {
            this._editBtn.setEnabled(this.isWritable() && !columnFilterNode.isNew());
        }
        int n = this._tableWithToolbar.getNiceTable().getSelectedRowCount();
        this._applyBtn.setEnabled(this.isWritable() && n > 0 && !columnFilterNode.isNew());
    }

    private void processEdit() {
        OutputColumnDialog outputColumnDialog = new OutputColumnDialog();
        if (this.isPIMode()) {
            outputColumnDialog.invoke(this._context, (ColumnFilterNode)this._data, (PropertyModel)this._propertyModel);
        } else {
            outputColumnDialog.invoke(this._context, (ColumnFilterNode)this._data, this);
        }
    }

    private void processApply() {
        int[] nArray = this._tableWithToolbar.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this._columnFilterAttribute.getAttribute().get(n);
            String string = columnFilterNode.getReasonHintsLookupMap().get(attribute.getName());
            if (attribute.getOutput().compareTo("Yes") == 0 && string != null) {
                attribute.setOutput("No");
            }
            if (attribute.getOutput().compareTo("No") != 0 || string != null) continue;
            attribute.setOutput("Yes");
        }
        this._tableWithToolbar.getNiceTable().updateUI();
        this._dirty = true;
        if (this.isPIMode()) {
            this.updateNode();
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private void initComponents() {
        this.jShowAICheckBox = new JCheckBox();
        this.jShowDQCheckBox = new JCheckBox();
        this.jSettingsButton = new JButton();
        this.columnComponentWithTitlebar = new ComponentWithTitlebar();
        this.jShowAICheckBox.setText("Show Attribute Importance");
        this.jShowAICheckBox.setName("jShowAICheckBox");
        this.jShowAICheckBox.setOpaque(false);
        this.jShowAICheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jShowAICheckBoxActionPerformed(actionEvent);
            }
        });
        this.jShowDQCheckBox.setText("Show Data Quality");
        this.jShowDQCheckBox.setName("jShowDQCheckBox");
        this.jShowDQCheckBox.setOpaque(false);
        this.jShowDQCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jShowDQCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSettingsButton.setText("Settings");
        this.jSettingsButton.setName("jSettingsButton");
        this.jSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jSettingsButtonActionPerformed(actionEvent);
            }
        });
        this.columnComponentWithTitlebar.setAutoscrolls(true);
        this.columnComponentWithTitlebar.setMinimumSize(new Dimension(2, 400));
        this.columnComponentWithTitlebar.setName("columnComponentWithTitlebar");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.columnComponentWithTitlebar, -1, 625, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jShowDQCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jShowAICheckBox, GroupLayout.Alignment.LEADING, -1, 210, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 344, Short.MAX_VALUE).addComponent(this.jSettingsButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jShowAICheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jShowDQCheckBox)).addComponent(this.jSettingsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.columnComponentWithTitlebar, -1, 400, Short.MAX_VALUE).addContainerGap()));
    }

    private void jShowAICheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jShowAICheckBox.isSelected();
        if (bl) {
            this._tableWithToolbar.getNiceTable().addColumn(this._rankTableColumn);
            this._tableWithToolbar.getNiceTable().moveColumn(this._tableWithToolbar.getNiceTable().getColumnCount() - 1, 3);
            this._tableWithToolbar.getNiceTable().addColumn(this._importanceTableColumn);
            this._tableWithToolbar.getNiceTable().moveColumn(this._tableWithToolbar.getNiceTable().getColumnCount() - 1, 4);
        } else {
            this._tableWithToolbar.getNiceTable().removeColumn(this._rankTableColumn);
            this._tableWithToolbar.getNiceTable().removeColumn(this._importanceTableColumn);
        }
        this.enableControls();
    }

    private void jShowDQCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jShowDQCheckBox.isSelected();
        if (bl) {
            this._tableWithToolbar.getNiceTable().addColumn(this._nullPercentTableColumn);
            int n = this.jShowAICheckBox.isSelected() ? 0 : 2;
            this._tableWithToolbar.getNiceTable().moveColumn(this._tableWithToolbar.getNiceTable().getColumnCount() - 1, 5 - n);
            this._tableWithToolbar.getNiceTable().addColumn(this._uniquePercentTableColumn);
            this._tableWithToolbar.getNiceTable().moveColumn(this._tableWithToolbar.getNiceTable().getColumnCount() - 1, 6 - n);
            this._tableWithToolbar.getNiceTable().addColumn(this._constantPercentTableColumn);
            this._tableWithToolbar.getNiceTable().moveColumn(this._tableWithToolbar.getNiceTable().getColumnCount() - 1, 7 - n);
        } else {
            this._tableWithToolbar.getNiceTable().removeColumn(this._nullPercentTableColumn);
            this._tableWithToolbar.getNiceTable().removeColumn(this._uniquePercentTableColumn);
            this._tableWithToolbar.getNiceTable().removeColumn(this._constantPercentTableColumn);
        }
        this.enableControls();
    }

    private void jSettingsButtonActionPerformed(ActionEvent actionEvent) {
        SettingsDialog settingsDialog = new SettingsDialog();
        settingsDialog.invoke(this._context, (ColumnFilterNode)this._data, this);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public void setOutputColumns(ColumnFilterAttributeType columnFilterAttributeType) {
        this._columnFilterAttribute = columnFilterAttributeType;
    }

    public void setColumnFilterSettings(ColumnFilterSettingsType columnFilterSettingsType) {
        this._columnFilterSettings = columnFilterSettingsType;
    }

    public void setAIResultTable(String string) {
        this._generatedAITableName = string;
    }

    public String getAIResultTable() {
        return this._generatedAITableName;
    }

    private class AttributeTypeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object != null && object instanceof ColumnFilterAttributeType.Attribute && object2 != null && object2 instanceof ColumnFilterAttributeType.Attribute) {
                return ((ColumnFilterAttributeType.Attribute)object).getName().compareTo(((ColumnFilterAttributeType.Attribute)object2).getName());
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object instanceof AttributeTypeComparator;
        }
    }

    private class HintCellRenderer
    extends DefaultTableCellRenderer {
        private NiceTableWithToolbar _tableWithToolbar;

        public HintCellRenderer(NiceTableWithToolbar niceTableWithToolbar) {
            this._tableWithToolbar = niceTableWithToolbar;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setIcon((Icon)_nullIcon);
            if (object instanceof String && (string = (String)object) != null && string.length() > 0) {
                if (string.compareTo(OutputColumnPanel.this.ATTRIBUTE_MAYBE_GOOD) == 0) {
                    this.setIcon(_info_icon);
                } else {
                    this.setIcon(_warning_icon);
                }
            }
            return component;
        }
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        private NiceTableWithToolbar _tableWithToolbar;

        public NameCellRenderer(NiceTableWithToolbar niceTableWithToolbar) {
            this._tableWithToolbar = niceTableWithToolbar;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = this._tableWithToolbar.convertRowToModelIndex(n);
            GenericBaseTableModel genericBaseTableModel = this._tableWithToolbar.getNiceTableModel();
            AttributeStatus attributeStatus = AttributeStatus.VALID;
            if (genericBaseTableModel instanceof AttrsTableModel && (object2 = genericBaseTableModel.getValueAt(n3, 99)) instanceof AttributeStatus) {
                attributeStatus = (AttributeStatus)object2;
            }
            if (attributeStatus.equals((Object)AttributeStatus.VALID)) {
                this.setIcon(_valid_icon);
            } else {
                this.setIcon(_invalid_icon);
            }
            return component;
        }
    }

    private class OutputCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Icon _icon;
        private JButton _btn = new JButton((Icon)OutputColumnPanel.access$1900());
        protected static final String EDIT = "edit";

        public OutputCellEditor() {
            this._btn.setActionCommand(EDIT);
            this._btn.addActionListener(this);
            this._btn.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = OutputColumnPanel.this._tableWithToolbar.convertRowToModelIndex(n);
            GenericBaseTableModel genericBaseTableModel = OutputColumnPanel.this._tableWithToolbar.getNiceTableModel();
            this._icon = OutputColumnPanel.this._expandedDialog ? (Icon)((AttrsTableModelEx)genericBaseTableModel).getValueAt(n3, 2) : (Icon)((AttrsTableModel)genericBaseTableModel).getValueAt(n3, 2);
            this._btn.setIcon(this._icon);
            return this._btn;
        }

        @Override
        public Object getCellEditorValue() {
            if (this._icon == _out_icon) {
                this._icon = _ignore_icon;
            } else if (this._icon == _ignore_icon) {
                this._icon = _out_icon;
            }
            return this._icon;
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }
    }

    private class AttrsTableModelEx
    extends AttrsTableModel {
        HashMap<String, ColumnFilterNode.Statistics> _statisticLookupMap;

        public AttrsTableModelEx() {
            this(null, null);
        }

        public AttrsTableModelEx(List<ColumnFilterAttributeType.Attribute> list, HashMap<String, ColumnFilterNode.Statistics> hashMap) {
            super(list);
            this._statisticLookupMap = hashMap;
            this.setColumnIdentifiers(OutputColumnPanel.this._columnNamesEx);
            this.setColumnCount(9);
        }

        @Override
        public Class getColumnClass(int n) {
            switch (n) {
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return Double.class;
                }
                case 5: {
                    return Double.class;
                }
                case 6: {
                    return Double.class;
                }
                case 7: {
                    return Double.class;
                }
                case 8: {
                    return String.class;
                }
            }
            return super.getColumnClass(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this._srcData == null) {
                return DialogsLrb.get("COLUMN_FILTER_LOADING_MESSAGE");
            }
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this._srcData.get(n);
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
            ColumnFilterNode.Statistics statistics = columnFilterNode.getStatisticLookupMap().get(attribute.getName());
            Object object = null;
            switch (n2) {
                case 3: {
                    if (statistics == null) break;
                    object = statistics.getRank();
                    break;
                }
                case 4: {
                    if (statistics == null) break;
                    object = statistics.getImportance();
                    break;
                }
                case 5: {
                    if (statistics == null) break;
                    object = statistics.getNulls();
                    break;
                }
                case 6: {
                    if (statistics == null) break;
                    object = statistics.getUnique();
                    break;
                }
                case 7: {
                    if (statistics == null) break;
                    object = statistics.getConstant();
                    break;
                }
                case 8: {
                    object = super.getValueAt(n, 3);
                    break;
                }
                default: {
                    object = super.getValueAt(n, n2);
                }
            }
            return object;
        }
    }

    private class AttrsTableModel
    extends GenericBaseTableModel {
        List<ColumnFilterAttributeType.Attribute> _srcData;

        public AttrsTableModel() {
            this(null);
        }

        public AttrsTableModel(List<ColumnFilterAttributeType.Attribute> list) {
            this._srcData = list;
            this.setColumnIdentifiers(OutputColumnPanel.this._columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(4);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 1;
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                return OutputColumnPanel.this.isWritable();
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (this._srcData == null || this._srcData.size() == 0) {
                return DialogsLrb.get("COLUMN_FILTER_LOADING_MESSAGE");
            }
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ColumnFilterAttributeType.Attribute attribute = this._srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = attribute.getName();
                    break;
                }
                case 1: {
                    object = attribute.getDataType();
                    break;
                }
                case 2: {
                    if (attribute.getOutput().compareTo("System") == 0) {
                        object = _unknown_icon;
                        break;
                    }
                    if (attribute.getOutput().compareTo("Yes") == 0) {
                        object = _out_icon;
                        break;
                    }
                    if (attribute.getOutput().compareTo("No") != 0) break;
                    object = _ignore_icon;
                    break;
                }
                case 3: {
                    object = "";
                    ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
                    String string = columnFilterNode.getReasonHintsLookupMap().get(attribute.getName());
                    if (string != null) {
                        object = string;
                    }
                    if (attribute.getOutput().compareTo("Yes") == 0 && string != null) {
                        object = string;
                    }
                    String string2 = columnFilterNode.getOuputCopyLookupMap().get(attribute.getName());
                    if (columnFilterNode.isNew() || attribute.getOutput().compareTo("No") != 0 || string != null) break;
                    object = OutputColumnPanel.this.ATTRIBUTE_MAYBE_GOOD;
                    break;
                }
                case 99: {
                    object = attribute.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ColumnFilterAttributeType.Attribute attribute = this._srcData.get(n);
            switch (n2) {
                case 2: {
                    OutputColumnPanel.this._dirty = true;
                    Icon icon = (Icon)object;
                    int[] nArray = OutputColumnPanel.this._tableWithToolbar.getSelectedRowsInModel();
                    if (!OutputColumnPanel.this.isPIMode()) {
                        if (icon == _out_icon) {
                            attribute.setOutput("Yes");
                        } else if (icon == _ignore_icon) {
                            attribute.setOutput("No");
                        }
                        for (int i = 0; i < nArray.length; ++i) {
                            int n3 = nArray[i];
                            ColumnFilterAttributeType.Attribute attribute2 = this._srcData.get(n3);
                            if (icon == _out_icon) {
                                attribute2.setOutput("Yes");
                                continue;
                            }
                            if (icon != _ignore_icon) continue;
                            attribute2.setOutput("No");
                        }
                        break;
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    String string = attribute.getOutput();
                    if (icon == _out_icon) {
                        hashMap.put(attribute.getName(), "Yes");
                        hashMap2.put(attribute.getName(), string);
                    } else if (icon == _ignore_icon) {
                        hashMap.put(attribute.getName(), "No");
                        hashMap2.put(attribute.getName(), string);
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        int n4 = nArray[i];
                        ColumnFilterAttributeType.Attribute attribute3 = this._srcData.get(n4);
                        string = attribute3.getOutput();
                        if (icon == _out_icon) {
                            hashMap.put(attribute3.getName(), "Yes");
                            hashMap2.put(attribute3.getName(), string);
                            continue;
                        }
                        if (icon != _ignore_icon) continue;
                        hashMap.put(attribute3.getName(), "No");
                        hashMap2.put(attribute3.getName(), string);
                    }
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("attrOutputs", hashMap);
                    complexProperty.setOldData(hashMap2);
                    arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.ATTR_OUTPUTS), null, complexProperty, null, null));
                    OutputColumnPanel.this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_COLUMNS_ATTRIBUTE_OUTPUT_COLUMN_CHANGED"), OutputColumnPanel.this.getData(), arrayList);
                }
            }
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        public Object construct() {
            try {
                ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
                columnFilterNode.loadResults();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    List list = OutputColumnPanel.this._columnFilterAttribute.getAttribute();
                    Collections.sort(list, new AttributeTypeComparator());
                    ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
                    OutputColumnPanel.this._models = new AttrsTableModelEx(list, columnFilterNode.getStatisticLookupMap());
                    OutputColumnPanel.this._tableWithToolbar.resetNiceTableModel(OutputColumnPanel.this._models);
                } else {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
                }
                OutputColumnPanel.this.enableControls();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
            }
        }
    }
}

