/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistDetailsDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistWizard;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPage;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPanel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCheckCombo;

public class TextTransColumnSettingTokenPanel
extends JPanel {
    private JPanel _parent;
    private String _sourceAttributeName = null;
    private TextNodeType.Stoplists _stoplists = null;
    private AbstractTextNode _node;
    private Context _context;
    private PropertyModel _propertyModel;
    private TextTransformationType _textTransformation;
    private boolean _isAdjusting = false;
    private boolean _isAllSelected = false;
    private boolean _isNoneSelected = false;
    private static Icon _editIcon;
    private static Icon _addIcon;
    private boolean _isReadOnly;
    private boolean _dirty;
    private static String LANG_ALL;
    private static String LANG_NONE;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JButton jEditStoplistButton;
    private JLabel jFrequencyLabel;
    private JLabel jLanguageLabel;
    private JLabel jMaxNumAllDocsLabel;
    private JSpinner jMaxNumAllDocsSpinner;
    private JLabel jMaxNumPerDocLabel;
    private JSpinner jMaxNumPerDocSpinner;
    private JComboBox jMultiByteComboBox;
    private JLabel jMultiByteLabel;
    private JRadioButton jMultiPerDocRadioButton;
    private JButton jNewStoplistButton;
    private JRadioButton jNoneStoplistRadioButton;
    private JComboBox jSelectedStoplistComboBox;
    private JRadioButton jSelectedStoplistRadioButton;
    private JRadioButton jSingleAllDocsRadioButton;
    private JCheckCombo jSingleBtyeComboBox;
    private JLabel jSingleByteLabel;
    private JComboBox jSingleLanguageComboBox;
    private JLabel jStoplistLabel;
    private JRadioButton jTermFrequencyIDFRadioButton;
    private JRadioButton jTermFrequencyRadioButton;
    private JLabel jTokensLabel;

    public TextTransColumnSettingTokenPanel(PropertyModel propertyModel, Context context, JPanel jPanel, AbstractTextNode abstractTextNode, String string, TextTransformationType textTransformationType) {
        this._propertyModel = propertyModel;
        this._node = abstractTextNode;
        this._context = context;
        this._parent = jPanel;
        if (jPanel instanceof TextTransColumnSettingPanel) {
            this._stoplists = ((TextTransColumnSettingPanel)jPanel).getStoplists();
        } else if (jPanel instanceof TextTransColumnSettingPage) {
            this._stoplists = ((TextTransColumnSettingPage)((Object)jPanel)).getStoplists();
        }
        this._sourceAttributeName = string;
        this._textTransformation = textTransformationType;
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initUI() {
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILDTEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(_addIcon);
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILDTEXT_ADD_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setEnabled(!this._isReadOnly);
        boolean bl = true;
        this.jSingleLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.StoplistLanguage.toHuman("ARABIC"), ServerConstants.StoplistLanguage.toHuman("BOKMAL"), ServerConstants.StoplistLanguage.toHuman("CATALAN"), ServerConstants.StoplistLanguage.toHuman("SIMPLIFIED CHINESE"), ServerConstants.StoplistLanguage.toHuman("TRADITIONAL CHINESE"), ServerConstants.StoplistLanguage.toHuman("CROATIAN"), ServerConstants.StoplistLanguage.toHuman("CZECH"), ServerConstants.StoplistLanguage.toHuman("DANISH"), ServerConstants.StoplistLanguage.toHuman("DUTCH"), ServerConstants.StoplistLanguage.toHuman("ENGLISH"), ServerConstants.StoplistLanguage.toHuman("FINNISH"), ServerConstants.StoplistLanguage.toHuman("FRENCH"), ServerConstants.StoplistLanguage.toHuman("GERMAN"), ServerConstants.StoplistLanguage.toHuman("GREEK"), ServerConstants.StoplistLanguage.toHuman("HEBREW"), ServerConstants.StoplistLanguage.toHuman("HUNGARIAN"), ServerConstants.StoplistLanguage.toHuman("ITALIAN"), ServerConstants.StoplistLanguage.toHuman("JAPANESE"), ServerConstants.StoplistLanguage.toHuman("KOREAN"), ServerConstants.StoplistLanguage.toHuman("NYNORSK"), ServerConstants.StoplistLanguage.toHuman("PERSIAN"), ServerConstants.StoplistLanguage.toHuman("POLISH"), ServerConstants.StoplistLanguage.toHuman("PORTUGUESE"), ServerConstants.StoplistLanguage.toHuman("RUSSIAN"), ServerConstants.StoplistLanguage.toHuman("SERBIAN"), ServerConstants.StoplistLanguage.toHuman("SLOVENIAN"), ServerConstants.StoplistLanguage.toHuman("SLOVAK"), ServerConstants.StoplistLanguage.toHuman("SPANISH"), ServerConstants.StoplistLanguage.toHuman("SWEDISH"), ServerConstants.StoplistLanguage.toHuman("THAI"), ServerConstants.StoplistLanguage.toHuman("TURKISH")}));
        this.jSingleAllDocsRadioButton.setSelected(bl);
        if (bl) {
            this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman("ENGLISH"));
        }
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(LANG_ALL);
        defaultListModel.addElement(LANG_NONE);
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("ARABIC"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("BOKMAL"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("CATALAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("CROATIAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("CZECH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("DANISH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("DUTCH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("ENGLISH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("FINNISH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("FRENCH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("GERMAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("GREEK"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("HEBREW"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("HUNGARIAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("ITALIAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("NYNORSK"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("PERSIAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("POLISH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("PORTUGUESE"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("RUSSIAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("SERBIAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("SLOVENIAN"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("SLOVAK"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("SPANISH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("SWEDISH"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("THAI"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("TURKISH"));
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addSelectionInterval(1, 1);
        CheckComboModel checkComboModel = new CheckComboModel(defaultListModel, (ListSelectionModel)defaultListSelectionModel);
        this.jSingleBtyeComboBox.setModel(checkComboModel);
        ListSelectionModel listSelectionModel = this.jSingleBtyeComboBox.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextTransColumnSettingTokenPanel.this.jSingleByteLanguageValueChanged(listSelectionEvent);
                }
            }
        });
        this.jMultiByteComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{LANG_NONE, ServerConstants.StoplistLanguage.toHuman("SIMPLIFIED CHINESE"), ServerConstants.StoplistLanguage.toHuman("TRADITIONAL CHINESE"), ServerConstants.StoplistLanguage.toHuman("JAPANESE"), ServerConstants.StoplistLanguage.toHuman("KOREAN")}));
        this.initStoplists(null);
        this.jMaxNumPerDocSpinner.setModel(new SpinnerNumberModel(50, 1, 10000, 100));
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(300, 1, 100000, 1000));
        this.refreshUI(this._textTransformation);
    }

    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("ADD_STOPWORD_LANGUAGE"), this.jLanguageLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_SINGLE_FOR_ALL_DOCS"), this.jSingleAllDocsRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_MULTI_PER_DOC"), this.jMultiPerDocRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_MULTI_SINGLE_BYTE"), this.jSingleByteLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_MULTI_MULTI_BYTE"), this.jMultiByteLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_STOPLIST"), this.jStoplistLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_STOPLIST_SELECTED"), this.jSelectedStoplistRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_STOPLIST_NONE"), this.jNoneStoplistRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_TOKENS"), this.jTokensLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_MAX_NUM_PER_DOC"), this.jMaxNumPerDocLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_MAX_NUM_ALL_DOCS"), this.jMaxNumAllDocsLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_FREQUENCY"), this.jFrequencyLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_FREQUENCY_TERM"), this.jTermFrequencyRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_FREQUENCY_TERM_IDF"), this.jTermFrequencyIDFRadioButton);
        UIResourceHelper.setComponentText(hashMap);
        Class<PIComponentPanel> clazz = PIComponentPanel.class;
        _editIcon = InspectorArb.getIcon((int)24);
        _addIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_ICON"));
    }

    private void initStoplists(String string) {
        Object object;
        boolean bl = false;
        if (this.jSingleAllDocsRadioButton.isSelected()) {
            object = (String)this.jSingleLanguageComboBox.getSelectedItem();
            bl = AbstractTextNode.defaultStoplistExists(this._context, ServerConstants.StoplistLanguage.toSchema((String)object));
        }
        object = null;
        object = this._stoplists.getStoplist();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            StoplistType object2 = (StoplistType)iterator.next();
            if (object2.getName().equals("Default")) continue;
            arrayList.add(object2.getName());
        }
        Collections.sort(arrayList);
        this.jSelectedStoplistComboBox.removeAllItems();
        if (bl) {
            this.jSelectedStoplistComboBox.addItem(ServerConstants.StoplistLanguage.toHuman("Default"));
        }
        for (String string2 : arrayList) {
            this.jSelectedStoplistComboBox.addItem(string2);
        }
        if (string != null) {
            this.jSelectedStoplistComboBox.setSelectedItem(string);
        }
    }

    public ArrayList<String> getAvailableStoplists() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.jSelectedStoplistComboBox.getItemCount(); ++i) {
            arrayList.add((String)this.jSelectedStoplistComboBox.getItemAt(i));
        }
        return arrayList;
    }

    public void refreshUI(TextTransformationType textTransformationType) {
        this._textTransformation = textTransformationType;
        if (textTransformationType != null && textTransformationType.getToken() != null) {
            Object object3;
            int n;
            Object object2;
            ListSelectionModel listSelectionModel;
            List list = null;
            list = this._textTransformation.getToken().getToken().getLanguages().getLanguage();
            boolean bl = this._textTransformation.getToken().getToken().getLexer().getType().equals("Basic");
            if (bl) {
                this.jSingleAllDocsRadioButton.setSelected(true);
                this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(((TransformationTokenType.Token.Languages.Language)list.get(0)).getName()));
            } else {
                this.jMultiPerDocRadioButton.setSelected(true);
                this._isAdjusting = true;
                listSelectionModel = this.jSingleBtyeComboBox.getSelectionModel();
                listSelectionModel.clearSelection();
                object2 = this.jSingleBtyeComboBox.getCheckModel();
                n = 0;
                this.jMultiByteComboBox.setSelectedItem(LANG_NONE);
                for (Object object3 : list) {
                    if (object3.getType().equals("SingleByte")) {
                        for (int i = 0; i < object2.getSize(); ++i) {
                            String string = (String)object2.getElementAt(i);
                            if (!string.equals(ServerConstants.StoplistLanguage.toHuman(object3.getName()))) continue;
                            listSelectionModel.addSelectionInterval(i, i);
                            n = 1;
                        }
                        continue;
                    }
                    this.jMultiByteComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(object3.getName()));
                }
                if (n == 0) {
                    listSelectionModel.addSelectionInterval(1, 1);
                }
                this._isAdjusting = false;
            }
            listSelectionModel = null;
            object2 = textTransformationType.getToken().getToken().getStoplistId();
            if (object2 != null) {
                for (StoplistType stoplistType : this._stoplists.getStoplist()) {
                    if (!stoplistType.getId().equals(object2)) continue;
                    listSelectionModel = stoplistType;
                    break;
                }
            }
            if (listSelectionModel != null) {
                this.jSelectedStoplistComboBox.setSelectedItem(listSelectionModel.getName());
            }
            this.jSelectedStoplistRadioButton.setSelected(listSelectionModel != null);
            this.jNoneStoplistRadioButton.setSelected(listSelectionModel == null);
            n = textTransformationType.getToken().getToken().getMaxNumberPerDoc().intValue();
            this.jMaxNumPerDocSpinner.setValue(new Integer(n));
            int n2 = textTransformationType.getToken().getToken().getMaxNumberAllDocs().intValue();
            this.jMaxNumAllDocsSpinner.setValue(new Integer(n2));
            object3 = textTransformationType.getToken().getToken().getFrequency();
            this.jTermFrequencyRadioButton.setSelected(((String)object3).equals("Terms"));
            this.jTermFrequencyIDFRadioButton.setSelected(((String)object3).equals("IDF"));
        } else {
            Preferences preferences = Preferences.getPreferences();
            BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
            List<String> list = buildTextPreferencesPanelSettings.getTokenLanguages();
            if (list.size() <= 1) {
                this.jSingleAllDocsRadioButton.setSelected(true);
                if (list.size() > 0) {
                    this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(list.get(0)));
                }
            } else {
                String string;
                int n;
                this.jMultiPerDocRadioButton.setSelected(true);
                this._isAdjusting = true;
                ListSelectionModel listSelectionModel = this.jSingleBtyeComboBox.getSelectionModel();
                listSelectionModel.clearSelection();
                CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
                boolean bl = false;
                for (n = 0; n < checkComboModel.getSize(); ++n) {
                    string = (String)checkComboModel.getElementAt(n);
                    if (!list.contains(ServerConstants.StoplistLanguage.toSchema(string))) continue;
                    listSelectionModel.addSelectionInterval(n, n);
                    bl = true;
                }
                if (!bl) {
                    listSelectionModel.addSelectionInterval(1, 1);
                }
                this.jMultiByteComboBox.setSelectedItem(LANG_NONE);
                for (n = 0; n < this.jMultiByteComboBox.getItemCount(); ++n) {
                    string = (String)this.jMultiByteComboBox.getItemAt(n);
                    if (!list.contains(ServerConstants.StoplistLanguage.toSchema(string))) continue;
                    this.jMultiByteComboBox.setSelectedIndex(n);
                    break;
                }
                this._isAdjusting = false;
            }
            this.jMaxNumPerDocSpinner.setValue(new Integer(buildTextPreferencesPanelSettings.getMaxNumPerDoc()));
            this.jMaxNumAllDocsSpinner.setValue(new Integer(buildTextPreferencesPanelSettings.getMaxNumAllDocs()));
            this.jTermFrequencyIDFRadioButton.setSelected(true);
        }
        this.enableControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copySettings(TextTransformationType textTransformationType, TextNodeType.Stoplists stoplists) throws ValidationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Connection connection;
        boolean bl = false;
        StoplistType stoplistType = null;
        Integer n = (Integer)this.jMaxNumPerDocSpinner.getValue();
        Integer n2 = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        if (n > n2) {
            throw new ValidationException(DialogsLrb.get("BUILDTEXT_MAX_NUM_PER_DOC_ERROR"));
        }
        TransformationTokenType.Token token = new TransformationTokenType.Token();
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        String string = null;
        String string2 = null;
        if (textTransformationType.getToken() != null) {
            string = textTransformationType.getToken().getToken().getPolicy();
            string2 = textTransformationType.getToken().getToken().getStatisticTable().getName();
        } else {
            bl = true;
            connection = null;
            try {
                connection = Connections.getSharedConnection(this._context);
                string = DatabaseMetadataUtils.createUniqueTableName("ODMR$" + (this._sourceAttributeName == null ? "" : this._sourceAttributeName), connection, "_PL");
                string2 = DatabaseMetadataUtils.createUniqueTableName("ODMR$" + (this._sourceAttributeName == null ? "" : this._sourceAttributeName), connection, "_FT");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        token.setPolicy(string);
        connection = new ResultType();
        connection.setCreationDate(null);
        connection.setName(string2);
        token.setStatisticTable((ResultType)connection);
        Preferences preferences = Preferences.getPreferences();
        BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.jSingleAllDocsRadioButton.isSelected()) {
            object6 = (String)this.jSingleLanguageComboBox.getSelectedItem();
            arrayList.add(ServerConstants.StoplistLanguage.toSchema((String)object6));
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(ServerConstants.StoplistLanguage.toSchema((String)object6));
            language.setType("SingleByte");
            languages.getLanguage().add(language);
            token.setLanguages(languages);
            object5 = new LexerType();
            object5.setType("Basic");
            token.setLexer((LexerType)object5);
            object4 = new LexerType.Settings();
            object5.setSettings(object4);
        } else {
            object6 = null;
            object5 = this.jSingleBtyeComboBox.getCheckModel();
            object4 = object5.getSelectedItem();
            for (Object object7 : object4) {
                String string3 = (String)object7;
                if (string3.equals(LANG_ALL) || string3.equals(LANG_NONE)) continue;
                language = new TransformationTokenType.Token.Languages.Language();
                language.setName(ServerConstants.StoplistLanguage.toSchema(string3));
                language.setType("SingleByte");
                languages.getLanguage().add(language);
                arrayList.add(ServerConstants.StoplistLanguage.toSchema(string3));
            }
            object3 = (String)this.jMultiByteComboBox.getSelectedItem();
            if (!((String)object3).equals(LANG_NONE)) {
                language = new TransformationTokenType.Token.Languages.Language();
                language.setName(ServerConstants.StoplistLanguage.toSchema((String)object3));
                language.setType("MultiByte");
                languages.getLanguage().add(language);
                arrayList.add(ServerConstants.StoplistLanguage.toSchema((String)object3));
                object6 = object3;
            }
            token.setLanguages(languages);
            object2 = new LexerType();
            object2.setType("Auto");
            token.setLexer((LexerType)object2);
            object = new LexerType.Settings();
            object2.setSettings((LexerType.Settings)object);
        }
        buildTextPreferencesPanelSettings.setTokenLanguages(arrayList);
        token.setStoplistId(null);
        if (this.jSelectedStoplistRadioButton.isSelected() && (object6 = (String)this.jSelectedStoplistComboBox.getSelectedItem()) != null) {
            if (((String)object6).equals(ServerConstants.StoplistLanguage.toHuman("Default"))) {
                object5 = (String)this.jSingleLanguageComboBox.getSelectedItem();
                object5 = ServerConstants.StoplistLanguage.toSchema((String)object5);
                object4 = null;
                stoplistType = AbstractTextNode.findDefaultStoplist(stoplists, (String)object5);
                if (stoplistType == null) {
                    stoplistType = AbstractTextNode.generateDefaultStoplist(this._context, (String)object5);
                    object4 = AbstractTextNode.getStoplistNextId(stoplists) + "";
                    stoplistType.setId((String)object4);
                    stoplists.getStoplist().add(stoplistType);
                } else {
                    object4 = stoplistType.getId();
                }
                token.setStoplistId((String)object4);
            } else {
                token.setStoplistId(BuildTextNode.findStoplistId(stoplists, (String)object6));
            }
        }
        object6 = (Integer)this.jMaxNumPerDocSpinner.getValue();
        token.setMaxNumberPerDoc(BigInteger.valueOf(((Integer)object6).intValue()));
        buildTextPreferencesPanelSettings.setMaxNumPerDoc((Integer)object6);
        object6 = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        token.setMaxNumberAllDocs(BigInteger.valueOf(((Integer)object6).intValue()));
        buildTextPreferencesPanelSettings.setMaxNumAllDocs((Integer)object6);
        object5 = this.jTermFrequencyRadioButton.isSelected() ? "Terms" : "IDF";
        token.setFrequency((String)object5);
        object4 = new TransformationTokenType();
        object4.setToken(token);
        if (!bl) {
            if (!textTransformationType.getToken().getToken().getFrequency().equals(object4.getToken().getFrequency())) {
                this._dirty = true;
            }
            if (!textTransformationType.getToken().getToken().getMaxNumberAllDocs().equals(object4.getToken().getMaxNumberAllDocs())) {
                this._dirty = true;
            }
            if (!textTransformationType.getToken().getToken().getMaxNumberPerDoc().equals(object4.getToken().getMaxNumberPerDoc())) {
                this._dirty = true;
            }
            if (textTransformationType.getToken().getToken().getStoplistId() != null || object4.getToken().getStoplistId() != null) {
                if (textTransformationType.getToken().getToken().getStoplistId() == null && object4.getToken().getStoplistId() != null) {
                    this._dirty = true;
                } else if (textTransformationType.getToken().getToken().getStoplistId() != null && object4.getToken().getStoplistId() == null) {
                    this._dirty = true;
                } else if (!textTransformationType.getToken().getToken().getStoplistId().equals(object4.getToken().getStoplistId())) {
                    this._dirty = true;
                }
            }
            object3 = textTransformationType.getToken().getToken().getLanguages().getLanguage();
            object2 = object4.getToken().getLanguages().getLanguage();
            if (object3.size() != object2.size()) {
                this._dirty = true;
            } else {
                object = object3.iterator();
                while (object.hasNext()) {
                    Object object7;
                    object7 = (TransformationTokenType.Token.Languages.Language)object.next();
                    boolean bl2 = false;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        TransformationTokenType.Token.Languages.Language language2 = (TransformationTokenType.Token.Languages.Language)iterator.next();
                        if (!object7.getName().equals(language2.getName())) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    this._dirty = true;
                    break;
                }
            }
        }
        textTransformationType.setToken((TransformationTokenType)object4);
        textTransformationType.setTheme(null);
        return this._dirty;
    }

    private void enableControls() {
        for (Component component : this.getComponents()) {
            component.setEnabled(!this._isReadOnly);
        }
        if (!this._isReadOnly) {
            boolean bl = this.jSingleAllDocsRadioButton.isSelected();
            this.jSingleLanguageComboBox.setEnabled(bl);
            this.jSingleBtyeComboBox.setEnabled(!bl);
            this.jMultiByteComboBox.setEnabled(!bl);
            this.jSingleLanguageComboBox.setEnabled(this.jSingleAllDocsRadioButton.isSelected());
            this.jSelectedStoplistComboBox.setEnabled(this.jSelectedStoplistRadioButton.isSelected());
            this.jNewStoplistButton.setEnabled(this.jSelectedStoplistRadioButton.isSelected());
        }
        this.jEditStoplistButton.setEnabled(this.jSelectedStoplistComboBox.getItemCount() > 0 && this.jSelectedStoplistRadioButton.isSelected());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jLanguageLabel = new JLabel();
        this.jSingleAllDocsRadioButton = new JRadioButton();
        this.jSingleLanguageComboBox = new JComboBox();
        this.jMultiPerDocRadioButton = new JRadioButton();
        this.jSingleByteLabel = new JLabel();
        this.jSingleBtyeComboBox = new JCheckCombo();
        this.jMultiByteLabel = new JLabel();
        this.jMultiByteComboBox = new JComboBox();
        this.jStoplistLabel = new JLabel();
        this.jSelectedStoplistRadioButton = new JRadioButton();
        this.jSelectedStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jNoneStoplistRadioButton = new JRadioButton();
        this.jTokensLabel = new JLabel();
        this.jMaxNumPerDocLabel = new JLabel();
        this.jMaxNumPerDocSpinner = new JSpinner();
        this.jMaxNumAllDocsLabel = new JLabel();
        this.jMaxNumAllDocsSpinner = new JSpinner();
        this.jFrequencyLabel = new JLabel();
        this.jTermFrequencyRadioButton = new JRadioButton();
        this.jTermFrequencyIDFRadioButton = new JRadioButton();
        this.jLanguageLabel.setText("Language:");
        this.buttonGroup1.add(this.jSingleAllDocsRadioButton);
        this.jSingleAllDocsRadioButton.setText("Single language");
        this.jSingleAllDocsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSingleAllDocsRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jSingleLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "German", "French"}));
        this.jSingleLanguageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSingleLanguageComboBoxActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jMultiPerDocRadioButton);
        this.jMultiPerDocRadioButton.setText("Multiple languages");
        this.jMultiPerDocRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jMultiPerDocRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jSingleByteLabel.setLabelFor((Component)this.jSingleBtyeComboBox);
        this.jSingleByteLabel.setText("Single Byte");
        this.jSingleByteLabel.setMaximumSize(new Dimension(60, 14));
        this.jSingleByteLabel.setMinimumSize(new Dimension(60, 14));
        this.jSingleByteLabel.setPreferredSize(new Dimension(60, 14));
        this.jSingleBtyeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "German", "French"}));
        this.jSingleBtyeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSingleBtyeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jMultiByteLabel.setLabelFor(this.jMultiByteComboBox);
        this.jMultiByteLabel.setText("Multi Byte");
        this.jMultiByteLabel.setMaximumSize(new Dimension(60, 14));
        this.jMultiByteLabel.setMinimumSize(new Dimension(60, 14));
        this.jMultiByteLabel.setPreferredSize(new Dimension(60, 14));
        this.jMultiByteComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "German", "French"}));
        this.jMultiByteComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jMultiByteComboBoxActionPerformed(actionEvent);
            }
        });
        this.jStoplistLabel.setText("Stoplist:");
        this.buttonGroup2.add(this.jSelectedStoplistRadioButton);
        this.jSelectedStoplistRadioButton.setText("Selected");
        this.jSelectedStoplistRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSelectedStoplistRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSelectedStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSelectedStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup2.add(this.jNoneStoplistRadioButton);
        this.jNoneStoplistRadioButton.setText("None");
        this.jNoneStoplistRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jNoneStoplistRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jTokensLabel.setText("Tokens:");
        this.jMaxNumPerDocLabel.setLabelFor(this.jMaxNumPerDocSpinner);
        this.jMaxNumPerDocLabel.setText("Max number per document");
        this.jMaxNumPerDocSpinner.setModel(new SpinnerNumberModel(50, 1, 10000, 10));
        this.jMaxNumAllDocsLabel.setLabelFor(this.jMaxNumAllDocsSpinner);
        this.jMaxNumAllDocsLabel.setText("Max number across all documents");
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 1, 100000, 100));
        this.jFrequencyLabel.setText("Frequency:");
        this.buttonGroup3.add(this.jTermFrequencyRadioButton);
        this.jTermFrequencyRadioButton.setText("Term Frequency");
        this.buttonGroup3.add(this.jTermFrequencyIDFRadioButton);
        this.jTermFrequencyIDFRadioButton.setText("Term Frequency - IDF");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jMultiPerDocRadioButton)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMultiByteLabel, -2, 60, -2).addComponent(this.jSingleByteLabel, -2, 86, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jSingleBtyeComboBox, -2, 283, -2).addComponent(this.jMultiByteComboBox, -2, 283, -2))).addComponent(this.jStoplistLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jNoneStoplistRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectedStoplistRadioButton, GroupLayout.Alignment.LEADING)).addGap(18, 18, 18).addComponent(this.jSelectedStoplistComboBox, -2, 216, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditStoplistButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2)).addComponent(this.jTokensLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMaxNumPerDocLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jMaxNumAllDocsLabel)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMaxNumPerDocSpinner, -2, -1, -2).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2))).addComponent(this.jFrequencyLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTermFrequencyRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jTermFrequencyIDFRadioButton, GroupLayout.Alignment.LEADING))).addComponent(this.jLanguageLabel, GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jSingleAllDocsRadioButton, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSingleLanguageComboBox, -2, 261, -2))).addContainerGap(45, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jMaxNumAllDocsSpinner, this.jMaxNumPerDocSpinner);
        groupLayout.linkSize(0, this.jMultiByteLabel, this.jSingleByteLabel);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLanguageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSingleLanguageComboBox, -2, -1, -2).addComponent(this.jSingleAllDocsRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMultiPerDocRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSingleByteLabel, -2, -1, -2).addComponent((Component)this.jSingleBtyeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMultiByteLabel, -2, -1, -2).addComponent(this.jMultiByteComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStoplistLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedStoplistRadioButton).addComponent(this.jSelectedStoplistComboBox, -2, -1, -2).addComponent(this.jNewStoplistButton).addComponent(this.jEditStoplistButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNoneStoplistRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTokensLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumPerDocLabel).addComponent(this.jMaxNumPerDocSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumAllDocsLabel).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFrequencyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTermFrequencyRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTermFrequencyIDFRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jSingleLanguageComboBoxActionPerformed(ActionEvent actionEvent) {
        this.initStoplists(null);
        String string = (String)this.jSingleLanguageComboBox.getSelectedItem();
        boolean bl = false;
        if (this._textTransformation != null && this._textTransformation.getToken() != null) {
            String string2;
            List list = null;
            list = this._textTransformation.getToken().getToken().getLanguages().getLanguage();
            if (list.size() == 1 && ((TransformationTokenType.Token.Languages.Language)list.get(0)).getName().equals(ServerConstants.StoplistLanguage.toSchema(string)) && (string2 = this._textTransformation.getToken().getToken().getStoplistId()) != null) {
                StoplistType stoplistType = null;
                for (StoplistType stoplistType2 : this._stoplists.getStoplist()) {
                    if (!stoplistType2.getId().equals(string2)) continue;
                    stoplistType = stoplistType2;
                    break;
                }
                String string3 = stoplistType.getName();
                this.jSelectedStoplistRadioButton.setSelected(true);
                this.jSelectedStoplistComboBox.setSelectedItem(string3);
                bl = true;
            }
        }
        if (!bl) {
            boolean bl2 = AbstractTextNode.defaultStoplistExists(this._context, ServerConstants.StoplistLanguage.toSchema(string));
            if (bl2) {
                this.jSelectedStoplistRadioButton.setSelected(true);
                this.jSelectedStoplistComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman("Default"));
            } else {
                this.jNoneStoplistRadioButton.setSelected(true);
            }
        }
        this.enableControls();
    }

    private void jSelectedStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        Object object3;
        Object object2;
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        class Loader
        extends ProgressRunnable {
            private String _language = null;
            private StoplistType _defaultStoplist = null;

            public Loader(String string) {
                this._language = string;
            }

            protected Object doWork() throws Exception {
                this._defaultStoplist = BuildTextNode.generateDefaultStoplist(TextTransColumnSettingTokenPanel.this._context, ServerConstants.StoplistLanguage.toSchema(this._language));
                return this._defaultStoplist;
            }

            protected void finish(Object object) {
            }

            public StoplistType getDefaultStoplist() {
                return this._defaultStoplist;
            }
        }
        Loader loader = null;
        boolean bl = false;
        if (ServerConstants.StoplistLanguage.isDefault(ServerConstants.StoplistLanguage.toSchema(string))) {
            object2 = (String)this.jSingleLanguageComboBox.getSelectedItem();
            object3 = new Loader((String)object2);
            object3.setTitle(DialogsLrb.get("ADD_BUILDTEXT_TEXT_TRANSFORM_DIALOG"));
            object3.setMessage(DialogsLrb.get("STOPLIST_DEFAULT_LOADING"));
            object3.setCancelable(false);
            try {
                object3.start(true);
                loader = ((Loader)((Object)object3)).getDefaultStoplist();
            }
            catch (ProgressException progressException) {
                progressException.printStackTrace();
            }
        } else {
            for (Object object3 : this._stoplists.getStoplist()) {
                if (!object3.getName().equals(string)) continue;
                loader = object3;
                break;
            }
            bl = !this._isReadOnly;
        }
        object2 = new StoplistDetailsDialog();
        if (this._propertyModel != null) {
            ((StoplistDetailsDialog)object2).invoke(this._propertyModel, this, (StoplistType)loader, bl);
        } else {
            ((StoplistDetailsDialog)object2).invoke(this._context, this._node, this, (StoplistType)loader, bl);
        }
        if (bl && ((StoplistDetailsPanel)(object3 = ((StoplistDetailsDialog)object2).getPanel())).isDirty()) {
            StoplistType stoplistType = ((StoplistDetailsPanel)object3).getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType);
                break;
            }
            this._dirty = true;
            this.initStoplists(stoplistType.getName());
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, this._propertyModel, this._context, (BuildTextNode)this._node, this._sourceAttributeName)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractTextNode.getStoplistNextId(this._stoplists) + "";
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this.initStoplists(stoplistType.getName());
        }
    }

    private void jSingleAllDocsRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.jSingleLanguageComboBoxActionPerformed(actionEvent);
        this.enableControls();
    }

    private void jMultiPerDocRadioButtonActionPerformed(ActionEvent actionEvent) {
        CheckComboModel checkComboModel3;
        this.initStoplists(null);
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        CheckComboModel checkComboModel2 = null;
        if (string != null) {
            for (CheckComboModel checkComboModel3 : this._stoplists.getStoplist()) {
                if (!checkComboModel3.getName().equals(string)) continue;
                checkComboModel2 = checkComboModel3;
                break;
            }
        }
        ArrayList arrayList = new ArrayList();
        checkComboModel3 = this.jSingleBtyeComboBox.getCheckModel();
        Object[] objectArray = checkComboModel3.getSelectedItem();
        for (Object object : objectArray) {
            if (((String)object).equals(LANG_ALL) || ((String)object).equals(LANG_NONE)) continue;
            arrayList.add(ServerConstants.StoplistLanguage.toSchema((String)object));
        }
        String string2 = (String)this.jMultiByteComboBox.getSelectedItem();
        if (!string2.equals(LANG_NONE)) {
            arrayList.add(string2);
        }
        this.jNoneStoplistRadioButton.setSelected(!this.isStoplistCompatible((StoplistType)checkComboModel2, arrayList));
        this.jSelectedStoplistRadioButton.setSelected(this.isStoplistCompatible((StoplistType)checkComboModel2, arrayList));
        this.enableControls();
    }

    private void jSelectedStoplistRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jNoneStoplistRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jSingleBtyeComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jMultiByteComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jSingleByteLanguageValueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
        for (Object object : objectArray = checkComboModel.getSelectedItem()) {
            String string = (String)object;
            if (!this._isNoneSelected && string.equals(LANG_NONE)) {
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(1, 1);
                this._isNoneSelected = true;
                this._isAllSelected = false;
                break;
            }
            if (!this._isAllSelected && string.equals(LANG_ALL)) {
                listSelectionModel.removeSelectionInterval(1, 1);
                listSelectionModel.addSelectionInterval(2, checkComboModel.getSize() - 1);
                this._isAllSelected = true;
                this._isNoneSelected = false;
                break;
            }
            listSelectionModel.removeSelectionInterval(0, 0);
            this._isAllSelected = false;
            listSelectionModel.removeSelectionInterval(1, 1);
            this._isNoneSelected = false;
        }
        this._isAdjusting = false;
    }

    private boolean isStoplistCompatible(StoplistType stoplistType, ArrayList<String> arrayList) {
        boolean bl = false;
        if (stoplistType != null && stoplistType.getStopTokens().getToken().size() > 0 && arrayList != null && arrayList.size() > 0) {
            for (StoplistType.StopTokens.Token token : stoplistType.getStopTokens().getToken()) {
                String string = token.getLanguage();
                if (!arrayList.contains(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setSourceAttributeName(String string) {
        this._sourceAttributeName = string;
    }

    public void setReadOnly(boolean bl) {
        this._isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public TextNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }

    static {
        LANG_ALL = DialogsLrb.get("BUILDTEXT_LANGUAGE_ALL");
        LANG_NONE = DialogsLrb.get("BUILDTEXT_LANGUAGE_NONE");
    }
}

