/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistDetailsDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistWizard;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPage;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPanel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.preferences.BuildTextPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;

public class TextTransColumnSettingThemePanel
extends JPanel {
    private JPanel _parent;
    private String _sourceAttributeName = null;
    private TextNodeType.Stoplists _stoplists = null;
    private AbstractTextNode _node;
    private Context _context;
    private PropertyModel _propertyModel;
    private TextTransformationType _textTransformation;
    private boolean _isAdjusting;
    private static Icon _editIcon;
    private static Icon _addIcon;
    private boolean _isReadOnly;
    private boolean _dirty;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JButton jEditStoplistButton;
    private JLabel jFrequencyLabel;
    private JLabel jLanguageLabel;
    private JLabel jMaxNumAllDocsLabel;
    private JSpinner jMaxNumAllDocsSpinner;
    private JLabel jMaxNumPerDocLabel;
    private JSpinner jMaxNumPerDocSpinner;
    private JButton jNewStoplistButton;
    private JRadioButton jNoneStoplistRadioButton;
    private JComboBox jSelectedStoplistComboBox;
    private JRadioButton jSelectedStoplistRadioButton;
    private JLabel jSingleAllDocsLabel;
    private JComboBox jSingleLanguageComboBox;
    private JLabel jStoplistLabel;
    private JRadioButton jTermFrequencyIDFRadioButton;
    private JRadioButton jTermFrequencyRadioButton;
    private JRadioButton jThemeTypeFullRadioButton;
    private JLabel jThemeTypeLabel;
    private JRadioButton jThemeTypeSingleRadioButton;
    private JLabel jTokensLabel;

    public TextTransColumnSettingThemePanel(PropertyModel propertyModel, Context context, JPanel jPanel, AbstractTextNode abstractTextNode, String string, TextTransformationType textTransformationType) {
        this._propertyModel = propertyModel;
        this._node = abstractTextNode;
        this._context = context;
        this._parent = jPanel;
        if (jPanel instanceof TextTransColumnSettingPanel) {
            this._stoplists = ((TextTransColumnSettingPanel)jPanel).getStoplists();
        } else if (jPanel instanceof TextTransColumnSettingPage) {
            this._stoplists = ((TextTransColumnSettingPage)((Object)jPanel)).getStoplists();
        }
        this._sourceAttributeName = string;
        this._textTransformation = textTransformationType;
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initUI() {
        this._isAdjusting = true;
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILDTEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(_addIcon);
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILDTEXT_ADD_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setEnabled(!this._isReadOnly);
        this.jSingleLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.StoplistLanguage.toHuman("ENGLISH"), ServerConstants.StoplistLanguage.toHuman("FRENCH")}));
        this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman("ENGLISH"));
        this.initStoplists(null);
        this.jMaxNumPerDocSpinner.setModel(new SpinnerNumberModel(50, 1, 10000, 100));
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(300, 1, 100000, 1000));
        this.refreshUI(this._textTransformation);
        this._isAdjusting = false;
    }

    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("ADD_STOPWORD_LANGUAGE"), this.jLanguageLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_SINGLE_FOR_ALL_DOCS"), this.jSingleAllDocsLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_STOPLIST"), this.jStoplistLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_STOPLIST_SELECTED"), this.jSelectedStoplistRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_STOPLIST_NONE"), this.jNoneStoplistRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_THEMES"), this.jTokensLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_MAX_NUM_PER_DOC"), this.jMaxNumPerDocLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_MAX_NUM_ALL_DOCS"), this.jMaxNumAllDocsLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_THEME_TYPE"), this.jThemeTypeLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_THEME_SINGLE_TYPE"), this.jThemeTypeSingleRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_THEME_FULL_TYPE"), this.jThemeTypeFullRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_FREQUENCY"), this.jFrequencyLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_FREQUENCY_TERM"), this.jTermFrequencyRadioButton);
        hashMap.put(DialogsLrb.get("BUILDTEXT_FREQUENCY_TERM_IDF"), this.jTermFrequencyIDFRadioButton);
        UIResourceHelper.setComponentText(hashMap);
        Class<PIComponentPanel> clazz = PIComponentPanel.class;
        _editIcon = InspectorArb.getIcon((int)24);
        _addIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_ICON"));
    }

    private void initStoplists(String string) {
        List list = null;
        list = this._stoplists.getStoplist();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType object : list) {
            arrayList.add(object.getName());
        }
        Collections.sort(arrayList);
        this.jSelectedStoplistComboBox.removeAllItems();
        this.jSelectedStoplistComboBox.addItem(ServerConstants.StoplistLanguage.toHuman("Default"));
        for (String string2 : arrayList) {
            this.jSelectedStoplistComboBox.addItem(string2);
        }
        if (string != null) {
            this.jSelectedStoplistComboBox.setSelectedItem(string);
        }
    }

    public ArrayList<String> getAvailableStoplists() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.jSelectedStoplistComboBox.getItemCount(); ++i) {
            arrayList.add((String)this.jSelectedStoplistComboBox.getItemAt(i));
        }
        return arrayList;
    }

    public void refreshUI(TextTransformationType textTransformationType) {
        this._textTransformation = textTransformationType;
        if (textTransformationType != null && textTransformationType.getTheme() != null) {
            List list = null;
            list = this._textTransformation.getTheme().getToken().getLanguages().getLanguage();
            this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(((TransformationTokenType.Token.Languages.Language)list.get(0)).getName()));
            StoplistType stoplistType = null;
            String string = textTransformationType.getTheme().getToken().getStoplistId();
            if (string != null) {
                for (StoplistType stoplistType2 : this._stoplists.getStoplist()) {
                    if (!stoplistType2.getId().equals(string)) continue;
                    stoplistType = stoplistType2;
                    break;
                }
            }
            if (stoplistType != null) {
                this.jSelectedStoplistComboBox.setSelectedItem(stoplistType.getName());
            }
            this.jSelectedStoplistRadioButton.setSelected(stoplistType != null);
            this.jNoneStoplistRadioButton.setSelected(stoplistType == null);
            int n = textTransformationType.getTheme().getToken().getMaxNumberPerDoc().intValue();
            this.jMaxNumPerDocSpinner.setValue(new Integer(n));
            int n2 = textTransformationType.getTheme().getToken().getMaxNumberAllDocs().intValue();
            this.jMaxNumAllDocsSpinner.setValue(new Integer(n2));
            String string2 = textTransformationType.getTheme().getToken().getFrequency();
            this.jTermFrequencyRadioButton.setSelected(string2.equals("Terms"));
            this.jTermFrequencyIDFRadioButton.setSelected(string2.equals("IDF"));
            String string3 = textTransformationType.getTheme().getType();
            this.jThemeTypeSingleRadioButton.setSelected(string3.equals("Single"));
            this.jThemeTypeFullRadioButton.setSelected(string3.equals("Full"));
        } else {
            Preferences preferences = Preferences.getPreferences();
            BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
            List<String> list = buildTextPreferencesPanelSettings.getThemeLanguages();
            if (list.size() > 0) {
                this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(list.get(0)));
            }
            this.jSelectedStoplistComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman("Default"));
            this.jSelectedStoplistRadioButton.setSelected(true);
            this.jMaxNumPerDocSpinner.setValue(new Integer(buildTextPreferencesPanelSettings.getMaxNumPerDoc()));
            this.jMaxNumAllDocsSpinner.setValue(new Integer(buildTextPreferencesPanelSettings.getMaxNumAllDocs()));
            this.jTermFrequencyIDFRadioButton.setSelected(true);
            this.jThemeTypeSingleRadioButton.setSelected(true);
        }
        this.enableControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copySettings(TextTransformationType textTransformationType, TextNodeType.Stoplists stoplists) throws ValidationException {
        String string;
        Object object;
        Connection connection;
        boolean bl = false;
        StoplistType stoplistType = null;
        Integer n = (Integer)this.jMaxNumPerDocSpinner.getValue();
        Integer n2 = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        if (n > n2) {
            throw new ValidationException(DialogsLrb.get("BUILDTEXT_MAX_NUM_PER_DOC_ERROR"));
        }
        TransformationTokenType.Token token = new TransformationTokenType.Token();
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        String string2 = null;
        String string3 = null;
        if (textTransformationType.getTheme() != null) {
            string2 = textTransformationType.getTheme().getToken().getPolicy();
            string3 = textTransformationType.getTheme().getToken().getStatisticTable().getName();
        } else {
            bl = true;
            connection = null;
            try {
                connection = Connections.getSharedConnection(this._context);
                string2 = DatabaseMetadataUtils.createUniqueTableName("ODMR$" + (this._sourceAttributeName == null ? "" : this._sourceAttributeName), connection, "_PL");
                string3 = DatabaseMetadataUtils.createUniqueTableName("ODMR$" + (this._sourceAttributeName == null ? "" : this._sourceAttributeName), connection, "_FT");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        token.setPolicy(string2);
        connection = new ResultType();
        connection.setName(string3);
        token.setStatisticTable((ResultType)connection);
        Preferences preferences = Preferences.getPreferences();
        BuildTextPreferencesPanelSettings buildTextPreferencesPanelSettings = BuildTextPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = (String)this.jSingleLanguageComboBox.getSelectedItem();
        arrayList.add(ServerConstants.StoplistLanguage.toSchema(string4));
        language = new TransformationTokenType.Token.Languages.Language();
        language.setName(ServerConstants.StoplistLanguage.toSchema(string4));
        language.setType("SingleByte");
        languages.getLanguage().add(language);
        token.setLanguages(languages);
        LexerType lexerType = new LexerType();
        lexerType.setType("Basic");
        token.setLexer(lexerType);
        LexerType.Settings settings = new LexerType.Settings();
        lexerType.setSettings(settings);
        buildTextPreferencesPanelSettings.setThemeLanguages(arrayList);
        token.setStoplistId(null);
        if (this.jSelectedStoplistRadioButton.isSelected() && (object = (String)this.jSelectedStoplistComboBox.getSelectedItem()) != null) {
            if (((String)object).equals(ServerConstants.StoplistLanguage.toHuman("Default"))) {
                string4 = (String)this.jSingleLanguageComboBox.getSelectedItem();
                string4 = ServerConstants.StoplistLanguage.toSchema(string4);
                string = null;
                stoplistType = AbstractTextNode.findDefaultStoplist(stoplists, string4);
                if (stoplistType == null) {
                    stoplistType = AbstractTextNode.generateDefaultStoplist(this._context, string4);
                    string = AbstractTextNode.getStoplistNextId(stoplists) + "";
                    stoplistType.setId(string);
                    stoplists.getStoplist().add(stoplistType);
                } else {
                    string = stoplistType.getId();
                }
                token.setStoplistId(string);
            } else {
                token.setStoplistId(BuildTextNode.findStoplistId(stoplists, (String)object));
            }
        }
        object = (Integer)this.jMaxNumPerDocSpinner.getValue();
        token.setMaxNumberPerDoc(BigInteger.valueOf(((Integer)object).intValue()));
        buildTextPreferencesPanelSettings.setMaxNumPerDoc((Integer)object);
        object = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        token.setMaxNumberAllDocs(BigInteger.valueOf(((Integer)object).intValue()));
        buildTextPreferencesPanelSettings.setMaxNumAllDocs((Integer)object);
        string = this.jTermFrequencyRadioButton.isSelected() ? "Terms" : "IDF";
        token.setFrequency(string);
        String string5 = this.jThemeTypeSingleRadioButton.isSelected() ? "Single" : "Full";
        TextTransformationType.Theme theme = new TextTransformationType.Theme();
        theme.setToken(token);
        theme.setType(string5);
        if (!bl) {
            if (!textTransformationType.getTheme().getType().equals(theme.getType())) {
                this._dirty = true;
            }
            if (!textTransformationType.getTheme().getToken().getFrequency().equals(theme.getToken().getFrequency())) {
                this._dirty = true;
            }
            if (!textTransformationType.getTheme().getToken().getMaxNumberAllDocs().equals(theme.getToken().getMaxNumberAllDocs())) {
                this._dirty = true;
            }
            if (!textTransformationType.getTheme().getToken().getMaxNumberPerDoc().equals(theme.getToken().getMaxNumberPerDoc())) {
                this._dirty = true;
            }
            if (textTransformationType.getTheme().getToken().getStoplistId() != null || theme.getToken().getStoplistId() != null) {
                if (textTransformationType.getTheme().getToken().getStoplistId() == null && theme.getToken().getStoplistId() != null) {
                    this._dirty = true;
                } else if (textTransformationType.getTheme().getToken().getStoplistId() != null && theme.getToken().getStoplistId() == null) {
                    this._dirty = true;
                } else if (!textTransformationType.getTheme().getToken().getStoplistId().equals(theme.getToken().getStoplistId())) {
                    this._dirty = true;
                }
            }
            List list = textTransformationType.getTheme().getToken().getLanguages().getLanguage();
            List list2 = theme.getToken().getLanguages().getLanguage();
            if (!((TransformationTokenType.Token.Languages.Language)list.get(0)).getName().equals(((TransformationTokenType.Token.Languages.Language)list2.get(0)).getName())) {
                this._dirty = true;
            }
        }
        textTransformationType.setTheme(theme);
        textTransformationType.setToken(null);
        return this._dirty;
    }

    private void enableControls() {
        for (Component component : this.getComponents()) {
            component.setEnabled(!this._isReadOnly);
        }
        if (!this._isReadOnly) {
            this.jSelectedStoplistComboBox.setEnabled(this.jSelectedStoplistRadioButton.isSelected());
            this.jNewStoplistButton.setEnabled(this.jSelectedStoplistRadioButton.isSelected());
        }
        this.jEditStoplistButton.setEnabled(this.jSelectedStoplistRadioButton.isSelected());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jLanguageLabel = new JLabel();
        this.jSingleAllDocsLabel = new JLabel();
        this.jSingleLanguageComboBox = new JComboBox();
        this.jStoplistLabel = new JLabel();
        this.jSelectedStoplistRadioButton = new JRadioButton();
        this.jSelectedStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jNoneStoplistRadioButton = new JRadioButton();
        this.jTokensLabel = new JLabel();
        this.jMaxNumPerDocLabel = new JLabel();
        this.jMaxNumPerDocSpinner = new JSpinner();
        this.jMaxNumAllDocsLabel = new JLabel();
        this.jMaxNumAllDocsSpinner = new JSpinner();
        this.jThemeTypeLabel = new JLabel();
        this.jThemeTypeSingleRadioButton = new JRadioButton();
        this.jThemeTypeFullRadioButton = new JRadioButton();
        this.jFrequencyLabel = new JLabel();
        this.jTermFrequencyRadioButton = new JRadioButton();
        this.jTermFrequencyIDFRadioButton = new JRadioButton();
        this.jLanguageLabel.setText("Language:");
        this.jSingleAllDocsLabel.setLabelFor(this.jSingleLanguageComboBox);
        this.jSingleAllDocsLabel.setText("Single language:");
        this.jSingleLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jStoplistLabel.setText("Stoplist:");
        this.buttonGroup2.add(this.jSelectedStoplistRadioButton);
        this.jSelectedStoplistRadioButton.setText("Selected");
        this.jSelectedStoplistRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jSelectedStoplistRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSelectedStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jSelectedStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup2.add(this.jNoneStoplistRadioButton);
        this.jNoneStoplistRadioButton.setText("None");
        this.jNoneStoplistRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jNoneStoplistRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jTokensLabel.setText("Themes:");
        this.jMaxNumPerDocLabel.setLabelFor(this.jMaxNumPerDocSpinner);
        this.jMaxNumPerDocLabel.setText("Max number per document");
        this.jMaxNumPerDocSpinner.setModel(new SpinnerNumberModel(50, 1, 10000, 10));
        this.jMaxNumAllDocsLabel.setLabelFor(this.jMaxNumAllDocsSpinner);
        this.jMaxNumAllDocsLabel.setText("Max number across all documents");
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 1, 100000, 100));
        this.jThemeTypeLabel.setText("Theme Type:");
        this.buttonGroup3.add(this.jThemeTypeSingleRadioButton);
        this.jThemeTypeSingleRadioButton.setText("Single");
        this.buttonGroup3.add(this.jThemeTypeFullRadioButton);
        this.jThemeTypeFullRadioButton.setText("Full");
        this.jFrequencyLabel.setText("Frequency:");
        this.buttonGroup4.add(this.jTermFrequencyRadioButton);
        this.jTermFrequencyRadioButton.setText("Term Frequency");
        this.buttonGroup4.add(this.jTermFrequencyIDFRadioButton);
        this.jTermFrequencyIDFRadioButton.setText("Term Frequency - IDF");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLanguageLabel).addComponent(this.jStoplistLabel).addComponent(this.jThemeTypeLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jThemeTypeFullRadioButton, -1, 368, Short.MAX_VALUE).addComponent(this.jThemeTypeSingleRadioButton, -1, 368, Short.MAX_VALUE))).addComponent(this.jTokensLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMaxNumAllDocsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jMaxNumPerDocLabel, -1, 171, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMaxNumPerDocSpinner, -2, -1, -2).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2))).addComponent(this.jFrequencyLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTermFrequencyIDFRadioButton, -1, 368, Short.MAX_VALUE).addComponent(this.jTermFrequencyRadioButton, -1, 368, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jNoneStoplistRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectedStoplistRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.jSingleAllDocsLabel, -2, 110, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jSelectedStoplistComboBox, -2, 173, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditStoplistButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton)).addComponent(this.jSingleLanguageComboBox, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)).addGap(0, 26, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jMaxNumAllDocsSpinner, this.jMaxNumPerDocSpinner);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLanguageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSingleAllDocsLabel).addComponent(this.jSingleLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jStoplistLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedStoplistRadioButton).addComponent(this.jSelectedStoplistComboBox, -2, -1, -2).addComponent(this.jEditStoplistButton).addComponent(this.jNewStoplistButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNoneStoplistRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTokensLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumPerDocLabel).addComponent(this.jMaxNumPerDocSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumAllDocsLabel).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jThemeTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThemeTypeSingleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThemeTypeFullRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFrequencyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTermFrequencyRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTermFrequencyIDFRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jSelectedStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        Object object3;
        Object object2;
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        class Loader
        extends ProgressRunnable {
            private String _language = null;
            private StoplistType _defaultStoplist = null;

            public Loader(String string) {
                this._language = string;
            }

            protected Object doWork() throws Exception {
                this._defaultStoplist = BuildTextNode.generateDefaultStoplist(TextTransColumnSettingThemePanel.this._context, ServerConstants.StoplistLanguage.toSchema(this._language));
                return this._defaultStoplist;
            }

            protected void finish(Object object) {
            }

            public StoplistType getDefaultStoplist() {
                return this._defaultStoplist;
            }
        }
        Loader loader = null;
        boolean bl = false;
        if (ServerConstants.StoplistLanguage.isDefault(ServerConstants.StoplistLanguage.toSchema(string))) {
            object2 = (String)this.jSingleLanguageComboBox.getSelectedItem();
            object3 = new Loader((String)object2);
            object3.setTitle(DialogsLrb.get("ADD_BUILDTEXT_TEXT_TRANSFORM_DIALOG"));
            object3.setMessage(DialogsLrb.get("STOPLIST_DEFAULT_LOADING"));
            object3.setCancelable(false);
            try {
                object3.start(true);
                loader = ((Loader)((Object)object3)).getDefaultStoplist();
            }
            catch (ProgressException progressException) {
                progressException.printStackTrace();
            }
        } else {
            for (Object object3 : this._stoplists.getStoplist()) {
                if (!object3.getName().equals(string)) continue;
                loader = object3;
                break;
            }
            bl = !this._isReadOnly;
        }
        object2 = new StoplistDetailsDialog();
        if (this._propertyModel != null) {
            ((StoplistDetailsDialog)object2).invoke(this._propertyModel, this, (StoplistType)loader, bl);
        } else {
            ((StoplistDetailsDialog)object2).invoke(this._context, this._node, this, (StoplistType)loader, bl);
        }
        if (bl && ((StoplistDetailsPanel)(object3 = ((StoplistDetailsDialog)object2).getPanel())).isDirty()) {
            StoplistType stoplistType = ((StoplistDetailsPanel)object3).getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType);
                break;
            }
            this._dirty = true;
            this.initStoplists(stoplistType.getName());
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, this._propertyModel, this._context, (BuildTextNode)this._node, this._sourceAttributeName)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractTextNode.getStoplistNextId(this._stoplists) + "";
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this.initStoplists(stoplistType.getName());
        }
    }

    private void jSelectedStoplistRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jNoneStoplistRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    public void setSourceAttributeName(String string) {
        this._sourceAttributeName = string;
    }

    public void setReadOnly(boolean bl) {
        this._isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public TextNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }
}

