/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.wizard.AbstractWizardPage;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.AddStopwordsDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.AddStopwordsPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistWizardModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class StoplistReviewPage
extends AbstractWizardPage
implements DataminerGUIPanel {
    private StoplistWizardModel _wizModel;
    private StoplistType _stoplist;
    private boolean _isAdjusting;
    private StopwordTableModel _stopwordModels;
    private NiceTableWithToolbar _stopwordTableWithToolbar;
    private JButton _stopwordRemoveBtn;
    private JButton _stopwordAddBtn;
    private static Icon _removeIcon;
    private static Icon _addIcon;
    private ComponentWithTitlebar<JComponent> StopwordComponentWithTitlebar;
    private JLabel jLanguageLabel;
    private JLabel jLanguageValueLabel;
    private JLabel jNameLabel;
    private JLabel jNameValueLabel;
    private String[] _stopwordColumnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_TYPE"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
    private int[] _stopwordColumnWidths = new int[]{180, 100, 100};
    private static final int STOPWORD_NAME = 0;
    private static final int STOPWORD_TYPE = 1;
    private static final int STOPWORD_LANGUAGE = 2;
    private static final int STOPWORD_COLUMN_COUNT = 3;

    public StoplistReviewPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("STOPLIST_WIZ_NAME"), this.jNameLabel);
        hashMap.put(DialogsLrb.get("ADD_STOPWORD_LANGUAGE"), this.jLanguageLabel);
        UIResourceHelper.setComponentText(hashMap);
        Class<PIComponentPanel> clazz = PIComponentPanel.class;
        _removeIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_REMOVE_ICON"));
        _addIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_ICON"));
    }

    @Override
    public void initUI() {
        this._wizModel = (StoplistWizardModel)this.getTraversableContext().get("wizardModel");
        this._stoplist = this._wizModel.getStoplist();
        this._isAdjusting = true;
        this.jNameValueLabel.setText(this._stoplist.getName());
        String string = null;
        string = this._stoplist.getType().equals("Basic") ? ServerConstants.StoplistLanguage.toHuman(this._stoplist.getLanguage()) : ServerConstants.StoplistLanguage.toHuman("Multi");
        this.jLanguageValueLabel.setText(string);
        this._stopwordModels = new StopwordTableModel(this._stoplist.getStopTokens());
        ControlBar controlBar = new ControlBar();
        this.installStopwordItemFilterActions(controlBar);
        this._stopwordTableWithToolbar = new NiceTableWithToolbar(this.StopwordComponentWithTitlebar, controlBar, this._stopwordColumnNames, this._stopwordModels);
        this._stopwordTableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("STOPLIST_STOPWORD_TABLE_TITLE")));
        this._stopwordTableWithToolbar.getNiceTable().setAutoResizeMode(0);
        this._stopwordTableWithToolbar.getNiceTable().setSelectionMode(2);
        this._stopwordTableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._stopwordTableWithToolbar.getNiceTable().setShowToolTips(true);
        this._stopwordTableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._stopwordTableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        this._stopwordTableWithToolbar.getNiceTable().setSortColumn(0, true);
        TableColumn tableColumn = this._stopwordTableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
        StopwordEditor stopwordEditor = new StopwordEditor();
        stopwordEditor.setDocument(new TextFieldLimit(4000));
        tableColumn.setCellEditor(stopwordEditor);
        int n = 0;
        for (int n2 : this._stopwordColumnWidths) {
            this._stopwordTableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._stopwordTableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                StoplistReviewPage.this.enableControls();
            }
        });
        this._isAdjusting = false;
        this.enableControls();
    }

    private void installStopwordItemFilterActions(ControlBar controlBar) {
        this._stopwordRemoveBtn = new JButton(_removeIcon);
        this._stopwordRemoveBtn.setToolTipText(DialogsLrb.get("STOPLIST_DELETE_STOPWORD_TOOLTIP"));
        this._stopwordRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistReviewPage.this._stopwordTableWithToolbar.getNiceTable().getSelectedRowsInModel();
                if (nArray.length > 0) {
                    StoplistReviewPage.this._stopwordModels.removeSelectedRows(nArray);
                    StoplistReviewPage.this._stopwordTableWithToolbar.resetNiceTableModel(StoplistReviewPage.this._stopwordModels);
                }
            }
        });
        controlBar.add((Component)this._stopwordRemoveBtn);
        this._stopwordAddBtn = new JButton(_addIcon);
        this._stopwordAddBtn.setToolTipText(DialogsLrb.get("STOPLIST_ADD_STOPWORD_TOOLTIP"));
        this._stopwordAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistReviewPage.this.processAdd();
            }
        });
        controlBar.add((Component)this._stopwordAddBtn);
    }

    private void processAdd() {
        AddStopwordsDialog addStopwordsDialog = new AddStopwordsDialog();
        if (addStopwordsDialog.invoke(this._wizModel.getContext(), null, (JPanel)((Object)this), this._stoplist)) {
            AddStopwordsPanel addStopwordsPanel = addStopwordsDialog.getPanel();
            this._stoplist = addStopwordsPanel.getStoplist();
            this._stopwordModels = new StopwordTableModel(this._stoplist.getStopTokens());
            this._stopwordTableWithToolbar.resetNiceTableModel(this._stopwordModels);
            this.enableControls();
        }
    }

    private void enableControls() {
        this._stopwordAddBtn.setEnabled(true);
        int[] nArray = this._stopwordTableWithToolbar.getNiceTable().getSelectedRowsInModel();
        this._stopwordRemoveBtn.setEnabled(nArray.length > 0);
    }

    @Override
    public String getPageDirtyKey() {
        return "reviewDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        StoplistWizardModel stoplistWizardModel = (StoplistWizardModel)traversableContext.get("wizardModel");
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        return this.validateAndWriteToState(stoplistWizardModel);
    }

    public boolean validateAndWriteToState(StoplistWizardModel stoplistWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread(stoplistWizardModel);
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private void initComponents() {
        this.jNameLabel = new JLabel();
        this.jNameValueLabel = new JLabel();
        this.jLanguageLabel = new JLabel();
        this.jLanguageValueLabel = new JLabel();
        this.StopwordComponentWithTitlebar = new ComponentWithTitlebar();
        this.jNameLabel.setText("Name:");
        this.jNameValueLabel.setText("jLabel2");
        this.jLanguageLabel.setText("Language:");
        this.jLanguageValueLabel.setText("jLabel2");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.StopwordComponentWithTitlebar, -1, 486, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLanguageLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jNameLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNameValueLabel, -2, 243, -2).addComponent(this.jLanguageValueLabel, -2, 243, -2)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNameLabel).addComponent(this.jNameValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jLanguageValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.StopwordComponentWithTitlebar, -1, 281, Short.MAX_VALUE).addContainerGap()));
    }

    private class StopwordEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextField _textField = new JTextField();

        public StopwordEditor() {
            this._textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StopwordEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                this._textField.setText(string);
            } else if (object == null) {
                this._textField.setText("");
            }
            return this._textField;
        }

        @Override
        public Object getCellEditorValue() {
            return this._textField.getText();
        }

        public void setDocument(Document document) {
            this._textField.setDocument(document);
        }
    }

    private class StopwordTableModel
    extends GenericBaseTableModel {
        private StoplistType.StopTokens _tokens;

        public StopwordTableModel(StoplistType.StopTokens stopTokens) {
            this._tokens = stopTokens;
            this.setColumnIdentifiers(StoplistReviewPage.this._stopwordColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._tokens == null ? 0 : this._tokens.getToken().size();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<StoplistType.StopTokens.Token> vector = new Vector<StoplistType.StopTokens.Token>();
            for (int i = 0; i < nArray.length; ++i) {
                StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(nArray[i]);
                vector.add(token);
            }
            this._tokens.getToken().removeAll(vector);
            this.setRowCount(this._tokens.getToken().size());
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._tokens == null || this._tokens.getToken().size() == 0) {
                return null;
            }
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = token.getItem();
                    break;
                }
                case 1: {
                    string = ServerConstants.StopTokenType.toHuman(token.getType());
                    break;
                }
                case 2: {
                    string = ServerConstants.StoplistLanguage.toHuman(token.getLanguage());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(n);
            switch (n2) {
                case 0: {
                    String string = null;
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (!this.validateStopwords(n, string, token.getLanguage(), this._tokens.getToken())) {
                        return;
                    }
                    token.setItem((String)object);
                    token.setType(ServerConstants.StopTokenType.toSchema(this.getType((String)object)));
                }
            }
        }

        private String getType(String string) {
            return string.indexOf(32) == -1 ? "Word" : "Theme";
        }

        private boolean validateStopwords(int n, String string, String string2, List<StoplistType.StopTokens.Token> list) {
            boolean bl = true;
            int n2 = 0;
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_STOPWORD_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            for (StoplistType.StopTokens.Token token : list) {
                String string3 = string + this.getType(string) + string2;
                String string4 = token.getItem() + token.getType() + token.getLanguage();
                if (n != n2 && string3.compareTo(string4) == 0) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPWORD"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            }
            return bl;
        }

        public StoplistType.StopTokens getTokens() {
            return this._tokens;
        }
    }

    class ValidateWriteThread
    extends ProgressRunnable {
        private StoplistWizardModel _model;
        boolean _validated = true;
        private boolean _canceled = false;
        private boolean _forceUpdate = false;

        public ValidateWriteThread(StoplistWizardModel stoplistWizardModel) {
            this._model = stoplistWizardModel;
        }

        public boolean getForceUpdate() {
            return this._forceUpdate;
        }

        public void setForceUpdate(boolean bl) {
            this._forceUpdate = bl;
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                this._validated = true;
                this._model.setStoplist(StoplistReviewPage.this._stoplist);
            }
            catch (Exception exception) {
                this._validated = false;
            }
            return null;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

