/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.AddStopwordsDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.AddStopwordsPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistWizard;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.applyText.WorkflowApplyTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.text.WorkflowTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class StoplistPanel
extends AbstractDialogPanel {
    private JPanel _parent;
    private TextNodeType _textNodeType;
    private TextNodeType.Stoplists _existStoplists;
    private TextNodeType.Stoplists _filterStoplists;
    private PropertyModel _propertyModel;
    private boolean _isReadOnly;
    private boolean _dirty;
    private boolean _isAdjusting;
    private StoplistTableModel _stoplistModels;
    private StopwordTableModel _stopwordModels;
    private NiceTableWithToolbar _stoplistTableWithToolbar;
    private NiceTableWithToolbar _stopwordTableWithToolbar;
    private JButton _stoplistRemoveBtn;
    private JButton _stoplistAddBtn;
    private JButton _stopwordRemoveBtn;
    private JButton _stopwordAddBtn;
    private static Icon _removeIcon;
    private static Icon _addIcon;
    private ComponentWithTitlebar<JComponent> StoplistComponentWithTitlebar;
    private ComponentWithTitlebar<JComponent> StopwordComponentWithTitlebar;
    private JSplitPane jSplitPane;
    private JPanel jStoplistPanel;
    private JPanel jStopwordPanel;
    private String[] _stoplistColumnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
    private int[] _stoplistColumnWidths = new int[]{180, 100};
    private static final int STOPLIST_NAME = 0;
    private static final int STOPLIST_LANGUAGE = 1;
    private static final int STOPLIST_COLUMN_COUNT = 2;
    private String[] _stopwordColumnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_TYPE"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
    private int[] _stopwordColumnWidths = new int[]{180, 100, 100};
    private static final int STOPWORD_NAME = 0;
    private static final int STOPWORD_TYPE = 1;
    private static final int STOPWORD_LANGUAGE = 2;
    private static final int STOPWORD_COLUMN_COUNT = 3;

    public StoplistPanel(PropertyModel propertyModel, JPanel jPanel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for BuildTextNode node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._parent = jPanel;
        this._isReadOnly = !(propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel);
        TextNodeType textNodeType = (TextNodeType)this._data.getData();
        this.init(textNodeType, propertyModel);
    }

    public StoplistPanel(Context context, AbstractTextNode abstractTextNode, TextNodeType textNodeType, JPanel jPanel) {
        super(context, abstractTextNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractTextNode != null) : "BuildTextNode node must not be null.";
        assert (abstractTextNode instanceof AbstractTextNode) : "Must be an instance of AbstractTextNode node.";
        this._parent = jPanel;
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this.init(textNodeType, null);
    }

    public StoplistPanel(Context context, BuildTextNodeRefType buildTextNodeRefType, JPanel jPanel) {
        super(context, null);
        assert (context != null) : "Context must not be null.";
        assert (buildTextNodeRefType != null) : "BuildTextNodeRefType must not be null.";
        this._parent = jPanel;
        this._isReadOnly = true;
        this.init((TextNodeType)buildTextNodeRefType, null);
    }

    private TextNodeType.Stoplists FilterStoplists(TextNodeType.Stoplists stoplists) {
        TextNodeType.Stoplists stoplists2 = new TextNodeType.Stoplists();
        for (StoplistType stoplistType : stoplists.getStoplist()) {
            if (stoplistType.getName().equals("Default") && stoplistType.getType().equals("Basic")) continue;
            stoplists2.getStoplist().add((StoplistType)MetaDataHelper.copyMetadataObject(stoplistType));
        }
        return stoplists2;
    }

    private void init(TextNodeType textNodeType, PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this._textNodeType = textNodeType;
        this._dirty = false;
        this._existStoplists = new TextNodeType.Stoplists();
        for (StoplistType stoplistType : textNodeType.getStoplists().getStoplist()) {
            this._existStoplists.getStoplist().add((StoplistType)MetaDataHelper.copyMetadataObject(stoplistType));
        }
        this._filterStoplists = this.FilterStoplists(textNodeType.getStoplists());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        Class<PIComponentPanel> clazz = PIComponentPanel.class;
        _removeIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_REMOVE_ICON"));
        _addIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_ICON"));
    }

    @Override
    public void initUI() {
        Object object;
        this._isAdjusting = true;
        HelpUtils.setHelpID((JComponent)this, (String)"stoplist");
        this._stoplistModels = new StoplistTableModel(this._isReadOnly);
        ControlBar controlBar = new ControlBar();
        if (!this._isReadOnly) {
            this.installStoplistItemFilterActions(controlBar);
        }
        this._stoplistTableWithToolbar = new NiceTableWithToolbar(this.StoplistComponentWithTitlebar, controlBar, this._stoplistColumnNames, this._stoplistModels);
        this._stoplistTableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("STOPLIST_STOPLIST_TABLE_TITLE")));
        this._stoplistTableWithToolbar.getNiceTable().setAutoResizeMode(0);
        this._stoplistTableWithToolbar.getNiceTable().setSelectionMode(2);
        this._stoplistTableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._stoplistTableWithToolbar.getNiceTable().setShowToolTips(true);
        this._stoplistTableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._stoplistTableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        this._stoplistTableWithToolbar.getNiceTable().setSortColumn(0, true);
        if (!this._isReadOnly) {
            TableColumn tableColumn = this._stoplistTableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
            object = new DBObjectNameEditor();
            tableColumn.setCellEditor((TableCellEditor)object);
        }
        int n = 0;
        for (int n2 : this._stoplistColumnWidths) {
            this._stoplistTableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._stoplistTableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                StoplistPanel.this.enableControls();
                int[] nArray = StoplistPanel.this._stoplistTableWithToolbar.getNiceTable().getSelectedRowsInModel();
                if (nArray.length == 1) {
                    StoplistType stoplistType = (StoplistType)StoplistPanel.this._filterStoplists.getStoplist().get(nArray[0]);
                    StoplistPanel.this._stopwordModels = new StopwordTableModel(stoplistType.getStopTokens(), StoplistPanel.this._isReadOnly);
                    StoplistPanel.this._stopwordTableWithToolbar.resetNiceTableModel(StoplistPanel.this._stopwordModels);
                } else {
                    StoplistPanel.this._stopwordModels = new StopwordTableModel(null, StoplistPanel.this._isReadOnly);
                    StoplistPanel.this._stopwordTableWithToolbar.resetNiceTableModel(StoplistPanel.this._stopwordModels);
                }
            }
        });
        this._stopwordModels = new StopwordTableModel(null, this._isReadOnly);
        controlBar = new ControlBar();
        if (!this._isReadOnly) {
            this.installStopwordItemFilterActions(controlBar);
        }
        this._stopwordTableWithToolbar = new NiceTableWithToolbar(this.StopwordComponentWithTitlebar, controlBar, this._stopwordColumnNames, this._stopwordModels);
        this._stopwordTableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("STOPLIST_STOPWORD_TABLE_TITLE")));
        this._stopwordTableWithToolbar.getNiceTable().setAutoResizeMode(0);
        this._stopwordTableWithToolbar.getNiceTable().setSelectionMode(2);
        this._stopwordTableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._stopwordTableWithToolbar.getNiceTable().setShowToolTips(true);
        this._stopwordTableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._stopwordTableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        this._stopwordTableWithToolbar.getNiceTable().setSortColumn(0, true);
        if (!this._isReadOnly) {
            object = this._stopwordTableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
            StopwordEditor stopwordEditor = new StopwordEditor();
            stopwordEditor.setDocument(new TextFieldLimit(4000));
            ((TableColumn)object).setCellEditor(stopwordEditor);
        }
        n = 0;
        for (int n2 : this._stopwordColumnWidths) {
            this._stopwordTableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._stopwordTableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                StoplistPanel.this.enableControls();
            }
        });
        this._isAdjusting = false;
        this.enableControls();
    }

    private void processAddStoplist() {
        StoplistWizard stoplistWizard = new StoplistWizard();
        BuildTextNode buildTextNode = (BuildTextNode)this._data;
        if (stoplistWizard.runWizard(this, this._propertyModel, this._context, buildTextNode, null)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractTextNode.getStoplistNextId(this._existStoplists) + "";
            stoplistType.setId(string);
            this._filterStoplists.getStoplist().add(stoplistType);
            this._stoplistModels = new StoplistTableModel(this._isReadOnly);
            this._stoplistTableWithToolbar.resetNiceTableModel(this._stoplistModels);
            this._dirty = true;
            this.enableControls();
        }
    }

    private void installStoplistItemFilterActions(ControlBar controlBar) {
        this._stoplistRemoveBtn = new JButton(_removeIcon);
        this._stoplistRemoveBtn.setToolTipText(DialogsLrb.get("STOPLIST_DELETE_STOPLIST_TOOLTIP"));
        this._stoplistRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistPanel.this._stoplistTableWithToolbar.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    StoplistPanel.this._stoplistModels.removeSelectedRows(nArray);
                    StoplistPanel.this._stoplistTableWithToolbar.resetNiceTableModel(StoplistPanel.this._stoplistModels);
                    StoplistPanel.this.enableControls();
                }
            }
        });
        controlBar.add((Component)this._stoplistRemoveBtn);
        this._stoplistAddBtn = new JButton(_addIcon);
        this._stoplistAddBtn.setToolTipText(DialogsLrb.get("STOPLIST_ADD_STOPLIST_TOOLTIP"));
        this._stoplistAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistPanel.this.processAddStoplist();
            }
        });
        controlBar.add((Component)this._stoplistAddBtn);
    }

    private void processAddStopwords() {
        AddStopwordsPanel addStopwordsPanel;
        AddStopwordsDialog addStopwordsDialog = new AddStopwordsDialog();
        int[] nArray = this._stoplistTableWithToolbar.getSelectedRowsInModel();
        int n = nArray[0];
        StoplistType stoplistType = (StoplistType)this._filterStoplists.getStoplist().get(n);
        if (addStopwordsDialog.invoke(this._context, null, this, stoplistType) && (addStopwordsPanel = addStopwordsDialog.getPanel()).isDirty()) {
            stoplistType = addStopwordsPanel.getStoplist();
            this._filterStoplists.getStoplist().set(n, stoplistType);
            this._stopwordModels = new StopwordTableModel(stoplistType.getStopTokens(), this._isReadOnly);
            this._stopwordTableWithToolbar.resetNiceTableModel(this._stopwordModels);
            this._dirty = true;
            this.enableControls();
        }
    }

    private void installStopwordItemFilterActions(ControlBar controlBar) {
        this._stopwordRemoveBtn = new JButton(_removeIcon);
        this._stopwordRemoveBtn.setToolTipText(DialogsLrb.get("STOPLIST_DELETE_STOPWORD_TOOLTIP"));
        this._stopwordRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistPanel.this._stopwordTableWithToolbar.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    StoplistPanel.this._stopwordModels.removeSelectedRows(nArray);
                    StoplistPanel.this._stopwordTableWithToolbar.resetNiceTableModel(StoplistPanel.this._stopwordModels);
                }
            }
        });
        controlBar.add((Component)this._stopwordRemoveBtn);
        this._stopwordAddBtn = new JButton(_addIcon);
        this._stopwordAddBtn.setToolTipText(DialogsLrb.get("STOPLIST_ADD_STOPWORD_TOOLTIP"));
        this._stopwordAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistPanel.this.processAddStopwords();
            }
        });
        controlBar.add((Component)this._stopwordAddBtn);
    }

    private void enableControls() {
        if (!this._isReadOnly) {
            int[] nArray = this._stoplistTableWithToolbar.getSelectedRowsInModel();
            this._stoplistRemoveBtn.setEnabled(nArray.length > 0);
            this._stoplistAddBtn.setEnabled(true);
            this._stopwordAddBtn.setEnabled(nArray.length == 1);
            nArray = this._stopwordTableWithToolbar.getSelectedRowsInModel();
            this._stopwordRemoveBtn.setEnabled(nArray.length > 0);
        }
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        Context context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private AbstractTextNode getTargetNode(PropertyModel propertyModel) {
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel;
        if (propertyModel == null) {
            return null;
        }
        Context context = null;
        if (propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel) {
            workflowNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
            context = workflowNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowApplyTextNodePropertyProxyModel) {
            workflowNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
            context = workflowNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowTextNodePropertyProxyModel) {
            workflowNodePropertyProxyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
            context = workflowNodePropertyProxyModel.getSelectionContext();
        }
        workflowNodePropertyProxyModel = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)workflowNodePropertyProxyModel[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof TextNodeType) {
            return (AbstractTextNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        HashMap<String, Boolean> hashMap;
        Object object2;
        BuildTextNode buildTextNode = (BuildTextNode)this.getData();
        for (Object object2 : this._existStoplists.getStoplist()) {
            if (!object2.getName().equals("Default") || !object2.getType().equals("Basic")) continue;
            this._filterStoplists.getStoplist().add(0, object2);
        }
        if (this.isPIMode()) {
            hashMap = new ArrayList();
            object2 = new ComplexProperty("editStoplists", this._filterStoplists);
            ((ComplexProperty)object2).setOldData(this._existStoplists);
            hashMap.add(new Property(String.valueOf(BuildTextNodePropertyModel.RowIndex.EDIT_STOPLISTS), null, object2, null, null));
            ((WorkflowBuildTextNodePropertyProxyModel)this._propertyModel).setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_EDIT_STOPLIST"), buildTextNode, (List<Property>)((Object)hashMap));
        } else {
            Object object32;
            this._textNodeType.setStoplists(this._filterStoplists);
            hashMap = new HashMap<String, Boolean>();
            for (Object object32 : this._filterStoplists.getStoplist()) {
                hashMap.put(object32.getId(), Boolean.TRUE);
            }
            object2 = this._textNodeType.getTransformedAttributes();
            if (object2 != null && (object32 = object2.getMapTextTransformedSource()) != null && !object32.isEmpty()) {
                Iterator iterator = object32.iterator();
                while (iterator.hasNext()) {
                    String string;
                    MapTextTransformedSourceType mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                    TransformationTokenType transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getToken();
                    if (transformationTokenType == null) {
                        transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getTheme();
                    }
                    if ((string = transformationTokenType.getToken().getStoplistId()) == null || hashMap.containsKey(string)) continue;
                    transformationTokenType.getToken().setStoplistId(null);
                }
            }
        }
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public boolean doWork() {
        boolean bl = true;
        if (this._dirty && !this._isReadOnly) {
            this.updateNode();
        }
        return bl;
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jStoplistPanel = new JPanel();
        this.StoplistComponentWithTitlebar = new ComponentWithTitlebar();
        this.jStopwordPanel = new JPanel();
        this.StopwordComponentWithTitlebar = new ComponentWithTitlebar();
        this.jSplitPane.setDividerLocation(215);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.5);
        GroupLayout groupLayout = new GroupLayout(this.jStoplistPanel);
        this.jStoplistPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.StoplistComponentWithTitlebar, -1, 483, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.StoplistComponentWithTitlebar, -1, 192, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setTopComponent(this.jStoplistPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jStopwordPanel);
        this.jStopwordPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.StopwordComponentWithTitlebar, -1, 483, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.StopwordComponentWithTitlebar, -1, 188, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setRightComponent(this.jStopwordPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 505, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 431, Short.MAX_VALUE));
    }

    public TextNodeType.Stoplists getStoplists() {
        return this._filterStoplists;
    }

    private class StopwordEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextField _textField = new JTextField();

        public StopwordEditor() {
            this._textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StopwordEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                this._textField.setText(string);
            } else if (object == null) {
                this._textField.setText("");
            }
            return this._textField;
        }

        @Override
        public Object getCellEditorValue() {
            return this._textField.getText();
        }

        public void setDocument(Document document) {
            this._textField.setDocument(document);
        }
    }

    private class StopwordTableModel
    extends GenericBaseTableModel {
        private StoplistType.StopTokens _tokens;
        private boolean _readOnly = false;

        public StopwordTableModel(StoplistType.StopTokens stopTokens) {
            this._tokens = stopTokens;
            this.setColumnIdentifiers(StoplistPanel.this._stopwordColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public StopwordTableModel(StoplistType.StopTokens stopTokens, boolean bl) {
            this._tokens = stopTokens;
            this.setColumnIdentifiers(StoplistPanel.this._stopwordColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
            this._readOnly = bl;
        }

        public int getRowCount() {
            return this._tokens == null ? 0 : this._tokens.getToken().size();
        }

        public boolean isCellEditable(int n, int n2) {
            if (this._readOnly) {
                return false;
            }
            return n2 == 0;
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<StoplistType.StopTokens.Token> vector = new Vector<StoplistType.StopTokens.Token>();
            StoplistType.StopTokens.Token token = null;
            for (int i = 0; i < nArray.length; ++i) {
                token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(nArray[i]);
                vector.add(token);
            }
            this._tokens.getToken().removeAll(vector);
            this.setRowCount(this._tokens.getToken().size());
            StoplistPanel.this._dirty = true;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._tokens == null || this._tokens.getToken().size() == 0) {
                return null;
            }
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = token.getItem();
                    break;
                }
                case 1: {
                    string = ServerConstants.StopTokenType.toHuman(token.getType());
                    break;
                }
                case 2: {
                    string = ServerConstants.StoplistLanguage.toHuman(token.getLanguage());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(n);
            switch (n2) {
                case 0: {
                    String string = null;
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (!this.validateStopwords(n, string, token.getLanguage(), this._tokens.getToken())) {
                        return;
                    }
                    StoplistPanel.this._dirty = true;
                    token.setItem((String)object);
                    token.setType(ServerConstants.StopTokenType.toSchema(this.getType((String)object)));
                    StoplistPanel.this._dirty = true;
                }
            }
        }

        private String getType(String string) {
            return string.indexOf(32) == -1 ? "Word" : "Theme";
        }

        private boolean validateStopwords(int n, String string, String string2, List<StoplistType.StopTokens.Token> list) {
            boolean bl = true;
            int n2 = 0;
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_STOPWORD_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            for (StoplistType.StopTokens.Token token : list) {
                String string3 = string.trim() + this.getType(string.trim()) + string2;
                String string4 = token.getItem() + token.getType() + token.getLanguage();
                if (n != n2 && string3.compareTo(string4) == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPWORD"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
                ++n2;
            }
            return bl;
        }

        public StoplistType.StopTokens getTokens() {
            return this._tokens;
        }
    }

    private class StoplistTableModel
    extends GenericBaseTableModel {
        private boolean _readOnly = false;

        public StoplistTableModel() {
            this.setColumnIdentifiers(StoplistPanel.this._stoplistColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
        }

        public StoplistTableModel(boolean bl) {
            this.setColumnIdentifiers(StoplistPanel.this._stoplistColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
            this._readOnly = bl;
        }

        public int getRowCount() {
            return StoplistPanel.this._filterStoplists.getStoplist().size();
        }

        public boolean isCellEditable(int n, int n2) {
            if (this._readOnly) {
                return false;
            }
            return n2 == 0;
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<StoplistType> vector = new Vector<StoplistType>();
            StoplistType stoplistType = null;
            for (int i = 0; i < nArray.length; ++i) {
                stoplistType = (StoplistType)StoplistPanel.this._filterStoplists.getStoplist().get(nArray[i]);
                vector.add(stoplistType);
            }
            StoplistPanel.this._filterStoplists.getStoplist().removeAll(vector);
            this.setRowCount(StoplistPanel.this._filterStoplists.getStoplist().size());
            StoplistPanel.this._dirty = true;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (StoplistPanel.this._filterStoplists.getStoplist().size() == 0) {
                return "Loading...";
            }
            StoplistType stoplistType = (StoplistType)StoplistPanel.this._filterStoplists.getStoplist().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = stoplistType.getName();
                    break;
                }
                case 1: {
                    String string2 = stoplistType.getType();
                    if (string2.equals("Basic")) {
                        string = ServerConstants.StoplistLanguage.toHuman(stoplistType.getLanguage());
                        break;
                    }
                    string = ServerConstants.StoplistLanguage.toHuman("Multi");
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            StoplistType stoplistType = (StoplistType)StoplistPanel.this._filterStoplists.getStoplist().get(n);
            switch (n2) {
                case 0: {
                    String string = null;
                    String string2 = stoplistType.getName();
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                        string2 = StringUtils.addDoubleQuotes(string2);
                    }
                    if (string.length() != 0 && !StringUtils.isDoubleQuotedString(string)) {
                        string = string.toUpperCase();
                    }
                    if (!this.validateStoplistName(n, string, StoplistPanel.this._filterStoplists.getStoplist())) {
                        return;
                    }
                    if (string2 != null && string2.compareTo(string) == 0) {
                        return;
                    }
                    string = StringUtils.trimDoubleQuotes(string);
                    stoplistType.setName(string);
                    StoplistPanel.this._dirty = true;
                }
            }
        }

        private boolean validateStoplistName(int n, String string, List<StoplistType> list) {
            boolean bl = true;
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (!this.isNameUnique(n, string, list)) {
                return false;
            }
            if (!AttributeNameValidator.isNameLengthValidInDB(StoplistPanel.this._context, string, false)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            return bl;
        }

        private boolean isNameUnique(int n, String string, List<StoplistType> list) {
            int n2 = 0;
            if (list == null) {
                return true;
            }
            for (StoplistType stoplistType : list) {
                if (n != n2 && stoplistType.getName().compareTo(string) == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPLIST"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

