/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.applyText.ApplyTextPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.text.TextPanel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class BuildTextOutputPanel
extends JPanel {
    private Context _context;
    private AbstractDialogPanel _parent;
    private AbstractTextNode _node;
    private StoplistType _stoplist;
    private List<AbstractTextNode.Statistics> _data;
    private TextNodeType _textNodeType;
    private TreeMap<String, Boolean> _allTokens = new TreeMap();
    private TextTransformationOutputAttributeType _outputAttribute = null;
    private AttrsTableModel _models;
    private NiceTableWithToolbar _tableWithToolbar;
    private JButton _addBtn;
    private boolean _isReadOnly;
    private boolean _dirty;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private String[] _columnNames = new String[]{DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"), DialogsLrb.get("BUILDTEXT_COLUMN_FREQUENCY")};
    private int[] _columnWidths = new int[]{250, 150};
    private static final int ATTRIBUTE = 0;
    private static final int FREQUENCY = 1;
    private static final int COLUMN_COUNT = 2;

    public BuildTextOutputPanel(Context context, AbstractTextNode abstractTextNode, TextNodeType textNodeType) {
        this._context = context;
        this._node = abstractTextNode;
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this._dirty = false;
        this._textNodeType = textNodeType;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initUI() {
        ControlBar controlBar = new ControlBar();
        if (!this._isReadOnly) {
            this.installItemFilterActions(controlBar);
        }
        this._models = new AttrsTableModel(null);
        this._tableWithToolbar = new NiceTableWithToolbar(this.componentWithTitlebar1, controlBar, this._columnNames, this._models);
        this._tableWithToolbar.getNiceTable().setAutoResizeMode(4);
        this._tableWithToolbar.getNiceTable().setSelectionMode(2);
        this._tableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._tableWithToolbar.getNiceTable().setShowToolTips(true);
        this._tableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._tableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        this._tableWithToolbar.getNiceTable().setSortColumn(1, false);
        int n = 0;
        for (int n2 : this._columnWidths) {
            this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                BuildTextOutputPanel.this.enableControls();
            }
        });
        LoadUI loadUI = new LoadUI(this._outputAttribute);
        loadUI.start();
    }

    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("BUILDTEXT_STOPLIST"), this.jLabel1);
        UIResourceHelper.setComponentText(hashMap);
    }

    public synchronized void refreshUI(AbstractDialogPanel abstractDialogPanel, TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
        this._parent = abstractDialogPanel;
        if (this._outputAttribute != null && this._outputAttribute.equals(textTransformationOutputAttributeType)) {
            return;
        }
        this._outputAttribute = textTransformationOutputAttributeType;
        LoadUI loadUI = new LoadUI(this._outputAttribute);
        loadUI.start();
    }

    private void enableControls() {
        if (!this._isReadOnly) {
            int n = this._tableWithToolbar.getNiceTable().getSelectedRowCount();
            boolean bl = false;
            if (this._stoplist != null) {
                bl = this._stoplist.getName().equals("Default");
            }
            this._addBtn.setEnabled(n > 0 && this._stoplist != null && !bl);
        }
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._addBtn = new JButton(DialogsLrb.get("BUILDTEXT_ADD_TO_STOP_LIST"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = BuildTextOutputPanel.this._tableWithToolbar.getNiceTable().getSelectedRowsInModel();
                boolean bl = false;
                for (int n : nArray) {
                    AbstractTextNode.Statistics statistics = (AbstractTextNode.Statistics)BuildTextOutputPanel.this._data.get(n);
                    String string = BuildTextOutputPanel.this._stoplist.getLanguage();
                    String string2 = statistics.getToken();
                    String string3 = string + ":" + string2;
                    if (BuildTextOutputPanel.this._allTokens.containsKey(string3)) continue;
                    StoplistType.StopTokens.Token token = new StoplistType.StopTokens.Token();
                    token.setItem(string2);
                    token.setLanguage(string);
                    token.setType(string2.indexOf(32) == -1 ? "Word" : "Theme");
                    BuildTextOutputPanel.this._stoplist.getStopTokens().getToken().add(token);
                    BuildTextOutputPanel.this._allTokens.put(string3, true);
                    bl = true;
                    BuildTextOutputPanel.this._dirty = true;
                }
                if (bl) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("BUILDTEXT_TOKENS_ADDED_TO_STOP_LIST"), (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null);
                } else {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("BUILDTEXT_TOKENS_EXIST_IN_STOP_LIST"), (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null);
                }
            }
        });
        controlBar.add((Component)this._addBtn);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.componentWithTitlebar1 = new ComponentWithTitlebar();
        this.setPreferredSize(new Dimension(620, 230));
        this.jLabel1.setText("Stoplist:");
        this.jLabel2.setText("English");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.componentWithTitlebar1, -1, 600, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 283, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.componentWithTitlebar1, -1, 188, Short.MAX_VALUE).addContainerGap()));
    }

    private class AttrsTableModel
    extends GenericBaseTableModel {
        private List<AbstractTextNode.Statistics> _data = null;

        public AttrsTableModel(List<AbstractTextNode.Statistics> list) {
            this._data = list;
            this.setColumnIdentifiers(BuildTextOutputPanel.this._columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 1) {
                return Integer.class;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._data == null || this._data.size() == 0) {
                return null;
            }
            AbstractTextNode.Statistics statistics = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = statistics.getToken();
                    break;
                }
                case 1: {
                    object = statistics.getValue();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private class LoadUI
    extends SwingWorker {
        private TextTransformationOutputAttributeType _outputAttribute;
        private String _sourceColumnName;
        private String _stoplistName;
        private Exception _ex = null;
        private boolean _success = false;

        public LoadUI(TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
            BuildTextOutputPanel.this._data = null;
            this._outputAttribute = textTransformationOutputAttributeType;
            this._stoplistName = DialogsLrb.get("BUILDTEXT_STOPLIST_NONE");
            this._sourceColumnName = null;
            BuildTextOutputPanel.this._stoplist = null;
            BuildTextOutputPanel.this._allTokens.clear();
        }

        public Object construct() {
            block17: {
                BuildTextOutputPanel.this._data = new ArrayList();
                try {
                    if (this._outputAttribute != null) {
                        TransformationTokenType transformationTokenType = this._outputAttribute.getTransformationElement().getToken();
                        TextTransformationType.Theme theme = this._outputAttribute.getTransformationElement().getTheme();
                        String string = null;
                        boolean bl = false;
                        if (transformationTokenType != null) {
                            string = transformationTokenType.getToken().getStoplistId();
                            bl = transformationTokenType.getToken().getStatisticTable().getCreationDate() != null;
                        } else if (theme != null) {
                            string = theme.getToken().getStoplistId();
                            boolean bl2 = bl = theme.getToken().getStatisticTable().getCreationDate() != null;
                        }
                        if (string != null) {
                            StoplistType stoplistType = null;
                            stoplistType = AbstractTextNode.findStoplistWithIdUsingInputType(string, BuildTextOutputPanel.this._textNodeType.getStoplists());
                            if (stoplistType != null) {
                                BuildTextOutputPanel.this._stoplist = stoplistType;
                                this._stoplistName = BuildTextOutputPanel.this._stoplist.getName() + " - " + ServerConstants.StoplistLanguage.toHuman(BuildTextOutputPanel.this._stoplist.getLanguage());
                                for (StoplistType.StopTokens.Token token : BuildTextOutputPanel.this._stoplist.getStopTokens().getToken()) {
                                    String string2 = token.getItem();
                                    String string3 = token.getLanguage();
                                    string2 = string3 + ":" + string2;
                                    BuildTextOutputPanel.this._allTokens.put(string2, true);
                                }
                            }
                        }
                        if (bl) {
                            BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_LOADING"), null));
                            BuildTextOutputPanel.this._models = new AttrsTableModel(BuildTextOutputPanel.this._data);
                            BuildTextOutputPanel.this._tableWithToolbar.resetNiceTableModel(BuildTextOutputPanel.this._models);
                            try {
                                BuildTextOutputPanel.this._data = BuildTextNode.loadStatistics(BuildTextOutputPanel.this._context, this._outputAttribute);
                            }
                            catch (Exception exception) {
                                BuildTextOutputPanel.this._data.clear();
                                BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_TABLE_NO_DATA"), null));
                            }
                            if (BuildTextOutputPanel.this._data.isEmpty()) {
                                if (theme != null) {
                                    BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_NO_THEME_GENERATED"), null));
                                } else {
                                    BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_NO_TOKEN_GENERATED"), null));
                                }
                            }
                        } else {
                            BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_TABLE_NO_DATA"), null));
                        }
                        this._sourceColumnName = this._outputAttribute.getName();
                    } else {
                        BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NOT_XFORMED_COLUMN"), null));
                    }
                    this._success = true;
                }
                catch (Exception exception) {
                    this._ex = exception;
                    this._success = false;
                    if (BuildTextOutputPanel.this._data == null) break block17;
                    BuildTextOutputPanel.this._data.clear();
                    BuildTextOutputPanel.this._data.add(new AbstractTextNode.Statistics(DialogsLrb.get("BUILDTEXT_NODE_TABLE_LOAD_FAILED"), null));
                }
            }
            return BuildTextOutputPanel.this._data;
        }

        public void finished() {
            Object object;
            Object object2;
            if (BuildTextOutputPanel.this._parent != null) {
                if (BuildTextOutputPanel.this._parent instanceof BuildTextPanel && (object2 = ((BuildTextPanel)(object = (BuildTextPanel)BuildTextOutputPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !object2.getName().equals(this._outputAttribute.getName())) {
                    return;
                }
                if (BuildTextOutputPanel.this._parent instanceof ApplyTextPanel && (object2 = ((ApplyTextPanel)(object = (ApplyTextPanel)BuildTextOutputPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !object2.getName().equals(this._outputAttribute.getName())) {
                    return;
                }
                if (BuildTextOutputPanel.this._parent instanceof TextPanel && (object2 = ((TextPanel)(object = (TextPanel)BuildTextOutputPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !object2.getName().equals(this._outputAttribute.getName())) {
                    return;
                }
            }
            if (this._success && this._ex == null) {
                BuildTextOutputPanel.this._tableWithToolbar.getCompToolbar().setLabel(this._sourceColumnName != null ? new JLabel(this._sourceColumnName) : null);
                BuildTextOutputPanel.this._tableWithToolbar.getCompToolbar().repaint();
                BuildTextOutputPanel.this.jLabel2.setText(this._stoplistName);
                object = (List)this.getValue();
                if (object != null) {
                    BuildTextOutputPanel.this._models = new AttrsTableModel((List<AbstractTextNode.Statistics>)object);
                } else {
                    BuildTextOutputPanel.this._models = new AttrsTableModel(null);
                }
                BuildTextOutputPanel.this._tableWithToolbar.resetNiceTableModel(BuildTextOutputPanel.this._models);
                BuildTextOutputPanel.this._tableWithToolbar.getNiceTable().setSortColumn(1, false);
            } else {
                boolean bl = false;
                if (this._ex instanceof SQLException && ((SQLException)this._ex).getErrorCode() == 942) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("BUILDTEXT_NODE_MISSING_TABLE"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    bl = true;
                }
                if (!bl) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
                }
                if ((object2 = (List)this.getValue()) != null) {
                    BuildTextOutputPanel.this._models = new AttrsTableModel((List<AbstractTextNode.Statistics>)object2);
                } else {
                    BuildTextOutputPanel.this._models = new AttrsTableModel(null);
                }
                BuildTextOutputPanel.this._tableWithToolbar.resetNiceTableModel(BuildTextOutputPanel.this._models);
                BuildTextOutputPanel.this._tableWithToolbar.getNiceTable().setSortColumn(1, false);
            }
            BuildTextOutputPanel.this.enableControls();
        }
    }
}

