/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;

public class ModelSVOBuildSettingsPanel
extends AbstractPropertiesPanel {
    private JCheckBox jCheckBoxActiveLearning;
    private JCheckBox jCheckBoxComplexityFactors;
    private JCheckBox jCheckBoxOutlierRate;
    private JCheckBox jCheckBoxStdDev;
    private JComboBox jComboBoxKernerFunction;
    private JLabel jLabelCacheSize;
    private JLabel jLabelKernelFunction;
    private JLabel jLabelToleranceValue;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTextFieldCacheSize;
    private JTextField jTextFieldComplexityFactors;
    private JTextField jTextFieldOutlierRate;
    private JTextField jTextFieldStdDev;
    private JTextField jTextFieldToleranceValue;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private DefaultComboBoxModel _kernelFunctionsModel;
    private String _currentKernelFunctionName;
    private static final String CLIENT_SVM_LINEAR = AlgSettingsLrb.get("SVMS_LINEAR");
    private static final String CLIENT_SVM_GAUSSIAN = AlgSettingsLrb.get("SVMS_GAUSSIAN");
    private static final String CLIENT_SVMS_SYSTEM_DEFAULT = AlgSettingsLrb.get("SVMS_SYSTEM_DEFAULT");

    public ModelSVOBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPaneTitle = new JScrollPane();
        this.jLabelKernelFunction = new JLabel();
        this.jComboBoxKernerFunction = new JComboBox();
        this.jLabelToleranceValue = new JLabel();
        this.jTextFieldToleranceValue = new NumberTextField();
        this.jCheckBoxComplexityFactors = new JCheckBox();
        this.jTextFieldComplexityFactors = new NumberTextField();
        this.jCheckBoxOutlierRate = new JCheckBox();
        this.jTextFieldOutlierRate = new NumberTextField();
        this.jCheckBoxActiveLearning = new JCheckBox();
        this.jCheckBoxStdDev = new JCheckBox();
        this.jTextFieldStdDev = new NumberTextField();
        this.jLabelCacheSize = new JLabel();
        this.jTextFieldCacheSize = new NumberTextField();
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jLabelKernelFunction.setText("Kernel Function");
        this.jComboBoxKernerFunction.setModel(new DefaultComboBoxModel<String>(new String[]{CLIENT_SVMS_SYSTEM_DEFAULT, CLIENT_SVM_GAUSSIAN, CLIENT_SVM_LINEAR}));
        this.jComboBoxKernerFunction.setInheritsPopupMenu(true);
        this.jComboBoxKernerFunction.setMinimumSize(new Dimension(58, 18));
        this.jComboBoxKernerFunction.setOpaque(false);
        this.jComboBoxKernerFunction.setPreferredSize(new Dimension(62, 22));
        this.jLabelToleranceValue.setText("Tolerance Value:");
        this.jTextFieldToleranceValue.setToolTipText("Range: > 0 and <= 0.01");
        this.jCheckBoxComplexityFactors.setText("Specify the complexity factors");
        this.jCheckBoxComplexityFactors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxComplexityFactors.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldComplexityFactors.setText("1");
        this.jTextFieldComplexityFactors.setToolTipText("Range: > 0");
        this.jCheckBoxOutlierRate.setText("Specify the rate of outliers");
        this.jCheckBoxOutlierRate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxOutlierRate.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldOutlierRate.setToolTipText("Range: > 0");
        this.jTextFieldOutlierRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelSVOBuildSettingsPanel.this.jTextFieldOutlierRateActionPerformed(actionEvent);
            }
        });
        this.jCheckBoxActiveLearning.setText("Active Learning");
        this.jCheckBoxActiveLearning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxActiveLearning.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxStdDev.setText("Specify the standard deviation for gaussian kernel");
        this.jCheckBoxStdDev.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxStdDev.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldStdDev.setText("1");
        this.jTextFieldStdDev.setToolTipText("Range: > 0");
        this.jLabelCacheSize.setText("Cache Size:");
        this.jTextFieldCacheSize.setText("1");
        this.jTextFieldCacheSize.setToolTipText("Range: > 0");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneTitle, GroupLayout.Alignment.TRAILING, -1, 505, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelKernelFunction).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxComplexityFactors).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jTextFieldComplexityFactors, -2, 86, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelToleranceValue).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxKernerFunction, -2, 161, -2).addComponent(this.jTextFieldToleranceValue, -2, 95, -2))).addComponent(this.jCheckBoxOutlierRate).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jTextFieldOutlierRate, -2, 86, -2)).addComponent(this.jCheckBoxActiveLearning).addComponent(this.jCheckBoxStdDev).addComponent(this.jLabelCacheSize).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldCacheSize, -2, 87, -2).addComponent(this.jTextFieldStdDev, -2, 91, -2)))))).addGap(190, 190, 190))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelKernelFunction).addComponent(this.jComboBoxKernerFunction, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelToleranceValue).addComponent(this.jTextFieldToleranceValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxComplexityFactors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldComplexityFactors, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxOutlierRate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldOutlierRate, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxActiveLearning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxStdDev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldStdDev, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCacheSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCacheSize, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldOutlierRate.getAccessibleContext().setAccessibleDescription("Range: > 0 and < 1");
    }

    private void jTextFieldOutlierRateActionPerformed(ActionEvent actionEvent) {
    }

    private static String convertToServerKernelFunctionName(String string) {
        assert (string != null);
        if (0 == string.compareTo(CLIENT_SVM_GAUSSIAN)) {
            return "SVMS_GAUSSIAN";
        }
        if (0 == string.compareTo(CLIENT_SVM_LINEAR)) {
            return "SVMS_LINEAR";
        }
        return "SVMS_SYSTEM_DETERMINED";
    }

    private void initRes() {
        this.jLabelKernelFunction.setText(AlgSettingsLrb.get("MODEL_SETTINGS_KERNEL_FUNCTION"));
        this.jLabelToleranceValue.setText(AlgSettingsLrb.get("MODEL_SETTINGS_TOLERANCE_VALUE"));
        this.jCheckBoxComplexityFactors.setText(AlgSettingsLrb.get("MODEL_SETTINGS_COMPLEXITY_FACTOR"));
        this.jCheckBoxActiveLearning.setText(AlgSettingsLrb.get("MODEL_SETTINGS_ACTIVE_LEARNING"));
        this.jCheckBoxStdDev.setText(AlgSettingsLrb.get("MODEL_SETTINGS_CHK_BOX_STDEV"));
        this.jLabelCacheSize.setText(AlgSettingsLrb.get("MODEL_SETTINGS_CACHE_SIZE"));
        this.jCheckBoxOutlierRate.setText(AlgSettingsLrb.get("MODEL_SETTINGS_OUTLIERS_RATE"));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        this.setDataType(this.jTextFieldToleranceValue, Double.class);
        this.setDataType(this.jTextFieldComplexityFactors, Double.class);
        this.setDataType(this.jTextFieldOutlierRate, Double.class);
        this.setDataType(this.jTextFieldStdDev, Double.class);
        this.setDataType(this.jTextFieldCacheSize, Long.class);
        this.setSigned(this.jTextFieldToleranceValue, false);
        this.setSigned(this.jTextFieldComplexityFactors, false);
        this.setSigned(this.jTextFieldOutlierRate, false);
        this.setSigned(this.jTextFieldStdDev, false);
        this.setSigned(this.jTextFieldCacheSize, false);
        this.setLocale(this.jTextFieldToleranceValue, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextFieldComplexityFactors, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextFieldOutlierRate, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextFieldStdDev, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextFieldCacheSize, commonSettingDataObject.getLocale());
        this._kernelFunctionsModel = new DefaultComboBoxModel<String>(new String[]{CLIENT_SVMS_SYSTEM_DEFAULT, CLIENT_SVM_GAUSSIAN, CLIENT_SVM_LINEAR});
        this.jComboBoxKernerFunction.setModel(this._kernelFunctionsModel);
        String string = commonSettingDataObject.getModelSettingStringValue("SVMS_KERNEL_FUNCTION");
        if (string == null) {
            string = "SVMS_SYSTEM_DETERMINED";
        }
        this._currentKernelFunctionName = this.convertToClientKernelFunctionName(string);
        commonSettingDataObject.setBackupValue("SVMS_KERNEL_FUNCTION", ModelSVOBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName));
        this.jComboBoxKernerFunction.setSelectedItem(this._currentKernelFunctionName);
        this.jComboBoxKernerFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ModelSVOBuildSettingsPanel.this.jComboBoxKernerFunction.getSelectedItem();
                if (string.equals(ModelSVOBuildSettingsPanel.this._currentKernelFunctionName)) {
                    return;
                }
                ModelSVOBuildSettingsPanel.this._currentKernelFunctionName = string;
                ModelSVOBuildSettingsPanel.this.updatePanel();
            }
        });
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("SVMS_CONV_TOLERANCE");
        if (bigDecimal != null) {
            commonSettingDataObject.setBackupValue("SVMS_CONV_TOLERANCE", bigDecimal.doubleValue());
        } else {
            commonSettingDataObject.setBackupNullValue("SVMS_CONV_TOLERANCE");
        }
        this.setNumber(this.jTextFieldToleranceValue, bigDecimal);
        this.jTextFieldToleranceValue.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_TOOLTIP"));
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("SVMS_COMPLEXITY_FACTOR");
        if (bigDecimal2 == null || 0 == bigDecimal2.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxComplexityFactors.setSelected(false);
            this.jTextFieldComplexityFactors.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("SVMS_COMPLEXITY_FACTOR");
        } else {
            commonSettingDataObject.setBackupValue("SVMS_COMPLEXITY_FACTOR", bigDecimal2);
            this.jCheckBoxComplexityFactors.setSelected(true);
            this.setNumber(this.jTextFieldComplexityFactors, bigDecimal2);
            this.jTextFieldComplexityFactors.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxComplexityFactors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVOBuildSettingsPanel.this.jTextFieldComplexityFactors.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("SVMS_OUTLIER_RATE");
        if (bigDecimal3 == null || 0 == bigDecimal3.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxOutlierRate.setSelected(false);
            this.jTextFieldOutlierRate.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("SVMS_OUTLIER_RATE");
        } else {
            commonSettingDataObject.setBackupValue("SVMS_OUTLIER_RATE", bigDecimal3);
            this.jCheckBoxOutlierRate.setSelected(true);
            this.setNumber(this.jTextFieldOutlierRate, bigDecimal3);
            this.jTextFieldOutlierRate.setToolTipText(AlgSettingsLrb.get("SVMS_SVMS_OUTLIER_RATE_TOOLTIP"));
        }
        this.jCheckBoxOutlierRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVOBuildSettingsPanel.this.jTextFieldOutlierRate.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        String string2 = commonSettingDataObject.getModelSettingStringValue("SVMS_ACTIVE_LEARNING");
        string2 = string2 != null ? string2 : "SVMS_AL_DISABLE";
        commonSettingDataObject.setBackupValue("SVMS_ACTIVE_LEARNING", string2);
        this.jCheckBoxActiveLearning.setSelected(string2.equals("SVMS_AL_ENABLE"));
        BigDecimal bigDecimal4 = commonSettingDataObject.getModelSettingNumValue("SVMS_STD_DEV");
        if (bigDecimal4 == null || 0 == bigDecimal4.compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("SVMS_STD_DEV");
            this.jCheckBoxStdDev.setSelected(false);
            this.jTextFieldStdDev.setEnabled(false);
        } else {
            commonSettingDataObject.setBackupValue("SVMS_STD_DEV", bigDecimal4);
            this.jCheckBoxStdDev.setSelected(true);
            this.setNumber(this.jTextFieldStdDev, bigDecimal4);
            this.jTextFieldStdDev.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxStdDev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVOBuildSettingsPanel.this.jTextFieldStdDev.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        Number number = commonSettingDataObject.getModelSettingNumValue("SVMS_KERNEL_CACHE_SIZE");
        if (null == number || ((Number)number).longValue() == 0L) {
            number = ServerConstants.SVMSettings.SVMS_KERNEL_CACHE_SIZE_DEFAULT;
        }
        commonSettingDataObject.setBackupValue("SVMS_KERNEL_CACHE_SIZE", number);
        this.setNumber(this.jTextFieldCacheSize, number);
        this.jTextFieldCacheSize.setToolTipText(AlgSettingsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        this.updatePanel();
    }

    private String convertToClientKernelFunctionName(String string) {
        if (string != null) {
            if (0 == string.compareTo("SVMS_GAUSSIAN")) {
                return CLIENT_SVM_GAUSSIAN;
            }
            if (0 == string.compareTo("SVMS_LINEAR")) {
                return CLIENT_SVM_LINEAR;
            }
        }
        return CLIENT_SVMS_SYSTEM_DEFAULT;
    }

    private void updatePanel() {
        boolean bl = this.isGaussian();
        this.jCheckBoxStdDev.setVisible(bl);
        this.jTextFieldStdDev.setVisible(bl);
        this.jLabelCacheSize.setVisible(bl);
        this.jTextFieldCacheSize.setVisible(bl);
        this.repaint();
    }

    private boolean isGaussian() {
        boolean bl = false;
        if (this._currentKernelFunctionName != null) {
            bl = this._currentKernelFunctionName.equals(CLIENT_SVM_GAUSSIAN);
        }
        return bl;
    }

    @Override
    public void processInput() {
        Number number;
        Number number2;
        CommonSettingDataObject commonSettingDataObject = this.getState();
        commonSettingDataObject.setCommonPerformanceOption();
        commonSettingDataObject.setValue("SVMS_KERNEL_FUNCTION", ModelSVOBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName));
        Number number3 = this.getNumber(this.jTextFieldToleranceValue);
        if (null == number3 || number3.doubleValue() <= 0.0 || number3.doubleValue() > 0.01) {
            commonSettingDataObject.setValidationError(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_OUT_OF_RANGE"));
            return;
        }
        commonSettingDataObject.setValue("SVMS_CONV_TOLERANCE", new Double(number3.toString()));
        if (this.jCheckBoxComplexityFactors.isSelected()) {
            number2 = this.getNumber(this.jTextFieldComplexityFactors);
            if (null == number2 || number2.doubleValue() <= 0.0) {
                commonSettingDataObject.setValidationError(AlgSettingsLrb.get("SVMS_COMPLEXITY_FACTOR_NULL"));
                return;
            }
            commonSettingDataObject.setValue("SVMS_COMPLEXITY_FACTOR", number2);
        } else {
            commonSettingDataObject.setNullValue("SVMS_COMPLEXITY_FACTOR");
        }
        if (this.jCheckBoxOutlierRate.isSelected()) {
            number2 = this.getNumber(this.jTextFieldOutlierRate);
            if (null == number2 || !(number2.doubleValue() > 0.0) || !(number2.doubleValue() < 1.0)) {
                commonSettingDataObject.setValidationError(AlgSettingsLrb.get("SVMS_SVMS_OUTLIER_RATE_OUT_OF_RANGE"));
                return;
            }
            commonSettingDataObject.setValue("SVMS_OUTLIER_RATE", number2);
        } else {
            commonSettingDataObject.setNullValue("SVMS_OUTLIER_RATE");
        }
        commonSettingDataObject.setValue("SVMS_ACTIVE_LEARNING", this.jCheckBoxActiveLearning.isSelected() ? "SVMS_AL_ENABLE" : "SVMS_AL_DISABLE");
        boolean bl = this.isGaussian();
        if (!bl) {
            commonSettingDataObject.removeValue("SVMS_STD_DEV");
            commonSettingDataObject.removeValue("SVMS_KERNEL_CACHE_SIZE");
            return;
        }
        if (this.jCheckBoxStdDev.isSelected()) {
            number = this.getNumber(this.jTextFieldStdDev);
            if (null == number || number.doubleValue() <= 0.0) {
                commonSettingDataObject.setValidationError(AlgSettingsLrb.get("SVMS_COMPLEXITY_STD_DEV_NULL"));
                return;
            }
            commonSettingDataObject.setValue("SVMS_STD_DEV", number);
        } else {
            commonSettingDataObject.setNullValue("SVMS_STD_DEV");
        }
        number = this.getNumber(this.jTextFieldCacheSize);
        if (null == number || number.doubleValue() <= 0.0) {
            commonSettingDataObject.setValidationError(AlgSettingsLrb.get("SVMS_COMPLEXITY_CACHE_SIZE_NULL"));
            return;
        }
        commonSettingDataObject.setValue("SVMS_KERNEL_CACHE_SIZE", number);
    }

    public void getIgnoredSettingsList() {
    }

    public boolean isNewDataInput(boolean bl) throws ValidationException {
        String string;
        Number number = this.getNumber(this.jTextFieldToleranceValue);
        if (null == number || number.doubleValue() < 0.0 || number.doubleValue() > 0.01) {
            throw new ValidationException(AlgSettingsLrb.get("SVMS_CONV_TOLERANCE_OUT_OF_RANGE"));
        }
        Number number2 = null;
        if (this.jCheckBoxComplexityFactors.isSelected() && null == (number2 = this.getNumber(this.jTextFieldComplexityFactors))) {
            throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_FACTOR_NULL"));
        }
        Number number3 = null;
        if (this.jCheckBoxOutlierRate.isSelected() && null == (number3 = this.getNumber(this.jTextFieldOutlierRate))) {
            throw new ValidationException(AlgSettingsLrb.get("SVMS_OUTLIER_RATE_NULL"));
        }
        Number number4 = null;
        Number number5 = null;
        String string2 = null;
        if (this.jCheckBoxActiveLearning.isSelected()) {
            if (this.jCheckBoxStdDev.isSelected() && null == (number4 = this.getNumber(this.jTextFieldStdDev))) {
                throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_STD_DEV_NULL"));
            }
            number5 = this.getNumber(this.jTextFieldCacheSize);
            if (null == number5) {
                throw new ValidationException(AlgSettingsLrb.get("SVMS_COMPLEXITY_CACHE_SIZE_NULL"));
            }
            string2 = "SVMS_AL_ENABLE";
        } else {
            string2 = "SVMS_AL_DISABLE";
        }
        if (!bl) {
            return bl;
        }
        CommonSettingDataObject commonSettingDataObject = this.getState();
        String string3 = (String)commonSettingDataObject.getBackupValue("SVMS_KERNEL_FUNCTION");
        if (0 != string3.compareTo(string = ModelSVOBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName))) {
            return true;
        }
        Double d = (Double)commonSettingDataObject.getBackupValue("SVMS_CONV_TOLERANCE");
        if (!NameValuePair.areEqual(number.doubleValue(), d)) {
            return true;
        }
        Object object = commonSettingDataObject.getBackupValue("SVMS_COMPLEXITY_FACTOR");
        if (!this.areEqual(object, number2)) {
            return true;
        }
        Object object2 = commonSettingDataObject.getBackupValue("SVMS_OUTLIER_RATE");
        if (!this.areEqual(object2, number3)) {
            return true;
        }
        String string4 = (String)commonSettingDataObject.getBackupValue("SVMS_ACTIVE_LEARNING");
        if (0 != string2.compareTo(string4)) {
            return true;
        }
        Object object3 = null;
        Object object4 = null;
        if (string4.equals("SVMS_AL_ENABLE")) {
            object3 = commonSettingDataObject.getBackupValue("SVMS_STD_DEV");
            if (!this.areEqual(object3, number4)) {
                return true;
            }
            object4 = commonSettingDataObject.getBackupValue("SVMS_KERNEL_CACHE_SIZE");
            if (!this.areEqual(object4, number5)) {
                return true;
            }
        }
        return false;
    }

    private boolean areEqual(Object object, Number number) {
        return !(object instanceof BigDecimal ? !NameValuePair.areEqual(number.doubleValue(), ((BigDecimal)object).doubleValue()) : object instanceof String && number != null);
    }
}

