/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;

public class ModelNMFBuildSettingsPanel
extends AbstractPropertiesPanel {
    private JCheckBox jCheckBoxNumOfFeatures;
    private JLabel jLabelConvTolerance;
    private JLabel jLabelNumIterations;
    private JLabel jLabelRandomSeed;
    private JScrollPane jScrollPane1;
    private JTextField jTextConvTolerance;
    private JTextField jTextFieldNumOfFeatures;
    private JTextField jTextNumIterations;
    private JTextField jTextRandomSeed;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public ModelNMFBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.intRes();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jCheckBoxNumOfFeatures = new JCheckBox();
        this.jTextFieldNumOfFeatures = new NumberTextField();
        this.jLabelConvTolerance = new JLabel();
        this.jTextConvTolerance = new NumberTextField();
        this.jLabelNumIterations = new JLabel();
        this.jTextNumIterations = new NumberTextField();
        this.jLabelRandomSeed = new JLabel();
        this.jTextRandomSeed = new NumberTextField();
        this.jScrollPane1.setBorder(null);
        this.jCheckBoxNumOfFeatures.setText("Specify the number of features");
        this.jCheckBoxNumOfFeatures.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxNumOfFeatures.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxNumOfFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelNMFBuildSettingsPanel.this.jCheckBoxNumOfFeaturesActionPerformed(actionEvent);
            }
        });
        this.jTextFieldNumOfFeatures.setText("1");
        this.jLabelConvTolerance.setText("Convergence tolerance:");
        this.jLabelNumIterations.setText("Number of iterations:");
        this.jLabelRandomSeed.setText("Random seed:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jTextFieldNumOfFeatures, -2, 86, -2).addContainerGap(317, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jCheckBoxNumOfFeatures).addContainerGap(223, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane1, -1, 394, Short.MAX_VALUE).addContainerGap(26, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelRandomSeed, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextRandomSeed, -2, 110, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelNumIterations, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextNumIterations, -2, 110, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelConvTolerance, -2, 182, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextConvTolerance, -2, 110, -2))).addGap(114, 114, 114)));
        groupLayout.linkSize(0, this.jLabelConvTolerance, this.jLabelNumIterations, this.jLabelRandomSeed);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxNumOfFeatures).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNumOfFeatures, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelConvTolerance).addComponent(this.jTextConvTolerance, -2, -1, -2)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumIterations).addComponent(this.jTextNumIterations, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRandomSeed).addComponent(this.jTextRandomSeed, -2, -1, -2)).addContainerGap(112, Short.MAX_VALUE)));
    }

    private void jCheckBoxNumOfFeaturesActionPerformed(ActionEvent actionEvent) {
    }

    private void intRes() {
        this.jCheckBoxNumOfFeatures.setText(AlgSettingsLrb.get("NMFS_SPECIFY_NUM_FEATURES"));
        this.jLabelConvTolerance.setText(AlgSettingsLrb.get("NMFS_CONV_TOLERANCE"));
        this.jLabelNumIterations.setText(AlgSettingsLrb.get("NMFS_NUM_ITERATIONS"));
        this.jLabelRandomSeed.setText(AlgSettingsLrb.get("NMFS_RANDOM_SEED"));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getState();
        this.loadDescription(this._jDescription, this.jScrollPane1);
        this.setDataType(this.jTextFieldNumOfFeatures, Integer.class);
        this.setDataType(this.jTextConvTolerance, Double.class);
        this.setDataType(this.jTextNumIterations, Integer.class);
        this.setDataType(this.jTextRandomSeed, Integer.class);
        this.setSigned(this.jTextFieldNumOfFeatures, false);
        this.setSigned(this.jTextConvTolerance, false);
        this.setSigned(this.jTextNumIterations, false);
        this.setSigned(this.jTextRandomSeed, true);
        this.setLocale(this.jTextFieldNumOfFeatures, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextConvTolerance, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextNumIterations, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextRandomSeed, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("FEAT_NUM_FEATURES");
        if (bigDecimal == null || 0 == bigDecimal.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxNumOfFeatures.setSelected(false);
            this.jTextFieldNumOfFeatures.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("FEAT_NUM_FEATURES");
        } else {
            commonSettingDataObject.setBackupValue("FEAT_NUM_FEATURES", bigDecimal);
            this.jCheckBoxNumOfFeatures.setSelected(true);
            this.setNumber(this.jTextFieldNumOfFeatures, bigDecimal);
            this.jTextFieldNumOfFeatures.setToolTipText(AlgSettingsLrb.get("FEAT_NUM_FEATURES_TOOLTIP"));
        }
        this.jCheckBoxNumOfFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelNMFBuildSettingsPanel.this.jTextFieldNumOfFeatures.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("NMFS_CONV_TOLERANCE");
        if (bigDecimal2 == null || 0 == bigDecimal2.compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("NMFS_CONV_TOLERANCE");
        } else {
            commonSettingDataObject.setBackupValue("NMFS_CONV_TOLERANCE", bigDecimal2);
            this.setNumber(this.jTextConvTolerance, bigDecimal2);
            this.jTextConvTolerance.setToolTipText(AlgSettingsLrb.get("NMFS_CONV_TOLERANCE_TOOLTIP"));
        }
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("NMFS_NUM_ITERATIONS");
        if (bigDecimal3 == null || 0 == bigDecimal3.compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("NMFS_NUM_ITERATIONS");
        } else {
            commonSettingDataObject.setBackupValue("NMFS_NUM_ITERATIONS", bigDecimal3);
            this.setNumber(this.jTextNumIterations, bigDecimal3);
            this.jTextNumIterations.setToolTipText(AlgSettingsLrb.get("NMFS_NUM_ITERATIONS_TOOLTIP"));
        }
        BigDecimal bigDecimal4 = commonSettingDataObject.getModelSettingNumValue("NMFS_RANDOM_SEED");
        if (bigDecimal3 == null || 0 == bigDecimal3.compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("NMFS_RANDOM_SEED");
        } else {
            commonSettingDataObject.setBackupValue("NMFS_RANDOM_SEED", bigDecimal4);
            this.setNumber(this.jTextRandomSeed, bigDecimal4);
        }
    }

    @Override
    public void processInput() {
        Number number;
        CommonSettingDataObject commonSettingDataObject = this.getState();
        if (this.jCheckBoxNumOfFeatures.isSelected()) {
            number = this.getNumber(this.jTextFieldNumOfFeatures);
            if (null == number || number.intValue() <= 0) {
                commonSettingDataObject.setValidationError(AlgSettingsLrb.get("FEAT_NUM_FEATURES_INVALID"));
                return;
            }
            commonSettingDataObject.setValue("FEAT_NUM_FEATURES", number);
        } else {
            commonSettingDataObject.setNullValue("FEAT_NUM_FEATURES");
        }
        number = this.getNumber(this.jTextConvTolerance);
        if (null == number || number.doubleValue() <= 0.0 || number.doubleValue() > 0.5) {
            commonSettingDataObject.setValidationError(AlgSettingsLrb.get("NMFS_CONV_TOLERANCE_INVALID"));
            return;
        }
        commonSettingDataObject.setValue("NMFS_CONV_TOLERANCE", number);
        Number number2 = this.getNumber(this.jTextNumIterations);
        if (null == number2 || number2.intValue() <= 0 || number.intValue() > 500) {
            commonSettingDataObject.setValidationError(AlgSettingsLrb.get("NMFS_NUM_ITERATIONS_INVALID"));
            return;
        }
        commonSettingDataObject.setValue("NMFS_NUM_ITERATIONS", number2);
        Number number3 = this.getNumber(this.jTextRandomSeed);
        commonSettingDataObject.setValue("NMFS_RANDOM_SEED", number3);
    }
}

