/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractAlgorithmSettingsPanel
extends AbstractPropertiesPanel {
    private AbstractPropertiesPanel contentPanel;

    public AbstractAlgorithmSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel) {
        super(advancedSettingsPanel);
        this.setLayout(new BorderLayout());
    }

    public abstract void initializeFromState(CommonSettingDataObject var1);

    protected abstract void addClientPanel();

    public String getTitle() {
        return AlgSettingsLrb.get("ALGORITHM_SETTINGS_ERROR_TITLE");
    }

    public void loadAlgorithm(Context context, ModelType modelType, BuildNodeType buildNodeType, AbstractDataNode abstractDataNode) {
        this.setModelType(modelType);
        CommonSettingDataObject commonSettingDataObject = this.getState();
        if (commonSettingDataObject == null) {
            commonSettingDataObject = new CommonSettingDataObject(context, this.parentPanel, this.getModelType(), buildNodeType, abstractDataNode, Locale.getDefault());
            this.setState(commonSettingDataObject);
            this.addClientPanel();
            LoadUI loadUI = new LoadUI(AlgSettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), AlgSettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"));
            loadUI.start();
        } else if (commonSettingDataObject.isLoaded()) {
            this.addClientPanel();
            this.initializeFromState(commonSettingDataObject);
        } else {
            this.addClientPanel();
            this.showLoadingStatus();
        }
    }

    public boolean isValidState() {
        boolean bl = true;
        Exception exception = null;
        if (this.isContentAvailable()) {
            block4: {
                try {
                    this.getState().validate();
                }
                catch (Exception exception2) {
                    if (!this.getState().isLoaded()) break block4;
                    bl = false;
                    exception = exception2;
                }
            }
            if (exception != null && exception instanceof ValidationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)this.getTitle(), (String)exception.getMessage());
            }
        }
        return bl;
    }

    public boolean apply() {
        boolean bl = this.isContentAvailable();
        if (bl && this.getState().isLoaded()) {
            try {
                bl = this.getState().isModified();
                if (bl) {
                    this.getState().finish();
                    this.getState().apply();
                }
            }
            catch (ValidationException validationException) {
                validationException.printStackTrace();
            }
        }
        return bl;
    }

    private void showLoadingStatus() {
        this.replaceContent(this.createLoadingStatusPanel(this.parentPanel));
    }

    protected void clearState() {
    }

    @Override
    public void processInput() {
        if (this.isContentAvailable()) {
            this.clearState();
            this.contentPanel.processInput();
        }
    }

    protected boolean isContentAvailable() {
        return this.contentPanel != null && !(this.contentPanel instanceof AbstractPropertiesPanel.ServicePanel);
    }

    protected void replaceContent(AbstractPropertiesPanel abstractPropertiesPanel) {
        boolean bl = this.parentPanel.isMultpleSelection();
        if (bl && this.contentPanel instanceof AbstractPropertiesPanel.ServicePanel && ((AbstractPropertiesPanel.ServicePanel)this.contentPanel).isMultipleSelectionPanel()) {
            return;
        }
        if (this.contentPanel != null) {
            this.remove(this.contentPanel);
        }
        this.contentPanel = abstractPropertiesPanel;
        this.add((Component)this.contentPanel, "Center");
        this.validate();
    }

    public void loadUnderConstruction() {
        this.replaceContent(this.createModelUnderConstructionPanel());
    }

    public void loadMultipleSelection() {
        this.replaceContent(this.createMultipleSelection());
    }

    protected class LoadUI
    extends SwingWorker {
        Exception ex = null;
        boolean success = false;
        private String errorLoadingTitle;
        private String errorLoadingMsg;

        public LoadUI(String string, String string2) {
            this.errorLoadingTitle = string;
            this.errorLoadingMsg = string2;
        }

        public Object construct() {
            CommonSettingDataObject commonSettingDataObject = AbstractAlgorithmSettingsPanel.this.getState();
            try {
                AbstractAlgorithmSettingsPanel.this.showLoadingStatus();
                commonSettingDataObject.load();
                commonSettingDataObject.setLoaded(true);
                this.success = true;
            }
            catch (Exception exception) {
                this.ex = exception;
                this.success = false;
            }
            return commonSettingDataObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            block6: {
                try {
                    if (this.success && this.ex == null) {
                        AbstractAlgorithmSettingsPanel.this.getState().initializeClients();
                        break block6;
                    }
                    if (this.ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this.ex, (String)this.errorLoadingTitle, (String)this.errorLoadingMsg, null);
                        break block6;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)this.errorLoadingTitle, (String)this.errorLoadingMsg);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)this.errorLoadingTitle, (String)this.errorLoadingMsg, null);
                }
            }
        }
    }
}

