/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ModelNameValidationDocument;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class NewModelPanel
extends JPanel {
    private AbstractBuildNode diagramNode;
    private Collection<String> wfInMemoryModelNames;
    private String modelName;
    private Boolean nameTouched = false;
    private String algorithm;
    private String miningFunction;
    private String comment;
    private ModelType newModel;
    private Context ctx;
    private String[] algorithms;
    private JComboBox jAlgorithm;
    private JLabel jAlgorithmLabel;
    private JLabel jCommentLabel;
    private JTextArea jCommentText;
    private JTextField jModelName;
    private JLabel jModelNameLabel;
    private JScrollPane textScrolPane;
    public static final int NAME_MAX_LEN = 25;
    private static Object[] classItems = new Object[]{BuildEditorLrb.get("ALGO_DT"), BuildEditorLrb.get("ALGO_GLM"), BuildEditorLrb.get("ALGO_NB"), BuildEditorLrb.get("ALGO_SVM")};
    private static String[] classAlgo = new String[]{"ALGO_DECISION_TREE", "ALGO_GENERALIZED_LINEAR_MODEL", "ALGO_NAIVE_BAYES", "ALGO_SUPPORT_VECTOR_MACHINES"};
    private static Object[] regrItems = new Object[]{BuildEditorLrb.get("ALGO_GLM"), BuildEditorLrb.get("ALGO_SVM")};
    private static String[] regrAlgo = new String[]{"ALGO_GENERALIZED_LINEAR_MODEL", "ALGO_SUPPORT_VECTOR_MACHINES"};
    private static Object[] clustItems = new Object[]{BuildEditorLrb.get("ALGO_KMCL"), BuildEditorLrb.get("ALGO_OCL")};
    private static String[] clustAlgo = new String[]{"ALGO_KMEANS", "ALGO_O_CLUSTER"};
    private static Object[] arItems = new Object[]{BuildEditorLrb.get("ALGO_AR")};
    private static String[] arAlgo = new String[]{"ALGO_APRIORI_ASSOCIATION_RULES"};
    private static Object[] aiItems = new Object[]{BuildEditorLrb.get("ALGO_AI")};
    private static String[] aiAlgo = new String[]{"ALGO_AI_MDL"};
    private static Object[] anomItems = new Object[]{BuildEditorLrb.get("ALGO_SVM")};
    private static String[] anomAlgo = new String[]{"ALGO_SUPPORT_VECTOR_MACHINES"};
    private static Object[] feItems = new Object[]{BuildEditorLrb.get("ALGO_NMF")};
    private static String[] feAlgo = new String[]{"ALGO_NONNEGATIVE_MATRIX_FACTOR"};

    public NewModelPanel(Context context, AbstractBuildNode abstractBuildNode, Collection<String> collection) {
        this.ctx = context;
        this.diagramNode = abstractBuildNode;
        this.algorithms = null;
        this.wfInMemoryModelNames = collection;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jModelNameLabel = new JLabel();
        this.jModelName = new JTextField();
        this.jAlgorithmLabel = new JLabel();
        this.jAlgorithm = new JComboBox();
        this.jCommentLabel = new JLabel();
        this.textScrolPane = new JScrollPane();
        this.jCommentText = new JTextArea();
        this.jModelNameLabel.setText("Name:");
        this.jAlgorithmLabel.setText("Algorithm:");
        this.jAlgorithm.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCommentLabel.setText("Comment:");
        this.jCommentText.setColumns(20);
        this.jCommentText.setRows(5);
        this.textScrolPane.setViewportView(this.jCommentText);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAlgorithmLabel).addComponent(this.jModelNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAlgorithm, 0, 351, Short.MAX_VALUE).addComponent(this.jModelName, -1, 351, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCommentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textScrolPane, -1, 351, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAlgorithmLabel).addComponent(this.jAlgorithm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jModelNameLabel).addComponent(this.jModelName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCommentLabel).addContainerGap(70, Short.MAX_VALUE)).addComponent(this.textScrolPane, -1, 84, Short.MAX_VALUE))));
    }

    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(BuildEditorLrb.get("MODEL_NAME"), this.jModelNameLabel);
        hashMap.put(BuildEditorLrb.get("MODEL_ALGO"), this.jAlgorithmLabel);
        hashMap.put(BuildEditorLrb.get("MODEL_COMMENT"), this.jCommentLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.initHelp();
    }

    private void initHelp() {
        if (this.diagramNode instanceof AssociationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"association_node_pi_models_build");
        } else if (this.diagramNode instanceof ClassificationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"classification_node_pi_models_build");
        } else if (this.diagramNode instanceof ClusteringBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"clustering_node_pi_models_build");
        } else if (this.diagramNode instanceof RegressionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"regression_node_pi_models_build");
        } else if (this.diagramNode instanceof AnomalyDetectionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"anomaly_node_pi_models_build");
        } else if (this.diagramNode instanceof FeatureExtractionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"feature_node_pi_models_build");
        }
    }

    public void initUI() {
        Object[] objectArray = null;
        BuildNodeType buildNodeType = (BuildNodeType)this.diagramNode.getData();
        this.jModelName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                NewModelPanel.this.nameTouched = true;
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            objectArray = classItems;
            this.algorithms = classAlgo;
            this.miningFunction = "CLASSIFICATION";
        } else if (buildNodeType instanceof RegressionBuildNodeType) {
            objectArray = regrItems;
            this.algorithms = regrAlgo;
            this.miningFunction = "REGRESSION";
        } else if (buildNodeType instanceof ClusteringBuildNodeType) {
            objectArray = clustItems;
            this.algorithms = clustAlgo;
            this.miningFunction = "CLUSTERING";
        } else if (buildNodeType instanceof AssociationBuildNodeType) {
            objectArray = arItems;
            this.algorithms = arAlgo;
            this.miningFunction = "ASSOCIATION";
        } else if (buildNodeType instanceof AnomalyDetectionBuildNodeType) {
            objectArray = anomItems;
            this.algorithms = anomAlgo;
            this.miningFunction = "ANOMALY_DETECTION";
        } else if (buildNodeType instanceof FeatureExtractionBuildNodeType) {
            objectArray = feItems;
            this.algorithms = feAlgo;
            this.miningFunction = "FEATURE_EXTRACTION";
        }
        String string = this.algorithms[this.jAlgorithm.getSelectedIndex()];
        String string2 = null;
        if (this.diagramNode instanceof ClassificationBuildNode) {
            string2 = "CLASSIFICATION";
        } else if (this.diagramNode instanceof RegressionBuildNode) {
            string2 = "REGRESSION";
        } else if (this.diagramNode instanceof ClusteringBuildNode) {
            string2 = "CLUSTERING";
        } else if (this.diagramNode instanceof AssociationBuildNode) {
            string2 = "ASSOCIATION";
        } else if (this.diagramNode instanceof AnomalyDetectionBuildNode) {
            string2 = "ANOMALY_DETECTION";
        } else if (this.diagramNode instanceof FeatureExtractionBuildNode) {
            string2 = "FEATURE_EXTRACTION";
        }
        try {
            this.modelName = WorkflowUtils.getNewModelNameWfid(this.ctx, this.wfInMemoryModelNames, string2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.modelName = "";
        }
        this.jModelName.setDocument(new ModelNameValidationDocument(25, true));
        this.jModelName.setText(this.modelName);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        this.jAlgorithm.setModel(defaultComboBoxModel);
        this.jAlgorithm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NewModelPanel.this.nameTouched.booleanValue()) {
                    return;
                }
                String string = NewModelPanel.this.algorithms[NewModelPanel.this.jAlgorithm.getSelectedIndex()];
                String string2 = null;
                if (NewModelPanel.this.diagramNode instanceof ClassificationBuildNode) {
                    string2 = "CLASSIFICATION";
                } else if (NewModelPanel.this.diagramNode instanceof RegressionBuildNode) {
                    string2 = "REGRESSION";
                } else if (NewModelPanel.this.diagramNode instanceof ClusteringBuildNode) {
                    string2 = "CLUSTERING";
                } else if (NewModelPanel.this.diagramNode instanceof AssociationBuildNode) {
                    string2 = "ASSOCIATION";
                } else if (NewModelPanel.this.diagramNode instanceof AnomalyDetectionBuildNode) {
                    string2 = "ANOMALY_DETECTION";
                } else if (NewModelPanel.this.diagramNode instanceof FeatureExtractionBuildNode) {
                    string2 = "FEATURE_EXTRACTION";
                }
                String string3 = "";
                try {
                    string3 = WorkflowUtils.getNewModelNameWfid(NewModelPanel.this.ctx, NewModelPanel.this.wfInMemoryModelNames, string2, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string3 = "";
                }
                NewModelPanel.this.jModelName.setText(string3);
            }
        });
    }

    public boolean doWork() {
        boolean bl = true;
        this.modelName = this.jModelName.getText();
        this.comment = this.jCommentText.getText();
        this.algorithm = this.algorithms[this.jAlgorithm.getSelectedIndex()];
        if (!NewModelPanel.validateName(this.modelName, this.ctx, this, this.wfInMemoryModelNames, null)) {
            bl = false;
        }
        if (!this.validateComment(this.comment)) {
            bl = false;
        }
        if (bl) {
            this.newModel = this.diagramNode.createNewModel(this.modelName, this.comment, this.miningFunction, this.algorithm);
        }
        if (this.newModel != null) {
            this.newModel.setUseForOutput(true);
        }
        return bl;
    }

    public static boolean validateName(String string, Context context, Component component, Collection<String> collection, String string2) {
        boolean bl = true;
        if (string.length() == 0 || string.length() > 25) {
            Object[] objectArray = new Object[]{25};
            String string3 = MessageFormat.format(BuildEditorLrb.get("ADD_NAME_ERROR"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)BuildEditorLrb.get("ADD_NAME_ERROR_TITLE"), null);
            return false;
        }
        if (!StringUtils.containsOnlyValidDBNameCharacters(string)) {
            Object[] objectArray = new Object[]{25};
            String string4 = MessageFormat.format(BuildEditorLrb.get("MODEL_NAME_INVALID"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)BuildEditorLrb.get("MODEL_NAME_INVALID_TITLE"), null);
            return false;
        }
        if (string2 == null || !string2.equals(string)) {
            bl = WorkflowUtils.validateUserModelName(context, string, component, collection, WorkflowUtils.getAllInMemoryModelNames(context));
        }
        return bl;
    }

    private boolean validateComment(String string) {
        boolean bl = true;
        if (string.length() > 10000) {
            bl = false;
        }
        return bl;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public ModelType getNewModel() {
        return this.newModel;
    }
}

