/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import oracle.dmt.dataminer.workflow.ModelNameValidationDocument;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.ide.Context;
import oracle.javatools.dialogs.ExceptionDialog;

public class ModelNameCellEditor
extends DefaultCellEditor {
    private JTextField tf;
    private String originalModelName;
    private Context context;
    private boolean requireValidation = true;
    private boolean validated;
    private WorkflowModel wfModel;
    private BuildNodeType nodeData;

    public ModelNameCellEditor(Context context, WorkflowModel workflowModel, BuildNodeType buildNodeType) {
        super(new JTextField());
        this.context = context;
        this.wfModel = workflowModel;
        this.nodeData = buildNodeType;
        this.tf = (JTextField)this.getComponent();
        this.tf.setDocument(new ModelNameValidationDocument(25, true));
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.tf.setText((String)object);
        this.validated = false;
        BuildNodeTableModel buildNodeTableModel = (BuildNodeTableModel)((Object)jTable.getModel());
        this.originalModelName = buildNodeTableModel.getOriginalModelName(n);
        return this.tf;
    }

    private boolean isRequireValidation() {
        return this.requireValidation;
    }

    public void setRequireValidation(boolean bl) {
        this.requireValidation = bl;
    }

    @Override
    public boolean stopCellEditing() {
        if (!this.validated && !this.validate((String)this.getCellEditorValue())) {
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.tf.setInputVerifier(null);
        super.cancelCellEditing();
    }

    private boolean validate(String string) {
        if (this.isRequireValidation()) {
            try {
                Collection<String> collection = WorkflowUtils.getInMemoryModelNames(this.wfModel, this.nodeData);
                if (!NewModelPanel.validateName(string, this.context, this.tf, collection, this.originalModelName)) {
                    return false;
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)this.tf, (Throwable)exception);
            }
        }
        this.validated = true;
        return true;
    }
}

