/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.CheckBoxTableListener;
import oracle.dmt.dataminer.controls.CheckedItemData;
import oracle.dmt.dataminer.controls.LabeledCheckBoxEditor;
import oracle.dmt.dataminer.controls.LabeledCheckBoxRenderer;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.util.TriStateBoolean;

public class CaseAttributesPanel
extends JPanel
implements DataminerGUIPanel {
    private AbstractBuildNode node;
    private CaseEditRecord caseEdits;
    private GenericTable _jCaseIdTable;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private LabeledCheckBoxRenderer _tableCellRenderer = new LabeledCheckBoxRenderer();
    private LabeledCheckBoxEditor _tableCaseIDCellEditor = new LabeledCheckBoxEditor();
    private CheckBoxTableListener _tableListener = new CheckListener(this._tableCellRenderer);

    public CaseAttributesPanel(AbstractBuildNode abstractBuildNode, CaseEditRecord caseEditRecord) {
        this.node = abstractBuildNode;
        this.caseEdits = caseEditRecord;
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this._jCaseIdTable = new GenericTable();
        this.jLabel1 = new JLabel();
        this._jCaseIdTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Name"}));
        this.jScrollPane1.setViewportView((Component)this._jCaseIdTable);
        this.jLabel1.setText("Select Case Attributes (TODO: RES)");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLabel1, -1, 385, Short.MAX_VALUE).addContainerGap()).addComponent(this.jScrollPane1, -1, 395, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 277, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        BuildNodeType buildNodeType = (BuildNodeType)this.node.getData();
        TableAttributesModel tableAttributesModel = new TableAttributesModel(buildNodeType.getMiningAttributes().getMiningAttribute());
        this._jCaseIdTable.setModel((TableModel)((Object)tableAttributesModel));
        this._jCaseIdTable.setSorted(true);
        this._jCaseIdTable.setSortColumn(0, true);
        TableColumn tableColumn = this._jCaseIdTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this._tableCellRenderer);
        tableColumn.setCellEditor(this._tableCaseIDCellEditor);
        TableColumnModel tableColumnModel = this._jCaseIdTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(300);
        tableColumnModel.getColumn(1).setPreferredWidth(85);
        this._jCaseIdTable.addMouseListener((MouseListener)this._tableListener);
        this._jCaseIdTable.addKeyListener((KeyListener)this._tableListener);
    }

    public boolean doWork() {
        TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)this._jCaseIdTable.getModel());
        ArrayList<ColumnData> arrayList = tableAttributesModel.getDataList();
        ArrayList<AttributeType> arrayList2 = new ArrayList<AttributeType>();
        for (ColumnData columnData : arrayList) {
            if (!columnData.getCheckBoxState().equals(TriStateBoolean.TRUE)) continue;
            MiningAttributeType miningAttributeType = (MiningAttributeType)columnData.getData();
            AttributeType attributeType = MetaDataHelper.createAttributeFrom(miningAttributeType);
            arrayList2.add(attributeType);
        }
        List list = this.caseEdits.getCaseAttributes().getAttribute();
        list.clear();
        list.addAll(arrayList2);
        return true;
    }

    class CheckListener
    extends CheckBoxTableListener {
        public CheckListener(LabeledCheckBoxRenderer labeledCheckBoxRenderer) {
            super(labeledCheckBoxRenderer);
        }

        @Override
        protected void itemChecked(int n) {
            super.itemChecked(n);
            TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)CaseAttributesPanel.this._jCaseIdTable.getModel());
            ColumnData columnData = (ColumnData)tableAttributesModel.getValueAt(CaseAttributesPanel.this._jCaseIdTable.convertRowIndexToModel(n), 0);
            columnData.setCheckBoxState(TriStateBoolean.TRUE);
            tableAttributesModel.fireTableCellUpdated(n, 0);
        }

        @Override
        protected void itemUnchecked(int n) {
            super.itemChecked(n);
            TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)CaseAttributesPanel.this._jCaseIdTable.getModel());
            ColumnData columnData = (ColumnData)tableAttributesModel.getValueAt(CaseAttributesPanel.this._jCaseIdTable.convertRowIndexToModel(n), 0);
            columnData.setCheckBoxState(TriStateBoolean.FALSE);
            tableAttributesModel.fireTableCellUpdated(n, 0);
        }
    }

    class ColumnData
    extends CheckedItemData {
        public ColumnData(Object object) {
            super(object);
        }

        @Override
        public String toString() {
            return ((AttributeType)this.getData()).getName();
        }
    }

    class TableAttributesModel
    extends GenericBaseTableModel {
        private ArrayList<ColumnData> _data = new ArrayList();
        private boolean _validated = false;
        private final int COLUMN_COUNT = 2;
        public static final int NAME = 0;
        public static final int DATA_TYPE = 1;

        public TableAttributesModel(List<MiningAttributeType> list) {
            List list2 = CaseAttributesPanel.this.caseEdits.getCaseAttributes().getAttribute();
            HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
            for (AttributeType attributeType : list2) {
                hashMap.put(attributeType.getName(), attributeType);
            }
            for (MiningAttributeType miningAttributeType : list) {
                ColumnData columnData = new ColumnData(miningAttributeType);
                if (hashMap.containsKey(miningAttributeType.getName())) {
                    columnData.setCheckBoxState(TriStateBoolean.TRUE);
                }
                if (miningAttributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                this._data.add(columnData);
            }
            Iterator<Object> iterator = new String[]{"Name", "Data Type"};
            this.setColumnIdentifiers((Object[])iterator);
            this.setRowCount(this._data.size());
            this.setColumnCount(2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            Object object = null;
            ColumnData columnData = this._data.get(CaseAttributesPanel.this._jCaseIdTable.convertRowIndexToModel(n));
            switch (n2) {
                case 0: {
                    object = columnData;
                    break;
                }
                case 1: {
                    object = ((AttributeType)columnData.getData()).getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public ArrayList<ColumnData> getDataList() {
            return this._data;
        }

        public void setValidated(boolean bl) {
            this._validated = bl;
        }

        public boolean isValidated() {
            return this._validated;
        }
    }
}

