/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public class BuildEditDialog {
    protected JEWTDialog _dlg;
    protected String wizName = "Edit build node";

    protected JEWTDialog buildDialog(Context context, AbstractBuildNode abstractBuildNode, List<String> list) {
        BuildEditPanel buildEditPanel = new BuildEditPanel(context, abstractBuildNode, list);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)buildEditPanel);
        jEWTDialog.setTitle(this.getDialogTitle(abstractBuildNode));
        return jEWTDialog;
    }

    protected String getDialogTitle(AbstractBuildNode abstractBuildNode) {
        if (abstractBuildNode == null) {
            return "Not Found";
        }
        if (abstractBuildNode instanceof ClassificationBuildNode) {
            return BuildEditorLrb.get("EDIT_CLASSIFICATION_NODE_TITLE");
        }
        if (abstractBuildNode instanceof RegressionBuildNode) {
            return BuildEditorLrb.get("EDIT_REGRESSION_NODE_TITLE");
        }
        if (abstractBuildNode instanceof ClusteringBuildNode) {
            return BuildEditorLrb.get("EDIT_CLUSTERING_NODE_TITLE");
        }
        if (abstractBuildNode instanceof AssociationBuildNode) {
            return BuildEditorLrb.get("EDIT_ASSOCIATION_NODE_TITLE");
        }
        if (abstractBuildNode instanceof AnomalyDetectionBuildNode) {
            return BuildEditorLrb.get("EDIT_ANOMALY_DETECTION_NODE_TITLE");
        }
        if (abstractBuildNode instanceof FeatureExtractionBuildNode) {
            return BuildEditorLrb.get("EDIT_FEATURE_EXTRACTION_NODE_TITLE");
        }
        return "Not Found";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, AbstractBuildNode abstractBuildNode, List<String> list) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(context, abstractBuildNode, list);
            jEWTDialog.setResizable(true);
            final BuildEditPanel buildEditPanel = (BuildEditPanel)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !buildEditPanel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }
}

