/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizardModel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizardPage;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class ApplySettingsPage
extends ApplyWizardPage
implements DataminerGUIPanel {
    private ApplyWizardModel _wizModel;
    private SpecificTableModel _models;
    private NiceTableWithToolbar _tableWithToolbar;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar;
    private JComboBox jBestNComboBox;
    private JCheckBox jBoundsCheckBox;
    private JTextField jConfidenceField;
    private JLabel jConfidenceLabel;
    private JTextField jCutOffField;
    private JLabel jCutOffLabel;
    private JScrollPane jDescScrollPane;
    private JLabel jFillerLabel;
    private JLabel jFillerLabel1;
    private JLabel jFillerLabel2;
    private JCheckBox jMostLikelyCheckBox;
    private JPanel jMostLikelyParamsPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JCheckBox jRuleCheckBox;
    private JCheckBox jSpecificCheckBox;
    private JPanel jSpecificParamsPanel;
    private JCheckBox jTopNCheckBox;
    private JLabel jTopNLabel;
    private JPanel jTopNParamsPanel;
    private JCheckBox jUseBestNCheckBox;
    private JCheckBox jUseCutOffCheckBox;
    private TransparentPanel transparentPanel1;

    public ApplySettingsPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initUI() {
        Serializable serializable;
        Object object;
        Object object2;
        this._wizModel = this.getModel(this.getTraversableContext());
        ApplyNode.Parameters parameters = this._wizModel.getMostLikelyParam();
        this.jMostLikelyCheckBox.setSelected(parameters != null);
        ApplyNode.Parameters parameters2 = this._wizModel.getMostLikelyScoringParam();
        this.jRuleCheckBox.setVisible(parameters2 != null);
        ApplyNode.Parameters parameters3 = this._wizModel.getMostLikelyBoundsParam();
        if (parameters3 == null) {
            this.jBoundsCheckBox.setVisible(false);
            this.jConfidenceLabel.setVisible(false);
            this.jConfidenceField.setVisible(false);
        } else {
            this.jBoundsCheckBox.setVisible(true);
            this.jConfidenceLabel.setVisible(true);
            this.jConfidenceField.setVisible(true);
            object2 = ((ApplyNode.DefaultPredictionBounds)parameters3).getConfidence();
            ((NumberTextField)this.jConfidenceField).setSigned(false);
            ((NumberTextField)this.jConfidenceField).setDataType(Double.class);
            ((NumberTextField)this.jConfidenceField).setNumber((Number)((Double)object2 * 100.0));
        }
        this.jMostLikelyParamsPanel.setVisible(parameters2 != null || parameters3 != null);
        object2 = this._wizModel.getTopNParam();
        if (object2 == null) {
            this.jTopNCheckBox.setVisible(false);
            this.jTopNParamsPanel.setVisible(false);
        } else {
            this.jTopNCheckBox.setVisible(true);
            this.jTopNParamsPanel.setVisible(true);
            object = null;
            int n = -1;
            serializable = null;
            if (object2 instanceof ApplyNode.PredictionSet) {
                int n2 = 0;
                for (RefModelType refModelType : this._wizModel.getSelectedModels()) {
                    boolean bl = ApplyNode.doesModelCostExist((ApplyNode)this._wizModel.getParent().getData(), refModelType);
                    if (bl) continue;
                    ++n2;
                }
                object = ((ApplyNode.PredictionSet)object2).getTopN();
                n = ((ApplyNode.PredictionSet)object2).getMaxN();
                serializable = ((ApplyNode.PredictionSet)object2).getCutOff();
                if (this._wizModel.getSelectedModels().size() > 1 && this._wizModel.getSelectedModels().size() > n2) {
                    this.jUseCutOffCheckBox.setVisible(false);
                    this.jCutOffLabel.setVisible(false);
                    this.jCutOffField.setVisible(false);
                } else {
                    Object object3;
                    this.jUseCutOffCheckBox.setVisible(true);
                    this.jCutOffLabel.setVisible(true);
                    this.jCutOffField.setVisible(true);
                    if (((ApplyNode.PredictionSet)object2).getUseCostType().compareTo("Model") == 0) {
                        serializable = ((ApplyNode.PredictionSet)object2).getCostCutOff();
                        object3 = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE");
                        ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffField, (String)object3);
                        this.jCutOffLabel.getAccessibleContext().setAccessibleName((String)object3);
                        this.jCutOffField.setToolTipText(DialogsLrb.get("APPLY_OUTPUT_COST_VALUE_TIP"));
                    } else {
                        serializable = ((ApplyNode.PredictionSet)object2).getCutOff();
                        object3 = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE");
                        ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffField, (String)object3);
                        this.jCutOffLabel.getAccessibleContext().setAccessibleName((String)object3);
                        this.jCutOffField.setToolTipText(DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE_TIP"));
                    }
                }
            } else if (object2 instanceof ApplyNode.ClusterSet) {
                object = ((ApplyNode.ClusterSet)object2).getTopN();
                n = ((ApplyNode.ClusterSet)object2).getMaxN();
                serializable = ((ApplyNode.ClusterSet)object2).getCutOff();
            } else if (object2 instanceof ApplyNode.FeatureSet) {
                object = ((ApplyNode.FeatureSet)object2).getTopN();
                n = ((ApplyNode.FeatureSet)object2).getMaxN();
                serializable = ((ApplyNode.FeatureSet)object2).getCutOff();
            }
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(i + "");
            }
            this.jBestNComboBox.setModel(defaultComboBoxModel);
            this.jBestNComboBox.setSelectedItem(((BigInteger)object).toString());
            ((NumberTextField)this.jCutOffField).setDataType(Double.class);
            ((NumberTextField)this.jCutOffField).setSigned(false);
            ((NumberTextField)this.jCutOffField).setNumber((Number)serializable);
        }
        object = this._wizModel.getSpecificParam();
        if (object == null) {
            this.jSpecificCheckBox.setVisible(false);
            this.jSpecificParamsPanel.setVisible(false);
            this.jFillerLabel.setVisible(true);
        } else {
            this.jSpecificCheckBox.setVisible(true);
            this.jSpecificParamsPanel.setVisible(true);
            this.jFillerLabel.setVisible(false);
            this._models = new SpecificTableModel(this._wizModel);
            ControlBar controlBar = new ControlBar();
            if (object instanceof ApplyNode.PredictionProbability) {
                this._tableWithToolbar = new NiceTableWithToolbar(this.componentWithTitlebar, controlBar, SpecificTableModel._targetColumnNames, this._models);
                this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("PAGE_OUTPUT_TARGET_COL")));
            } else if (object instanceof ApplyNode.ClusterProbability) {
                this._tableWithToolbar = new NiceTableWithToolbar(this.componentWithTitlebar, controlBar, SpecificTableModel._clusterColumnNames, this._models);
                this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("PAGE_OUTPUT_CLUSTER_COL")));
            } else if (object instanceof ApplyNode.FeatureValue) {
                this._tableWithToolbar = new NiceTableWithToolbar(this.componentWithTitlebar, controlBar, SpecificTableModel._featureColumnNames, this._models);
                this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("PAGE_OUTPUT_FEATURE_COL")));
            }
            serializable = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
            ((TableColumn)serializable).setMaxWidth(15);
            ((TableColumn)serializable).setResizable(false);
            this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(1).setPreferredWidth(100);
            this._tableWithToolbar.getNiceTable().setSortColumn(1, true);
            this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ApplySettingsPage.this.handleModelSelectionChanged();
                }
            });
        }
        this.jDescScrollPane.setVisible(false);
    }

    private void handleModelSelectionChanged() {
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_OPTION"), this.jMostLikelyCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_SCORING"), this.jRuleCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_BOUNDS"), this.jBoundsCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_BOUNDS_CONFIDENCE"), this.jConfidenceLabel);
        this.jConfidenceField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_BOUNDS_CONFIDENCE_TIP"));
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_TOPN_OPTION"), this.jTopNCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_TOPN_USE_N"), this.jUseBestNCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_TOPN_N_VALUE"), this.jTopNLabel);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_TOPN_USE_CUTOFF"), this.jUseCutOffCheckBox);
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_TOPN_CUTOFF_VALUE"), this.jCutOffLabel);
        this.jCutOffField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_TOPN_CUTOFF_VALUE_TIP"));
        hashMap.put(DialogsLrb.get("PAGE_OUTPUT_SPEC_OPTION"), this.jSpecificCheckBox);
        UIResourceHelper.setComponentText(hashMap);
    }

    private void initComponents() {
        this.jDescScrollPane = new JScrollPane();
        this.jMostLikelyCheckBox = new JCheckBox();
        this.jMostLikelyParamsPanel = new JPanel();
        this.jRuleCheckBox = new JCheckBox();
        this.jBoundsCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jConfidenceLabel = new JLabel();
        this.jConfidenceField = new NumberTextField();
        this.jFillerLabel2 = new JLabel();
        this.jTopNCheckBox = new JCheckBox();
        this.jTopNParamsPanel = new JPanel();
        this.jUseBestNCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jTopNLabel = new JLabel();
        this.jBestNComboBox = new JComboBox();
        this.jUseCutOffCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jCutOffLabel = new JLabel();
        this.jCutOffField = new NumberTextField();
        this.jFillerLabel1 = new JLabel();
        this.jSpecificCheckBox = new JCheckBox();
        this.jSpecificParamsPanel = new JPanel();
        this.transparentPanel1 = new TransparentPanel();
        this.componentWithTitlebar = new ComponentWithTitlebar();
        this.jFillerLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jDescScrollPane.setBorder(null);
        this.jDescScrollPane.setMinimumSize(new Dimension(400, 30));
        this.jDescScrollPane.setName("jDescScrollPane");
        this.jDescScrollPane.setPreferredSize(new Dimension(600, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.add(this.jDescScrollPane, gridBagConstraints);
        this.jMostLikelyCheckBox.setText("Most Likely");
        this.jMostLikelyCheckBox.setName("jMostLikelyCheckBox");
        this.jMostLikelyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jMostLikelyCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.jMostLikelyCheckBox, gridBagConstraints);
        this.jMostLikelyParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jMostLikelyParamsPanel.setName("jMostLikelyParamsPanel");
        this.jMostLikelyParamsPanel.setLayout(new GridBagLayout());
        this.jRuleCheckBox.setText("Scoring Node (for decision tree only)");
        this.jRuleCheckBox.setName("jRuleCheckBox");
        this.jRuleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jRuleCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.jMostLikelyParamsPanel.add((Component)this.jRuleCheckBox, gridBagConstraints);
        this.jBoundsCheckBox.setText("Prediction Bounds (for GLM only)");
        this.jBoundsCheckBox.setName("jBoundsCheckBox");
        this.jBoundsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jBoundsCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 6, 0);
        this.jMostLikelyParamsPanel.add((Component)this.jBoundsCheckBox, gridBagConstraints);
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jConfidenceLabel.setLabelFor(this.jConfidenceField);
        this.jConfidenceLabel.setText("Confidence (%):");
        this.jConfidenceLabel.setName("jConfidenceLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jConfidenceLabel, gridBagConstraints);
        this.jConfidenceField.setName("jConfidenceField");
        this.jConfidenceField.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.jConfidenceField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 20, 6, 0);
        this.jMostLikelyParamsPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jFillerLabel2.setName("jFillerLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.jMostLikelyParamsPanel.add((Component)this.jFillerLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 16, 0, 6);
        this.add(this.jMostLikelyParamsPanel, gridBagConstraints);
        this.jTopNCheckBox.setText("Top N");
        this.jTopNCheckBox.setName("jTopNCheckBox");
        this.jTopNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jTopNCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.jTopNCheckBox, gridBagConstraints);
        this.jTopNParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jTopNParamsPanel.setName("jTopNParamsPanel");
        this.jTopNParamsPanel.setLayout(new GridBagLayout());
        this.jUseBestNCheckBox.setText("Use Best N");
        this.jUseBestNCheckBox.setName("jUseBestNCheckBox");
        this.jUseBestNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jUseBestNCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 10, 6, 10);
        this.jTopNParamsPanel.add((Component)this.jUseBestNCheckBox, gridBagConstraints);
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jTopNLabel.setLabelFor(this.jBestNComboBox);
        this.jTopNLabel.setText("N Value:");
        this.jTopNLabel.setName("jTopNLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jTopNLabel, gridBagConstraints);
        this.jBestNComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jBestNComboBox.setName("jBestNComboBox");
        this.jBestNComboBox.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel2.add((Component)this.jBestNComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 20, 6, 10);
        this.jTopNParamsPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.jUseCutOffCheckBox.setText("Use CutOff");
        this.jUseCutOffCheckBox.setName("jUseCutOffCheckBox");
        this.jUseCutOffCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jUseCutOffCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 6, 10);
        this.jTopNParamsPanel.add((Component)this.jUseCutOffCheckBox, gridBagConstraints);
        this.jPanel3.setName("jPanel3");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jCutOffLabel.setLabelFor(this.jCutOffField);
        this.jCutOffLabel.setText("Prob Value:");
        this.jCutOffLabel.setName("jCutOffLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jCutOffLabel, gridBagConstraints);
        this.jCutOffField.setName("jCutOffField");
        this.jCutOffField.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel3.add((Component)this.jCutOffField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 20, 6, 10);
        this.jTopNParamsPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jFillerLabel1.setName("jFillerLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.jTopNParamsPanel.add((Component)this.jFillerLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(6, 16, 0, 6);
        this.add(this.jTopNParamsPanel, gridBagConstraints);
        this.jSpecificCheckBox.setText("Specific");
        this.jSpecificCheckBox.setName("jSpecificCheckBox");
        this.jSpecificCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplySettingsPage.this.jSpecificCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add(this.jSpecificCheckBox, gridBagConstraints);
        this.jSpecificParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jSpecificParamsPanel.setName("jSpecificParamsPanel");
        this.transparentPanel1.setName("transparentPanel1");
        this.componentWithTitlebar.setName("componentWithTitlebar");
        GroupLayout groupLayout = new GroupLayout((Container)this.transparentPanel1);
        this.transparentPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.componentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 484, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.componentWithTitlebar, -1, 28, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this.jSpecificParamsPanel);
        this.jSpecificParamsPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.transparentPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.transparentPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 16, 6, 6);
        this.add(this.jSpecificParamsPanel, gridBagConstraints);
        this.jFillerLabel.setName("jFillerLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        this.add(this.jFillerLabel, gridBagConstraints);
    }

    private void jMostLikelyCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jMostLikelyCheckBox.isSelected();
        if (!bl) {
            this.jRuleCheckBox.setSelected(bl);
            this.jBoundsCheckBox.setSelected(bl);
        }
    }

    private void jTopNCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jTopNCheckBox.isSelected();
        if (!bl) {
            this.jUseBestNCheckBox.setSelected(bl);
            this.jUseCutOffCheckBox.setSelected(bl);
        }
    }

    private void jSpecificCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jRuleCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jRuleCheckBox.isSelected();
        boolean bl2 = this.jBoundsCheckBox.isSelected();
        boolean bl3 = bl ? bl : bl2;
        this.jMostLikelyCheckBox.setSelected(bl3);
    }

    private void jBoundsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jBoundsCheckBox.isSelected();
        boolean bl2 = this.jRuleCheckBox.isSelected();
        boolean bl3 = bl ? bl : bl2;
        this.jMostLikelyCheckBox.setSelected(bl3);
    }

    private void jUseCutOffCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jUseCutOffCheckBox.isSelected();
        boolean bl2 = this.jUseBestNCheckBox.isSelected();
        boolean bl3 = bl ? bl : bl2;
        this.jTopNCheckBox.setSelected(bl3);
    }

    private void jUseBestNCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jUseBestNCheckBox.isSelected();
        boolean bl2 = this.jUseCutOffCheckBox.isSelected();
        boolean bl3 = bl ? bl : bl2;
        this.jTopNCheckBox.setSelected(bl3);
    }

    @Override
    public String getPageDirtyKey() {
        return "outputDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        Serializable serializable;
        List<Integer> list;
        ApplyWizardModel applyWizardModel = this.getModel(traversableContext);
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        if (!(this.jMostLikelyCheckBox.isSelected() || this.jTopNCheckBox.isSelected() || this.jSpecificCheckBox.isSelected())) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OPTION_NONE_ERROR"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (!this.jMostLikelyCheckBox.isSelected()) {
            applyWizardModel.setMostLikelyParam(null);
        }
        if (!this.jRuleCheckBox.isSelected()) {
            applyWizardModel.setMostLikelyScoringParam(null);
        }
        if (!this.jBoundsCheckBox.isSelected()) {
            applyWizardModel.setMostLikelyBoundsParam(null);
        } else {
            list = (Double)((NumberTextField)this.jConfidenceField).getNumber();
            ApplyNode.DefaultPredictionBounds defaultPredictionBounds = (ApplyNode.DefaultPredictionBounds)applyWizardModel.getMostLikelyBoundsParam();
            defaultPredictionBounds.setConfidence(new Double((Double)((Object)list) / 100.0));
            try {
                defaultPredictionBounds.validate();
            }
            catch (ValidationException validationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
        }
        if (this.jTopNCheckBox.isSelected()) {
            list = null;
            boolean bl = this.jUseBestNCheckBox.isSelected();
            if (bl) {
                list = (String)this.jBestNComboBox.getSelectedItem();
            }
            serializable = null;
            boolean bl2 = this.jUseCutOffCheckBox.isSelected();
            if (bl2) {
                serializable = (Double)((NumberTextField)this.jCutOffField).getNumber();
            }
            ApplyNode.DefaultPredictionSet defaultPredictionSet = (ApplyNode.DefaultPredictionSet)applyWizardModel.getTopNParam();
            defaultPredictionSet.setUseTopN(bl);
            defaultPredictionSet.setUseCutOff(bl2);
            if (bl) {
                defaultPredictionSet.setTopN(new BigInteger((String)((Object)list)));
            }
            if (bl2) {
                defaultPredictionSet.setCutOff((Double)serializable);
            }
            try {
                defaultPredictionSet.validate();
            }
            catch (ValidationException validationException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
        } else {
            applyWizardModel.setTopNParam(null);
        }
        if (this.jSpecificCheckBox.isSelected()) {
            list = this._models.getSelecteds();
            if (list.size() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OPTION_SPECIFIC_NO_VALUES_ERROR"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (this._models.isDirty()) {
                ApplyNode.Parameters parameters = applyWizardModel.getSpecificParam();
                serializable = null;
                if (parameters instanceof ApplyNode.PredictionProbability) {
                    serializable = ((ApplyNode.PredictionProbability)parameters).getTargetValues();
                } else if (parameters instanceof ApplyNode.ClusterProbability) {
                    serializable = ((ApplyNode.ClusterProbability)parameters).getClusterIds();
                } else if (parameters instanceof ApplyNode.FeatureValue) {
                    serializable = ((ApplyNode.FeatureValue)parameters).getFeatureIds();
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((Vector)serializable).get((Integer)list.get(i)));
                }
                applyWizardModel.setSpecificValues(arrayList);
            }
        } else {
            applyWizardModel.setSpecificParam(null);
        }
        return this.validateAndWriteToState(applyWizardModel);
    }

    public boolean validateAndWriteToState(ApplyWizardModel applyWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread();
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private static class SpecificTableModel
    extends GenericBaseTableModel {
        public static String[] _targetColumnNames = new String[]{"", DialogsLrb.get("PAGE_OUTPUT_TARGET_COL")};
        public static String[] _clusterColumnNames = new String[]{"", DialogsLrb.get("PAGE_OUTPUT_CLUSTER_COL")};
        public static String[] _featureColumnNames = new String[]{"", DialogsLrb.get("PAGE_OUTPUT_FEATURE_COL")};
        public static final int SELECT_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        public static final int COLUMN_COUNT = 2;
        private List<Boolean> _selecteds = new ArrayList<Boolean>();
        private ApplyNode.Parameters _specificParam;
        private boolean dirty = false;

        public SpecificTableModel(ApplyWizardModel applyWizardModel) {
            this._specificParam = applyWizardModel.getSpecificParam();
            if (this._specificParam instanceof ApplyNode.PredictionProbability) {
                this.setColumnIdentifiers(_targetColumnNames);
            } else if (this._specificParam instanceof ApplyNode.ClusterProbability) {
                this.setColumnIdentifiers(_clusterColumnNames);
            } else if (this._specificParam instanceof ApplyNode.FeatureValue) {
                this.setColumnIdentifiers(_featureColumnNames);
            }
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
            if (this.getRowCount() > 0) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    this._selecteds.add(Boolean.FALSE);
                }
            }
        }

        public int getRowCount() {
            Vector<Object> vector = null;
            if (this._specificParam instanceof ApplyNode.PredictionProbability) {
                vector = ((ApplyNode.PredictionProbability)this._specificParam).getTargetValues();
            } else if (this._specificParam instanceof ApplyNode.ClusterProbability) {
                vector = ((ApplyNode.ClusterProbability)this._specificParam).getClusterIds();
            } else if (this._specificParam instanceof ApplyNode.FeatureValue) {
                vector = ((ApplyNode.FeatureValue)this._specificParam).getFeatureIds();
            }
            return vector != null ? vector.size() : 0;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            Object object = this.getValueAt(0, 1);
            return object.getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                Boolean bl;
                if (!this.dirty && (bl = this._selecteds.get(n)) != (Boolean)object) {
                    this.dirty = true;
                }
                this._selecteds.set(n, (Boolean)object);
            }
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            Vector<Object> vector = null;
            if (this._specificParam instanceof ApplyNode.PredictionProbability) {
                vector = ((ApplyNode.PredictionProbability)this._specificParam).getTargetValues();
            } else if (this._specificParam instanceof ApplyNode.ClusterProbability) {
                vector = ((ApplyNode.ClusterProbability)this._specificParam).getClusterIds();
            } else if (this._specificParam instanceof ApplyNode.FeatureValue) {
                vector = ((ApplyNode.FeatureValue)this._specificParam).getFeatureIds();
            }
            Object object = null;
            switch (n2) {
                case 0: {
                    object = this._selecteds.get(n);
                    break;
                }
                case 1: {
                    object = vector.get(n);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public List<Integer> getSelecteds() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this._selecteds.size(); ++i) {
                if (this._selecteds.get(i) != Boolean.TRUE) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }

    class ValidateWriteThread
    extends ProgressRunnable {
        boolean _validated = true;
        private boolean _canceled = false;
        private boolean _forceUpdate = false;

        ValidateWriteThread() {
        }

        public boolean getForceUpdate() {
            return this._forceUpdate;
        }

        public void setForceUpdate(boolean bl) {
            this._forceUpdate = bl;
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                this._validated = true;
            }
            catch (Exception exception) {
                this._validated = false;
            }
            return null;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

