/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyDataPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyModelsPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.dialogs.ExceptionDialog;

public class ApplyEditorPanel
extends AbstractDialogPanel {
    private PropertyModel _model;
    private ApplyNode _node;
    private ApplyModelsPanel _modelPanel;
    private ApplyDataPanel _dataPanel;
    private String _outputOrder;
    private JComboBox jOutputOrderComboBox;
    private JLabel jOutputOrderLabel;
    private JTabbedPane jTabbedPane;
    private static String APPLY_MODEL_TAB = DialogsLrb.get("APPLY_MODEL_TAB");
    private static String APPLY_DATA_TAB = DialogsLrb.get("APPLY_DATA_TAB");

    public ApplyEditorPanel(JEWTDialog jEWTDialog, Context context, ApplyNode applyNode, PropertyModel propertyModel) {
        super(context, applyNode);
        assert (context != null) : "Context must not be null.";
        assert (applyNode != null) : "Apply node must not be null.";
        assert (applyNode instanceof ApplyNode) : "Must be an instance of apply node.";
        this._context = context;
        this._model = propertyModel;
        this._node = applyNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"apply_editor");
        this._modelPanel = new ApplyModelsPanel(this._context, this._node, this._model);
        this.jTabbedPane.add(APPLY_MODEL_TAB, this._modelPanel);
        this._dataPanel = new ApplyDataPanel(this._context, this._node, this._model);
        this.jTabbedPane.add(APPLY_DATA_TAB, this._dataPanel);
        this.jOutputOrderComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA"), DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_APPLY")}));
        this._outputOrder = ((ApplyNodeType)this._node.getData()).getColumnOutputOrder();
        if (this._outputOrder.equals("SupplementalColumns")) {
            this.jOutputOrderComboBox.setSelectedItem(DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA"));
        } else {
            this.jOutputOrderComboBox.setSelectedItem(DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_APPLY"));
        }
    }

    @Override
    public void initRes() {
        this.jOutputOrderLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING")));
        this.jOutputOrderLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING")));
        this.jOutputOrderLabel.getAccessibleContext().setAccessibleName("PREF_OUTPUT_ORDER_SETTING");
        this.jOutputOrderLabel.getAccessibleContext().setAccessibleDescription("PREF_OUTPUT_ORDER_SETTING_ADA");
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jOutputOrderLabel = new JLabel();
        this.jOutputOrderComboBox = new JComboBox();
        this.setPreferredSize(new Dimension(950, 400));
        this.jTabbedPane.setName("jTabbedPane");
        this.jOutputOrderLabel.setLabelFor(this.jOutputOrderComboBox);
        this.jOutputOrderLabel.setText("Column Output Order:");
        this.jOutputOrderLabel.setName("jOutputOrderLabel");
        this.jOutputOrderComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jOutputOrderComboBox.setName("jOutputOrderComboBox");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 930, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jOutputOrderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOutputOrderComboBox, -2, 173, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOutputOrderLabel).addComponent(this.jOutputOrderComboBox, -2, -1, -2)).addContainerGap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        boolean bl = true;
        String string = (String)this.jOutputOrderComboBox.getSelectedItem();
        string = string.equals(DialogsLrb.get("PREF_OUTPUT_ORDER_SETTING_DATA")) ? "SupplementalColumns" : "OutputColumns";
        if (this._modelPanel.isDirty() || this._dataPanel.isDirty() || !this._outputOrder.equals(string)) {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("APPLY_NODE_EDIT_TRANSACTION_NAME"));
            try {
                boolean bl2 = false;
                ArrayList<Property> arrayList = new ArrayList<Property>();
                if (!this._outputOrder.equals(string)) {
                    arrayList.add(new Property("applyColumnOutputOrder", null, string, null, null));
                    bl2 = true;
                }
                if (this._modelPanel.isDirty() && this._model == null) {
                    arrayList.add(new Property("applyScoreOutputColumns", null, this._modelPanel.getApplyOutputColumns(), null, null));
                    bl2 = true;
                }
                if (this._dataPanel.isDirty() && this._model == null) {
                    arrayList.add(new Property("applySupplementalColumns", null, this._dataPanel.getSupplementalAttributes(), null, null));
                    bl2 = true;
                }
                if (bl2) {
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                    odmrSDMUndoFilter.prepareUndoPropertyList(this._node, this.getContext(), arrayList);
                    this._node.validate(true);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("APPLY_NODE_EDIT_ERROR_MESG"), null);
                CommandProcessor.getInstance().abortTrans();
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }
        return bl;
    }
}

