/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.SuppAttrsDialog;
import oracle.dmt.dataminer.workflow.dialog.apply.SuppAttrsPanel;
import oracle.dmt.dataminer.workflow.inspect.ApplyNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowApplyNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowPIComponent;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class ApplyDataPanel
extends AbstractDialogPanel {
    private WorkflowApplyNodePropertyProxyModel _propertyModel;
    private AttrsTableModel _models;
    private NiceTableWithToolbar _tableWithToolbar;
    private static Icon _invalid_icon;
    private static Icon _valid_icon;
    private JButton _removeBtn;
    private JButton _addBtn;
    private SupplementalAttributesType _supplementalAttributes;
    private boolean _dirty;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar;
    private JCheckBox jAutoSettingsCheckBox;

    public ApplyDataPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for apply node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((ApplyNode)this._data, propertyModel);
    }

    public ApplyDataPanel(Context context, ApplyNode applyNode, PropertyModel propertyModel) {
        super(context, applyNode);
        assert (context != null) : "Context must not be null.";
        assert (applyNode != null) : "Apply node must not be null.";
        assert (applyNode instanceof ApplyNode) : "Must be an instance of apply node.";
        this.init(applyNode, propertyModel);
    }

    private void init(ApplyNode applyNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        this._supplementalAttributes = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(applyNodeType.getSupplementalAttributes());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ApplyNode applyNode = (ApplyNode)workflowNodeInspectorElement.getNode();
        if (applyNode == null) {
            return;
        }
        this._propertyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = applyNode;
        this._dirty = false;
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        this._supplementalAttributes = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(applyNodeType.getSupplementalAttributes());
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ApplyNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ApplyNodeType) {
            return (ApplyNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        if (this._dirty && this._propertyModel != null) {
            ApplyNode applyNode = (ApplyNode)this.getData();
            ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
            ComplexProperty complexProperty = new ComplexProperty("applySupplementalColumns", this._supplementalAttributes);
            SupplementalAttributesType supplementalAttributesType = (SupplementalAttributesType)MetaDataHelper.copyMetadataObject(applyNodeType.getSupplementalAttributes());
            complexProperty.setOldData(supplementalAttributesType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ApplyNodePropertyModel.RowIndex.APPLY_SUPPLEMENTAL_COLUMNS), null, complexProperty, null, null));
            this._propertyModel.setValueAt(PropertyLrb.get("PI_APPLY_GROUP_SUPPLEMENTAL_COLUMNS"), applyNode, arrayList);
        }
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("APPLY_AUTO_SETTING"), this.jAutoSettingsCheckBox);
        UIResourceHelper.setComponentText(hashMap);
        Class<WorkflowPIComponent> clazz = WorkflowPIComponent.class;
        Class<WorkflowEditor> clazz2 = WorkflowEditor.class;
        if (_invalid_icon == null) {
            _invalid_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
        }
        if (_valid_icon == null) {
            _valid_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
        }
    }

    @Override
    public void initUI() {
        this.jAutoSettingsCheckBox.setVisible(false);
        this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
        ControlBar controlBar = new ControlBar();
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(DialogsLrb.get("APPLY_DATA_EDIT_OUTPUT_COLUMNS"));
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DialogsLrb.get("APPLY_DATA_DELETE_OUTPUT_COLUMNS"));
        this._removeBtn.setEnabled(false);
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        this._tableWithToolbar = new NiceTableWithToolbar(this.componentWithTitlebar, controlBar, AttrsTableModel._columnNames, this._models);
        this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("APPLY_DATA_TABLE_TITLE")));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyDataPanel.this.processAdd();
            }
        });
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_DATA_REMOVE_ATTRIBUTE"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                ApplyDataPanel.this.processRemove();
            }
        });
        this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ApplyDataPanel.this.handleModelSelectionChanged();
            }
        });
        TableColumn tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(1);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor();
        tableColumn.setCellEditor(dBObjectNameEditor);
        this.enableControls();
    }

    private void enableControls() {
        ApplyNode applyNode = (ApplyNode)this.getData();
        DataProvider dataProvider = (DataProvider)((Object)applyNode.findApplyDataNode(applyNode.getModel()));
        boolean bl = this._supplementalAttributes.getAutoSpec().value().compareTo("Yes") == 0;
        this.jAutoSettingsCheckBox.setSelected(bl);
        this.jAutoSettingsCheckBox.setEnabled(this.isWritable());
        int n = this._tableWithToolbar.getNiceTable().getSelectedRowCount();
        this._addBtn.setEnabled(this.isWritable() && !bl && dataProvider != null);
        this._removeBtn.setEnabled(this.isWritable() && !bl && n > 0);
    }

    private void processAdd() {
        SuppAttrsPanel suppAttrsPanel;
        SuppAttrsDialog suppAttrsDialog = new SuppAttrsDialog();
        ApplyNode applyNode = (ApplyNode)this.getData();
        DataProvider dataProvider = (DataProvider)((Object)applyNode.findApplyDataNode(applyNode.getModel()));
        if (suppAttrsDialog.invoke(this.getContext(), this, dataProvider, this._supplementalAttributes) && (suppAttrsPanel = suppAttrsDialog.getPanel()).isDirty()) {
            List<AttributeType> list = suppAttrsPanel.getSelectedAttrsCache();
            this._supplementalAttributes.getAttribute().clear();
            this._supplementalAttributes.getAttribute().addAll(list);
            this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
            this._tableWithToolbar.resetNiceTableModel(this._models);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    private void processRemove() {
        int[] nArray = this._tableWithToolbar.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            AttributeType attributeType = (AttributeType)this._supplementalAttributes.getAttribute().get(n);
            arrayList.add(attributeType);
        }
        for (AttributeType attributeType : arrayList) {
            this._supplementalAttributes.getAttribute().remove(attributeType);
        }
        this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
        this._tableWithToolbar.resetNiceTableModel(this._models);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
    }

    private void processRemoveAll() {
        this._supplementalAttributes.getAttribute().clear();
        this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
        this._tableWithToolbar.resetNiceTableModel(this._models);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private void initComponents() {
        this.jAutoSettingsCheckBox = new JCheckBox();
        this.componentWithTitlebar = new ComponentWithTitlebar();
        this.setPreferredSize(new Dimension(950, 400));
        this.jAutoSettingsCheckBox.setText("Automatic Settings");
        this.jAutoSettingsCheckBox.setName("jAutoSettingsCheckBox");
        this.jAutoSettingsCheckBox.setOpaque(false);
        this.jAutoSettingsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyDataPanel.this.jAutoSettingsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.componentWithTitlebar.setAutoscrolls(true);
        this.componentWithTitlebar.setName("componentWithTitlebar");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAutoSettingsCheckBox).addComponent((Component)this.componentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 930, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoSettingsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.componentWithTitlebar, -1, 357, Short.MAX_VALUE).addContainerGap()));
    }

    private void jAutoSettingsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jAutoSettingsCheckBox.isSelected();
        if (bl) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_DATA_AUTO_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jAutoSettingsCheckBox.setSelected(false);
                return;
            }
            if (this._propertyModel != null) {
                this._supplementalAttributes.setAutoSpec(AutoSpecType.fromValue((String)"Yes"));
                this._supplementalAttributes.getAttribute().clear();
                this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
                this._tableWithToolbar.resetNiceTableModel(this._models);
                ApplyNode.addSupplAttrs(this._supplementalAttributes, (ApplyNode)this.getData());
                this._dirty = true;
                this.updateNode();
            } else {
                this.processRemoveAll();
                this._supplementalAttributes.setAutoSpec(AutoSpecType.fromValue((String)"Yes"));
                ApplyNode.addSupplAttrs(this._supplementalAttributes, (ApplyNode)this.getData());
                this._models = new AttrsTableModel(this._context, this, this._supplementalAttributes.getAttribute());
                this._tableWithToolbar.resetNiceTableModel(this._models);
            }
        } else {
            this._supplementalAttributes.setAutoSpec(AutoSpecType.fromValue((String)"No"));
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
        this.enableControls();
    }

    public SupplementalAttributesType getSupplementalAttributes() {
        return this._supplementalAttributes;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public NiceTableWithToolbar getTableWithToolbar() {
        return this._tableWithToolbar;
    }

    private static class AttrsTableModel
    extends GenericBaseTableModel {
        public static String[] _columnNames = new String[]{DialogsLrb.get("APPLY_MODEL_COLUMN"), DialogsLrb.get("APPLY_DATA_ALIAS"), DialogsLrb.get("APPLY_DATA_TYPE")};
        public static final int MODEL_COLUMN = 0;
        public static final int DATA_ALIAS = 1;
        public static final int DATA_TYPE = 2;
        public static final int COLUMN_COUNT = 3;
        private Context _context;
        private ApplyDataPanel _parent;
        private List<AttributeType> _srcData;

        public AttrsTableModel(Context context, ApplyDataPanel applyDataPanel, List<AttributeType> list) {
            this._context = context;
            this._parent = applyDataPanel;
            this._srcData = list;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return this._parent.isWritable();
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            AttributeType attributeType = this._srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = attributeType.getName();
                    break;
                }
                case 1: {
                    string = attributeType.getAlias();
                    break;
                }
                case 2: {
                    string = attributeType.getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            AttributeType attributeType = this._srcData.get(n);
            String string = null;
            String string2 = attributeType.getAlias();
            if (object != null) {
                string = ((String)object).trim();
            }
            if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                string2 = StringUtils.addDoubleQuotes(string2);
            }
            if (string.length() != 0) {
                if (!StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                if (!AttributeNameValidator.validateAttributeName(string, this._srcData, this._context, true)) {
                    return;
                }
            }
            if (string2 != null && string2.compareTo(string) == 0) {
                return;
            }
            string = StringUtils.trimDoubleQuotes(string);
            attributeType.setAlias(string);
            this._parent.setDirty(true);
            this._parent.updateNode();
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = ApplyDataPanel.this._tableWithToolbar.convertRowToModelIndex(n);
            AttributeType attributeType = (AttributeType)ApplyDataPanel.this._supplementalAttributes.getAttribute().get(n3);
            AttributeStatus attributeStatus = attributeType.getStatus();
            if (attributeStatus == AttributeStatus.VALID) {
                this.setIcon(_valid_icon);
            } else {
                this.setIcon(_invalid_icon);
            }
            return component;
        }
    }
}

