/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.validate.Validator;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.GenericTableValidationComponent;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AbstractAggregationWizardPage;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;

public class AggregateEditAttributesPanel
extends AbstractAggregationWizardPage
implements DataminerGUIPanel,
DataConsumerPanel {
    protected List<AttributeType> availAttrsTotal;
    protected List<AttributeType> availAttrsCache;
    protected List<AttributeType> selectedAttrsCache = new ArrayList<AttributeType>();
    private Context _context;
    private GroupingElementType _currentGroupByElement;
    private Boolean _wizardMode = Boolean.FALSE;
    private String[] _colNames = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
    private JScrollPane _jDescriptionScrollPane;
    private ComponentWithTitlebar<JComponent> jAvailAttrComponentWithTitlebar;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private ComponentWithTitlebar<JComponent> jSelAttrComponentWithTitlebar;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private static Icon _invalidAttrIcon;
    private static Icon _select;
    private static Icon _selectAll;
    private static Icon _remove;
    private static Icon _removeAll;
    private GenericTable jSelectedAttrs = new GenericTable();
    private GenericTable jAvailAttrs = new GenericTable();
    private SearchField _searchField;
    private JComponent _findPane;
    public static final int FILTER_ATTRIBUTE_NAME = 0;
    public static final int FILTER_ATTRIBUTE_TYPE = 1;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(DataDialogsLrb.get("NAME_COLUMN"));
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private Boolean _wizard = Boolean.FALSE;
    private ValidationMessagePane _validationPanel;
    private GenericTableValidationComponent _validationComponent;
    private static String warningNum;
    private static String warningChar;
    private static AttributeTypeHelper.AttributeTypeComparator _comparator;

    @Override
    public String getPageDirtyKey() {
        return "columnsDirty";
    }

    @Override
    protected String getValidationMessage() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_PAGE_VALIDATION_MESSAGE");
    }

    @Override
    protected String getValidationTitle() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_PAGE_VALIDATE_TITLE");
    }

    @Override
    protected String getValidationFailedMessage() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_PAGE_VALIDATION_FAILED");
    }

    @Override
    protected void pageSelected(TraversableContext traversableContext) {
        super.pageSelected(traversableContext);
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        boolean bl;
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        boolean bl2 = bl = null != this.selectedAttrsCache && !this.selectedAttrsCache.isEmpty();
        if (!bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_NO_COLUMNS"), (String)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_TITLE"), null);
        }
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        aggregationWizardModel.setSelectedAttrs(this.selectedAttrsCache);
        return bl;
    }

    public AggregateEditAttributesPanel(Context context, List<AttributeType> list, GroupingElementType groupingElementType) {
        this(context, list, groupingElementType, Boolean.FALSE);
    }

    public AggregateEditAttributesPanel(Context context, List<AttributeType> list, GroupingElementType groupingElementType, Boolean bl) {
        List<AttributeType> list2;
        this._wizardMode = bl;
        assert (list != null) : "Available attribute collection must not be null";
        this._currentGroupByElement = groupingElementType;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        if (null != this._currentGroupByElement.getAttributes()) {
            list2 = this._currentGroupByElement.getAttributes().getAttribute();
            if (!this._currentGroupByElement.getAttributes().getAttribute().isEmpty()) {
                for (AttributeType attributeType : list2) {
                    hashMap.put(attributeType.getName(), attributeType);
                }
            }
        }
        list2 = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (null != hashMap.get(list.get(i).getName())) continue;
            ((ArrayList)list2).add(list.get(i));
        }
        this.availAttrsCache = list2;
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.availAttrsTotal.addAll(list2);
        this._context = context;
        this.initComponents();
        this.initRes();
        if (bl == null || bl.equals(Boolean.FALSE)) {
            this.initUI();
        } else {
            this.creatValidationMessagePane();
        }
    }

    private void initComponents() {
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jAvailAttrComponentWithTitlebar = new ComponentWithTitlebar();
        this.jSelAttrComponentWithTitlebar = new ComponentWithTitlebar();
        this._jDescriptionScrollPane = new JScrollPane();
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this._jDescriptionScrollPane.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAvailAttrComponentWithTitlebar, -1, 281, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -2, 49, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jSelAttrComponentWithTitlebar, -1, 281, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(13, 13, 13).addComponent(this._jDescriptionScrollPane, -1, 620, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jDescriptionScrollPane, -2, 23, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAvailAttrComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 181, Short.MAX_VALUE).addComponent((Component)this.jSelAttrComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 181, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn))).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.initIcons();
        if (this._wizardMode.equals(Boolean.TRUE)) {
            this._jDescription.setText(AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_PAGE_DESCRIPTION"));
            this._jDescriptionScrollPane.getViewport().add((Component)this._jDescription);
        } else {
            this._jDescriptionScrollPane.setVisible(false);
        }
    }

    private void initIcons() {
        if (_invalidAttrIcon == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _invalidAttrIcon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _select = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHT"));
            _selectAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHTALL"));
            _remove = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFT"));
            _removeAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFTALL"));
        }
        this.jSelectBtn.setIcon(_select);
        this.jSelectAllBtn.setIcon(_selectAll);
        this.jRemoveBtn.setIcon(_remove);
        this.jRemoveAllBtn.setIcon(_removeAll);
    }

    protected List<AttributeType> getSelectedAttributes() {
        return null != this._currentGroupByElement.getAttributes() ? this._currentGroupByElement.getAttributes().getAttribute() : new ArrayList();
    }

    private void initSelectedAttributesCache(List<AttributeType> list) {
        for (AttributeType object : list) {
            AttributeType attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object);
            this.selectedAttrsCache.add(attributeType);
        }
        HashMap hashMap = new HashMap(this.availAttrsTotal.size());
        for (AttributeType attributeType : this.availAttrsTotal) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        for (AttributeType attributeType : this.selectedAttrsCache) {
            if (null != hashMap.get(attributeType.getName())) continue;
            this.availAttrsTotal.add(attributeType);
            hashMap.put(attributeType.getName(), attributeType);
        }
    }

    @Override
    public void initUI() {
        List<AttributeType> list = this.getSelectedAttributes();
        Collections.sort(list, new AttributeTypeComparator());
        this.initSelectedAttributesCache(list);
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        JScrollPane jScrollPane = new JScrollPane((Component)this.jAvailAttrs);
        this.jAvailAttrs.setFillsViewportHeight(true);
        this.jAvailAttrComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.jAvailAttrComponentWithTitlebar.setLabel(new JLabel(DataDialogsLrb.get("AVAILABLE_LABEL")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this.jAvailAttrComponentWithTitlebar.setControlBar(controlBar);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.jSelectedAttrs);
        this.jSelectedAttrs.setFillsViewportHeight(true);
        this.jSelAttrComponentWithTitlebar.setComponent((JComponent)jScrollPane2);
        this.jSelAttrComponentWithTitlebar.setLabel(new JLabel(DataDialogsLrb.get("SELECTED_LABEL")));
        ControlBar controlBar2 = new ControlBar();
        this.jSelAttrComponentWithTitlebar.setControlBar(controlBar2);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.jAvailAttrs, AggregateEditAttributesPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.jAvailAttrs, AggregateEditAttributesPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.jSelectedAttrs, AggregateEditAttributesPanel.this.jAvailAttrs, false);
                String string = AggregateEditAttributesPanel.this._searchField.getText();
                AggregateEditAttributesPanel.this.translateSearchCategoryToConstant(AggregateEditAttributesPanel.this._searchField.getSelectedCategory());
                AggregateEditAttributesPanel.this.processFilter(string);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateEditAttributesPanel.this.moveItems(AggregateEditAttributesPanel.this.jSelectedAttrs, AggregateEditAttributesPanel.this.jAvailAttrs, true);
                String string = AggregateEditAttributesPanel.this._searchField.getText();
                AggregateEditAttributesPanel.this.translateSearchCategoryToConstant(AggregateEditAttributesPanel.this._searchField.getSelectedCategory());
                AggregateEditAttributesPanel.this.processFilter(string);
            }
        });
        this.initializeTables();
        this.jSelectBtn.setEnabled(false);
        this.jRemoveBtn.setEnabled(false);
        this.jAvailAttrs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AggregateEditAttributesPanel.this.jSelectBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
            }
        });
        this.jSelectedAttrs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AggregateEditAttributesPanel.this.jRemoveBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
            }
        });
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._searchField);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                AggregateEditAttributesPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                AggregateEditAttributesPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                AggregateEditAttributesPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                AggregateEditAttributesPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void processFilter(String string) {
        try {
            List<AttributeType> list = this.getCurrentlyAvailable();
            if (list != null && !list.isEmpty()) {
                AttrTableModel attrTableModel = this.getFilteredAttributesTableModel(list, string, this._currentSearchCategory);
                this.setupAvialableTable(attrTableModel);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("DATA_SOURCE_QUERY_FAILURE_TITLE"), (String)DataDialogsLrb.get("DATA_SOURCE_QUERY_FAILURE_MSG"), null);
        }
    }

    public AttrTableModel getFilteredAttributesTableModel(List<AttributeType> list, String string, int n) throws Exception {
        Vector<AttributeType> vector = new Vector<AttributeType>();
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Iterator<AttributeType> iterator = list.iterator();
        AttributeType attributeType = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            attributeType = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = "";
                switch (n) {
                    case 0: {
                        string2 = attributeType.getName();
                        break;
                    }
                    case 1: {
                        string2 = attributeType.getDataType();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid item filter category.";
                        string2 = null;
                    }
                }
                bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(attributeType);
        }
        return new AttrTableModel(vector);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 0;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(DataDialogsLrb.get("DATATYPE_COLUMN")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    private synchronized void translateSearchCategoryToConstant(SearchCategory searchCategory) {
        if (searchCategory.getLabel().equals(DataDialogsLrb.get("NAME_COLUMN"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(DataDialogsLrb.get("DATATYPE_COLUMN"))) {
            this._currentSearchCategory = 1;
        } else assert (false) : "Invalid Search Category Code";
    }

    private void removeInvalidDataTypes(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            if (DatabaseMetadataUtils.isDataTypeSupported(attributeType.getDataType())) continue;
            arrayList.add(attributeType);
        }
        list.removeAll(arrayList);
    }

    private void initializeTables() {
        this.removeInvalidDataTypes(this.availAttrsCache);
        AttrTableModel attrTableModel = new AttrTableModel(this.availAttrsCache);
        this.setupAvialableTable(attrTableModel);
        AttrTableModel attrTableModel2 = new AttrTableModel(this.selectedAttrsCache);
        this.setupSelectedTable(attrTableModel2);
        if (!this._wizardMode.booleanValue()) {
            return;
        }
        if (this._validationComponent != null) {
            this.validateAttributeSelection();
        }
        this.jSelectedAttrs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                if (AggregateEditAttributesPanel.this._validationComponent != null) {
                    AggregateEditAttributesPanel.this.validateAttributeSelection();
                }
            }
        });
    }

    private void setupSelectedTable(AttrTableModel attrTableModel) {
        this.jSelectedAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jSelectedAttrs.setSorted(true);
        TableColumn tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(null, _invalidAttrIcon);
        tableColumn.setCellRenderer(attributeNameCellRenderer);
    }

    private void setupAvialableTable(AttrTableModel attrTableModel) {
        this.jAvailAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(null, _invalidAttrIcon);
        tableColumn.setCellRenderer(attributeNameCellRenderer);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<AttributeType> list = ((AttrTableModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = list.get(nArray[n2]);
                arrayList.add((AttributeType)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List<AttributeType> list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (AttributeType)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
    }

    private List<AttributeType> getCurrentlyAvailable() {
        AttrTableModel attrTableModel = (AttrTableModel)((Object)this.jSelectedAttrs.getModel());
        List<AttributeType> list = attrTableModel.getDataList();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        arrayList.addAll(this.availAttrsTotal);
        this.removeSelectedAttrs(arrayList, list);
        return arrayList;
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    public Context getContext() {
        return this._context;
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        if (bl) {
            Attributes attributes = new Attributes();
            List list = attributes.getAttribute();
            list.addAll(this.selectedAttrsCache);
            this._currentGroupByElement.setAttributes(attributes);
            this._currentGroupByElement.setExpression(null);
        }
        return bl;
    }

    @Override
    protected void pageDeselected(TraversableContext traversableContext) throws TraversalException {
        super.pageDeselected(traversableContext);
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        aggregationWizardModel.getWizard().setValidationMessagePane(null);
    }

    private void validateAttributeSelection() {
        AttrTableModel attrTableModel = (AttrTableModel)((Object)this.jSelectedAttrs.getModel());
        List<AttributeType> list = attrTableModel.getDataList();
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        boolean bl = null != aggregationWizardModel.getSelectedNumericFunctions() && !aggregationWizardModel.getSelectedNumericFunctions().isEmpty();
        boolean bl2 = null != aggregationWizardModel.getSelectedCharFunctions() && !aggregationWizardModel.getSelectedCharFunctions().isEmpty();
        Vector<ValidationMessage> vector = new Vector<ValidationMessage>();
        if (list == null || list.isEmpty()) {
            if (bl) {
                vector.add(new ValidationMessage(2, warningNum));
            }
            if (bl2) {
                vector.add(new ValidationMessage(2, warningChar));
            }
        } else {
            boolean bl3 = false;
            boolean bl4 = false;
            for (AttributeType attributeType : list) {
                if (bl3 && bl4) break;
                if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                if (!bl4 && attributeType.getDataType().equals("VARCHAR2")) {
                    bl4 = true;
                    continue;
                }
                if (bl3 || !attributeType.getDataType().equals("NUMBER")) continue;
                bl3 = true;
            }
            if (bl && !bl3) {
                vector.add(new ValidationMessage(2, warningNum));
            } else if (bl2 && !bl4) {
                vector.add(new ValidationMessage(2, warningChar));
            }
        }
        this._validationComponent.getValidationMessageModel().clear();
        if (!vector.isEmpty()) {
            this._validationComponent.getValidationMessageModel().addValidationMessages(vector.toArray(new ValidationMessage[vector.size()]));
        }
    }

    @Override
    protected void onEntryAfterInit(TraversableContext traversableContext) {
        if (this.isUiInitialized()) {
            if (this._validationComponent != null) {
                this.validateAttributeSelection();
            }
            this._validationPanel.addValidationComponent((ValidationComponent)this._validationComponent);
        }
    }

    private void hideOrShowMessagePane() {
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        if (this._validationComponent.getValidationMessageModel().getMessageCount() > 0) {
            this._validationPanel.addValidationComponent((ValidationComponent)this._validationComponent);
            aggregationWizardModel.getWizard().setValidationMessagePane(this.getWizardValidationPanel());
        } else {
            aggregationWizardModel.getWizard().setValidationMessagePane(null);
        }
    }

    protected ValidationMessagePane getWizardValidationPanel() {
        if (this._validationPanel == null) {
            this.creatValidationMessagePane();
        }
        return this._validationPanel;
    }

    private void creatValidationMessagePane() {
        MessageListener messageListener = new MessageListener();
        this._validationPanel = new ValidationMessagePane();
        this._validationPanel.addPropertyChangeListener((PropertyChangeListener)messageListener);
        this._validationComponent = new GenericTableValidationComponent(new GenericTable());
        AttributeSelectionValidator attributeSelectionValidator = new AttributeSelectionValidator();
        this._validationComponent.addValidator(this.jSelectedAttrs, attributeSelectionValidator);
        this._validationPanel.addValidationComponent((ValidationComponent)this._validationComponent);
        this._validationComponent.addValidationMessageModelListener(new MessageModelListener());
    }

    static {
        warningNum = AggregateDialogsLrb.get("AGGREGATE_WIZ_WARNING_NUMERIC");
        warningChar = AggregateDialogsLrb.get("AGGREGATE_WIZ_WARNING_CHARACTER");
        _comparator = new AttributeTypeHelper.AttributeTypeComparator();
    }

    class AttrTableModel
    extends GenericBaseTableModel {
        private List<AttributeType> _data;
        private final int NAME = 0;
        private final int DATA_TYPE = 1;
        private final int COLUMN_COUNT = 2;

        public AttrTableModel(List<AttributeType> list) {
            this._data = list;
            this.setColumnIdentifiers(AggregateEditAttributesPanel.this._colNames);
            this.setRowCount(this._data.size());
            this.setColumnCount(2);
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            AttributeType attributeType = this._data.get(n);
            if (0 == n2) {
                object = attributeType;
            } else if (1 == n2) {
                assert (n2 > 0 && n2 < this.getColumnCount()) : "Column out of bounds";
                object = attributeType.getDataType();
            }
            return object;
        }

        public List<AttributeType> getDataList() {
            return this._data;
        }

        public Comparator getColumnSortComparator(int n) {
            if (0 == n) {
                return _comparator;
            }
            return super.getColumnSortComparator(n);
        }
    }

    private class AttributeSelectionValidator
    implements Validator {
        private AttributeSelectionValidator() {
        }

        public ValidationMessage[] validate(Component component, Object object) {
            assert (object instanceof AggregationWizardModel) : "Data parameter must be a AggregationWizardModel";
            Vector<ValidationMessage> vector = new Vector<ValidationMessage>();
            AggregationWizardModel aggregationWizardModel = (AggregationWizardModel)object;
            aggregationWizardModel.validateSelectedAttributes(vector);
            ValidationMessage[] validationMessageArray = new ValidationMessage[vector.size()];
            return vector.toArray(validationMessageArray);
        }
    }

    private class MessageModelListener
    implements ValidationMessageModelListener {
        private MessageModelListener() {
        }

        public void messageAdded(ValidationMessageModelEvent validationMessageModelEvent) {
            AggregateEditAttributesPanel.this.hideOrShowMessagePane();
        }

        public void messageRemoved(ValidationMessageModelEvent validationMessageModelEvent) {
            AggregateEditAttributesPanel.this.hideOrShowMessagePane();
        }
    }

    private class MessageListener
    implements PropertyChangeListener {
        private MessageListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof ValidationMessagePane && ValidationMessagePane.PANE_EMPTY.equals(propertyChangeEvent.getPropertyName())) {
                AggregateEditAttributesPanel.this.hideOrShowMessagePane();
            }
        }
    }
}

