/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.JLabelTableCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public class ShowMessagesDialog {
    protected JEWTDialog _dlg;
    protected String wizName = "showValidations";
    Node selectedNode;
    private static String[] columns = new String[]{WorkflowDialogLrb.get("MESSAGE_COLUMN_TITLE")};

    public ShowMessagesDialog(Node node) {
        this.selectedNode = node;
    }

    protected JEWTDialog buildDialog() {
        ValidationErrorsPanel validationErrorsPanel = new ValidationErrorsPanel(this.selectedNode.getData().getMessages().getMessage());
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 20;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)validationErrorsPanel);
        jEWTDialog.setTitle(WorkflowDialogLrb.get("DIALOG_TITLE"));
        return jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke() {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog();
            jEWTDialog.setResizable(true);
            final ValidationErrorsPanel validationErrorsPanel = (ValidationErrorsPanel)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !validationErrorsPanel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    class ValidationsTableModel
    extends GenericBaseTableModel {
        private transient List<MessageType> _data;
        public static final int MESSAGE = 0;
        private static final int COLUMN_COUNT = 1;

        public ValidationsTableModel(List<MessageType> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return MessageType.class;
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            MessageType messageType = this._data.get(n);
            MessageType messageType2 = null;
            switch (n2) {
                case 0: {
                    messageType2 = messageType;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return messageType2;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public List<MessageType> getDataList() {
            return this._data;
        }
    }

    class MessageCellRenderer
    extends JLabelTableCellRenderer {
        MessageCellRenderer() {
        }

        @Override
        protected Icon getCellIcon(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.getMessageIcon((MessageType)object);
        }

        @Override
        protected String getLabelText(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.getMessageText((MessageType)object);
        }

        private String getMessageText(MessageType messageType) {
            MessageType.Resource resource = messageType.getResource();
            String string = NodeMessagesLrb.get(resource.getId());
            if (resource.getParameters() != null) {
                List list = resource.getParameters().getValue();
                Object[] objectArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MessageType.Resource.Parameters.Value value = (MessageType.Resource.Parameters.Value)list.get(i);
                    objectArray[i] = value.getValue();
                }
                string = MessageFormat.format(string, objectArray);
            }
            return string;
        }

        private Icon getMessageIcon(MessageType messageType) {
            URL uRL = null;
            ClassLoader classLoader = this.getClass().getClassLoader();
            ImageIcon imageIcon = null;
            if (messageType.getType().equals((Object)MessageEnumType.INCOMPLETE) || messageType.getType().equals((Object)MessageEnumType.WARNING)) {
                uRL = classLoader.getResource("oracle/dmt/dataminer/workflow/res/images/warning_status.png");
            }
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            return imageIcon;
        }
    }

    class ValidationErrorsPanel
    extends JPanel {
        private transient List<MessageType> messages;
        private GenericTable messageTable;
        private JScrollPane scrollPane;

        public ValidationErrorsPanel(List<MessageType> list) {
            this.messages = list;
            this.initComponents();
            this.initRes();
            this.initUI();
        }

        private void initComponents() {
            this.scrollPane = new JScrollPane();
            this.messageTable = new GenericTable();
            this.messageTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Validation Error"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false};
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return this.canEdit[n2];
                }
            });
            this.messageTable.getTableHeader().setReorderingAllowed(false);
            this.scrollPane.setViewportView((Component)this.messageTable);
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 418, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 131, Short.MAX_VALUE));
        }

        public void initRes() {
            this.initHelp();
        }

        private void initHelp() {
            HelpUtils.setHelpID((JComponent)this, (String)"showValidationErrors");
        }

        public void initUI() {
            ValidationsTableModel validationsTableModel = new ValidationsTableModel(this.messages, columns);
            this.messageTable.setModel((TableModel)((Object)validationsTableModel));
            this.messageTable.setSorted(true);
            this.messageTable.setColumnSelectorAvailable(false);
            this.messageTable.setUpdateSelectionOnSort(true);
            this.scrollPane.setColumnHeader(null);
            TableColumn tableColumn = this.messageTable.getColumnModel().getColumn(0);
            MessageCellRenderer messageCellRenderer = new MessageCellRenderer();
            tableColumn.setCellRenderer(messageCellRenderer);
        }

        public boolean doWork() {
            return true;
        }
    }
}

