/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowPaletteGroup;
import oracle.dmt.dataminer.workflow.WorkflowPaletteItem;
import oracle.dmt.dataminer.workflow.WorkflowPalettePage;
import oracle.dmt.dataminer.workflow.WorkflowPalettePageProvider;
import oracle.ide.Context;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;

public class WorkflowPalettePages
extends PalettePages {
    private static final String PAGEPROVIDER_ID = WorkflowPalettePageProvider.class.getName();
    private WorkflowPalettePage preferredPage = null;
    private static WorkflowPalettePages _singleton = new WorkflowPalettePages();
    protected List<PalettePagesListener> palettePagesListeners;
    protected List<PalettePage> palettePages;

    public static WorkflowPalettePages getInstance() {
        return _singleton;
    }

    public void initialize(Context context) {
        if (context.getNode() instanceof WorkflowNode) {
            WorkflowPalettePage workflowPalettePage;
            if (this.palettePages != null) {
                this.palettePages.clear();
            }
            this.preferredPage = workflowPalettePage = new WorkflowPalettePage("DataMiner-Workflow", WorkflowEditorLrb.get("PALETTE_WORKFLOW_EDITOR_NAME"), WorkflowEditorLrb.get("PALETTE_WORKFLOW_EDITOR_DESCRIPTION"), null, "", "", "");
            workflowPalettePage.addGroup((PaletteGroup)this.createDataGroup());
            workflowPalettePage.addGroup((PaletteGroup)this.createXformGroup());
            workflowPalettePage.addGroup((PaletteGroup)this.createTextGroup());
            workflowPalettePage.addGroup((PaletteGroup)this.createModelGroup());
            workflowPalettePage.addGroup((PaletteGroup)this.createEvaluateAndApplyGroup());
            workflowPalettePage.addGroup((PaletteGroup)this.createLinkGroup());
            this.addPage(workflowPalettePage);
        } else {
            this.palettePages.clear();
        }
    }

    public Collection<PalettePage> getPages() {
        return Collections.unmodifiableList(this.palettePages);
    }

    public PaletteItem getItem(String string, String string2) {
        PaletteItem paletteItem;
        block2: {
            PalettePage palettePage;
            WorkflowPalettePage workflowPalettePage;
            if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
                return null;
            }
            paletteItem = null;
            if (!string.equals(PAGEPROVIDER_ID)) break block2;
            Iterator<PalettePage> iterator = this.palettePages.iterator();
            while (iterator.hasNext() && (paletteItem = (workflowPalettePage = (WorkflowPalettePage)(palettePage = iterator.next())).getItem(string2)) == null) {
            }
        }
        return paletteItem;
    }

    public void addPalettePagesListener(PalettePagesListener palettePagesListener) {
        if (this.palettePagesListeners == null) {
            this.palettePagesListeners = new ArrayList<PalettePagesListener>();
        }
        this.palettePagesListeners.add(palettePagesListener);
    }

    public void removePalettePagesListener(PalettePagesListener palettePagesListener) {
        if (this.palettePagesListeners != null) {
            this.palettePagesListeners.remove(palettePagesListener);
        }
    }

    private void addPage(WorkflowPalettePage workflowPalettePage) {
        if (this.palettePages == null) {
            this.palettePages = new ArrayList<PalettePage>();
        }
        this.palettePages.add((PalettePage)workflowPalettePage);
    }

    private WorkflowPaletteGroup createEvaluateAndApplyGroup() {
        WorkflowPaletteGroup workflowPaletteGroup = new WorkflowPaletteGroup("EVALUATE_APPLY_GROUP", WorkflowEditorLrb.get("PALETTE_EVALUATE_AND_APPLY_GROUP_NAME"), WorkflowEditorLrb.get("PALETTE_EVALUATE_AND_APPLY_GROUP_DESCRIPTION"), "");
        DefaultPaletteSection defaultPaletteSection = new DefaultPaletteSection("", "oracle.dmt.dataminer.workflow.pageprovider.EvaluateAndApply");
        workflowPaletteGroup.addSection((PaletteSection)defaultPaletteSection);
        WorkflowPaletteItem workflowPaletteItem = new WorkflowPaletteItem("apply", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_APPLY_NAME"), WorkflowEditorLrb.get("PALETTE_APPLY_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_APPLY_ICON"), "ApplyNode", "ApplyNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("test", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_TEST_NAME"), WorkflowEditorLrb.get("PALETTE_TEST_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_TEST_ICON"), "TestNode", "TestNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        return workflowPaletteGroup;
    }

    private WorkflowPaletteGroup createTextGroup() {
        WorkflowPaletteGroup workflowPaletteGroup = new WorkflowPaletteGroup("TEXT_GROUP", WorkflowEditorLrb.get("PALETTE_TEXT_GROUP_NAME"), WorkflowEditorLrb.get("PALETTE_TEXT_GROUP_DESCRIPTION"), "");
        DefaultPaletteSection defaultPaletteSection = new DefaultPaletteSection("", "oracle.dmt.dataminer.workflow.pageprovider.Text");
        workflowPaletteGroup.addSection((PaletteSection)defaultPaletteSection);
        WorkflowPaletteItem workflowPaletteItem = new WorkflowPaletteItem("buildtext", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_BUILD_TEXT_NAME"), WorkflowEditorLrb.get("PALETTE_BUILD_TEXT_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_BUILD_TEXT_ICON"), "BuildTextNode", "BuildTextNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("applytext", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_APPLY_TEXT_NAME"), WorkflowEditorLrb.get("PALETTE_APPLY_TEXT_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_APPLY_TEXT_ICON"), "ApplyTextNode", "ApplyTextNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("textsettings", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_TEXT_SETTINGS_NAME"), WorkflowEditorLrb.get("PALETTE_TEXT_SETTINGS_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_TEXT_SETTINGS_ICON"), "BuildTextNodeRef", "BuildTextNodeRef");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        return workflowPaletteGroup;
    }

    private WorkflowPaletteGroup createModelGroup() {
        WorkflowPaletteGroup workflowPaletteGroup = new WorkflowPaletteGroup("MODELS_GROUP", WorkflowEditorLrb.get("PALETTE_WORKFLOW_MODELS_GROUP_NAME"), WorkflowEditorLrb.get("PALETTE_WORKFLOW_MODELS_GROUP_DESCRIPTION"), "");
        DefaultPaletteSection defaultPaletteSection = new DefaultPaletteSection("", "oracle.dmt.dataminer.workflow.pageprovider.Section1");
        workflowPaletteGroup.addSection((PaletteSection)defaultPaletteSection);
        WorkflowPaletteItem workflowPaletteItem = new WorkflowPaletteItem("anomalybuild", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_ANOMALY_DETECTION_NAME"), WorkflowEditorLrb.get("PALETTE_ANOMALY_DETECTION_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_ANOMALY_DETECTION_ICON"), "AnomalyDetectionBuildNode", "AnomalyDetectionBuildNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("assocbuild", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_ASSOCIATION_NAME"), WorkflowEditorLrb.get("PALETTE_ASSOCIATION_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_ASSOCIATION_ICON"), "AssociationBuildNode", "AssociationBuildNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("classbuild", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_CLASSIFICATION_NAME"), WorkflowEditorLrb.get("PALETTE_CLASSIFICATION_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_CLASSIFICATION_ICON"), "ClassificationBuildNode", "ClassificationBuildNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("clustbuild", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_CLUSTERING_NAME"), WorkflowEditorLrb.get("PALETTE_CLUSTERING_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_CLUSTERING_ICON"), "ClusteringBuildNode", "ClusteringBuildNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("featurebuild", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_FEATURE_EXTRACTION_NAME"), WorkflowEditorLrb.get("PALETTE_FEATURE_EXTRACTION_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_FEATURE_EXTRACTION_ICON"), "FeatureExtractionBuildNode", "FeatureExtractionBuildNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("regrbuild", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_REGRESSION_NAME"), WorkflowEditorLrb.get("PALETTE_REGRESSION_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_REGRESSION_ICON"), "RegressionBuildNode", "RegressionBuildNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("modelContainer", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_MODEL_NAME"), WorkflowEditorLrb.get("PALETTE_MODEL_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_MODEL_ICON"), "ModelNode", "ModelNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("modeldetails ", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_MODEL_DETAILS_NAME"), WorkflowEditorLrb.get("PALETTE_MODEL_DETAILS_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_MODEL_DETAILS_ICON"), "ModelDetailsDataNode", "ModelDetailsDataNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        return workflowPaletteGroup;
    }

    private WorkflowPaletteGroup createLinkGroup() {
        WorkflowPaletteGroup workflowPaletteGroup = new WorkflowPaletteGroup("LINK_GROUP", WorkflowEditorLrb.get("PALETTE_LINK_GROUP_NAME"), WorkflowEditorLrb.get("PALETTE_LINK_GROUP_DESCRIPTION"), "");
        DefaultPaletteSection defaultPaletteSection = new DefaultPaletteSection("", "oracle.dmt.dataminer.workflow.pageprovider.Link");
        workflowPaletteGroup.addSection((PaletteSection)defaultPaletteSection);
        WorkflowPaletteItem workflowPaletteItem = new WorkflowPaletteItem("transition", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_LINK_NAME"), WorkflowEditorLrb.get("PALETTE_LINK_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_LINK_ICON"), "WorkflowLink", "GeneralLink");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        return workflowPaletteGroup;
    }

    private WorkflowPaletteGroup createDataGroup() {
        WorkflowPaletteGroup workflowPaletteGroup = new WorkflowPaletteGroup("DATA_GROUP", WorkflowEditorLrb.get("PALETTE_DATA_GROUP_NAME"), WorkflowEditorLrb.get("PALETTE_DATA_GROUP_DESCRIPTION"), "");
        DefaultPaletteSection defaultPaletteSection = new DefaultPaletteSection("", "oracle.dmt.dataminer.workflow.pageprovider.Data");
        workflowPaletteGroup.addSection((PaletteSection)defaultPaletteSection);
        WorkflowPaletteItem workflowPaletteItem = new WorkflowPaletteItem("source", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_DATA_SOURCE_NAME"), WorkflowEditorLrb.get("PALETTE_DATA_SOURCE_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_DATA_SOURCE_ICON"), "DataSourceNode", "DataSourceNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("createtable", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_CREATE_TABLE_NAME"), WorkflowEditorLrb.get("PALETTE_CREATE_TABLE_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_CREATE_TABLE_ICON"), "CreateTableNode", "CreateTableNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("updatetable", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_UPDATE_TABLE_NAME"), WorkflowEditorLrb.get("PALETTE_UPDATE_TABLE_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_UPDATE_TABLE_ICON"), "UpdateTableNode", "UpdateTableNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("profile", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_DATA_PROFILE_NAME"), WorkflowEditorLrb.get("PALETTE_DATA_PROFILE_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_DATA_PROFILE_ICON"), "DataProfileNode", "DataProfileNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        return workflowPaletteGroup;
    }

    private WorkflowPaletteGroup createXformGroup() {
        WorkflowPaletteGroup workflowPaletteGroup = new WorkflowPaletteGroup("TRANSFORMS_GROUP", WorkflowEditorLrb.get("PALETTE_TRANSFORMATIONS_GROUP_NAME"), WorkflowEditorLrb.get("PALETTE_TRANSFORMATIONS_GROUP_DESCRIPTION"), "");
        DefaultPaletteSection defaultPaletteSection = new DefaultPaletteSection("", "oracle.dmt.dataminer.workflow.pageprovider.Transform");
        workflowPaletteGroup.addSection((PaletteSection)defaultPaletteSection);
        WorkflowPaletteItem workflowPaletteItem = new WorkflowPaletteItem("join", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_JOIN_NAME"), WorkflowEditorLrb.get("PALETTE_JOIN_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_JOIN_ICON"), "JoinNode", "JoinNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("aggregation", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_AGGREGATION_NAME"), WorkflowEditorLrb.get("PALETTE_AGGREGATION_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_AGGREGATION_ICON"), "AggregationNode", "AggregationNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("transformation", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_TRANSFORMATION_NAME"), WorkflowEditorLrb.get("PALETTE_TRANSFORMATION_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_TRANSFORMATION_ICON"), "TransformationNode", "TransformationNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("sample ", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_SAMPLE_NAME"), WorkflowEditorLrb.get("PALETTE_SAMPLE_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_SAMPLE_ICON"), "SampleNode", "SampleNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("colfilter", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_NAME"), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_ICON"), "ColumnFilterNode", "ColumnFilterNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("colfilterdetails", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_DETAILS_NAME"), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_DETAILS_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_COLUMN_FILTER_DETAILS_ICON"), "FilterDetailsDataNode", "FilterDetailsDataNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        workflowPaletteItem = new WorkflowPaletteItem("rowfilter", PAGEPROVIDER_ID, WorkflowEditorLrb.get("PALETTE_ROW_FILTER_NAME"), WorkflowEditorLrb.get("PALETTE_ROW_FILTER_DESCRIPTION"), WorkflowEditorLrb.get("PALETTE_ROW_FILTER_ICON"), "RowFilterNode", "RowFilterNode");
        defaultPaletteSection.addItem((PaletteItem)workflowPaletteItem);
        return workflowPaletteGroup;
    }

    public PalettePage getPreferredPage() {
        return this.preferredPage;
    }
}

