/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.workflow;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.wizard.workflow.WorkflowDialogState;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.dmt.dataminer.wizard.workflow.WorkflowPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;

public class CreateWorkflowDialog {
    private static Icon _icon;
    private WorkflowDialogState _state;
    protected JEWTDialog _dlg;
    protected String wizName = "createWorkflow";
    private boolean _editMode = false;

    public CreateWorkflowDialog() {
        this._editMode = false;
    }

    public CreateWorkflowDialog(boolean bl) {
        this._editMode = bl;
    }

    protected JEWTDialog buildDialog(Context context, WorkflowDialogState workflowDialogState) {
        WorkflowPanel workflowPanel = this.buildPanel(context, workflowDialogState);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)workflowPanel);
        jEWTDialog.setTitle(this.getDialogTitle());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "workflows.htm");
        DialogHeader dialogHeader = new DialogHeader();
        dialogHeader.setHeaderImage(this.getHeaderImage());
        dialogHeader.setHeaderDescription(this.getHeaderDescription());
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        return jEWTDialog;
    }

    protected String getHeaderTitle() {
        if (this._editMode) {
            return WorkflowLrb.get("EDIT_WORKFLOW_DIALOG_TITLE");
        }
        return WorkflowLrb.get("CREATE_WORKFLOW_DIALOG_TITLE");
    }

    protected String getHeaderDescription() {
        if (this._editMode) {
            return WorkflowLrb.get("EDIT_WORKFLOW_DESCRIPTION");
        }
        return WorkflowLrb.get("CREATE_WORKFLOW_DESCRIPTION");
    }

    protected String getDialogTitle() {
        if (this._editMode) {
            return WorkflowLrb.get("EDIT_WORKFLOW_DIALOG_TITLE");
        }
        return WorkflowLrb.get("CREATE_WORKFLOW_DIALOG_TITLE");
    }

    protected WorkflowDialogState buildState(Context context) throws Exception {
        WorkflowDialogState workflowDialogState = null;
        if (this._editMode) {
            Element[] elementArray = context.getSelection();
            BaseTreeNode baseTreeNode = (BaseTreeNode)elementArray[0];
            Workflow workflow = (Workflow)baseTreeNode.getRepositoryData();
            assert (workflow != null) : "Project repository object is null.";
            workflowDialogState = new WorkflowDialogState(context, workflow);
        } else {
            workflowDialogState = new WorkflowDialogState(context);
        }
        return workflowDialogState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context) {
        boolean bl = false;
        try {
            this._state = this.buildState(context);
            if (this._state != null) {
                JEWTDialog jEWTDialog = this.buildDialog(context, this._state);
                jEWTDialog.setResizable(true);
                final WorkflowPanel workflowPanel = (WorkflowPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !workflowPanel.validateAndWriteToState(CreateWorkflowDialog.this._state)) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog != null) {
                    workflowPanel.initializeFromState(this._state);
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
        }
        catch (Exception exception) {
            if (!this._editMode) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("EDIT_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("EDIT_WORKFLOW_FAILURE_MESG"), null);
            }
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        this._state = null;
        this._dlg = null;
        _icon = null;
        return bl;
    }

    protected void cancel() {
    }

    protected WorkflowPanel buildPanel(Context context, WorkflowDialogState workflowDialogState) {
        return new WorkflowPanel(context, workflowDialogState);
    }

    protected Image getHeaderImage() {
        return ((ImageIcon)this.getIcon()).getImage();
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), WorkflowLrb.get("CREATE_WORKFLOW_DIALOG_IMAGE"));
        }
        return _icon;
    }
}

