/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.project;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.wizard.project.ProjectLrb;
import oracle.dmt.dataminer.wizard.project.ProjectModel;
import oracle.dmt.dataminer.wizard.project.ProjectPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;

public class CreateProjectDialog {
    private static Icon _icon;
    private ProjectModel _state;
    protected JEWTDialog _dlg;
    protected String wizName = "Create Project";
    private boolean _editMode = false;

    public CreateProjectDialog() {
        this._editMode = false;
    }

    public CreateProjectDialog(boolean bl) {
        this._editMode = bl;
    }

    protected JEWTDialog buildDialog(Context context, ProjectModel projectModel) {
        ProjectPanel projectPanel = this.buildPanel(context, projectModel);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)projectPanel);
        jEWTDialog.setTitle(this.getDialogTitle());
        DialogHeader dialogHeader = new DialogHeader();
        dialogHeader.setHeaderImage(this.getHeaderImage());
        dialogHeader.setHeaderDescription(this.getHeaderDescription());
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        this.registerHelp(jEWTDialog);
        return jEWTDialog;
    }

    private void registerHelp(JEWTDialog jEWTDialog) {
        if (!this._editMode) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "project_create");
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "project_properties");
        }
    }

    protected String getHeaderTitle() {
        if (this._editMode) {
            return ProjectLrb.get("EDIT_PROJECT_DIALOG_TITLE");
        }
        return ProjectLrb.get("CREATE_PROJECT_DIALOG_TITLE");
    }

    protected String getHeaderDescription() {
        if (this._editMode) {
            return ProjectLrb.get("EDIT_PROJECT_DESCRIPTION");
        }
        return ProjectLrb.get("CREATE_PROJECT_DESCRIPTION");
    }

    protected String getDialogTitle() {
        if (this._editMode) {
            return ProjectLrb.get("EDIT_PROJECT_DIALOG_TITLE");
        }
        return ProjectLrb.get("CREATE_PROJECT_DIALOG_TITLE");
    }

    protected ProjectModel buildState(Context context) throws Exception {
        ProjectModel projectModel = null;
        if (this._editMode) {
            Element[] elementArray = context.getSelection();
            BaseTreeNode baseTreeNode = (BaseTreeNode)elementArray[0];
            WorkflowProject workflowProject = (WorkflowProject)baseTreeNode.getRepositoryData();
            assert (workflowProject != null) : "Project repository object is null.";
            projectModel = new ProjectModel(context, workflowProject);
        } else {
            projectModel = new ProjectModel(context);
        }
        return projectModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context) {
        boolean bl = false;
        try {
            this._state = this.buildState(context);
            if (this._state != null) {
                JEWTDialog jEWTDialog = this.buildDialog(context, this._state);
                jEWTDialog.setResizable(true);
                final ProjectPanel projectPanel = (ProjectPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !projectPanel.validateAndWriteToState(CreateProjectDialog.this._state)) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog != null) {
                    projectPanel.initializeFromState(this._state);
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
        }
        catch (Exception exception) {
            if (!this._editMode) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ProjectLrb.get("CREATE_PROJECT_FAILURE_TITLE"), (String)ProjectLrb.get("CREATE_PROJECT_FAILURE_MESG"), null);
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ProjectLrb.get("EDIT_PROJECT_FAILURE_TITLE"), (String)ProjectLrb.get("EDIT_PROJECT_FAILURE_MESG"), null);
            }
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        this._state = null;
        this._dlg = null;
        _icon = null;
        return bl;
    }

    protected void cancel() {
    }

    protected ProjectPanel buildPanel(Context context, ProjectModel projectModel) {
        return new ProjectPanel(context, projectModel);
    }

    protected Image getHeaderImage() {
        return ((ImageIcon)this.getIcon()).getImage();
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), ProjectLrb.get("CREATE_PROJECT_DIALOG_IMAGE"));
        }
        return _icon;
    }
}

