/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.sql.ZONEIDMAP;

public class TimeUtils {
    public static String GMT = UtilsLrb.get("GMT");
    private static String NO_ZONE_FORMAT_SHORT = "yyyy-MM-dd HH:mm:ss";
    private static String NO_ZONE_FORMAT = "dd.MM.yyyy HH:mm:ss.SSSSSSSSS";
    private static String ZONE_FORMAT_SHORT_GMT = "yyyy-MM-dd HH:mm:ss z";
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;
    private static HashMap<String, TimeZone> _mapStringToTimeZone;
    private static Vector<String> _timezone_strings;

    public static SimpleDateFormat getShortSimpleDateFormat() {
        return new SimpleDateFormat(NO_ZONE_FORMAT_SHORT, Locale.getDefault());
    }

    public static SimpleDateFormat getShortSimpleDateFormatRFC() {
        return new SimpleDateFormat(NO_ZONE_FORMAT_SHORT, Locale.getDefault());
    }

    public static SimpleDateFormat getShortSimpleDateFormatZone() {
        return new SimpleDateFormat(ZONE_FORMAT_SHORT_GMT, Locale.getDefault());
    }

    public static SimpleDateFormat getShortSimpleDateFormatZoneRFC() {
        return new SimpleDateFormat(ZONE_FORMAT_SHORT_GMT, Locale.getDefault());
    }

    public static SimpleDateFormat getExplorerNodeFormatTimestampTimeZone() {
        return new SimpleDateFormat("yy-MMM-dd HH:mm:ss.SSSSSS a z", Locale.getDefault());
    }

    public static SimpleDateFormat getExplorerNodeTimestampFormat() {
        return new SimpleDateFormat("yy-MMM-dd HH:mm:ss.SSSSSS a", Locale.getDefault());
    }

    public static SimpleDateFormat getExplorerNodeDateFormat() {
        return new SimpleDateFormat("yy-MMM-dd", Locale.getDefault());
    }

    public static String getTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        return DateFormat.getInstance().format(calendar.getTime());
    }

    public static Date toDate1(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, n + 5);
        String string4 = string.substring(n);
        n = string4.indexOf(" ");
        string4 = string4.substring(n);
        string4 = string4.replace(":", "");
        string = string2 + string3 + string4;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(NO_ZONE_FORMAT, Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        return date;
    }

    public static Date toDate2(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, n + 5);
        String string4 = string.substring(n);
        n = string4.indexOf(" ");
        string4 = string4.substring(n);
        string4 = string4.replace(":", "");
        string = string2 + string3 + string4;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy hh.mm.ss.SSSSSSSSS a Z");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        return date;
    }

    public static String formatDate(XMLGregorianCalendar xMLGregorianCalendar) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        Date date = xMLGregorianCalendar.toGregorianCalendar().getTime();
        java.sql.Date date2 = new java.sql.Date(date.getTime());
        return dateFormat.format(date2);
    }

    public static XMLGregorianCalendar Date2XMLDate(Calendar calendar) {
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            xMLGregorianCalendar = TimeUtils.long2Gregorian(calendar);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            xMLGregorianCalendar = null;
        }
        return xMLGregorianCalendar;
    }

    private static XMLGregorianCalendar long2Gregorian(Calendar calendar) {
        DatatypeFactory datatypeFactory;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(datatypeConfigurationException);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(calendar.getTimeInMillis());
        gregorianCalendar.setTimeZone(calendar.getTimeZone());
        return datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
    }

    public static String getRegionName(byte[] byArray) {
        String string;
        if ((byArray[11] & REGIONIDBIT) != 0) {
            int n = TimeUtils.getHighOrderbits(byArray[11]);
            string = ZONEIDMAP.getRegion((int)(n += TimeUtils.getLowOrderbits(byArray[12])));
        } else {
            int n = byArray[11] - OFFSET_HOUR;
            int n2 = byArray[12] - OFFSET_MINUTE;
            StringBuffer stringBuffer = new StringBuffer(n < 0 ? "-" : "+");
            if (Math.abs(n) < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Math.abs(n));
            stringBuffer.append(":");
            string = stringBuffer.toString();
            string = n2 == 0 ? string + "00" : string + "" + n2;
        }
        return string;
    }

    private static int getHighOrderbits(int n) {
        return (n & 0x7F) << 6;
    }

    private static int getLowOrderbits(int n) {
        return (n & 0xFC) >> 2;
    }

    public static String[] getTimeZoneStrings() {
        if (_timezone_strings == null) {
            _timezone_strings = new Vector();
            _mapStringToTimeZone = new HashMap();
            boolean bl = false;
            for (int i = -12; i <= 14; ++i) {
                String string = GMT + (i < 0 ? "-" : "+") + Math.abs(i);
                TimeZone timeZone = TimeZone.getTimeZone(string);
                String string2 = timeZone.getID();
                _mapStringToTimeZone.put(string2, timeZone);
                _timezone_strings.add(string2);
            }
        }
        return _timezone_strings.toArray(new String[_timezone_strings.size()]);
    }

    public static TimeZone toTimeZone(String string) {
        if (_mapStringToTimeZone == null) {
            TimeUtils.getTimeZoneStrings();
        }
        TimeZone timeZone = _mapStringToTimeZone.get(string);
        return timeZone;
    }

    public static TimeZone toTimeZoneFromZoneId(String string) {
        if (_mapStringToTimeZone == null) {
            TimeUtils.getTimeZoneStrings();
        }
        TimeZone timeZone = _mapStringToTimeZone.get(string);
        return timeZone;
    }

    public static String removeGMT(String string) {
        int n = string.indexOf(GMT);
        if (-1 == n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        stringBuffer.append(string.substring(n + 3));
        return stringBuffer.toString();
    }
}

