/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class TableNameValidator {
    static final int MAXIMUM = 30;

    public static boolean validateTableName(String string, List<String> list, String string2, boolean bl) {
        boolean bl2 = true;
        if (string.length() != 0) {
            if (!StringUtils.isDoubleQuotedString(string) && !TableNameValidator.isNameValidNonQuoted(string, bl)) {
                return false;
            }
            if (!TableNameValidator.isNameValid(string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : StringUtils.trimDoubleQuotes(string), bl)) {
                return false;
            }
            if (!TableNameValidator.isNameUnique(string, list, bl)) {
                return false;
            }
            if (!TableNameValidator.isNameLengthValidInDB(string2, string, bl)) {
                return false;
            }
        }
        return bl2;
    }

    public static boolean validateTableName(String string, List<String> list, Context context, boolean bl) {
        boolean bl2 = true;
        if (string.length() != 0) {
            if (!StringUtils.isDoubleQuotedString(string) && !TableNameValidator.isNameValidNonQuoted(string, bl)) {
                return false;
            }
            if (!TableNameValidator.isNameValid(string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : StringUtils.trimDoubleQuotes(string), bl)) {
                return false;
            }
            if (!TableNameValidator.isNameUnique(string, list, bl)) {
                return false;
            }
            if (!TableNameValidator.isNameLengthValidInDB(context, string, bl)) {
                return false;
            }
            if (TableNameValidator.isDuplicateName(string)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NOT_UNIQUE_MSG"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_TITLE"), null);
                return false;
            }
        }
        return bl2;
    }

    private static boolean isDuplicateName(String string) {
        boolean bl = false;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            bl = workflowEditor.doesNodeNameAlreadyExist(string);
        }
        return bl;
    }

    public static boolean isNameValidNonQuoted(String string, boolean bl) {
        if (StringUtils.isValidNonQuotedDBObjectName(string)) {
            return true;
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_UNQUOTED_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
        }
        return false;
    }

    public static boolean isNameValid(String string, boolean bl) {
        if (StringUtils.isDoubleQuotedString(string) && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
            return false;
        }
        if (WorkflowUtils.validateDBObjectName(string)) {
            return true;
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNameLengthValidInDB(Context context, String string, boolean bl) {
        boolean bl2 = false;
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(context);
            bl2 = StringUtils.checkStringDBLengthMax(string, connection, 30);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), (String)UtilsLrb.get("NAME_ERROR_UNEXPECTED_FAILURE_MESG"), null);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!bl2 && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNameLengthValidInDB(String string, String string2, boolean bl) {
        boolean bl2 = false;
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(string);
            bl2 = StringUtils.checkStringDBLengthMax(string2, connection, 30);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), (String)UtilsLrb.get("NAME_ERROR_UNEXPECTED_FAILURE_MESG"), null);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!bl2 && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
        }
        return bl2;
    }

    public static boolean isNameUnique(String string, List<String> list, boolean bl) {
        if (list == null) {
            return true;
        }
        for (String string2 : list) {
            if (string2 == null || string2.compareTo(string) != 0) continue;
            if (bl) {
                return MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_DUPLICATE"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null) == 1;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTableNameUnique(Context context, String string) {
        Connection connection = null;
        boolean bl = false;
        try {
            connection = Connections.getUniqueConnection(context);
            Collection<String> collection = WorkflowUtils.getAllKnownTableNames(connection, context);
            if (!collection.contains(string)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), (String)UtilsLrb.get("NAME_ERROR_UNEXPECTED_FAILURE_MESG"), null);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNameUniqueWithinWorkflows(Context context, String string, boolean bl) {
        boolean bl2 = true;
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(context);
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"ODMR_OBJECT_NAMES", (Connection)connection);
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)new String[0]);
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ODMR_WORKFLOW.WF_GET_ALL_TABLES(?)}");
            oracleCallableStatement.setARRAY(1, aRRAY);
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMR_OBJECT_NAMES");
            oracleCallableStatement.execute();
            ARRAY aRRAY2 = oracleCallableStatement.getARRAY(1);
            String[] stringArray = (String[])aRRAY2.getArray();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl2 = false;
                break;
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), (String)UtilsLrb.get("NAME_ERROR_UNEXPECTED_FAILURE_MESG"), null);
            bl2 = false;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl2;
    }
}

