/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Referenceable;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class DataMinerConnections {
    private static DataMinerConnections instance = null;
    private static ConnectionDisconnectListener disconnectListener = null;
    private static Map<String, String> privateConnectionsMap = new HashMap<String, String>();

    public static DataMinerConnections getInstance() {
        if (instance == null) {
            instance = new DataMinerConnections();
        }
        return instance;
    }

    private DataMinerConnections() {
    }

    public String getPrivateConnectionName(String string) throws ConnectionException {
        String string2 = null;
        String string3 = DataMinerConnections.getQualifiedName(string);
        if (privateConnectionsMap.containsKey(string3)) {
            string2 = privateConnectionsMap.get(string3);
        } else {
            string2 = Connections.getInstance().createPrivateConnection(string3);
            privateConnectionsMap.put(string3, string2);
        }
        return string2;
    }

    public static String getUnqualifiedName(String string) {
        String string2 = null;
        try {
            String string3 = URLDecoder.decode(string, "utf-8");
            int n = string3.indexOf(35);
            string2 = n != -1 ? string3.substring(n + 1) : string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String getQualifiedName(String string) {
        String string2 = DatabaseConnections.getInstance().getStoreName();
        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)string2, (String)string);
        return connectionKey.getQualifiedName();
    }

    public Connection createPrivateConnection(String string) throws SQLException, ConnectionException, DBException {
        Connection connection = null;
        Referenceable referenceable = DatabaseConnections.getInstance().getReferenceable(string);
        if (referenceable instanceof DatabaseProvider) {
            connection = ((DatabaseProvider)referenceable).getConnection();
        }
        return connection;
    }

    public void closePrivateConnection(String string) throws ConnectionException {
        Referenceable referenceable = DatabaseConnections.getInstance().getReferenceable(string);
        if (referenceable instanceof DatabaseProvider) {
            ((DatabaseProvider)referenceable).disconnect();
        }
    }

    private ConnectionDisconnectListener addDisconnectListener() {
        ConnectionDisconnectListener connectionDisconnectListener = new ConnectionDisconnectListener(){

            public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
                try {
                    Properties properties = connectionDetails.getConnectionProperties();
                    String string = DatabaseConnections.getInstance().getStoreName();
                    Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)string, (String)((String)properties.get("UnsharedWorksheetOriginalConnectionName")));
                    String string2 = connectionKey.getConnectionName();
                    if (privateConnectionsMap.containsKey(string2)) {
                        connectionDetails.getConnection().commit();
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }

            public void connectionDisconnected(ConnectionDetails connectionDetails) {
            }
        };
        Connections.getInstance().addConnectionDisconnectListener(connectionDisconnectListener);
        return connectionDisconnectListener;
    }
}

