/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DateCellRenderer2;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.GraphPanel2;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.AbstractTestEditor;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCDetailDialog;
import oracle.dmt.dataminer.tviewer.roc.ROCEditor;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.tviewer.roc.ThresholdDialog;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.ColorIcon;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class ROCTabPanel
extends DataMinerViewGUI {
    private GraphPanel2 _graphPanel;
    private ROCTabPanelState _state;
    private boolean _loading = true;
    private JButton jCustomROCButton;
    private JPanel jPanel2;
    private TransparentPanel jROCPanel;
    private ComponentWithTitlebar<JComponent> jROCToolbar;
    private JPanel jRocGraphPanel;
    private JSplitPane jSplitPane1;
    private JComboBox jTargetComb;
    private JLabel jTargetLbl;
    private JButton jDetailBtn;
    private JButton _jBT_AddOrRemove;
    private CustomGenericTable jROCSummaryTable;
    private static Icon _detailBtnIconEna;
    private static Icon _detailBtnIconDis;
    private static Icon _jIC_UpdateENA;
    private static Icon _jIC_UpdateDIS;
    private JScrollPane tscroller;

    public ROCTabPanel(ROCEditor rOCEditor, Context context) {
        super(rOCEditor, context);
        this._state = new ROCTabPanelState((SharedTestEditorState)rOCEditor.getCachedLegendState(), context);
        boolean bl = false;
        List<TestResult> list = this._state.getParentTestViewerState().getTestResults();
        for (TestResult testResult : list) {
            if (!((ClassTestResult)testResult).rocResultExists()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.initComponents();
            this.initGraph();
            this.initRes();
            this.initUI();
        }
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel2(new DefaultGraphDataModel(null, null, null, null, null));
        this.jRocGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.jRocGraphPanel.updateUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, (Component)this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jCustomROCButton, (String)TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleName(TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("ROC_CUSTOM_BTN_ADA"));
    }

    @Override
    public void initUI() {
        this._loading = true;
        this.jROCSummaryTable = new CustomGenericTable();
        this.tscroller = new JScrollPane((Component)((Object)this.jROCSummaryTable));
        this.jROCSummaryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int[] nArray = ROCTabPanel.this.jROCSummaryTable.getSelectedRowsInModel();
                    String string = (String)ROCTabPanel.this._state.getRocTableModel().getValueAt(nArray[0], 0);
                    ROCDetailDialog rOCDetailDialog = new ROCDetailDialog(string, ROCTabPanel.this._state.getROCData().get(string));
                    if (rOCDetailDialog.invoke()) {
                        // empty if block
                    }
                }
            }
        });
        this.jROCToolbar.setComponent((JComponent)this.tscroller);
        this.jROCToolbar.setLabel(new JLabel(TestViewerLrb.get("MODELS")));
        ControlBar controlBar = new ControlBar();
        this.installROCSummaryActions(controlBar);
        this.jROCToolbar.setControlBar(controlBar);
        this.initializeControls();
        this.jSplitPane1.setDividerLocation(0.85);
        this.jSplitPane1.setResizeWeight(0.85);
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void enableControls(boolean bl) {
        this.jTargetComb.setEnabled(bl);
        this.jCustomROCButton.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && this.jROCSummaryTable.getSelectedRowCount() > 0);
    }

    private void initializeControls() {
        this.jROCSummaryTable.setModel((TableModel)((Object)new ROCTabPanelState.ROCTableModel(new ROCTabPanelState(this._state.getParentTestViewerState(), this.getContext()))));
        this.jROCSummaryTable.setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("LOADING_SHORTENED")}));
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        ListSelectionModel listSelectionModel = this.jROCSummaryTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ROCTabPanel.this._loading) {
                    return;
                }
                ROCTabPanel.this.jROCSummaryTableValueChanged(listSelectionEvent);
                ROCTabPanel.this.getEditor().updateSelection();
            }
        });
        this.enableControls(false);
    }

    public void jROCSummaryTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.jROCSummaryTable.getSelectedRowsInModel();
            String string = (String)this._state.getRocTableModel().getValueAt(nArray[0], 0);
            this._state.setSelectedTestResult(string);
            this.enableControls(true);
            this.fireViewPropertySelectionChange(this, string);
        }
    }

    public ROCTabPanelState.ROCData getROCData() {
        String string = this._state.getSelectedTestResult();
        if (string == null) {
            int[] nArray = this.jROCSummaryTable.getSelectedRowsInModel();
            if (nArray.length > 0 && -1 != nArray[0]) {
                string = (String)this._state.getRocTableModel().getValueAt(nArray[0], 0);
                this._state.setSelectedTestResult(string);
            }
            if (string == null) {
                return null;
            }
        }
        int n = this._state.getStatisticsData().get(string).getMaxOverallAccuracyIdx();
        ROCTabPanelState.ROCData rOCData = this._state.getROCData().get(string).get(n);
        rOCData.setLabel(string);
        return rOCData;
    }

    private void initComponents() {
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jSplitPane1 = new JSplitPane();
        this.jRocGraphPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jROCPanel = new TransparentPanel();
        this.jROCToolbar = new ComponentWithTitlebar();
        this.jCustomROCButton = new JButton();
        this.jTargetLbl.setText("Target Value:");
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jRocGraphPanel.setMinimumSize(new Dimension(100, 100));
        this.jRocGraphPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setTopComponent(this.jRocGraphPanel);
        GroupLayout groupLayout = new GroupLayout((Container)this.jROCPanel);
        this.jROCPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jROCToolbar, -1, 573, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jROCToolbar, -1, 107, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jROCPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jROCPanel, -1, -1, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.jCustomROCButton.setText("Edit Custom Operating Point...");
        this.jCustomROCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jCustomROCActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 575, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, 0, 242, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 85, Short.MAX_VALUE).addComponent(this.jCustomROCButton, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jCustomROCButton).addComponent(this.jTargetComb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 513, Short.MAX_VALUE).addContainerGap()));
    }

    private void installROCSummaryActions(ControlBar controlBar) {
        Class<AbstractTestEditor> clazz = AbstractTestEditor.class;
        _detailBtnIconEna = OracleIcons.getIcon((String)"lov.png");
        _detailBtnIconDis = OracleIcons.getIcon((String)"lov.png");
        this.jDetailBtn = new JButton(_detailBtnIconEna);
        this.jDetailBtn.setDisabledIcon(_detailBtnIconDis);
        this.jDetailBtn.setToolTipText(TestViewerLrb.get("ROC_DETAIL_DIALOG"));
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jDetailBtnActionPerformed(actionEvent);
            }
        });
        controlBar.add((Component)this.jDetailBtn);
        if (this._state.getParentTestViewerState().getAllTestResults().size() > 1) {
            _jIC_UpdateENA = UIResourceHelper.getImageIcon(clazz, TestViewerLrb.get("ADD_REMOVE_BTN_ICON_ENA"));
            _jIC_UpdateDIS = UIResourceHelper.getImageIcon(clazz, TestViewerLrb.get("ADD_REMOVE_BTN_ICON_DIS"));
            this._jBT_AddOrRemove = new JButton(_jIC_UpdateENA);
            this._jBT_AddOrRemove.setDisabledIcon(_jIC_UpdateDIS);
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ROCTabPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            controlBar.add((Component)this._jBT_AddOrRemove);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._state.getParentTestViewerState(), this._state.getParentTestViewerState().getContext(), this._state.getParentTestViewerState().getParentActivity(), this._state.getParentTestViewerState().getAllTestResults(), this._state.getParentTestViewerState().getTestResults())) {
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            this._state.getParentTestViewerState().setTestResults(list);
            this.jRocGraphPanel.removeAll();
            this.jRocGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
            this.jROCSummaryTable.setModel((TableModel)((Object)new ROCTabPanelState.ROCTableModel(new ROCTabPanelState(this._state.getParentTestViewerState(), this.getContext()))));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(false);
            loadUI.start();
        }
    }

    private void jEditCustOPBtnActionPerformed(ActionEvent actionEvent) {
        ThresholdDialog thresholdDialog = new ThresholdDialog(this._state);
        if (thresholdDialog.invoke()) {
            this._state.refreshCustomThresholdData();
            this.jRocGraphPanel.removeAll();
            this.jRocGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
            this.jROCSummaryTable.setModel((TableModel)((Object)new ROCTabPanelState.ROCTableModel(new ROCTabPanelState(this._state.getParentTestViewerState(), this.getContext()))));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(true);
            loadUI.start();
        }
    }

    private void jDetailBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jROCSummaryTable.getSelectedRowsInModel();
        String string = (String)this._state.getRocTableModel().getValueAt(nArray[0], 0);
        ROCDetailDialog rOCDetailDialog = new ROCDetailDialog(string, this._state.getROCData().get(string));
        if (rOCDetailDialog.invoke()) {
            // empty if block
        }
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jRocGraphPanel.removeAll();
        this.jRocGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.jROCSummaryTable.setModel((TableModel)((Object)new ROCTabPanelState.ROCTableModel(new ROCTabPanelState(this._state.getParentTestViewerState(), this.getContext()))));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(true);
        loadUI.start();
    }

    private void jCustomROCActionPerformed(ActionEvent actionEvent) {
        this.jEditCustOPBtnActionPerformed(actionEvent);
    }

    public void setCachedPropertyState(Object object) {
    }

    public Object getCachedPropertyState() {
        return this._state;
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        private DateFormat _df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        private Preferences _p = Preferences.getPreferences();
        private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
        private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
        private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

        CustomGenericTable() {
            this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._percentageFormat.setMinimumIntegerDigits(1);
            this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._numericalFormat.setMinimumIntegerDigits(1);
        }

        @Override
        public void addDynamicCellRenderers() {
            NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
            this.addCellRenderer(ROCTabPanel.this._state.getRocTableModel().getColumnName(0), new CustomCellRenderer());
            this.addCellRenderer(ROCTabPanel.this._state.getRocTableModel().getColumnName(1), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this._state.getRocTableModel().getColumnName(5), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this._state.getRocTableModel().getColumnName(4), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this._state.getRocTableModel().getColumnName(3), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this._state.getRocTableModel().getColumnName(2), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this._state.getRocTableModel().getColumnName(7), new DateCellRenderer2());
        }

        private String formatCellValue(Object object) {
            String string = null;
            if (object != null) {
                string = object instanceof Double ? this._percentageFormat.format((Double)object) : (object instanceof Integer ? this._numericalFormat.format(((Integer)object).intValue()) : (object instanceof BigDecimal ? this._numericalFormat.format(((BigDecimal)object).doubleValue()) : (object instanceof Date ? this._df.format(object) : object.toString())));
            }
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = this.formatCellValue(object);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = this.formatCellValue(object);
            return string;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(object instanceof String)) assert (false);
            String string = (String)object;
            Color color = ROCTabPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
            this.setIcon((Icon)new ColorIcon(color));
            return component;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    ROCTabPanel.this._state.refreshROCStatData();
                } else {
                    ROCTabPanel.this._state.load();
                }
                ROCTabPanel.this._graphPanel.initGraph(ROCTabPanel.this._state.getRocGraphModel());
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ROCTabPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                int n = 1;
                if (this._success && this._ex == null) {
                    ROCTabPanel.this.jRocGraphPanel.removeAll();
                    ROCTabPanel.this.jRocGraphPanel.add((Component)ROCTabPanel.this._graphPanel, "Center");
                    ROCTabPanel.this.jRocGraphPanel.updateUI();
                    String string = ROCTabPanel.this._state.getSelectedTestResult();
                    ROCTabPanel.this.jROCSummaryTable.setFixedColumnCount(n);
                    ROCTabPanel.this.jROCSummaryTable.setModel((TableModel)((Object)ROCTabPanel.this._state.getRocTableModel()));
                    String string2 = ROCTabPanel.this._state.getRocTableModel().getColumnName(0);
                    ROCTabPanel.this.jROCSummaryTable.setFixedColumnPreferredWidth(string2, 165);
                    ROCTabPanel.this.jROCSummaryTable.findOrCreateTableRowHeader(ROCTabPanel.this.tscroller);
                    ROCTabPanel.this.jROCSummaryTable.setSorted(true);
                    ROCTabPanel.this.jROCSummaryTable.setAutoResizeMode(0);
                    ROCTabPanel.this.jROCSummaryTable.addDynamicCellRenderers();
                    TableColumnModel tableColumnModel = ROCTabPanel.this.jROCSummaryTable.getColumnModel();
                    tableColumnModel.getColumn(1 - n).setPreferredWidth(120);
                    tableColumnModel.getColumn(2 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(3 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(4 - n).setPreferredWidth(125);
                    tableColumnModel.getColumn(5 - n).setPreferredWidth(120);
                    tableColumnModel.getColumn(6 - n).setPreferredWidth(135);
                    tableColumnModel.getColumn(7 - n).setPreferredWidth(135);
                    ROCTabPanel.this.jROCSummaryTable.setSelectionMode(0);
                    ROCTabPanel.this.jROCSummaryTable.setColumnSelectorAvailable(true);
                    ROCTabPanel.this.jROCSummaryTable.setShowToolTips(true);
                    ROCTabPanel.this.jROCSummaryTable.setSortRetainsSelection(true);
                    ROCTabPanel.this.jROCSummaryTable.setRowSelectionAllowed(true);
                    ROCTabPanel.this.jROCSummaryTable.setCellRenderers();
                    ROCTabPanel.this.jROCSummaryTable.setRowHeaderCellRenderers();
                    int n2 = 0;
                    if (string == null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < ROCTabPanel.this.jROCSummaryTable.getRowCount(); ++i) {
                            d = (Double)ROCTabPanel.this._state.getRocTableModel().getValueAt(i, 1);
                            if (!(d2 < d)) continue;
                            d2 = d;
                            n2 = i;
                        }
                    } else {
                        for (int i = 0; i < ROCTabPanel.this.jROCSummaryTable.getRowCount(); ++i) {
                            Object object = ROCTabPanel.this._state.getRocTableModel().getValueAt(i, 0);
                            if (!string.equals(object)) continue;
                            n2 = i;
                        }
                    }
                    ROCTabPanel.this.jROCSummaryTable.setRowSelectionInterval(n2, n2);
                    if (!this._reload) {
                        ROCTabPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ROCTabPanel.this._state.getTargetValues()));
                        ROCTabPanel.this.jTargetComb.setSelectedItem(ROCTabPanel.this._state.getSelectedTargetValue());
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                ROCTabPanel.this.enableControls(true);
                ROCTabPanel.this.getEditor().updateSelection();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ROCTabPanel.this._loading = false;
            }
        }
    }
}

