/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.RowColumnValue;
import oracle.dmt.dataminer.generated.server.ODMRPkg_Activity;
import oracle.dmt.dataminer.generated.server.OdmrCostMatrix;
import oracle.dmt.dataminer.generated.server.OdmrCostMatrixDetail;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.Model;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public class CostMatrixPanel
extends JPanel
implements DataminerGUIPanel,
DataMinerViewListener {
    private boolean _loaded;
    private ROCTabPanelState _state;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private static final String _confirmMsg = "ROC-ApplyCostMatrixToModel";
    private JButton jApplyCostMatrixBtn;
    private JLabel jAvgAccuracyLabel;
    private JTextField jAvgAccuracyText;
    private JComboBox jComboAccurayTypes;
    private JLabel jConfusionMatrixLabel;
    private JLabel jFalsePosRateLabel;
    private JTextField jFalsePosRateText;
    private JLabel jLabel1;
    private JLabel jOverallAccuracyLabel;
    private JTextField jOverallAccuracyText;
    private JScrollPane jScrollPane2;
    private JLabel jThresholdLabel;
    private JTextField jThresholdText;
    private JLabel jTruePosRateLabel;
    private JTextField jTruePosRateText;
    private GenericTable niceTable2;

    public CostMatrixPanel(Object object) {
        this._state = (ROCTabPanelState)object;
        this.initComponents();
        this.initRes();
        this.initUI();
        this.setupUIDetail();
    }

    private void initComponents() {
        this.jConfusionMatrixLabel = new JLabel();
        this.jComboAccurayTypes = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.niceTable2 = new BaseCostMatrixTable();
        this.jTruePosRateLabel = new JLabel();
        this.jTruePosRateText = new NumberTextField();
        this.jFalsePosRateLabel = new JLabel();
        this.jFalsePosRateText = new NumberTextField();
        this.jAvgAccuracyLabel = new JLabel();
        this.jAvgAccuracyText = new NumberTextField();
        this.jOverallAccuracyLabel = new JLabel();
        this.jOverallAccuracyText = new NumberTextField();
        this.jThresholdLabel = new JLabel();
        this.jThresholdText = new NumberTextField();
        this.jApplyCostMatrixBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.jConfusionMatrixLabel.setText("Performance Matrix ");
        this.jComboAccurayTypes.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboAccurayTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixPanel.this.jComboAccurayTypesActionPerformed(actionEvent);
            }
        });
        this.niceTable2.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.niceTable2.setRowSelectionAllowed(false);
        this.niceTable2.setShowHorizontalLines(true);
        this.niceTable2.setShowVerticalLines(true);
        this.jScrollPane2.setViewportView((Component)this.niceTable2);
        this.jTruePosRateLabel.setText("True Positive Rate:");
        this.jFalsePosRateLabel.setText("False Positive Rate:");
        this.jAvgAccuracyLabel.setText("Average Accuracy:");
        this.jOverallAccuracyLabel.setText("Overall Accuracy:");
        this.jThresholdLabel.setText("Probability Threshold:");
        this.jApplyCostMatrixBtn.setText("Apply Derived Cost Matrix to Model");
        this.jApplyCostMatrixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixPanel.this.jApplyCostMatrixBtnActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText("Rows: Actual; Columns: Predicted");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 201, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jConfusionMatrixLabel, -1, 110, Short.MAX_VALUE).addGap(91, 91, 91)).addComponent(this.jComboAccurayTypes, 0, 201, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFalsePosRateLabel).addComponent(this.jAvgAccuracyLabel).addComponent(this.jOverallAccuracyLabel).addComponent(this.jThresholdLabel).addComponent(this.jTruePosRateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jThresholdText, GroupLayout.Alignment.LEADING, -1, 93, Short.MAX_VALUE).addComponent(this.jOverallAccuracyText, GroupLayout.Alignment.LEADING, -1, 93, Short.MAX_VALUE).addComponent(this.jAvgAccuracyText, GroupLayout.Alignment.LEADING, -1, 93, Short.MAX_VALUE).addComponent(this.jFalsePosRateText, GroupLayout.Alignment.LEADING, -1, 93, Short.MAX_VALUE).addComponent(this.jTruePosRateText, -1, 93, Short.MAX_VALUE))).addComponent(this.jApplyCostMatrixBtn, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jConfusionMatrixLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboAccurayTypes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(14, 14, 14).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTruePosRateLabel).addComponent(this.jTruePosRateText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFalsePosRateLabel).addComponent(this.jFalsePosRateText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAvgAccuracyLabel).addComponent(this.jAvgAccuracyText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOverallAccuracyLabel).addComponent(this.jOverallAccuracyText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThresholdLabel).addComponent(this.jThresholdText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jApplyCostMatrixBtn).addContainerGap(-1, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jApplyCostMatrixBtnActionPerformed(ActionEvent actionEvent) {
        if (!MessageDialog.optionalConfirm((String)_confirmMsg, (Component)Ide.getMainWindow(), (String)TestViewerLrb.get("APPLY_COST_MATRIX_CONFIRMATION"), (String)TestViewerLrb.get("APPLY_COST_MATRIX_BTN"), (String)"")) {
            return;
        }
        String string = (String)this.jComboAccurayTypes.getSelectedItem();
        String string2 = this._state.getSelectedTestResult();
        int n = 0;
        if (string.equals(TestViewerLrb.get("OVERALL_ACCURACY"))) {
            n = this._state.getStatisticsData().get(string2).getMaxOverallAccuracyIdx();
        } else if (string.equals(TestViewerLrb.get("AVG_ACCURACY"))) {
            n = this._state.getStatisticsData().get(string2).getMaxAvgAccuracyIdx();
        } else if (string.equals(TestViewerLrb.get("CUSTOM_ACCURACY"))) {
            n = this._state.getStatisticsData().get(string2).getCustomAccuracyIdx();
        } else if (string.equals(TestViewerLrb.get("CURRENT_ACCURACY"))) {
            n = this._state.getStatisticsData().get(string2).getModelAccuracyIdx();
        }
        ROCTabPanelState.ROCData rOCData = this._state.getROCData().get(string2).get(n);
        double d = rOCData.getProb();
        this._state.setCustomThresholdValue(d);
        double d2 = 1.0E-6f;
        double d3 = d - d2 < 0.0 ? d : d - d2;
        double d4 = (1.0 - d3) / d3;
        String string3 = null;
        String string4 = null;
        string3 = this._state.getSelectedTargetValue();
        Vector<String> vector = this._state.getTargetValues();
        string4 = vector.firstElement().equals(string3) ? vector.lastElement() : vector.firstElement();
        Vector<RowColumnValue> vector2 = new Vector<RowColumnValue>();
        vector2.add(new RowColumnValue(string3, string3, new BigDecimal(0.0)));
        vector2.add(new RowColumnValue(string4, string3, new BigDecimal(1.0)));
        vector2.add(new RowColumnValue(string3, string4, new BigDecimal(d4)));
        vector2.add(new RowColumnValue(string4, string4, new BigDecimal(0.0)));
        CostMatrixInfo costMatrixInfo = Model.getROCCostBenefit(vector2);
        Connection connection = null;
        ODMRPkg_Activity oDMRPkg_Activity = null;
        try {
            connection = Connections.getUniqueConnection(this._state.getContext());
            oDMRPkg_Activity = new ODMRPkg_Activity(connection);
            OdmrCostMatrixDetail[] odmrCostMatrixDetailArray = new OdmrCostMatrixDetail[costMatrixInfo.getRowCount() * costMatrixInfo.geColumnCount()];
            n = 0;
            for (int i = 0; i < costMatrixInfo.getRowCount(); ++i) {
                for (int j = 0; j < costMatrixInfo.geColumnCount(); ++j) {
                    RowColumnValue rowColumnValue = costMatrixInfo.getRowColumnValue(i, j);
                    if (rowColumnValue._row instanceof String) {
                        odmrCostMatrixDetailArray[n++] = new OdmrCostMatrixDetail((String)rowColumnValue._row, null, (String)rowColumnValue._col, null, rowColumnValue._value);
                        continue;
                    }
                    if (!(rowColumnValue._row instanceof BigDecimal)) continue;
                    odmrCostMatrixDetailArray[n++] = new OdmrCostMatrixDetail(null, (BigDecimal)rowColumnValue._row, null, (BigDecimal)rowColumnValue._col, rowColumnValue._value);
                }
            }
            OdmrCostMatrix odmrCostMatrix = new OdmrCostMatrix(odmrCostMatrixDetailArray);
            BigDecimal bigDecimal = this._state.getSelectedTestResultObj().getParentId();
            oDMRPkg_Activity.setModelCostBenefit2(bigDecimal, odmrCostMatrix);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void jComboAccurayTypesActionPerformed(ActionEvent actionEvent) {
        this.loadConfusionMatrix();
    }

    private void enableAllControls(boolean bl) {
        this.jApplyCostMatrixBtn.setVisible(false);
        this.jApplyCostMatrixBtn.setEnabled(false);
        this.jComboAccurayTypes.setEnabled(bl);
        this.jTruePosRateText.setEnabled(bl);
        this.jFalsePosRateText.setEnabled(bl);
        this.jAvgAccuracyText.setEnabled(bl);
        this.jOverallAccuracyText.setEnabled(bl);
        this.jThresholdText.setEnabled(bl);
    }

    @Override
    public void viewPropertySelectionChange(DataMinerViewEvent dataMinerViewEvent) {
        if (dataMinerViewEvent.getAction() == "PROPERTY_SELECTION_EVENT") {
            this.loadConfusionMatrix();
        }
    }

    private void loadConfusionMatrix() {
        String string = this._state.getSelectedTestResult();
        ROCTabPanelState.ROCData rOCData = null;
        String string2 = null;
        String string3 = null;
        if (string != null) {
            String string4 = (String)this.jComboAccurayTypes.getSelectedItem();
            int n = 0;
            if (string4.equals(TestViewerLrb.get("OVERALL_ACCURACY"))) {
                n = this._state.getStatisticsData().get(string).getMaxOverallAccuracyIdx();
            } else if (string4.equals(TestViewerLrb.get("AVG_ACCURACY"))) {
                n = this._state.getStatisticsData().get(string).getMaxAvgAccuracyIdx();
            } else if (string4.equals(TestViewerLrb.get("CUSTOM_ACCURACY"))) {
                n = this._state.getStatisticsData().get(string).getCustomAccuracyIdx();
            } else if (string4.equals(TestViewerLrb.get("CURRENT_ACCURACY"))) {
                n = this._state.getStatisticsData().get(string).getModelAccuracyIdx();
            }
            if (n >= 0) {
                rOCData = this._state.getROCData().get(string).get(n);
                this.setNumber(this.jTruePosRateText, new Double(rOCData.getTruePositivesFraction()));
                this.setNumber(this.jFalsePosRateText, new Double(rOCData.getFalsePositivesFraction()));
                this.setNumber(this.jAvgAccuracyText, new Double(rOCData.getAvgAccuracy()));
                this.setNumber(this.jOverallAccuracyText, new Double(rOCData.getAccuracy()));
                this.setNumber(this.jThresholdText, new Double(rOCData.getProb()));
            } else {
                rOCData = null;
                this.setNumber(this.jTruePosRateText, null);
                this.setNumber(this.jFalsePosRateText, null);
                this.setNumber(this.jAvgAccuracyText, null);
                this.setNumber(this.jOverallAccuracyText, null);
                this.setNumber(this.jThresholdText, null);
            }
            string2 = this._state.getSelectedTargetValue();
            Vector<String> vector = this._state.getTargetValues();
            string3 = vector.firstElement().equals(string2) ? vector.lastElement() : vector.firstElement();
        }
        ((BaseCostMatrixTable)this.niceTable2).setModel(new PerformanceMatrixModel(new PerformanceMatrixDataProvider(this._state.getSelectedTargetValue(), string3, rOCData)));
    }

    private void loadState() {
        this.jComboAccurayTypes.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("OVERALL_ACCURACY"), TestViewerLrb.get("AVG_ACCURACY"), TestViewerLrb.get("CUSTOM_ACCURACY"), TestViewerLrb.get("CURRENT_ACCURACY")}));
        this.jComboAccurayTypes.setSelectedIndex(0);
        this.loadConfusionMatrix();
    }

    private void setupUIDetail() {
        this.loadState();
        this.enableAllControls(true);
        this.setLoaded(true);
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    @Override
    public void initUI() {
        this.setEditable(this.jTruePosRateText, false);
        this.setDataType(this.jTruePosRateText, Double.class);
        this.setDecimal(this.jTruePosRateText, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
        this.setLocale(this.jTruePosRateText, Locale.getDefault());
        this.setEditable(this.jFalsePosRateText, false);
        this.setDataType(this.jFalsePosRateText, Double.class);
        this.setDecimal(this.jFalsePosRateText, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
        this.setLocale(this.jFalsePosRateText, Locale.getDefault());
        this.setEditable(this.jAvgAccuracyText, false);
        this.setDataType(this.jAvgAccuracyText, Double.class);
        this.setDecimal(this.jAvgAccuracyText, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
        this.setLocale(this.jAvgAccuracyText, Locale.getDefault());
        this.setEditable(this.jOverallAccuracyText, false);
        this.setDataType(this.jOverallAccuracyText, Double.class);
        this.setDecimal(this.jOverallAccuracyText, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
        this.setLocale(this.jOverallAccuracyText, Locale.getDefault());
        this.setEditable(this.jThresholdText, false);
        this.setDataType(this.jThresholdText, Double.class);
        this.setDecimal(this.jThresholdText, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
        this.setLocale(this.jThresholdText, Locale.getDefault());
        this.enableAllControls(false);
    }

    private void setNumber(JTextField jTextField, Number number) {
        ((NumberTextField)jTextField).setNumber(number);
    }

    private void setDecimal(JTextField jTextField, int n) {
        ((NumberTextField)jTextField).setDecimal(true, n);
    }

    private void setEditable(JTextField jTextField, boolean bl) {
        jTextField.setEditable(bl);
    }

    private void setDataType(JTextField jTextField, Class clazz) {
        ((NumberTextField)jTextField).setDataType(clazz);
    }

    private void setLocale(JTextField jTextField, Locale locale) {
        ((NumberTextField)jTextField).setLocale(locale);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jConfusionMatrixLabel, (Component)this.jComboAccurayTypes, (String)TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE"));
        this.jConfusionMatrixLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE"));
        this.jConfusionMatrixLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTruePosRateLabel, (Component)this.jTruePosRateText, (String)TestViewerLrb.get("TRUE_POSITIVE_RATE_VALUE"));
        this.jTruePosRateLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TRUE_POSITIVE_RATE_VALUE"));
        this.jTruePosRateLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TRUE_POSITIVE_RATE_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jFalsePosRateLabel, (Component)this.jFalsePosRateText, (String)TestViewerLrb.get("FALSE_POSITIVE_RATE_VALUE"));
        this.jFalsePosRateLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("FALSE_POSITIVE_RATE_VALUE"));
        this.jFalsePosRateLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("FALSE_POSITIVE_RATE_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jAvgAccuracyLabel, (Component)this.jAvgAccuracyText, (String)TestViewerLrb.get("AVG_ACCURACY_VALUE"));
        this.jAvgAccuracyLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("AVG_ACCURACY_VALUE"));
        this.jAvgAccuracyLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("AVG_ACCURACY_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jOverallAccuracyLabel, (Component)this.jOverallAccuracyText, (String)TestViewerLrb.get("OVERALL_ACCURACY_VALUE"));
        this.jOverallAccuracyLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("OVERALL_ACCURACY_VALUE"));
        this.jOverallAccuracyLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("OVERALL_ACCURACY_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jThresholdLabel, (Component)this.jThresholdText, (String)TestViewerLrb.get("PROB_THRESHOLD_VALUE"));
        this.jThresholdLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PROB_THRESHOLD_VALUE"));
        this.jThresholdLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PROB_THRESHOLD_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jApplyCostMatrixBtn, (String)TestViewerLrb.get("APPLY_COST_MATRIX_BTN"));
        this.jApplyCostMatrixBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("APPLY_COST_MATRIX_BTN"));
        this.jApplyCostMatrixBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("APPLY_COST_MATRIX_BTN_ADA"));
    }

    @Override
    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
    }

    @Override
    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
    }

    class PerformanceMatrixModel
    extends BaseCostMatrixTableModel {
        public PerformanceMatrixModel(PerformanceMatrixDataProvider performanceMatrixDataProvider) {
            super(performanceMatrixDataProvider);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return super.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class PerformanceMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private ROCTabPanelState.ROCData _data;

        PerformanceMatrixDataProvider(String string, String string2, ROCTabPanelState.ROCData rOCData) {
            this._positiveTarget = string == null ? "" : string;
            this._otherTarget = string2 == null ? "" : string2;
            this._data = rOCData;
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                return null;
            }
            if (n == 0 && n2 == 0) {
                return CostMatrixPanel.this._percentageFormat.format(this._data.getTruePositives());
            }
            if (n == 0 && n2 == 1) {
                return CostMatrixPanel.this._percentageFormat.format(this._data.getFalseNegatives());
            }
            if (n == 1 && n2 == 0) {
                return CostMatrixPanel.this._percentageFormat.format(this._data.getFalsePositives());
            }
            if (n == 1 && n2 == 1) {
                return CostMatrixPanel.this._percentageFormat.format(this._data.getTrueNegatives());
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

