/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitInputPanel;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class ProfitInputDialog {
    private static final String _WIZARD_NAME = TestViewerLrb.get("PROFIT_INPUT_DIALOG");
    private static final String _DIALOG_TITLE = TestViewerLrb.get("PROFIT_INPUT_DIALOG");
    protected JEWTDialog _dlg;
    private ProfitTabState _state;

    public ProfitInputDialog(ProfitTabState profitTabState) {
        this._state = profitTabState;
    }

    protected JEWTDialog buildDialog() {
        ProfitInputPanel profitInputPanel = this.buildPanel();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, _WIZARD_NAME, n);
        jEWTDialog.setContent((Component)profitInputPanel);
        jEWTDialog.setTitle(this.getDialogTitle());
        DialogHeader dialogHeader = new DialogHeader();
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        return jEWTDialog;
    }

    protected String getDialogTitle() {
        return _DIALOG_TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke() {
        boolean bl = false;
        if (this._state != null) {
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                final ProfitInputPanel profitInputPanel = (ProfitInputPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                            try {
                                profitInputPanel.validateAndWriteToState(ProfitInputDialog.this._state);
                            }
                            catch (ValidationException validationException) {
                                MessageDialog.error((Component)ProfitInputDialog.this._dlg, (Object)validationException.getLocalizedMessage(), (String)validationException.getDialogTitle(), null);
                                throw new PropertyVetoException("panel", propertyChangeEvent);
                            }
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog == null) return bl;
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                return bl;
            }
            catch (Exception exception) {
                Assert.printStackTrace((Throwable)exception);
                return bl;
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        } else {
            Assert.println((String)("Failed to create a valid BaliWizardState for wizard " + this));
        }
        return bl;
    }

    protected void cancel() {
    }

    protected ProfitInputPanel buildPanel() {
        return new ProfitInputPanel(this._state);
    }

    protected Image getHeaderImage() {
        return (Image)((Object)OracleIcons.getIcon((String)"warning.png"));
    }
}

