/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.performance;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DateCellRenderer2;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.tviewer.AbstractTestEditor;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.tviewer.performance.PerformanceEditor;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.ColorIcon;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class PerformanceTabPanel
extends DataMinerViewGUI {
    CPerformanceTabState _performanceTabState;
    GraphPanel _graphPanel;
    MeasureItem _selectedMeasureItem;
    MeasureItem _predictionConfidenceMeasureItem;
    MeasureItem _measureItem1;
    MeasureItem _measureItem2;
    MeasureItem _measureItem3;
    MeasureItem _allMeasureItem;
    SortByItem _selectedSortByItem;
    SortOrderItem _selectedSortOrderItem;
    Context _context;
    boolean _showClassResults = true;
    private String[] _columnNames = null;
    private JComboBox _jCBSortOrder;
    private JComboBox _jCB_Measure;
    private JComboBox _jCB_SortBy;
    private JLabel _jLB_Measure;
    private JLabel _jLB_SortBy;
    private JPanel _jPNL_Graph;
    private JSplitPane _jSPLPane;
    private JPanel jPanel1;
    private TransparentPanel jPerformancePanel;
    private ComponentWithTitlebar<JComponent> jPerformanceToolbar;
    private CustomGenericTable _jPerfTable;
    private JScrollPane _jSP_Table;
    private JButton _jBT_AddOrRemove;
    private static Icon _jIC_UpdateENA;
    private static Icon _jIC_UpdateDIS;

    public PerformanceTabPanel(PerformanceEditor performanceEditor, Context context) {
        this._performanceTabState = new CPerformanceTabState((SharedTestEditorState)performanceEditor.getCachedLegendState());
        if (this._performanceTabState.getParentTestViewerState().getTestResults().get(0) instanceof RegressTestResult) {
            this._showClassResults = false;
        }
        this._context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jLB_Measure = new JLabel();
        this._jCB_Measure = new JComboBox();
        this._jLB_SortBy = new JLabel();
        this._jCB_SortBy = new JComboBox();
        this._jCBSortOrder = new JComboBox();
        this._jSPLPane = new JSplitPane();
        this._jPNL_Graph = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPerformancePanel = new TransparentPanel();
        this.jPerformanceToolbar = new ComponentWithTitlebar();
        this._jLB_Measure.setLabelFor(this._jCB_Measure);
        this._jLB_Measure.setText("Measure:");
        this._jCB_Measure.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jLB_SortBy.setLabelFor(this._jCB_SortBy);
        this._jLB_SortBy.setText("Sort By:");
        this._jCB_SortBy.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jCB_SortBy.setMinimumSize(new Dimension(53, 20));
        this._jCBSortOrder.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jCBSortOrder.setMinimumSize(new Dimension(53, 20));
        this._jCBSortOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._jCBSortOrderActionPerformed(actionEvent);
            }
        });
        this._jSPLPane.setDividerLocation(400);
        this._jSPLPane.setOrientation(0);
        this._jSPLPane.setOneTouchExpandable(true);
        this._jSPLPane.setPreferredSize(new Dimension(3, 4));
        this._jPNL_Graph.setMinimumSize(new Dimension(100, 100));
        this._jPNL_Graph.setLayout(new BorderLayout());
        this._jSPLPane.setLeftComponent(this._jPNL_Graph);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPerformancePanel);
        this.jPerformancePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jPerformanceToolbar, -1, 575, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jPerformanceToolbar, -1, 87, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jPerformancePanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jPerformancePanel, -1, -1, Short.MAX_VALUE));
        this._jSPLPane.setRightComponent(this.jPanel1);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jSPLPane, GroupLayout.Alignment.LEADING, -1, 577, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this._jLB_Measure, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCB_Measure, 0, 122, Short.MAX_VALUE).addGap(93, 93, 93).addComponent(this._jLB_SortBy, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCB_SortBy, 0, 92, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCBSortOrder, 0, 70, Short.MAX_VALUE))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_Measure).addComponent(this._jCBSortOrder, -1, -1, Short.MAX_VALUE).addComponent(this._jCB_SortBy, -1, -1, Short.MAX_VALUE).addComponent(this._jCB_Measure).addComponent(this._jLB_SortBy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSPLPane, -1, 493, Short.MAX_VALUE).addContainerGap()));
    }

    private void _jCBSortOrderActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void initRes() {
        this._jLB_Measure.setText(TestViewerLrb.get("MEASURE") + ":");
        this._jCB_Measure.removeAllItems();
        this._predictionConfidenceMeasureItem = new MeasureItem(CPerformanceTabState.Measure.PREDICTIVE_CONFIDENCE, TestViewerLrb.get("PREDICTIVE_CONFIDENCE"));
        if (this._showClassResults) {
            this._measureItem1 = new MeasureItem(CPerformanceTabState.Measure.AVG_ACCURACY, TestViewerLrb.get("AVG_ACCURACY"));
            this._measureItem2 = new MeasureItem(CPerformanceTabState.Measure.OVERALL_ACCURACY, TestViewerLrb.get("OVERALL_ACCURACY"));
            this._measureItem3 = new MeasureItem(CPerformanceTabState.Measure.COST, TestViewerLrb.get("COST"));
            this._columnNames = new String[]{TestViewerLrb.get("NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), TestViewerLrb.get("OVERALL_ACCURACY_COL"), TestViewerLrb.get("AVG_ACCURACY_COL"), this._measureItem3._displayName, TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        } else {
            this._measureItem1 = new MeasureItem(CPerformanceTabState.Measure.MEAN_ABS_ERR, TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"));
            this._measureItem2 = new MeasureItem(CPerformanceTabState.Measure.ROOT_MEAN_SQRT_ERR, TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"));
            this._measureItem3 = new MeasureItem(CPerformanceTabState.Measure.MEAN_PREDICTED_VALUE, TestViewerLrb.get("MEAN_PREDICTED_VALUE"));
            this._columnNames = new String[]{TestViewerLrb.get("NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), this._measureItem1._displayName, this._measureItem2._displayName, this._measureItem3._displayName, TestViewerLrb.get("MEAN_ACTUAL_VALUE"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        }
        this._allMeasureItem = new MeasureItem(CPerformanceTabState.Measure.MULTIPLE_SELECTION, TestViewerLrb.get("MULTIPLE_SELECTION"));
        this._jCB_Measure.addItem(this._predictionConfidenceMeasureItem);
        this._jCB_Measure.addItem(this._measureItem1);
        this._jCB_Measure.addItem(this._measureItem2);
        this._jCB_Measure.addItem(this._measureItem3);
        this._jCB_Measure.addItem(this._allMeasureItem);
        this._selectedMeasureItem = this._allMeasureItem;
        this._jLB_SortBy.setText(TestViewerLrb.get("SORT_BY") + ":");
        this._selectedSortByItem = new SortByItem(CPerformanceTabState.SortBy.NAME, TestViewerLrb.get("NAME"));
        this._jCB_SortBy.removeAllItems();
        this._jCB_SortBy.addItem(this._selectedSortByItem);
        this._jCB_SortBy.addItem(new SortByItem(CPerformanceTabState.SortBy.CREATION_TIME, TestViewerLrb.get("CREATION_DATE")));
        this._jCB_SortBy.addItem(new SortByItem(CPerformanceTabState.SortBy.MEASURE, TestViewerLrb.get("MEASURE")));
        this._selectedSortOrderItem = new SortOrderItem(CPerformanceTabState.SortOrder.DESCENDING, TestViewerLrb.get("DESCENDING"));
        this._jCBSortOrder.removeAllItems();
        this._jCBSortOrder.addItem(new SortOrderItem(CPerformanceTabState.SortOrder.ASCENDING, TestViewerLrb.get("ASCENDING")));
        this._jCBSortOrder.addItem(this._selectedSortOrderItem);
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this._jCB_Measure.setSelectedItem(this._selectedMeasureItem);
        this._jCB_SortBy.setSelectedItem(this._selectedSortByItem);
        this._jCBSortOrder.setSelectedItem(this._selectedSortOrderItem);
        this._jCB_Measure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedMeasureItem = (MeasureItem)PerformanceTabPanel.this._jCB_Measure.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this._jCB_SortBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedSortByItem = (SortByItem)PerformanceTabPanel.this._jCB_SortBy.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this._jCBSortOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PerformanceTabPanel.this._selectedSortOrderItem = (SortOrderItem)PerformanceTabPanel.this._jCBSortOrder.getSelectedItem();
                PerformanceTabPanel.this.reloadGraphPanel();
            }
        });
        this._jPerfTable = new CustomGenericTable();
        this._jSP_Table = new JScrollPane((Component)((Object)this._jPerfTable));
        this.jPerformanceToolbar.setComponent((JComponent)this._jSP_Table);
        this.jPerformanceToolbar.setLabel(new JLabel(TestViewerLrb.get("MODELS")));
        ControlBar controlBar = new ControlBar();
        this.installPerfSummaryActions(controlBar);
        this.jPerformanceToolbar.setControlBar(controlBar);
        this._jSPLPane.setDividerLocation(0.85);
        this._jSPLPane.setResizeWeight(0.85);
        LoadUI loadUI = new LoadUI();
        this._jPNL_Graph.add(GraphPanel.LOADING_GRAPH);
        loadUI.start();
    }

    private void installPerfSummaryActions(ControlBar controlBar) {
        Class<AbstractTestEditor> clazz = AbstractTestEditor.class;
        if (this._performanceTabState.getParentTestViewerState().getAllTestResults().size() > 1) {
            _jIC_UpdateENA = UIResourceHelper.getImageIcon(clazz, TestViewerLrb.get("ADD_REMOVE_BTN_ICON_ENA"));
            _jIC_UpdateDIS = UIResourceHelper.getImageIcon(clazz, TestViewerLrb.get("ADD_REMOVE_BTN_ICON_DIS"));
            this._jBT_AddOrRemove = new JButton(_jIC_UpdateENA);
            this._jBT_AddOrRemove.setDisabledIcon(_jIC_UpdateDIS);
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PerformanceTabPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            controlBar.add((Component)this._jBT_AddOrRemove);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._performanceTabState.getParentTestViewerState(), this._performanceTabState.getParentTestViewerState().getContext(), this._performanceTabState.getParentTestViewerState().getParentActivity(), this._performanceTabState.getParentTestViewerState().getAllTestResults(), this._performanceTabState.getParentTestViewerState().getTestResults())) {
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            this._performanceTabState.getParentTestViewerState().setTestResults(list);
            LoadUI loadUI = new LoadUI();
            loadUI.start();
        }
    }

    private void reloadGraphPanel() {
        int n = 1;
        GenericBaseTableModel genericBaseTableModel = this._performanceTabState.getPerformanceTableModel();
        this._jPerfTable.setFixedColumnCount(n);
        this._jPerfTable.setModel((TableModel)genericBaseTableModel);
        this._jPerfTable.setFixedColumnPreferredWidth(this._columnNames[0], 165);
        this._jPerfTable.findOrCreateTableRowHeader(this._jSP_Table);
        this._jPerfTable.setSorted(true);
        this._jPerfTable.setAutoResizeMode(0);
        this._jPerfTable.addDynamicCellRenderers();
        TableColumnModel tableColumnModel = this._jPerfTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(this._showClassResults ? 145 : 145);
        tableColumnModel.getColumn(1).setPreferredWidth(this._showClassResults ? 125 : 125);
        tableColumnModel.getColumn(2).setPreferredWidth(this._showClassResults ? 130 : 145);
        tableColumnModel.getColumn(3).setPreferredWidth(this._showClassResults ? 75 : 130);
        tableColumnModel.getColumn(4).setPreferredWidth(this._showClassResults ? 135 : 120);
        tableColumnModel.getColumn(5).setPreferredWidth(this._showClassResults ? 135 : 135);
        if (tableColumnModel.getColumnCount() > 6) {
            tableColumnModel.getColumn(6).setPreferredWidth(135);
        }
        this._jPerfTable.setSelectionMode(0);
        this._jPerfTable.setColumnSelectorAvailable(true);
        this._jPerfTable.setShowToolTips(true);
        this._jPerfTable.setSortRetainsSelection(true);
        this._jPerfTable.setRowSelectionAllowed(true);
        this._jPerfTable.addCellRenderer(this._columnNames[0], new CustomCellRenderer());
        if (this._showClassResults) {
            this._jPerfTable.addCellRenderer(this._columnNames[6], new DateCellRenderer2());
        } else {
            this._jPerfTable.addCellRenderer(this._columnNames[7], new DateCellRenderer2());
        }
        this._jPerfTable.setCellRenderers();
        this._jPerfTable.setRowHeaderCellRenderers();
        if (!this._performanceTabState.hasCost()) {
            this._jCB_Measure.removeItem(this._measureItem3);
        }
        if (CPerformanceTabState.Measure.MULTIPLE_SELECTION.equals((Object)this._selectedMeasureItem._measure)) {
            if (!this._performanceTabState.hasCost()) {
                this._jPerfTable.setHiddenColumns(new int[]{3});
            } else {
                this._jPerfTable.setHiddenColumns(new int[0]);
            }
            CPerformanceTabState.Measure[] measureArray = null;
            String[] stringArray = null;
            if (!this._performanceTabState.hasCost()) {
                measureArray = new CPerformanceTabState.Measure[]{this._predictionConfidenceMeasureItem._measure, this._measureItem1._measure, this._measureItem2._measure};
                stringArray = new String[]{this._predictionConfidenceMeasureItem._displayName, this._measureItem1._displayName, this._measureItem2._displayName};
            } else {
                measureArray = new CPerformanceTabState.Measure[]{this._predictionConfidenceMeasureItem._measure, this._measureItem1._measure, this._measureItem2._measure, this._measureItem3._measure};
                stringArray = new String[]{this._predictionConfidenceMeasureItem._displayName, this._measureItem1._displayName, this._measureItem2._displayName, this._measureItem3._displayName};
            }
            GraphPanel[] graphPanelArray = new GraphPanel[measureArray.length];
            GraphDataModel[] graphDataModelArray = new GraphDataModel[measureArray.length];
            this._jPNL_Graph.removeAll();
            this._jPNL_Graph.setLayout(new GridLayout(2, 2));
            for (int i = 0; i < measureArray.length; ++i) {
                graphDataModelArray[i] = this._performanceTabState.sortedGraphDataModel(measureArray[i], this._selectedSortByItem._sortBy, this._selectedSortOrderItem._sortOrder, new Object[]{stringArray[i]});
                graphPanelArray[i] = new GraphPanel(graphDataModelArray[i]);
                graphPanelArray[i].initGraph();
                this._jPNL_Graph.add(graphPanelArray[i]);
            }
            this._jPNL_Graph.updateUI();
        } else {
            GraphDataModel graphDataModel;
            if (!(this._jPNL_Graph.getLayout() instanceof BorderLayout)) {
                this._jPNL_Graph.removeAll();
                this._jPNL_Graph.setLayout(new BorderLayout());
                if (this._graphPanel == null) {
                    graphDataModel = this._performanceTabState.sortedGraphDataModel(this._selectedMeasureItem._measure, this._selectedSortByItem._sortBy, this._selectedSortOrderItem._sortOrder, new Object[]{this._selectedMeasureItem._displayName});
                    this._graphPanel = new GraphPanel(graphDataModel);
                    this._graphPanel.initGraph();
                }
                this._jPNL_Graph.add((Component)this._graphPanel, "Center");
            }
            graphDataModel = this._performanceTabState.sortedGraphDataModel(this._selectedMeasureItem._measure, this._selectedSortByItem._sortBy, this._selectedSortOrderItem._sortOrder, new Object[]{this._selectedMeasureItem._displayName});
            if (CPerformanceTabState.Measure.PREDICTIVE_CONFIDENCE.equals((Object)this._selectedMeasureItem._measure)) {
                this._jPerfTable.setHiddenColumns(new int[]{1, 2, 3});
            } else if (CPerformanceTabState.Measure.OVERALL_ACCURACY.equals((Object)this._selectedMeasureItem._measure) || CPerformanceTabState.Measure.MEAN_ABS_ERR.equals((Object)this._selectedMeasureItem._measure)) {
                this._jPerfTable.setHiddenColumns(new int[]{0, 2, 3});
            } else if (CPerformanceTabState.Measure.AVG_ACCURACY.equals((Object)this._selectedMeasureItem._measure) || CPerformanceTabState.Measure.ROOT_MEAN_SQRT_ERR.equals((Object)this._selectedMeasureItem._measure)) {
                this._jPerfTable.setHiddenColumns(new int[]{0, 1, 3});
            } else if (CPerformanceTabState.Measure.COST.equals((Object)this._selectedMeasureItem._measure) || CPerformanceTabState.Measure.MEAN_PREDICTED_VALUE.equals((Object)this._selectedMeasureItem._measure)) {
                this._jPerfTable.setHiddenColumns(new int[]{0, 1, 2});
            }
            this._graphPanel.initGraph(graphDataModel);
            this._jPNL_Graph.updateUI();
        }
    }

    public void setLegendState(LegendEvent legendEvent) {
        LoadUI loadUI = new LoadUI();
        loadUI.start();
        this.repaint();
    }

    public void updateTime() {
        this._performanceTabState.resetTime();
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        private DateFormat _df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        private Preferences _p = Preferences.getPreferences();
        private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
        private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
        private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

        CustomGenericTable() {
            this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._percentageFormat.setMinimumIntegerDigits(1);
            this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._numericalFormat.setMinimumIntegerDigits(1);
        }

        @Override
        public void addDynamicCellRenderers() {
            NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
            for (String string : PerformanceTabPanel.this._columnNames) {
                if (string.equals(TestViewerLrb.get("NAME"))) {
                    this.addCellRenderer(string, new CustomCellRenderer());
                    continue;
                }
                if (string.equals(TestViewerLrb.get("CREATION_DATE"))) {
                    this.addCellRenderer(string, new DateCellRenderer2());
                    continue;
                }
                if (string.equals(TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"))) {
                    this.addCellRenderer(string, numberCellRenderer);
                    continue;
                }
                if (string.equals(TestViewerLrb.get("OVERALL_ACCURACY_COL"))) {
                    this.addCellRenderer(string, numberCellRenderer);
                    continue;
                }
                if (string.equals(TestViewerLrb.get("AVG_ACCURACY_COL"))) {
                    this.addCellRenderer(string, numberCellRenderer);
                    continue;
                }
                if (string.equals(TestViewerLrb.get("COST"))) {
                    this.addCellRenderer(string, numberCellRenderer);
                    continue;
                }
                if (string.equals(TestViewerLrb.get("MEAN_PREDICTED_VALUE"))) {
                    this.addCellRenderer(string, numberCellRenderer);
                    continue;
                }
                if (string.equals(TestViewerLrb.get("MEAN_ACTUAL_VALUE"))) {
                    this.addCellRenderer(string, numberCellRenderer);
                    continue;
                }
                if (string.equals(TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"))) {
                    this.addCellRenderer(string, numberCellRenderer);
                    continue;
                }
                if (!string.equals(TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"))) continue;
                this.addCellRenderer(string, numberCellRenderer);
            }
        }

        private String formatCellValue(Object object) {
            String string = null;
            string = object != null ? (object instanceof Double ? this._percentageFormat.format((Double)object) : (object instanceof Integer ? this._numericalFormat.format(((Integer)object).intValue()) : (object instanceof BigDecimal ? this._numericalFormat.format(((BigDecimal)object).doubleValue()) : (object instanceof Date ? this._df.format(object) : object.toString())))) : "";
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = this.formatCellValue(object);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = this.formatCellValue(object);
            return string;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(PerformanceTabPanel.this._context);
                PerformanceTabPanel.this._performanceTabState.load(PerformanceTabPanel.this._columnNames, connection);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return PerformanceTabPanel.this._performanceTabState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            int n = 1;
            try {
                if (this._success && this._ex == null) {
                    GenericBaseTableModel genericBaseTableModel = PerformanceTabPanel.this._performanceTabState.getPerformanceTableModel();
                    PerformanceTabPanel.this._jPerfTable.setFixedColumnCount(n);
                    PerformanceTabPanel.this._jPerfTable.setModel((TableModel)genericBaseTableModel);
                    PerformanceTabPanel.this._jPerfTable.setFixedColumnPreferredWidth(PerformanceTabPanel.this._columnNames[0], 165);
                    PerformanceTabPanel.this._jPerfTable.findOrCreateTableRowHeader(PerformanceTabPanel.this._jSP_Table);
                    PerformanceTabPanel.this._jPerfTable.setSorted(true);
                    PerformanceTabPanel.this._jPerfTable.setAutoResizeMode(0);
                    PerformanceTabPanel.this._jPerfTable.addDynamicCellRenderers();
                    TableColumnModel tableColumnModel = PerformanceTabPanel.this._jPerfTable.getColumnModel();
                    tableColumnModel.getColumn(0).setPreferredWidth(PerformanceTabPanel.this._showClassResults ? 145 : 145);
                    tableColumnModel.getColumn(1).setPreferredWidth(PerformanceTabPanel.this._showClassResults ? 125 : 125);
                    tableColumnModel.getColumn(2).setPreferredWidth(PerformanceTabPanel.this._showClassResults ? 130 : 145);
                    tableColumnModel.getColumn(3).setPreferredWidth(PerformanceTabPanel.this._showClassResults ? 75 : 130);
                    tableColumnModel.getColumn(4).setPreferredWidth(PerformanceTabPanel.this._showClassResults ? 135 : 120);
                    tableColumnModel.getColumn(5).setPreferredWidth(PerformanceTabPanel.this._showClassResults ? 135 : 135);
                    if (tableColumnModel.getColumnCount() > 6) {
                        tableColumnModel.getColumn(6).setPreferredWidth(135);
                    }
                    PerformanceTabPanel.this._jPerfTable.setSelectionMode(0);
                    PerformanceTabPanel.this._jPerfTable.setColumnSelectorAvailable(true);
                    PerformanceTabPanel.this._jPerfTable.setShowToolTips(true);
                    PerformanceTabPanel.this._jPerfTable.setSortRetainsSelection(true);
                    PerformanceTabPanel.this._jPerfTable.setRowSelectionAllowed(true);
                    PerformanceTabPanel.this._jPerfTable.addCellRenderer(PerformanceTabPanel.this._columnNames[0], new CustomCellRenderer());
                    if (PerformanceTabPanel.this._showClassResults) {
                        PerformanceTabPanel.this._jPerfTable.addCellRenderer(PerformanceTabPanel.this._columnNames[6], new DateCellRenderer2());
                    } else {
                        PerformanceTabPanel.this._jPerfTable.addCellRenderer(PerformanceTabPanel.this._columnNames[7], new DateCellRenderer2());
                    }
                    PerformanceTabPanel.this._jPerfTable.setCellRenderers();
                    PerformanceTabPanel.this._jPerfTable.setRowHeaderCellRenderers();
                    if (!PerformanceTabPanel.this._performanceTabState.hasCost()) {
                        PerformanceTabPanel.this._jCB_Measure.removeItem(PerformanceTabPanel.this._measureItem3);
                    }
                    if (CPerformanceTabState.Measure.MULTIPLE_SELECTION.equals((Object)PerformanceTabPanel.this._selectedMeasureItem._measure)) {
                        if (!PerformanceTabPanel.this._performanceTabState.hasCost()) {
                            PerformanceTabPanel.this._jPerfTable.setHiddenColumns(new int[]{3});
                        } else {
                            PerformanceTabPanel.this._jPerfTable.setHiddenColumns(new int[0]);
                        }
                        CPerformanceTabState.Measure[] measureArray = null;
                        String[] stringArray = null;
                        if (!PerformanceTabPanel.this._performanceTabState.hasCost()) {
                            measureArray = new CPerformanceTabState.Measure[]{PerformanceTabPanel.this._predictionConfidenceMeasureItem._measure, PerformanceTabPanel.this._measureItem1._measure, PerformanceTabPanel.this._measureItem2._measure};
                            stringArray = new String[]{PerformanceTabPanel.this._predictionConfidenceMeasureItem._displayName, PerformanceTabPanel.this._measureItem1._displayName, PerformanceTabPanel.this._measureItem2._displayName};
                        } else {
                            measureArray = new CPerformanceTabState.Measure[]{PerformanceTabPanel.this._predictionConfidenceMeasureItem._measure, PerformanceTabPanel.this._measureItem1._measure, PerformanceTabPanel.this._measureItem2._measure, PerformanceTabPanel.this._measureItem3._measure};
                            stringArray = new String[]{PerformanceTabPanel.this._predictionConfidenceMeasureItem._displayName, PerformanceTabPanel.this._measureItem1._displayName, PerformanceTabPanel.this._measureItem2._displayName, PerformanceTabPanel.this._measureItem3._displayName};
                        }
                        GraphPanel[] graphPanelArray = new GraphPanel[measureArray.length];
                        GraphDataModel[] graphDataModelArray = new GraphDataModel[measureArray.length];
                        PerformanceTabPanel.this._jPNL_Graph.removeAll();
                        PerformanceTabPanel.this._jPNL_Graph.setLayout(new GridLayout(2, 2));
                        for (int i = 0; i < measureArray.length; ++i) {
                            graphDataModelArray[i] = PerformanceTabPanel.this._performanceTabState.sortedGraphDataModel(measureArray[i], PerformanceTabPanel.this._selectedSortByItem._sortBy, PerformanceTabPanel.this._selectedSortOrderItem._sortOrder, new Object[]{stringArray[i]});
                            graphPanelArray[i] = new GraphPanel(graphDataModelArray[i]);
                            graphPanelArray[i].initGraph();
                            PerformanceTabPanel.this._jPNL_Graph.add(graphPanelArray[i]);
                        }
                    } else {
                        if (CPerformanceTabState.Measure.PREDICTIVE_CONFIDENCE.equals((Object)PerformanceTabPanel.this._selectedMeasureItem._measure)) {
                            PerformanceTabPanel.this._jPerfTable.setHiddenColumns(new int[]{1, 2, 3});
                        } else if (CPerformanceTabState.Measure.OVERALL_ACCURACY.equals((Object)PerformanceTabPanel.this._selectedMeasureItem._measure) || CPerformanceTabState.Measure.MEAN_ABS_ERR.equals((Object)PerformanceTabPanel.this._selectedMeasureItem._measure)) {
                            PerformanceTabPanel.this._jPerfTable.setHiddenColumns(new int[]{0, 2, 3});
                        } else if (CPerformanceTabState.Measure.AVG_ACCURACY.equals((Object)PerformanceTabPanel.this._selectedMeasureItem._measure) || CPerformanceTabState.Measure.ROOT_MEAN_SQRT_ERR.equals((Object)PerformanceTabPanel.this._selectedMeasureItem._measure)) {
                            PerformanceTabPanel.this._jPerfTable.setHiddenColumns(new int[]{0, 1, 3});
                        } else if (CPerformanceTabState.Measure.COST.equals((Object)PerformanceTabPanel.this._selectedMeasureItem._measure) || CPerformanceTabState.Measure.MEAN_PREDICTED_VALUE.equals((Object)PerformanceTabPanel.this._selectedMeasureItem._measure)) {
                            PerformanceTabPanel.this._jPerfTable.setHiddenColumns(new int[]{0, 1, 2});
                        }
                        GraphDataModel graphDataModel = PerformanceTabPanel.this._performanceTabState.sortedGraphDataModel(PerformanceTabPanel.this._selectedMeasureItem._measure, PerformanceTabPanel.this._selectedSortByItem._sortBy, PerformanceTabPanel.this._selectedSortOrderItem._sortOrder, new Object[]{PerformanceTabPanel.this._selectedMeasureItem._displayName});
                        PerformanceTabPanel.this._graphPanel = new GraphPanel(graphDataModel);
                        PerformanceTabPanel.this._jPNL_Graph.removeAll();
                        PerformanceTabPanel.this._graphPanel.initGraph();
                        PerformanceTabPanel.this._jPNL_Graph.add((Component)PerformanceTabPanel.this._graphPanel, "Center");
                    }
                    PerformanceTabPanel.this._jPerfTable.setRowSelectionInterval(0, 0);
                    PerformanceTabPanel.this.updateUI();
                    PerformanceTabPanel.this.setLoaded(true);
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                PerformanceTabPanel.this.setLoading(false);
            }
        }
    }

    private class SortOrderItem {
        CPerformanceTabState.SortOrder _sortOrder;
        String _displayName;

        public SortOrderItem(CPerformanceTabState.SortOrder sortOrder, String string) {
            this._sortOrder = sortOrder;
            this._displayName = string;
        }

        public String toString() {
            return this._displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof SortOrderItem) {
                return this._sortOrder.equals((Object)((SortOrderItem)object)._sortOrder);
            }
            return false;
        }
    }

    private class SortByItem {
        CPerformanceTabState.SortBy _sortBy;
        String _displayName;

        public SortByItem(CPerformanceTabState.SortBy sortBy, String string) {
            this._sortBy = sortBy;
            this._displayName = string;
        }

        public String toString() {
            return this._displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof SortByItem) {
                return this._sortBy.equals((Object)((SortByItem)object)._sortBy);
            }
            return false;
        }
    }

    private class MeasureItem {
        CPerformanceTabState.Measure _measure;
        String _displayName;

        public MeasureItem(CPerformanceTabState.Measure measure, String string) {
            this._measure = measure;
            this._displayName = string;
        }

        public String toString() {
            return this._displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof MeasureItem) {
                return this._measure.equals((Object)((MeasureItem)object)._measure);
            }
            return false;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(object instanceof String)) assert (false);
            String string = (String)object;
            Color color = PerformanceTabPanel.this._performanceTabState.getParentTestViewerState().getTestResultGraphColor(string);
            this.setIcon((Icon)new ColorIcon(color));
            return component;
        }
    }
}

