/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.matrix;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.RowFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class PMatrixTabState {
    private SharedTestEditorState _parentTestViewerState;
    private Map<BigDecimal, PerformanceMatrixModel> _matricesMap;
    private Map<BigDecimal, PerformanceMatrixSummaryModel> _matrixSummaryMap;
    private Map<String, PerformanceMatrixSummaryModel> _matrixSummaryMapByName;
    private Map<BigDecimal, CPerformanceTabState.PerformanceMetric> _metricsMap;
    private PMatrixCompareModel _compareSummaryModel;
    private ArrayList<String> _testResultNames = new ArrayList();
    private ArrayList<BigDecimal> _testResultIds = new ArrayList();
    private boolean _currentPivotMode = false;
    private Vector<String> _currentSelectedTestResults = new Vector();
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private static final String PMATRIX_SUMMARY_STAT_WITHOUT_COST = new StringBuffer("WITH total_actuals AS ").append("  (SELECT actual_target_value, ").append("     SUM(VALUE) total_actuals ").append("   FROM {0} ").append("   GROUP BY actual_target_value), ").append("  total_predicted AS ").append("  (SELECT predicted_target_value, ").append("     SUM(VALUE) total_predicted ").append("   FROM {0} ").append("   GROUP BY predicted_target_value), ").append("  right_predictions AS ").append("  (SELECT actual_target_value, ").append("     VALUE AS correct ").append("   FROM {0} ").append("   WHERE actual_target_value = predicted_target_value) ").append("SELECT a.actual_target_value target_value, ").append("  total_actuals, ").append("  nvl(total_predicted, 0) total_predicted, ").append("  null as actuals_cost, ").append("  null as predicted_cost, ").append("  nvl((correct / total_actuals) * 100, 0) correct_perc_actual, ").append("  nvl((correct / total_predicted) * 100, 0) correct_perc_predicted, ").append("  null as actuals_perc_cost , ").append("  nvl(correct, 0) correct_predicted ").append("FROM total_actuals a, total_predicted p, right_predictions c  ").append("WHERE a.actual_target_value = p.predicted_target_value(+) AND a.actual_target_value = c.actual_target_value(+) ").append("ORDER BY a.actual_target_value asc").toString();
    private static final String PMATRIX_SUMMARY_STAT_WITH_COST = new StringBuffer(" WITH tr_cost AS ").append("  (    select ACTUAL actual_target_value, PREDICTED predicted_target_value, COST ").append("  from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(?)) ").append("  ), ").append("  total_actuals AS ").append("  (SELECT nvl(a.actual_target_value,    b.actual_target_value) actual_target_value, ").append("     SUM(a.VALUE * b.cost) actuals_cost, ").append("     SUM(a.VALUE) total_actuals ").append("   FROM {0} a, ").append("     tr_cost b ").append("   WHERE a.actual_target_value(+) = b.actual_target_value ").append("   AND a.predicted_target_value(+) = b.predicted_target_value ").append("   GROUP BY nvl(a.actual_target_value,    b.actual_target_value)), ").append("  total_predicted AS ").append("  (SELECT nvl(a.predicted_target_value,    b.predicted_target_value) predicted_target_value, ").append("     SUM(a.VALUE * b.cost) predicted_cost, ").append("     SUM(a.VALUE) total_predicted ").append("   FROM {0} a, ").append("     tr_cost b ").append("   WHERE a.actual_target_value(+) = b.actual_target_value ").append("   AND a.predicted_target_value(+) = b.predicted_target_value ").append("   GROUP BY nvl(a.predicted_target_value,    b.predicted_target_value)), ").append("  right_predictions AS ").append("  (SELECT actual_target_value, ").append("     VALUE AS correct ").append("   FROM {0} ").append("   WHERE actual_target_value = predicted_target_value), ").append("  actuals_total_cost as ").append("  (SELECT SUM(a.VALUE * b.cost) actuals_total_cost, a.actual_target_value ").append("   FROM {0} a, ").append("     tr_cost b ").append("   WHERE a.actual_target_value = b.actual_target_value ").append("   AND a.predicted_target_value = b.predicted_target_value group by a.actual_target_value) ").append("SELECT a.actual_target_value target_value, ").append("  nvl(total_actuals, 0) total_actuals, ").append("  nvl(total_predicted, 0) total_predicted, ").append("  nvl(actuals_cost, 0) actuals_cost, ").append("  nvl(predicted_cost, 0) predicted_cost, ").append("  nvl((correct / total_actuals) * 100, 0) correct_perc_actual, ").append("  nvl((correct / total_predicted) * 100, 0) correct_perc_predicted, ").append("  nvl((actuals_cost / GREATEST(0.0001, tc.actuals_total_cost)) * 100, 0) actuals_perc_cost, ").append("  nvl(correct, 0) correct_predicted ").append("FROM total_actuals a, ").append("  total_predicted p, ").append("  right_predictions c, ").append("  actuals_total_cost tc ").append("WHERE a.actual_target_value = p.predicted_target_value(+) AND a.actual_target_value = c.actual_target_value(+) AND a.actual_target_value = tc.actual_target_value ").append("ORDER BY a.actual_target_value ASC").toString();
    public static final int IX_TARGET_VALUES = 0;
    public static final int IX_TOTAL_ACTUALS = 1;
    public static final int IX_TOTAL_PREDICTED = 2;
    public static final int IX_ACTUAL_COST = 3;
    public static final int IX_PREDICTED_COST = 4;
    public static final int IX_CORRECT_PERC_ACTUAL = 5;
    public static final int IX_CORRECT_PERC_PREDICTED = 6;
    public static final int IX_ACTUAL_PERC_COST = 7;
    public static final int IX_CORRECT_PREDICTED = 8;
    private static final Integer ZERO = new Integer(0);

    public PMatrixTabState(SharedTestEditorState sharedTestEditorState) {
        this._parentTestViewerState = sharedTestEditorState;
    }

    public void setCurrentSelectedTestResults(Vector<String> vector) {
        this._currentSelectedTestResults = vector;
    }

    public Vector<String> getCurrentSelectedTestResults() {
        return this._currentSelectedTestResults;
    }

    public CPerformanceTabState.PerformanceMetric getPerformanceMetric(BigDecimal bigDecimal) {
        return this._metricsMap.get(bigDecimal);
    }

    public PerformanceMatrixModel getPerformanceMatrixModel(BigDecimal bigDecimal) {
        return this._matricesMap.get(bigDecimal);
    }

    public PerformanceMatrixSummaryModel getPerformanceMatrixSummaryModel(BigDecimal bigDecimal) {
        return this._matrixSummaryMap.get(bigDecimal);
    }

    public void switchCurrentPivotMode() {
        this._currentPivotMode = !this._currentPivotMode;
    }

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public ArrayList<String> getTestResultNames() {
        return this._testResultNames;
    }

    public ArrayList<BigDecimal> getTestResultIds() {
        return this._testResultIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(Connection connection) throws Exception {
        this._numericalFormat.setMaximumFractionDigits(this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
        this._percentageFormat.setMaximumFractionDigits(this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
        boolean bl = false;
        this._matricesMap = new HashMap<BigDecimal, PerformanceMatrixModel>();
        this._matrixSummaryMap = new HashMap<BigDecimal, PerformanceMatrixSummaryModel>();
        this._matrixSummaryMapByName = new HashMap<String, PerformanceMatrixSummaryModel>();
        this._metricsMap = new HashMap<BigDecimal, CPerformanceTabState.PerformanceMetric>();
        List<CPerformanceTabState.PerformanceMetric> list = this._parentTestViewerState.getPerformanceMetrics();
        if (list == null) {
            CPerformanceTabState cPerformanceTabState = new CPerformanceTabState(this._parentTestViewerState);
            cPerformanceTabState.load(null, connection);
            list = this._parentTestViewerState.getPerformanceMetrics();
        }
        int n = 0;
        for (TestResult testResult : this._parentTestViewerState.getTestResults()) {
            String string;
            int n2 = 0;
            String string2 = ((ClassTestResult)testResult).getConfusionMatrixTable();
            this._metricsMap.put(testResult.getId(), list.get(n++));
            SQLHelper sQLHelper = new SQLHelper();
            ArrayList[] arrayListArray = new ArrayList[9];
            try {
                string = "select COUNT(COST) from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(?))";
                sQLHelper.pstmt = connection.prepareStatement(string);
                sQLHelper.pstmt.setString(1, testResult.toString());
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    if (sQLHelper.rs.getInt(1) > 0) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                }
                if (bl) {
                    string = "SELECT COUNT(*) FROM user_mining_models WHERE model_name = ? AND COMMENTS = 'BALANCED'";
                    sQLHelper.pstmt = connection.prepareStatement(string);
                    sQLHelper.pstmt.setString(1, testResult.toString());
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        if (sQLHelper.rs.getInt(1) > 0) {
                            bl = false;
                            continue;
                        }
                        bl = true;
                    }
                }
            }
            finally {
                sQLHelper.close();
            }
            string = null;
            string = bl ? PMATRIX_SUMMARY_STAT_WITH_COST : PMATRIX_SUMMARY_STAT_WITHOUT_COST;
            Object[] objectArray = new Object[]{string2};
            string = MessageFormat.format(string, objectArray);
            Double d = 0.0;
            Double d2 = 0.0;
            Double d3 = 0.0;
            try {
                sQLHelper.pstmt = connection.prepareStatement(string);
                if (bl) {
                    sQLHelper.pstmt.setString(1, testResult.toString());
                }
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                boolean bl2 = true;
                while (sQLHelper.rs.next()) {
                    if (bl2) {
                        arrayListArray[0] = new ArrayList();
                        arrayListArray[1] = new ArrayList();
                        arrayListArray[2] = new ArrayList();
                        arrayListArray[3] = new ArrayList();
                        arrayListArray[4] = new ArrayList();
                        arrayListArray[5] = new ArrayList();
                        arrayListArray[6] = new ArrayList();
                        arrayListArray[7] = new ArrayList();
                        arrayListArray[8] = new ArrayList();
                        bl2 = false;
                    }
                    arrayListArray[0].add(sQLHelper.rs.getObject("target_value"));
                    d = d + sQLHelper.rs.getDouble("total_actuals");
                    d2 = d2 + sQLHelper.rs.getDouble("correct_predicted");
                    d3 = d3 + sQLHelper.rs.getDouble("predicted_cost");
                    arrayListArray[1].add(sQLHelper.rs.getObject("total_actuals"));
                    arrayListArray[2].add(sQLHelper.rs.getObject("total_predicted"));
                    arrayListArray[3].add(sQLHelper.rs.getObject("actuals_cost"));
                    arrayListArray[4].add(sQLHelper.rs.getObject("predicted_cost"));
                    arrayListArray[5].add(sQLHelper.rs.getObject("correct_perc_actual"));
                    arrayListArray[6].add(sQLHelper.rs.getObject("correct_perc_predicted"));
                    arrayListArray[7].add(sQLHelper.rs.getObject("actuals_perc_cost"));
                    arrayListArray[8].add(sQLHelper.rs.getObject("correct_predicted"));
                }
            }
            finally {
                sQLHelper.close();
            }
            PerformanceMatrixSummaryModel performanceMatrixSummaryModel = new PerformanceMatrixSummaryModel(testResult.toString(), arrayListArray, d, d2, d3);
            this._matrixSummaryMap.put(testResult.getId(), performanceMatrixSummaryModel);
            this._matrixSummaryMapByName.put(testResult.toString(), performanceMatrixSummaryModel);
            string = "Select ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE, VALUE from " + string2 + " order by ACTUAL_TARGET_VALUE ASC, PREDICTED_TARGET_VALUE ASC";
            HashMap<TargetPair, BigDecimal> hashMap = new HashMap<TargetPair, BigDecimal>();
            try {
                Object object;
                Object object2;
                sQLHelper.pstmt = connection.prepareStatement(string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    object2 = sQLHelper.rs.getObject("ACTUAL_TARGET_VALUE");
                    object = sQLHelper.rs.getObject("PREDICTED_TARGET_VALUE");
                    BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("VALUE");
                    n2 += bigDecimal.intValue();
                    hashMap.put(new TargetPair(object2, object), bigDecimal);
                }
                object2 = new PerformanceMatrixDataProvider(hashMap, arrayListArray, n2);
                object = new PerformanceMatrixModel((PerformanceMatrixDataProvider)object2);
                this._matricesMap.put(testResult.getId(), (PerformanceMatrixModel)((Object)object));
                this._testResultNames.add(testResult.getName());
                this._testResultIds.add(testResult.getId());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw sQLException;
            }
            finally {
                sQLHelper.close();
            }
        }
        this._compareSummaryModel = new PMatrixCompareModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh(Connection connection) throws Exception {
        boolean bl = false;
        this._matrixSummaryMap = new HashMap<BigDecimal, PerformanceMatrixSummaryModel>();
        for (TestResult testResult : this._parentTestViewerState.getTestResults()) {
            String string;
            String string2 = ((ClassTestResult)testResult).getConfusionMatrixTable();
            SQLHelper sQLHelper = new SQLHelper();
            ArrayList[] arrayListArray = new ArrayList[9];
            try {
                string = "select COUNT(COST) from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(?))";
                sQLHelper.pstmt = connection.prepareStatement(string);
                sQLHelper.pstmt.setString(1, testResult.toString());
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    if (sQLHelper.rs.getInt(1) > 0) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                }
                if (bl) {
                    string = "SELECT COUNT(*) FROM user_mining_models WHERE model_name = ? AND COMMENTS = 'BALANCED'";
                    sQLHelper.pstmt = connection.prepareStatement(string);
                    sQLHelper.pstmt.setString(1, testResult.toString());
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        if (sQLHelper.rs.getInt(1) > 0) {
                            bl = false;
                            continue;
                        }
                        bl = true;
                    }
                }
            }
            finally {
                sQLHelper.close();
            }
            string = null;
            string = bl ? PMATRIX_SUMMARY_STAT_WITH_COST : PMATRIX_SUMMARY_STAT_WITHOUT_COST;
            Object[] objectArray = new Object[]{string2};
            string = MessageFormat.format(string, objectArray);
            Double d = 0.0;
            Double d2 = 0.0;
            Double d3 = 0.0;
            try {
                sQLHelper.pstmt = connection.prepareStatement(string);
                if (bl) {
                    sQLHelper.pstmt.setString(1, testResult.toString());
                }
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                boolean bl2 = true;
                while (sQLHelper.rs.next()) {
                    if (bl2) {
                        arrayListArray[0] = new ArrayList();
                        arrayListArray[1] = new ArrayList();
                        arrayListArray[2] = new ArrayList();
                        arrayListArray[3] = new ArrayList();
                        arrayListArray[4] = new ArrayList();
                        arrayListArray[5] = new ArrayList();
                        arrayListArray[6] = new ArrayList();
                        arrayListArray[7] = new ArrayList();
                        arrayListArray[8] = new ArrayList();
                        bl2 = false;
                    }
                    arrayListArray[0].add(sQLHelper.rs.getObject("target_value"));
                    d = d + sQLHelper.rs.getDouble("total_actuals");
                    d2 = d2 + sQLHelper.rs.getDouble("correct_predicted");
                    d3 = d3 + sQLHelper.rs.getDouble("predicted_cost");
                    arrayListArray[1].add(sQLHelper.rs.getObject("total_actuals"));
                    arrayListArray[2].add(sQLHelper.rs.getObject("total_predicted"));
                    arrayListArray[3].add(sQLHelper.rs.getObject("actuals_cost"));
                    arrayListArray[4].add(sQLHelper.rs.getObject("predicted_cost"));
                    arrayListArray[5].add(sQLHelper.rs.getObject("correct_perc_actual"));
                    arrayListArray[6].add(sQLHelper.rs.getObject("correct_perc_predicted"));
                    arrayListArray[7].add(sQLHelper.rs.getObject("actuals_perc_cost"));
                    arrayListArray[8].add(sQLHelper.rs.getObject("correct_predicted"));
                }
            }
            finally {
                sQLHelper.close();
            }
            PerformanceMatrixSummaryModel performanceMatrixSummaryModel = new PerformanceMatrixSummaryModel(testResult.getName(), arrayListArray, d, d2, d3);
            this._matrixSummaryMap.put(testResult.getId(), performanceMatrixSummaryModel);
        }
        this._compareSummaryModel = new PMatrixCompareModel();
    }

    public GenericBaseTableModel getCompareSummaryModel() {
        return this._compareSummaryModel;
    }

    public PMatrixTargetCompareModel createPMatrixTargetCompareModel(Vector<String> vector, int n) {
        return new PMatrixTargetCompareModel(vector, n);
    }

    private class PerformanceMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private Map<TargetPair, BigDecimal> _confusionMatrix;
        private ArrayList[] _summaryInfo;
        private Object[] _targetValues;
        private Object[] _targetValuesWithTotalsAndCosts;
        private int _totalValues;
        private int _actualNumOfTargets;
        private int col_total_actuals;
        private int col_correct_perc_actuals;
        private int col_cost_actuals;
        private int row_total_predicted;
        private int row_correct_perc_predicted;
        private int row_cost_predicted;
        private boolean _hideTotals;

        PerformanceMatrixDataProvider(Map<TargetPair, BigDecimal> map, ArrayList[] arrayListArray, int n) {
            this._confusionMatrix = map;
            this._summaryInfo = arrayListArray;
            this._actualNumOfTargets = this._summaryInfo[0].size();
            this._targetValuesWithTotalsAndCosts = new Object[this._summaryInfo[0].size() + 3];
            this._targetValues = this._summaryInfo[0].toArray();
            this._targetValuesWithTotalsAndCosts = this._summaryInfo[0].toArray(this._targetValuesWithTotalsAndCosts);
            this._targetValuesWithTotalsAndCosts[this._actualNumOfTargets] = TestViewerLrb.get("PMATRIX_TOTAL");
            this._targetValuesWithTotalsAndCosts[this._actualNumOfTargets + 1] = TestViewerLrb.get("PMATRIX_CORRECT_PERC");
            this._targetValuesWithTotalsAndCosts[this._actualNumOfTargets + 2] = TestViewerLrb.get("PMATRIX_COST");
            this.col_total_actuals = this._actualNumOfTargets;
            this.col_correct_perc_actuals = this.col_total_actuals + 1;
            this.col_cost_actuals = this.col_correct_perc_actuals + 1;
            this.row_total_predicted = this.col_total_actuals;
            this.row_correct_perc_predicted = this.col_correct_perc_actuals;
            this.row_cost_predicted = this.col_cost_actuals;
            this._totalValues = n;
        }

        @Override
        public Object[] getTargetValues() {
            if (this._hideTotals) {
                return this._targetValues;
            }
            return this._targetValuesWithTotalsAndCosts;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= this._actualNumOfTargets && n2 >= this._actualNumOfTargets) {
                if (n == this._actualNumOfTargets && n2 == this._actualNumOfTargets) {
                    return PMatrixTabState.this._numericalFormat.format(this._totalValues);
                }
                return null;
            }
            if (n < this._actualNumOfTargets && n2 < this._actualNumOfTargets) {
                BigDecimal bigDecimal = this._confusionMatrix.get(new TargetPair(this._targetValues[n], this._targetValues[n2]));
                if (bigDecimal == null) {
                    return ZERO;
                }
                return PMatrixTabState.this._numericalFormat.format(bigDecimal.intValue());
            }
            if (n < this._actualNumOfTargets && n2 >= this._actualNumOfTargets) {
                if (n2 == this.col_total_actuals) {
                    Object e = this._summaryInfo[1].get(n);
                    if (e == null) {
                        return ZERO;
                    }
                    return PMatrixTabState.this._numericalFormat.format(((BigDecimal)e).intValue());
                }
                if (n2 == this.col_correct_perc_actuals) {
                    Object e = this._summaryInfo[5].get(n);
                    if (e == null) {
                        return ZERO;
                    }
                    return PMatrixTabState.this._percentageFormat.format(((BigDecimal)e).doubleValue());
                }
                if (n2 == this.col_cost_actuals) {
                    Object e = this._summaryInfo[3].get(n);
                    if (e == null) {
                        return e;
                    }
                    return PMatrixTabState.this._percentageFormat.format(((BigDecimal)e).doubleValue());
                }
                return null;
            }
            if (n >= this._actualNumOfTargets && n2 < this._actualNumOfTargets) {
                if (n == this.row_total_predicted) {
                    Object e = this._summaryInfo[2].get(n2);
                    if (e == null) {
                        return ZERO;
                    }
                    return PMatrixTabState.this._numericalFormat.format(((BigDecimal)e).intValue());
                }
                if (n == this.row_correct_perc_predicted) {
                    Object e = this._summaryInfo[6].get(n2);
                    if (e == null) {
                        return ZERO;
                    }
                    return PMatrixTabState.this._percentageFormat.format(((BigDecimal)e).doubleValue());
                }
                if (n == this.row_cost_predicted) {
                    Object e = this._summaryInfo[4].get(n2);
                    if (e == null) {
                        return e;
                    }
                    return PMatrixTabState.this._percentageFormat.format(((BigDecimal)e).doubleValue());
                }
                return null;
            }
            return ZERO;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public int[] getTotalAndCostColumnIndexes() {
            return new int[]{this.col_total_actuals + 1, this.col_correct_perc_actuals + 1, this.col_cost_actuals + 1};
        }

        public int[] getTotalAndCostRowIndexes() {
            return new int[]{this.col_total_actuals, this.col_correct_perc_actuals, this.col_cost_actuals};
        }
    }

    class HideRows
    extends RowFilter {
        int[] _hiddenRows = null;

        HideRows(int[] nArray) {
            this._hiddenRows = nArray;
        }

        public boolean include(RowFilter.Entry entry) {
            if (this._hiddenRows == null || this._hiddenRows.length == 0) {
                return true;
            }
            return Arrays.binarySearch(this._hiddenRows, (Integer)entry.getIdentifier()) == -1;
        }
    }

    public class PMatrixTargetCompareModel
    extends GenericBaseTableModel {
        private Vector _values = null;
        private Vector<String> _columnNames = null;
        private Vector<String> _selectedResults = null;
        private int _selectedValueMetricIndex = 5;
        private int _totalValue = 0;

        public PMatrixTargetCompareModel(Vector<String> vector, int n) {
            this._selectedResults = vector;
            this._columnNames = new Vector<String>(this._selectedResults);
            this._columnNames.add(0, TestViewerLrb.get("PMATRIX_TARGET_VALUE"));
            this._selectedValueMetricIndex = n;
            this.setupTable();
        }

        public int getTotalValue() {
            if (this._totalValue == 0) {
                return 1;
            }
            return this._totalValue;
        }

        public void setupTable() {
            if (this._selectedResults == null || this._selectedResults.size() == 0) {
                this._values = new Vector();
                Vector<String> vector = new Vector<String>();
                vector.add(TestViewerLrb.get("PMATRIX_SELECT_TEST_RESULT"));
                this._values.add(vector);
                this._columnNames = new Vector();
                this._columnNames.add("...");
            } else {
                this._values = new Vector();
                boolean bl = true;
                for (String string : this._selectedResults) {
                    ArrayList[] arrayListArray;
                    PerformanceMatrixSummaryModel performanceMatrixSummaryModel = (PerformanceMatrixSummaryModel)((Object)PMatrixTabState.this._matrixSummaryMapByName.get(string));
                    if (performanceMatrixSummaryModel == null || (arrayListArray = performanceMatrixSummaryModel.getSummaryInfo()) == null) continue;
                    for (int i = 0; i < arrayListArray[0].size(); ++i) {
                        Vector vector;
                        if (bl) {
                            vector = new Vector();
                            vector.add(arrayListArray[0].get(i));
                            if (arrayListArray[this._selectedValueMetricIndex].get(i) == null) {
                                vector.add(0.0);
                            } else {
                                try {
                                    this._totalValue = (int)((double)this._totalValue + Math.ceil(((Number)arrayListArray[this._selectedValueMetricIndex].get(i)).doubleValue()));
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                vector.add(arrayListArray[this._selectedValueMetricIndex].get(i));
                            }
                            this._values.add(vector);
                            continue;
                        }
                        vector = (Vector)this._values.get(i);
                        if (arrayListArray[this._selectedValueMetricIndex].get(i) == null) {
                            vector.add(0.0);
                            continue;
                        }
                        vector.add(arrayListArray[this._selectedValueMetricIndex].get(i));
                    }
                    bl = false;
                }
            }
            super.setDataVector(this._values, this._columnNames);
        }
    }

    class PMatrixCompareModel
    extends GenericBaseTableModel {
        private Vector _values = null;
        private Vector _columnNames = null;
        private String _resultNameColName = TestViewerLrb.get("PMATRIX_RESULTS_COL_NAME");

        public PMatrixCompareModel() {
            this.setupTable();
        }

        public Object getValueAt(int n, int n2) {
            Object object = super.getValueAt(n, n2);
            if (object == null && n2 > 0) {
                return 0.0;
            }
            return object;
        }

        public void setupTable() {
            this._columnNames = new Vector();
            Collection collection = PMatrixTabState.this._matrixSummaryMap.values();
            this._columnNames.add(this._resultNameColName);
            this._columnNames.add(TestViewerLrb.get("PMATRIX_CORRECT_PERC_PREDICTED"));
            this._columnNames.add(TestViewerLrb.get("PMATRIX_CORRECT_PREDICTED_COUNT"));
            this._columnNames.add(TestViewerLrb.get("PMATRIX_TOTAL_ACTUALS"));
            this._columnNames.add(TestViewerLrb.get("PMATRIX_TOTAL_COST"));
            this._values = new Vector();
            Vector<Object> vector = null;
            for (PerformanceMatrixSummaryModel performanceMatrixSummaryModel : collection) {
                vector = new Vector<Object>();
                vector.add(performanceMatrixSummaryModel.getResultName());
                vector.add(performanceMatrixSummaryModel.getCorrectPredictionPercentage());
                vector.add(performanceMatrixSummaryModel.getTotalPredicted().intValue());
                vector.add(performanceMatrixSummaryModel.getTotalActuals().intValue());
                vector.add(performanceMatrixSummaryModel.getTotalCost());
                this._values.add(vector);
            }
            super.setDataVector(this._values, this._columnNames);
        }
    }

    class PerformanceMatrixModel
    extends BaseCostMatrixTableModel {
        private PerformanceMatrixDataProvider _dataProvider;
        private int[] _hiddenColIxs;
        private int[] _hiddenRowIxs;
        private Boolean _hide;
        private TableColumn[] _hiddenCols;
        private HideRows _hiddenRows;
        private TableRowSorter<TableModel> _sorter;

        public PerformanceMatrixModel(PerformanceMatrixDataProvider performanceMatrixDataProvider) {
            super(performanceMatrixDataProvider);
            this._hide = null;
            this._hiddenCols = null;
            this._hiddenRows = null;
            this._dataProvider = performanceMatrixDataProvider;
            this.setColumn0Header("");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return super.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public int[] getTotalAndCostColumnIndexes() {
            return this._dataProvider.getTotalAndCostColumnIndexes();
        }

        public int[] getTotalAndCostRowIndexes() {
            return this._dataProvider.getTotalAndCostRowIndexes();
        }

        public synchronized void setHideSettings(int[] nArray, int[] nArray2, boolean bl) {
            this._hiddenColIxs = nArray;
            this._hiddenRowIxs = nArray2;
            this._hide = bl;
            this._hiddenRows = new HideRows(this._hiddenRowIxs);
            if (this._sorter == null) {
                this._sorter = new TableRowSorter<PerformanceMatrixModel>(this);
            }
            if (this._hide.booleanValue()) {
                this._sorter.setRowFilter(this._hiddenRows);
            } else {
                this._sorter.setRowFilter(null);
            }
        }

        public void hide(boolean bl) {
            if (this._hiddenColIxs == null && this._hiddenRowIxs == null) {
                this.setHideSettings(this.getTotalAndCostColumnIndexes(), this.getTotalAndCostRowIndexes(), bl);
            } else {
                this._hide = bl;
                if (this._hide.booleanValue()) {
                    this._sorter.setRowFilter(this._hiddenRows);
                } else {
                    this._sorter.setRowFilter(null);
                }
            }
        }

        public Boolean isHideEnabled() {
            return this._hide;
        }

        public TableColumn[] getHiddenColumns() {
            return this._hiddenCols;
        }

        public synchronized void setHiddenColumns(TableColumn[] tableColumnArray) {
            this._hiddenCols = tableColumnArray;
        }

        public HideRows getHiddenRows() {
            return this._hiddenRows;
        }

        public TableRowSorter<TableModel> getTableRowSorter() {
            return this._sorter;
        }
    }

    class PerformanceMatrixSummaryModel
    extends GenericBaseTableModel {
        private int COLUMN_COUNT = 5;
        private Map COL_MAP = new HashMap();
        private Double _totalActuals = 0.0;
        private Double _totalPredited = 0.0;
        private Double _totalCost = 0.0;
        String _resultName = null;
        ArrayList[] _summaryInfo = null;
        private String[] _columnNames = new String[]{TestViewerLrb.get("PMATRIX_TARGET_VALUE"), TestViewerLrb.get("PMATRIX_TOTAL_ACTUALS"), TestViewerLrb.get("PMATRIX_CORRECT_PERC_PREDICTED"), TestViewerLrb.get("PMATRIX_COST"), TestViewerLrb.get("PMATRIX_COST_PERC")};

        public PerformanceMatrixSummaryModel(String string, ArrayList[] arrayListArray, Double d, Double d2, Double d3) {
            this._resultName = string;
            this.COL_MAP.put(new Integer(0), new Integer(0));
            this.COL_MAP.put(new Integer(1), new Integer(1));
            this.COL_MAP.put(new Integer(2), new Integer(5));
            this.COL_MAP.put(new Integer(3), new Integer(3));
            this.COL_MAP.put(new Integer(4), new Integer(7));
            this._summaryInfo = arrayListArray;
            this.setColumnIdentifiers(this._columnNames);
            this.setRowCount(arrayListArray[0].size());
            this.setColumnCount(this.COLUMN_COUNT);
            this._totalActuals = d;
            this._totalPredited = d2;
            this._totalCost = d3;
        }

        public String getResultName() {
            return this._resultName;
        }

        public ArrayList[] getSummaryInfo() {
            return this._summaryInfo;
        }

        public Double getTotalActuals() {
            return this._totalActuals;
        }

        public Double getTotalPredicted() {
            return this._totalPredited;
        }

        public Double getTotalCost() {
            return this._totalCost;
        }

        public Double getCorrectPredictionPercentage() {
            return this._totalPredited / this._totalActuals * 100.0;
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            Object e = this._summaryInfo[(Integer)this.COL_MAP.get(n2)].get(n);
            if (n2 == 0) {
                return e;
            }
            if (e == null) {
                if (n2 == 0) {
                    return null;
                }
                if (n2 == 1) {
                    return 0;
                }
                if (n2 == 2) {
                    return 0.0;
                }
                return null;
            }
            if (e instanceof BigDecimal) {
                return ((BigDecimal)e).doubleValue();
            }
            if (e instanceof Integer) {
                return (int)((Integer)e);
            }
            return e;
        }
    }

    class TargetPair {
        private Object _actualTarget;
        private Object _predictedTarget;

        public TargetPair(Object object, Object object2) {
            this._actualTarget = object;
            this._predictedTarget = object2;
        }

        public Object getActualTarget() {
            return this._actualTarget;
        }

        public Object getPredictedTarget() {
            return this._predictedTarget;
        }

        public boolean equals(Object object) {
            TargetPair targetPair = (TargetPair)object;
            if (this._actualTarget == null && this._predictedTarget == null) {
                return targetPair.getActualTarget() == null && targetPair.getPredictedTarget() == null;
            }
            if (this._actualTarget == null && this._predictedTarget != null) {
                return targetPair.getActualTarget() == null && this._predictedTarget.equals(targetPair.getPredictedTarget());
            }
            if (this._actualTarget != null && this._predictedTarget == null) {
                return this._actualTarget.equals(targetPair.getActualTarget()) && targetPair.getPredictedTarget() == null;
            }
            return this._actualTarget.equals(targetPair.getActualTarget()) && this._predictedTarget.equals(targetPair.getPredictedTarget());
        }

        public int hashCode() {
            if (this._actualTarget == null && this._predictedTarget == null) {
                return super.hashCode();
            }
            if (this._actualTarget == null && this._predictedTarget != null) {
                return this._predictedTarget.hashCode();
            }
            if (this._actualTarget != null && this._predictedTarget == null) {
                return this._actualTarget.hashCode();
            }
            return 31 * this._actualTarget.hashCode() + this._predictedTarget.hashCode();
        }
    }
}

