/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.matrix;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.legend.LegendListener;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.AbstractTestEditor;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixEditor;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixTabState;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class PMatrixPanel
extends DataMinerViewGUI {
    PMatrixTabState _pMatrixTabState = null;
    Context _context;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private JComboBox _jCB_Display;
    private JComboBox _jCB_Measure1;
    private JCheckBox _jCB_showTotalsAndCost;
    private JComboBox _jCB_testResults;
    private JPanel _jCompareResultsPanel;
    private JSplitPane _jCompareResultsSplitPane;
    private JLabel _jLBTargetDetails;
    private JLabel _jLBV_avgAccuracy;
    private JLabel _jLBV_overallAccuracy;
    private JLabel _jLBV_totalCost;
    private JLabel _jLB_Display;
    private JLabel _jLB_Measure1;
    private JLabel _jLB_PMatrix;
    private JLabel _jLB_RowsCols;
    private JLabel _jLB_avgAccuracy;
    private JLabel _jLB_overallAccuracy;
    private JLabel _jLB_testResults;
    private JLabel _jLB_totalCost;
    private GenericTable _jNT_PMatrixDetails;
    private GenericTable _jNT_PMatrixSummary;
    private GenericTable _jNT_TargetDetails;
    private JPanel _jPMatrixDetailsPanel;
    private JScrollPane _jSP_PMatrixDetails;
    private JScrollPane _jSP_PMatrixSummary;
    private JScrollPane _jSP_TargetDeatils;
    private JSplitPane _jShowDetailSplitPane;
    private JPanel _jTargetDetailsPane;
    private TransparentPanel jNTPanel;
    private ComponentWithTitlebar<JComponent> jNTToolbar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JScrollPane _jSP_NTcompare;
    private CustomGenericTable _jNT_Compare1;
    private JButton _jBT_AddOrRemove;
    private static Icon _jIC_UpdateENA;
    private static Icon _jIC_UpdateDIS;

    public PMatrixPanel(PMatrixEditor pMatrixEditor, Context context) {
        this._pMatrixTabState = new PMatrixTabState((SharedTestEditorState)pMatrixEditor.getCachedLegendState());
        this._context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this._jLB_Display.setText(TestViewerLrb.get("LOADING"));
        this._jLB_testResults.setText(TestViewerLrb.get("PMATRIX_TEST_RESULTS") + ":");
        this._jLB_avgAccuracy.setText(TestViewerLrb.get("PMATRIX_AVG_ACCURACY") + ":");
        this._jLB_overallAccuracy.setText(TestViewerLrb.get("PMATRIX_OVERALL_ACCURACY") + ":");
        this._jLB_totalCost.setText(TestViewerLrb.get("PMATRIX_TOTAL_COST") + ":");
        this._jLB_PMatrix.setText(TestViewerLrb.get("PMATRIX") + ":");
        this._jLB_RowsCols.setText(TestViewerLrb.get("PMATRIX_ROWS_COLS") + ":");
        this._jCB_showTotalsAndCost.setText(TestViewerLrb.get("PMATRIX_SHOW_TOTALS_COST") + ":");
        this._jCB_Display.removeAllItems();
        this._jCB_Display.addItem(TestViewerLrb.get("PMATRIX_DISPLAY_COMPARE"));
        this._jCB_Display.addItem(TestViewerLrb.get("PMATRIX_DISPLAY_DETAILS"));
        this._jCB_Measure1.removeAllItems();
        this._jCB_Measure1.addItem(TestViewerLrb.get("PMATRIX_CORRECT_PREDICTIONS"));
        this._jCB_Measure1.addItem(TestViewerLrb.get("PMATRIX_COST"));
        this._jLBTargetDetails.setText(TestViewerLrb.get("TEST_VIEWER_TARGET_VALUE_DETAILS"));
        this._jLB_Measure1.setText(TestViewerLrb.get("TEST_VIEWER_MEASURE"));
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this._jPMatrixDetailsPanel.setVisible(false);
        this._jCompareResultsPanel.setVisible(false);
        this._jCB_Display.setVisible(false);
        this._jCB_testResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PMatrixPanel.this._jCB_testResults.getSelectedIndex();
                PMatrixPanel.this.displaySelectedTestResults(n);
            }
        });
        this._jCB_showTotalsAndCost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((PMatrixTable)PMatrixPanel.this._jNT_PMatrixDetails).setTotalsAndCostVisible(PMatrixPanel.this._jCB_showTotalsAndCost.isSelected());
            }
        });
        this._jCB_Display.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PMatrixPanel.this._jCB_Display.getSelectedIndex() == 0) {
                    PMatrixPanel.this._jPMatrixDetailsPanel.setVisible(false);
                    PMatrixPanel.this._jCompareResultsPanel.setVisible(true);
                } else {
                    PMatrixPanel.this._jPMatrixDetailsPanel.setVisible(true);
                    PMatrixPanel.this._jCompareResultsPanel.setVisible(false);
                }
            }
        });
        this._jCB_Measure1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PMatrixPanel.this.setCompareModel();
            }
        });
        this._jNT_Compare1 = new CustomGenericTable();
        this._jNT_Compare1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (PMatrixPanel.this.isLoading()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int[] nArray = PMatrixPanel.this._jNT_Compare1.getSelectedRowsInModel();
                    Vector<String> vector = new Vector<String>();
                    if (nArray != null && nArray.length != 0) {
                        for (int i = 0; i < nArray.length; ++i) {
                            String string = (String)PMatrixPanel.this._pMatrixTabState.getCompareSummaryModel().getValueAt(nArray[i], 0);
                            vector.add(string);
                        }
                        PMatrixPanel.this._pMatrixTabState.setCurrentSelectedTestResults(vector);
                        PMatrixPanel.this.setCompareModel();
                    }
                }
            }
        });
        this._jSP_NTcompare = new JScrollPane((Component)((Object)this._jNT_Compare1));
        this.jNTToolbar.setComponent((JComponent)this._jSP_NTcompare);
        ControlBar controlBar = new ControlBar();
        this.installPMatrixSummaryActions(controlBar);
        this.jNTToolbar.setControlBar(controlBar);
        this._jShowDetailSplitPane.setDividerLocation(0.5);
        this._jShowDetailSplitPane.setResizeWeight(0.5);
        this._jCompareResultsSplitPane.setDividerLocation(0.5);
        this._jCompareResultsSplitPane.setResizeWeight(0.5);
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void installPMatrixSummaryActions(ControlBar controlBar) {
        Class<AbstractTestEditor> clazz = AbstractTestEditor.class;
        if (this._pMatrixTabState.getParentTestViewerState().getAllTestResults().size() > 1) {
            _jIC_UpdateENA = UIResourceHelper.getImageIcon(clazz, TestViewerLrb.get("ADD_REMOVE_BTN_ICON_ENA"));
            _jIC_UpdateDIS = UIResourceHelper.getImageIcon(clazz, TestViewerLrb.get("ADD_REMOVE_BTN_ICON_DIS"));
            this._jBT_AddOrRemove = new JButton(_jIC_UpdateENA);
            this._jBT_AddOrRemove.setDisabledIcon(_jIC_UpdateDIS);
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PMatrixPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            controlBar.add((Component)this._jBT_AddOrRemove);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._pMatrixTabState.getParentTestViewerState(), this._pMatrixTabState.getParentTestViewerState().getContext(), this._pMatrixTabState.getParentTestViewerState().getParentActivity(), this._pMatrixTabState.getParentTestViewerState().getAllTestResults(), this._pMatrixTabState.getParentTestViewerState().getTestResults())) {
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            this._pMatrixTabState.getParentTestViewerState().setTestResults(list);
            LoadUI loadUI = new LoadUI(true);
            loadUI.start();
        }
    }

    private void setCompareModel() {
        int n = Integer.MAX_VALUE;
        switch (this._jCB_Measure1.getSelectedIndex()) {
            case 1: {
                PMatrixTabState.PMatrixTargetCompareModel pMatrixTargetCompareModel = this._pMatrixTabState.createPMatrixTargetCompareModel(this._pMatrixTabState.getCurrentSelectedTestResults(), 3);
                this._jNT_TargetDetails.setModel((TableModel)((Object)pMatrixTargetCompareModel));
                n = pMatrixTargetCompareModel.getTotalValue();
                break;
            }
            default: {
                this._jNT_TargetDetails.setModel((TableModel)((Object)this._pMatrixTabState.createPMatrixTargetCompareModel(this._pMatrixTabState.getCurrentSelectedTestResults(), 5)));
                n = 100;
            }
        }
        this._jNT_TargetDetails.setSorted(true);
        this._jNT_TargetDetails.autoSizeColumnsToFit();
        for (int i = 1; i < this._jNT_TargetDetails.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this._jNT_TargetDetails.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new HistogramBarRenderer(n, true, this._percentageFormat));
        }
    }

    public void setLegendState(LegendEvent legendEvent) {
        if (this.isLoading() || legendEvent.getTarget() != this._editor || legendEvent.getAction() != "LEGEND_ADD_EVENT") {
            System.out.println("In the Add event code");
        }
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void initComponents() {
        this._jLB_Display = new JLabel();
        this._jCB_Display = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this._jPMatrixDetailsPanel = new JPanel();
        this._jLB_avgAccuracy = new JLabel();
        this._jLB_testResults = new JLabel();
        this._jCB_testResults = new JComboBox();
        this._jLBV_avgAccuracy = new JLabel();
        this._jLBV_overallAccuracy = new JLabel();
        this._jLB_overallAccuracy = new JLabel();
        this._jLB_totalCost = new JLabel();
        this._jLBV_totalCost = new JLabel();
        this._jShowDetailSplitPane = new JSplitPane();
        this.jPanel2 = new JPanel();
        this._jSP_PMatrixSummary = new JScrollPane();
        this._jNT_PMatrixSummary = new GenericTable();
        this.jPanel3 = new JPanel();
        this._jLB_PMatrix = new JLabel();
        this._jLB_RowsCols = new JLabel();
        this._jCB_showTotalsAndCost = new JCheckBox();
        this._jSP_PMatrixDetails = new JScrollPane();
        this._jNT_PMatrixDetails = new PMatrixTable();
        this._jCompareResultsPanel = new JPanel();
        this._jCompareResultsSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jNTPanel = new TransparentPanel();
        this.jNTToolbar = new ComponentWithTitlebar();
        this._jTargetDetailsPane = new JPanel();
        this._jLBTargetDetails = new JLabel();
        this._jLB_Measure1 = new JLabel();
        this._jCB_Measure1 = new JComboBox();
        this._jSP_TargetDeatils = new JScrollPane();
        this._jNT_TargetDetails = new GenericTable();
        this._jLB_Display.setText("Display:");
        this._jCB_Display.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jLB_avgAccuracy.setText("Average Accuracy:");
        this._jLB_testResults.setText("Test Results:");
        this._jCB_testResults.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jLBV_avgAccuracy.setText("avg");
        this._jLBV_overallAccuracy.setText("overall");
        this._jLB_overallAccuracy.setText("Overall Accuracy:");
        this._jLB_totalCost.setText("Total Cost:");
        this._jLBV_totalCost.setText("cost");
        this._jShowDetailSplitPane.setDividerLocation(100);
        this._jShowDetailSplitPane.setOrientation(0);
        this._jShowDetailSplitPane.setResizeWeight(0.5);
        this._jShowDetailSplitPane.setMinimumSize(new Dimension(0, 0));
        this._jShowDetailSplitPane.setOneTouchExpandable(true);
        this._jNT_PMatrixSummary.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._jSP_PMatrixSummary.setViewportView((Component)this._jNT_PMatrixSummary);
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 575, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSP_PMatrixSummary, GroupLayout.Alignment.TRAILING, -1, 575, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 99, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSP_PMatrixSummary, -1, 99, Short.MAX_VALUE)));
        this._jShowDetailSplitPane.setTopComponent(this.jPanel2);
        this._jLB_PMatrix.setText("Performance Matrix:");
        this._jLB_RowsCols.setText("Rows=Actual, Columns=Predicted");
        this._jCB_showTotalsAndCost.setText("Show totals and cost");
        this._jCB_showTotalsAndCost.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jCB_showTotalsAndCost.setMargin(new Insets(0, 0, 0, 0));
        this._jNT_PMatrixDetails.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._jNT_PMatrixDetails.setAutoResizeMode(0);
        this._jSP_PMatrixDetails.setViewportView((Component)this._jNT_PMatrixDetails);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSP_PMatrixDetails, GroupLayout.Alignment.TRAILING, -1, 575, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this._jLB_PMatrix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jLB_RowsCols).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCB_showTotalsAndCost).addContainerGap(176, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_PMatrix).addComponent(this._jLB_RowsCols).addComponent(this._jCB_showTotalsAndCost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSP_PMatrixDetails, -1, 84, Short.MAX_VALUE)));
        this._jShowDetailSplitPane.setRightComponent(this.jPanel3);
        GroupLayout groupLayout3 = new GroupLayout(this._jPMatrixDetailsPanel);
        this._jPMatrixDetailsPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jShowDetailSplitPane, -1, 577, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this._jLB_testResults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCB_testResults, -2, 180, -2)).addGroup(groupLayout3.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jLB_avgAccuracy).addComponent(this._jLB_overallAccuracy).addComponent(this._jLB_totalCost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jLBV_overallAccuracy).addComponent(this._jLBV_totalCost).addComponent(this._jLBV_avgAccuracy)))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jCB_testResults, -2, -1, -2).addComponent(this._jLB_testResults)).addGap(10, 10, 10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_avgAccuracy).addComponent(this._jLBV_avgAccuracy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_overallAccuracy).addComponent(this._jLBV_overallAccuracy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_totalCost).addComponent(this._jLBV_totalCost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jShowDetailSplitPane, -1, 222, Short.MAX_VALUE).addContainerGap()));
        this._jCompareResultsSplitPane.setDividerLocation(110);
        this._jCompareResultsSplitPane.setOrientation(0);
        this._jCompareResultsSplitPane.setResizeWeight(0.4);
        this._jCompareResultsSplitPane.setMinimumSize(new Dimension(0, 0));
        this._jCompareResultsSplitPane.setOneTouchExpandable(true);
        this.jPanel1.setMinimumSize(new Dimension(0, 100));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jNTPanel);
        this.jNTPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jNTToolbar, -1, 565, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jNTToolbar, -1, 109, Short.MAX_VALUE));
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jNTPanel, -1, -1, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jNTPanel, -1, -1, Short.MAX_VALUE));
        this._jCompareResultsSplitPane.setLeftComponent(this.jPanel1);
        this._jLBTargetDetails.setText("Target Value Details:");
        this._jLB_Measure1.setText("Measure:");
        this._jCB_Measure1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jNT_TargetDetails.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._jNT_TargetDetails.setAutoResizeMode(0);
        this._jSP_TargetDeatils.setViewportView((Component)this._jNT_TargetDetails);
        GroupLayout groupLayout6 = new GroupLayout(this._jTargetDetailsPane);
        this._jTargetDetailsPane.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSP_TargetDeatils, -1, 555, Short.MAX_VALUE).addGroup(groupLayout6.createSequentialGroup().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jLBTargetDetails, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout6.createSequentialGroup().addGap(10, 10, 10).addComponent(this._jLB_Measure1, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCB_Measure1, -2, 180, -2))).addContainerGap(303, Short.MAX_VALUE)))));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this._jLBTargetDetails).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_Measure1).addComponent(this._jCB_Measure1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSP_TargetDeatils, -1, 173, Short.MAX_VALUE).addContainerGap()));
        this._jCompareResultsSplitPane.setBottomComponent(this._jTargetDetailsPane);
        GroupLayout groupLayout7 = new GroupLayout(this._jCompareResultsPanel);
        this._jCompareResultsPanel.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this._jCompareResultsSplitPane, -1, 567, Short.MAX_VALUE).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this._jCompareResultsSplitPane, -1, 357, Short.MAX_VALUE)));
        GroupLayout groupLayout8 = new GroupLayout(this);
        this.setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addComponent(this._jLB_Display).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCB_Display, -2, 162, -2).addContainerGap(383, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout8.createSequentialGroup().addComponent(this._jCompareResultsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 577, Short.MAX_VALUE).addContainerGap()).addComponent(this._jPMatrixDetailsPanel, -1, -1, Short.MAX_VALUE));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_Display).addComponent(this._jCB_Display, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jPMatrixDetailsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCompareResultsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void displaySelectedTestResults(int n) {
        TestResult testResult = (TestResult)this._jCB_testResults.getItemAt(n);
        BigDecimal bigDecimal = testResult.getId();
        CPerformanceTabState.PerformanceMetric performanceMetric = this._pMatrixTabState.getPerformanceMetric(bigDecimal);
        PMatrixTabState.PerformanceMatrixModel performanceMatrixModel = this._pMatrixTabState.getPerformanceMatrixModel(bigDecimal);
        PMatrixTabState.PerformanceMatrixSummaryModel performanceMatrixSummaryModel = this._pMatrixTabState.getPerformanceMatrixSummaryModel(bigDecimal);
        this._jLBV_avgAccuracy.setText(this._percentageFormat.format(performanceMetric._measureItemValue1.doubleValue()));
        this._jLBV_overallAccuracy.setText(this._percentageFormat.format(performanceMetric._measureItemValue2.doubleValue()));
        if (performanceMetric._measureItemValue3 == null) {
            this._jLB_totalCost.setVisible(false);
            this._jLBV_totalCost.setVisible(false);
        } else {
            this._jLB_totalCost.setVisible(true);
            this._jLBV_totalCost.setVisible(true);
            this._jLBV_totalCost.setText(this._percentageFormat.format(performanceMetric._measureItemValue3.doubleValue()));
        }
        this._jNT_PMatrixSummary.setModel((TableModel)((Object)performanceMatrixSummaryModel));
        this._jNT_PMatrixSummary.setSorted(true);
        this._jNT_PMatrixSummary.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this._jNT_PMatrixSummary.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(165);
        tableColumnModel.getColumn(1).setPreferredWidth(130);
        tableColumnModel.getColumn(2).setPreferredWidth(130);
        tableColumnModel.getColumn(3).setPreferredWidth(75);
        tableColumnModel.getColumn(4).setPreferredWidth(75);
        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
        tableColumnModel.getColumn(1).setCellRenderer(numberCellRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(numberCellRenderer);
        tableColumnModel.getColumn(3).setCellRenderer(numberCellRenderer);
        tableColumnModel.getColumn(4).setCellRenderer(numberCellRenderer);
        ((PMatrixTable)this._jNT_PMatrixDetails).setModel(performanceMatrixModel);
        ((PMatrixTable)this._jNT_PMatrixDetails).setTotalsAndCostVisible(this._jCB_showTotalsAndCost.isSelected());
        ((PMatrixTable)this._jNT_PMatrixDetails).setSorted(false);
        this._jNT_PMatrixDetails.setAutoResizeMode(0);
        this._jNT_PMatrixDetails.setColumnSelectorAvailable(false);
        tableColumnModel = this._jNT_PMatrixDetails.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(70);
        }
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        private DateFormat _df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        private Preferences _p = Preferences.getPreferences();
        private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
        private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
        private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

        CustomGenericTable() {
            this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._percentageFormat.setMinimumIntegerDigits(1);
            this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._numericalFormat.setMinimumIntegerDigits(1);
        }

        @Override
        public void addDynamicCellRenderers() {
            NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
            this.addCellRenderer(TestViewerLrb.get("PMATRIX_CORRECT_PERC_PREDICTED"), new HistogramBarRenderer(100L, true, this._percentageFormat));
            this.addCellRenderer(TestViewerLrb.get("PMATRIX_CORRECT_PREDICTED_COUNT"), numberCellRenderer);
            this.addCellRenderer(TestViewerLrb.get("PMATRIX_TOTAL_ACTUALS"), numberCellRenderer);
            this.addCellRenderer(TestViewerLrb.get("PMATRIX_TOTAL_COST"), numberCellRenderer);
        }

        private String formatCellValue(Object object) {
            String string = null;
            if (object != null) {
                string = object instanceof Double ? this._percentageFormat.format((Double)object) : (object instanceof Integer ? this._numericalFormat.format(((Integer)object).intValue()) : (object instanceof BigDecimal ? this._numericalFormat.format(((BigDecimal)object).doubleValue()) : (object instanceof Date ? this._df.format(object) : object.toString())));
            }
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = this.formatCellValue(object);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = this.formatCellValue(object);
            return string;
        }
    }

    class MatrixSummaryTable
    extends GenericTable {
        private DateFormat _df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        private Preferences _p = Preferences.getPreferences();
        private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
        private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
        private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

        MatrixSummaryTable() {
            this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._percentageFormat.setMinimumIntegerDigits(1);
            this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._numericalFormat.setMinimumIntegerDigits(1);
        }

        private String formatCellValue(Object object) {
            String string = null;
            if (object != null) {
                string = object instanceof Double ? this._percentageFormat.format((Double)object) : (object instanceof Integer ? this._numericalFormat.format(((Integer)object).intValue()) : (object instanceof BigDecimal ? this._numericalFormat.format(((BigDecimal)object).doubleValue()) : (object instanceof Date ? this._df.format(object) : object.toString())));
            }
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = this.formatCellValue(object);
            return string;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = this.formatCellValue(object);
            return string;
        }
    }

    class PMatrixTable
    extends BaseCostMatrixTable {
        boolean totalsAndCostVisible = false;
        PMatrixTabState.PerformanceMatrixModel _model = null;

        PMatrixTable() {
        }

        @Override
        public void setModel(BaseCostMatrixTableModel baseCostMatrixTableModel) {
            super.setModel(baseCostMatrixTableModel);
            this._model = (PMatrixTabState.PerformanceMatrixModel)baseCostMatrixTableModel;
            this.setHighlights(this._model.getTotalAndCostColumnIndexes(), this._model.getTotalAndCostRowIndexes(), new int[][]{{this._model.getTotalAndCostRowIndexes()[0], this._model.getTotalAndCostColumnIndexes()[0]}});
        }

        public synchronized void setTotalsAndCostVisible(boolean bl) {
            int n;
            this._model.hide(!bl);
            int[] nArray = this._model.getTotalAndCostColumnIndexes();
            TableColumn[] tableColumnArray = this._model.getHiddenColumns();
            if (tableColumnArray == null) {
                tableColumnArray = new TableColumn[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    tableColumnArray[n] = this.getColumnModel().getColumn(nArray[n]);
                }
                this._model.setHiddenColumns(tableColumnArray);
            }
            if (bl) {
                if (!this.totalsAndCostVisible) {
                    for (n = 0; n < nArray.length; ++n) {
                        this.setColumnVisible(tableColumnArray[n], nArray[n], true);
                    }
                    this.setHiddenColumns(new int[0]);
                }
            } else {
                int[] nArray2 = this.getHiddenColumns();
                if (nArray2 == null || nArray2.length == 0) {
                    this.setHiddenColumns(nArray);
                }
            }
            this.totalsAndCostVisible = bl;
        }
    }

    class TestLegendListener
    implements LegendListener {
        TestLegendListener() {
        }

        @Override
        public void addEvent(LegendEvent legendEvent) {
            PMatrixPanel.this.setLegendState(legendEvent);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(PMatrixPanel.this._context);
                PMatrixPanel.this._pMatrixTabState.load(connection);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return PMatrixPanel.this._pMatrixTabState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            int n = 1;
            try {
                if (this._success && this._ex == null) {
                    Object[] objectArray = PMatrixPanel.this._pMatrixTabState.getParentTestViewerState().getTestResults().toArray();
                    PMatrixPanel.this._jCB_testResults.setModel(new DefaultComboBoxModel<Object>(objectArray));
                    PMatrixPanel.this._jCB_testResults.setSelectedIndex(0);
                    PMatrixPanel.this._jLB_Display.setText(TestViewerLrb.get("PMATRIX_DISPLAY") + ":");
                    PMatrixPanel.this._jCB_Display.setVisible(true);
                    PMatrixPanel.this._percentageFormat.setMaximumFractionDigits(PMatrixPanel.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    PMatrixPanel.this._jNT_Compare1.setFixedColumnCount(n);
                    PMatrixPanel.this._jNT_Compare1.setModel((TableModel)PMatrixPanel.this._pMatrixTabState.getCompareSummaryModel());
                    PMatrixPanel.this._jNT_Compare1.setFixedColumnPreferredWidth(TestViewerLrb.get("PMATRIX_RESULTS_COL_NAME"), 165);
                    PMatrixPanel.this._jNT_Compare1.findOrCreateTableRowHeader(PMatrixPanel.this._jSP_NTcompare);
                    PMatrixPanel.this._jNT_Compare1.setSorted(true);
                    PMatrixPanel.this._jNT_Compare1.setAutoResizeMode(0);
                    PMatrixPanel.this._jNT_Compare1.addDynamicCellRenderers();
                    TableColumnModel tableColumnModel = PMatrixPanel.this._jNT_Compare1.getColumnModel();
                    tableColumnModel.getColumn(0).setPreferredWidth(300);
                    tableColumnModel.getColumn(1).setPreferredWidth(150);
                    tableColumnModel.getColumn(2).setPreferredWidth(110);
                    tableColumnModel.getColumn(3).setPreferredWidth(80);
                    PMatrixPanel.this._jNT_Compare1.setSelectionMode(2);
                    PMatrixPanel.this._jNT_Compare1.setColumnSelectorAvailable(true);
                    PMatrixPanel.this._jNT_Compare1.setShowToolTips(true);
                    PMatrixPanel.this._jNT_Compare1.setSortRetainsSelection(true);
                    PMatrixPanel.this._jNT_Compare1.setRowSelectionAllowed(true);
                    PMatrixPanel.this._jNT_Compare1.setCellRenderers();
                    PMatrixPanel.this._jNT_Compare1.setRowHeaderCellRenderers();
                    if (PMatrixPanel.this._jCB_Display.getSelectedIndex() == 0) {
                        PMatrixPanel.this._jPMatrixDetailsPanel.setVisible(false);
                        PMatrixPanel.this._jCompareResultsPanel.setVisible(true);
                    } else {
                        PMatrixPanel.this._jPMatrixDetailsPanel.setVisible(true);
                        PMatrixPanel.this._jCompareResultsPanel.setVisible(false);
                    }
                    if (objectArray.length <= 1) {
                        PMatrixPanel.this._jLB_testResults.setVisible(false);
                        PMatrixPanel.this._jCB_testResults.setVisible(false);
                        PMatrixPanel.this._jLB_Display.setVisible(false);
                        PMatrixPanel.this._jCB_Display.setVisible(false);
                        PMatrixPanel.this.jSeparator1.setVisible(false);
                        PMatrixPanel.this._jPMatrixDetailsPanel.setVisible(true);
                        PMatrixPanel.this._jCompareResultsPanel.setVisible(false);
                    }
                    PMatrixPanel.this._jNT_PMatrixDetails.setAutoResizeMode(0);
                    PMatrixPanel.this.setCompareModel();
                    PMatrixPanel.this.setLoaded(true);
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                PMatrixPanel.this.setLoading(false);
            }
        }
    }
}

