/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.AbstractHiddenNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.ide.Context;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.icons.OracleIcons;

public class TestCompareNode
extends AbstractHiddenNode {
    private List<TestResult> _testResults;
    private SharedTestEditorState _sharedState;
    private Context _context;
    private boolean _showROC = false;
    private boolean _isClassification = true;

    public TestCompareNode() {
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
    }

    public void setClassificationTest(boolean bl) {
        this._isClassification = bl;
    }

    public void setRegressionTest(boolean bl) {
        this._isClassification = !bl;
    }

    public boolean isRegressionTest() {
        return !this._isClassification;
    }

    public boolean isClassificationTest() {
        return this._isClassification;
    }

    public void setTestResults(List<TestResult> list) {
        this._testResults = list;
        for (TestResult testResult : list) {
            if (!(testResult instanceof ClassTestResult) || !((ClassTestResult)testResult).isROCResult()) continue;
            this._showROC = true;
            break;
        }
    }

    public List<TestResult> getTestResults() {
        return this._testResults;
    }

    public boolean isDirty() {
        return false;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        NodeFactory.uncache((URL)this.getURL());
    }

    @Override
    public Icon getIcon() {
        if (_icon == null) {
            _icon = OracleIcons.getIcon((String)"compare.png");
        }
        return _icon;
    }

    public SharedTestEditorState getSharedTestEditorState() {
        if (this._sharedState == null) {
            this._sharedState = new SharedTestEditorState((Node)this);
        }
        return this._sharedState;
    }

    public boolean isShowROC() {
        return this._showROC;
    }

    @Override
    public void setContext(Context context) {
        this._context = context;
    }

    @Override
    public Context getContext() {
        return this._context;
    }
}

