/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.lift.LiftEditor;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixEditor;
import oracle.dmt.dataminer.tviewer.performance.PerformanceEditor;
import oracle.dmt.dataminer.tviewer.profit.ProfitEditor;
import oracle.dmt.dataminer.tviewer.residual.ResidualEditor;
import oracle.dmt.dataminer.tviewer.roc.ROCEditor;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.PreferredLayoutEvent;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;

public class AbstractTestEditorAddin
extends EditorAddin {
    protected MenuSpec _mspec = null;
    private Icon _largeIcon = null;
    private MeasureType _type = null;

    public AbstractTestEditorAddin(MeasureType measureType) {
        this._type = measureType;
    }

    public Class getEditorClass() {
        switch (this._type) {
            case PERFORMANCE: {
                return PerformanceEditor.class;
            }
            case RESIDUAL: {
                return ResidualEditor.class;
            }
            case ROC: {
                return ROCEditor.class;
            }
            case LIFT: {
                return LiftEditor.class;
            }
            case PROFIT: {
                return ProfitEditor.class;
            }
            case MATRIX: {
                return PMatrixEditor.class;
            }
        }
        return null;
    }

    public boolean isDefault() {
        return true;
    }

    public synchronized MenuSpec getMenuSpecification() {
        if (this._mspec == null) {
            this._mspec = new MenuSpec(TestViewerLrb.get("EDITOR_PANEL_NAME"), this.getIcon());
        }
        return this._mspec;
    }

    public Icon getIcon() {
        if (this._largeIcon == null) {
            this._largeIcon = UIResourceHelper.getImageIcon(((Object)((Object)this)).getClass(), TestViewerLrb.get("EDITOR_ICON"));
        }
        return this._largeIcon;
    }

    public void initialize() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.registerDynamic((EditorAddin)this);
        Class clazz = this.getEditorClass();
        editorManager.registerPreferredLayoutListener(TestResultNode.class, clazz, "dataminer.tviewer", (PreferredLayoutListener)new MyPreferredLayoutListener());
        editorManager.registerPreferredLayoutListener(TestCompareNode.class, clazz, "dataminer.tviewer", (PreferredLayoutListener)new MyPreferredLayoutListener());
    }

    public float getEditorWeight(Element element) {
        TestResult testResult = null;
        boolean bl = false;
        if (element instanceof TestResultNode || element instanceof TestCompareNode) {
            if (element instanceof TestResultNode) {
                testResult = (TestResult)((TestResultNode)element).getRepositoryData();
                if (testResult instanceof ClassTestResult) {
                    bl = ((ClassTestResult)testResult).isROCResult();
                }
            } else if (element instanceof TestCompareNode && (testResult = ((TestCompareNode)element).getTestResults().get(0)) instanceof ClassTestResult) {
                bl = ((TestCompareNode)element).isShowROC();
            }
            switch (this._type) {
                case PERFORMANCE: {
                    return 1.0f;
                }
                case RESIDUAL: {
                    if (testResult instanceof ClassTestResult) {
                        return Float.NaN;
                    }
                    return 0.9f;
                }
                case MATRIX: {
                    if (testResult instanceof ClassTestResult) {
                        return 0.9f;
                    }
                    return Float.NaN;
                }
                case LIFT: {
                    if (testResult instanceof ClassTestResult) {
                        return 0.7f;
                    }
                    return Float.NaN;
                }
                case PROFIT: {
                    if (testResult instanceof ClassTestResult) {
                        return 0.6f;
                    }
                    return Float.NaN;
                }
                case ROC: {
                    if (bl) {
                        return 0.8f;
                    }
                    return Float.NaN;
                }
            }
        }
        return Float.NaN;
    }

    public boolean restoreAtStartup() {
        return true;
    }

    public boolean isDuplicable() {
        return false;
    }

    private class MyPreferredLayoutListener
    implements PreferredLayoutListener {
        private MyPreferredLayoutListener() {
        }

        public void onInitializeLayout(PreferredLayoutEvent preferredLayoutEvent) {
        }

        public void onPreferredLayoutActivate(PreferredLayoutEvent preferredLayoutEvent) {
        }
    }

    public static enum MeasureType {
        PERFORMANCE,
        RESIDUAL,
        ROC,
        LIFT,
        PROFIT,
        MATRIX;

    }
}

