/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.structure;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.teditor.structure.StructureLrb;
import oracle.dmt.dataminer.utils.NumberComparator;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.javatools.ui.search.SearchMatcher;

public class StructureViewTableModel
extends GenericBaseTableModel {
    private Vector<ColumnDataRow> _data = new Vector();
    private static Vector<String> _colNames = new Vector();
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_DATA_TYPE = 1;
    public static final int _COLUMN_MINING_TYPE = 2;
    public static final int _COLUMN_LENGTH = 3;
    public static final int _COLUMN_PRECISION = 4;
    public static final int _COLUMN_SCALE = 5;
    public static final int _COLUMN_ID = 6;

    public StructureViewTableModel(List<ColumnDataRow> list) {
        this.setColumnIdentifiers(_colNames);
        for (ColumnDataRow columnDataRow : list) {
            this._data.add(columnDataRow);
        }
        this.setRowCount(this._data.size());
        this.setColumnCount(_colNames.size());
    }

    public StructureViewTableModel(boolean bl) {
        this.setColumnIdentifiers(_colNames);
        if (bl) {
            this.showLoading();
        } else {
            this.showSelectionRequired();
        }
        this.setColumnCount(_colNames.size());
    }

    public void showLoading() {
        this._data.clear();
        ColumnDataRow columnDataRow = new ColumnDataRow();
        columnDataRow.setName(StructureLrb.get("TABLE_STRUCTURE_EDITOR_LOADING"));
        this._data.add(columnDataRow);
        this.setRowCount(this._data.size());
    }

    public void showSelectionRequired() {
        this._data.clear();
        ColumnDataRow columnDataRow = new ColumnDataRow();
        columnDataRow.setName(StructureLrb.get("TABLE_STRUCTURE_EDITOR_SELECTION_REQUIRED"));
        this._data.add(columnDataRow);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ColumnDataRow columnDataRow = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = columnDataRow.getName();
                break;
            }
            case 1: {
                object = columnDataRow.getDataType();
                break;
            }
            case 2: {
                if (columnDataRow.getDataType() == null) {
                    object = null;
                    break;
                }
                object = columnDataRow.getDataType().isEmpty() ? columnDataRow.getDataType() : DatabaseMetadataUtils.getDefaultUIMiningType(columnDataRow.getDataType());
                break;
            }
            case 3: {
                object = columnDataRow.getLength();
                break;
            }
            case 4: {
                object = columnDataRow.getPrecision();
                break;
            }
            case 5: {
                object = columnDataRow.getScale();
                break;
            }
            case 6: {
                object = columnDataRow.getColumn_id();
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator comparator = null;
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                comparator = NumberComparator.getComparator();
                break;
            }
            default: {
                comparator = super.getColumnSortComparator(n);
            }
        }
        return comparator;
    }

    public void setFailedStatus() {
        ColumnDataRow columnDataRow = new ColumnDataRow();
        columnDataRow.setName(StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILED_TO_LOAD_TABLE_STRUCTURE"));
        this._data.clear();
        this._data.add(columnDataRow);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public StructureViewTableModel getFilteredRows(String string, int n) throws Exception {
        SearchMatcher searchMatcher;
        Vector<ColumnDataRow> vector = null;
        boolean bl = n == 0;
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                break;
            }
            case 0: 
            case 1: {
                searchMatcher = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)bl);
                break;
            }
            default: {
                assert (false) : "Invalid  filter category.";
                searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
            }
        }
        Vector<ColumnDataRow> vector2 = this.getDataVector();
        vector = new Vector<ColumnDataRow>();
        Iterator<ColumnDataRow> iterator = vector2.iterator();
        ColumnDataRow columnDataRow = null;
        boolean bl2 = string.length() <= 0;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            columnDataRow = iterator.next();
            if (bl2) {
                bl3 = true;
            } else {
                String string2;
                switch (n) {
                    case 2: {
                        string2 = columnDataRow.getName();
                        break;
                    }
                    case 3: {
                        string2 = columnDataRow.getDataType();
                        break;
                    }
                    case 4: {
                        string2 = DatabaseMetadataUtils.getDefaultMiningType(columnDataRow.getDataType(), true);
                        break;
                    }
                    case 0: 
                    case 1: {
                        string2 = columnDataRow.getName() + " " + columnDataRow.getDataType() + " " + DatabaseMetadataUtils.getDefaultMiningType(columnDataRow.getDataType(), true);
                        break;
                    }
                    default: {
                        assert (false) : "Invalid filter category.";
                        string2 = columnDataRow.getName();
                    }
                }
                bl3 = searchMatcher.matches((CharSequence)string2);
            }
            if (!bl3) continue;
            vector.add(columnDataRow);
        }
        return new StructureViewTableModel(vector);
    }

    public Vector<ColumnDataRow> getDataVector() {
        return this._data;
    }

    static {
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_NAME"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_TYPE"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_MINING_TYPE"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_LENGTH"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_PRECISION"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_SCALE"));
        _colNames.add(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_COLUMN_ID"));
    }
}

