/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.structure;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.TableChooserModel;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.structure.StructureLrb;
import oracle.dmt.dataminer.teditor.structure.StructureViewState;
import oracle.dmt.dataminer.teditor.structure.StructureViewTableModel;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class StructureViewPanel
extends DataMinerViewGUI {
    boolean _loadFromNode = true;
    TableChooserModel.TableRow _selectedTable = null;
    String SYN_SELECTED_TABLE = "syn_selected_table";
    private String _connectionName;
    private String _schemaName;
    private String _tableName;
    private boolean _completedHiddenColumnsDefinition = false;
    private GenericTable _table = new GenericTable();
    private Component _findPane;
    private LoadingTableModel loadingModel;
    private ComponentWithTitlebar<JComponent> _jComponentWithToolBar;
    private StructureViewState _state;
    private SearchField _jFilterCtl = new SearchField();
    public static final int FILTER_STRUCTURE_ALL_OR = 0;
    public static final int FILTER_STRUCTURE_ALL_AND = 1;
    public static final int FILTER_STRUCTURE_COLUMN_NAME = 2;
    public static final int FILTER_STRUCTURE_COLUMN_DATA_TYPE = 3;
    public static final int FILTER_STRUCTURE_COLUMN_MINING_TYPE = 4;
    private int _currentSearchCategory = 2;
    private SearchCategory _defaultSearchCategory = new SearchCategory(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_NAME"));

    public StructureViewPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(Context context) throws Exception {
        super(null, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(Context context, boolean bl) throws Exception {
        super(null, context);
        this._loadFromNode = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public StructureViewPanel(String string, String string2, String string3) throws Exception {
        super(null, null);
        this._loadFromNode = true;
        this._connectionName = string;
        this._schemaName = string2;
        this._tableName = string3;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jComponentWithToolBar = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentWithToolBar, -1, 478, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentWithToolBar, -1, 151, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._state = this._context != null ? new StructureViewState(this._context, this._loadFromNode) : new StructureViewState(this._connectionName, this._schemaName, this._tableName);
        this.setLoading(true);
        this.initializeControls(this._loadFromNode);
        JScrollPane jScrollPane = new JScrollPane((Component)this._table);
        this._jComponentWithToolBar.setComponent((JComponent)jScrollPane);
        this._jComponentWithToolBar.setLabel(new JLabel(StructureLrb.get("TABLE_STRUCTURE_EDITOR_GRID_TITLE")));
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this._jComponentWithToolBar.setControlBar(controlBar);
        this.addListeners();
        if (this._loadFromNode) {
            LoadUI loadUI = new LoadUI();
            loadUI.start();
        }
    }

    public StructureViewState getState() {
        return this._state;
    }

    private void setLoadingStatus(boolean bl) {
        TableModel tableModel = this._table.getModel();
        if (tableModel instanceof StructureViewTableModel) {
            if (bl) {
                ((StructureViewTableModel)((Object)tableModel)).showLoading();
            } else {
                ((StructureViewTableModel)((Object)tableModel)).showSelectionRequired();
            }
        }
    }

    public void loadTable(TableChooserModel.TableRow tableRow) {
        this.setLoading(true);
        this.enableControls(true);
        this.setSelectedTable(tableRow);
        this.setLoadingStatus(tableRow != null);
        LoadUISync loadUISync = new LoadUISync(tableRow != null ? tableRow.getSchema() : "", tableRow != null ? tableRow.getTableName() : "");
        loadUISync.start();
    }

    public StructureViewTableModel getColumnsTableModel() {
        return this._state.getTableModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableChooserModel.TableRow getSelectedTable() {
        String string = this.SYN_SELECTED_TABLE;
        synchronized (string) {
            return this._selectedTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTable(TableChooserModel.TableRow tableRow) {
        String string = this.SYN_SELECTED_TABLE;
        synchronized (string) {
            this._selectedTable = tableRow;
        }
    }

    public void close() {
        this._state.close();
    }

    private void initializeControls(boolean bl) {
        this.loadingModel = new LoadingTableModel();
        this._table.setModel((TableModel)((Object)this.loadingModel));
        if (!bl) {
            this.loadingModel.showSelectionRequired();
        } else {
            this.loadingModel.showLoading();
        }
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._jFilterCtl.addCategory(new SearchCategory(StructureLrb.get("TABLE_STRUCTURE_EDITOR_FILTER_CATEGORY_ALL_OR")));
        this._jFilterCtl.addCategory(new SearchCategory(StructureLrb.get("TABLE_STRUCTURE_EDITOR_FILTER_CATEGORY_ALL_AND")));
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.addCategory(new SearchCategory(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_TYPE")));
        this._jFilterCtl.addCategory(new SearchCategory(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_MINING_TYPE")));
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this.enableControls(false);
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 200);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    public HelpInfo getHelpInfo() {
        String string = "data_structure_viewer_help";
        return new HelpInfo(string);
    }

    private void setColumnWidths(TableColumnModel tableColumnModel) {
        tableColumnModel.getColumn(0).setPreferredWidth(295);
        tableColumnModel.getColumn(1).setPreferredWidth(100);
        tableColumnModel.getColumn(2).setPreferredWidth(100);
        tableColumnModel.getColumn(3).setPreferredWidth(80);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
    }

    private void setupTable(StructureViewTableModel structureViewTableModel) {
        this._table.setModel((TableModel)((Object)structureViewTableModel));
        this._table.setSorted(true);
        this._table.setSortColumn(6, true);
        this._table.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        this.setColumnWidths(tableColumnModel);
        if (!this._completedHiddenColumnsDefinition) {
            this._table.setHiddenColumns(new int[]{4, 5});
            this._completedHiddenColumnsDefinition = true;
        }
    }

    private void enableControls(boolean bl) {
        this._jFilterCtl.setEnabled(bl);
    }

    private void addListeners() {
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                StructureViewPanel.this.translateSearchCategoryToConstant(StructureViewPanel.this._jFilterCtl.getSelectedCategory());
                StructureViewPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                StructureViewPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                StructureViewPanel.this.processFilter(string);
            }
        });
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(StructureLrb.get("TABLE_STRUCTURE_EDITOR_FILTER_CATEGORY_ALL_OR"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(StructureLrb.get("TABLE_STRUCTURE_EDITOR_FILTER_CATEGORY_ALL_AND"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_NAME"))) {
            this._currentSearchCategory = 2;
        } else if (searchCategory.getLabel().equals(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_TYPE"))) {
            this._currentSearchCategory = 3;
        } else if (searchCategory.getLabel().equals(StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_MINING_TYPE"))) {
            this._currentSearchCategory = 4;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private void processFilter(String string) {
        try {
            StructureViewTableModel structureViewTableModel = this._state.getFilteredRows(string, this._currentSearchCategory);
            this.setupTable(structureViewTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), null);
        }
    }

    public class LoadingTableModel
    extends GenericBaseTableModel {
        private Vector<String> _data = new Vector();
        public static final int _COLUMN_NAME = 0;

        public LoadingTableModel() {
            Vector<String> vector = new Vector<String>();
            vector.add(" ");
            this.setColumnIdentifiers(vector);
            String string = DataLrb.get("DATA_VIEWER_EDITOR_LOADING");
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.setColumnCount(vector.size());
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public void showSelectionRequired() {
            this._data.clear();
            String string = DataLrb.get("DATA_VIEWER_EDITOR_SELECTION_REQUIRED");
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public void showLoading() {
            this._data.clear();
            String string = DataLrb.get("DATA_VIEWER_EDITOR_LOADING");
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public void showError(String string) {
            this._data.clear();
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            int n3 = 0;
            if (n <= 0 || n >= this.getRowCount()) {
                ++n3;
            }
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            String string = this._data.get(n);
            String string2 = null;
            switch (n2) {
                case 0: {
                    string2 = string;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds";
                    break;
                }
            }
            return string2 != null ? string2 : "";
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public Object construct() {
            try {
                StructureViewPanel.this._state.load();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return StructureViewPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    if (StructureViewPanel.this._jFilterCtl.getText().trim().length() > 0) {
                        StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getFilteredRows(StructureViewPanel.this._jFilterCtl.getText(), StructureViewPanel.this._currentSearchCategory));
                    } else {
                        StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getTableModel());
                    }
                    StructureViewPanel.this.enableControls(true);
                    StructureViewPanel.this.setLoaded(true);
                } else {
                    StructureViewPanel.this.loadingModel.showError(DataLrb.get("DATA_VIEWER_FAILURE_MESG_TRY_RERUN"));
                    if (StructureViewPanel.this._state.getTableModel() != null) {
                        StructureViewPanel.this._state.getTableModel().setFailedStatus();
                        StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getTableModel());
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG_TRY_RERUN"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), null);
            }
            finally {
                StructureViewPanel.this.setLoading(false);
            }
        }
    }

    private class LoadUISync
    extends SwingWorker {
        Exception _ex = null;
        static final String _syncObject = "SyncObject";
        boolean _success = false;
        String _schema;
        String _table;
        boolean _abandon = false;

        public LoadUISync(String string, String string2) {
            this._schema = string;
            this._table = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            try {
                String string = _syncObject;
                synchronized (_syncObject) {
                    TableChooserModel.TableRow tableRow = StructureViewPanel.this.getSelectedTable();
                    if (tableRow == null) {
                        this._abandon = true;
                        this._success = false;
                    } else if (tableRow.getSchema().compareTo(this._schema) == 0 && tableRow.getTableName().compareTo(this._table) == 0) {
                        StructureViewPanel.this._state.setTableName(this._schema, this._table);
                        StructureViewPanel.this._state.load();
                        tableRow = StructureViewPanel.this.getSelectedTable();
                        if (tableRow == null) {
                            this._abandon = true;
                        } else if (tableRow.getSchema().compareTo(this._schema) != 0 || tableRow.getTableName().compareTo(this._table) != 0) {
                            this._abandon = true;
                        } else {
                            this._success = true;
                        }
                    } else {
                        this._abandon = true;
                        this._success = false;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                this._abandon = true;
            }
            {
                return StructureViewPanel.this._state;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            block12: {
                try {
                    if (this._abandon) {
                        return;
                    }
                    if (this._success && this._ex == null) {
                        TableChooserModel.TableRow tableRow = StructureViewPanel.this.getSelectedTable();
                        if (tableRow.getSchema().compareTo(this._schema) != 0 || tableRow.getTableName().compareTo(this._table) != 0) {
                            return;
                        }
                        if (StructureViewPanel.this._jFilterCtl.getText().trim().length() > 0) {
                            StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getFilteredRows(StructureViewPanel.this._jFilterCtl.getText(), StructureViewPanel.this._currentSearchCategory));
                        } else {
                            StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getTableModel());
                        }
                        StructureViewPanel.this.enableControls(true);
                        StructureViewPanel.this.setLoaded(true);
                        break block12;
                    }
                    if (!this._success && this._table.compareTo("") == 0) {
                        StructureViewPanel.this._state.getTableModel().showSelectionRequired();
                        break block12;
                    }
                    if (StructureViewPanel.this._state.getTableModel() != null) {
                        StructureViewPanel.this._state.getTableModel().setFailedStatus();
                        StructureViewPanel.this.setupTable(StructureViewPanel.this._state.getTableModel());
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), null);
                        break block12;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"));
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_TITLE"), (String)StructureLrb.get("TABLE_STRUCTURE_EDITOR_FAILURE_MESG"), null);
                }
            }
        }
    }
}

