/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JMenu;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.teditor.data.ODMrColumnAutoSize;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class ODMrRSTableHeaderMenu
implements Controller,
ContextMenuListener {
    private static ODMrRSTableHeaderMenu _instance;
    private static final Object LOCK;
    private ODMrResultSetTable _table;
    public static String CMD_AUTO_FIT_ALL_ON_HEADER;
    public static String CMD_AUTO_FIT_ALL_ON_VALUE;
    public static String CMD_AUTO_FIT_ALL_BEST;
    public static String CMD_AUTO_FIT_SELECTED_ON_HEADER;
    public static String CMD_AUTO_FIT_SELECTED_ON_VALUE;
    public static String CMD_AUTO_FIT_SELECTED_BEST;
    private static int _cmdId1;
    private static int _cmdId2;
    private static int _cmdId3;
    private static int _cmdId4;
    private static int _cmdId5;
    private static int _cmdId6;
    private IdeAction actionFitSelectedonHeader = null;
    private IdeAction actionFitSelectedonValue = null;
    private IdeAction actionFitSelectedBest = null;
    private IdeAction actionFitAllonHeader = null;
    private IdeAction actionFitAllonValue = null;
    private IdeAction actionFitAllBest = null;
    private static JMenu menuFitSelected;
    private static JMenu menuFitAll;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ODMrRSTableHeaderMenu getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new ODMrRSTableHeaderMenu();
            }
        }
        return _instance;
    }

    public void initAction() {
        String string = ODMrColumnAutoSize.AUTO_FIT_ON_HEADER;
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionFitAllonHeader == null) {
            this.actionFitAllonHeader = IdeAction.get((int)_cmdId1, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionFitAllonHeader.setEnabled(true);
        }
        if (this.actionFitSelectedonHeader == null) {
            this.actionFitSelectedonHeader = IdeAction.get((int)_cmdId3, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionFitSelectedonHeader.setEnabled(true);
        }
        string = ODMrColumnAutoSize.AUTO_FIT_ON_DATA;
        string2 = StringUtils.stripMnemonic((String)string);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionFitAllonValue == null) {
            this.actionFitAllonValue = IdeAction.get((int)_cmdId2, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionFitAllonValue.setEnabled(true);
        }
        if (this.actionFitSelectedonValue == null) {
            this.actionFitSelectedonValue = IdeAction.get((int)_cmdId4, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionFitSelectedonValue.setEnabled(true);
        }
        string = ODMrColumnAutoSize.AUTO_FIT_OPTIMUM;
        string2 = StringUtils.stripMnemonic((String)string);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionFitAllBest == null) {
            this.actionFitAllBest = IdeAction.get((int)_cmdId5, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionFitAllBest.setEnabled(true);
        }
        if (this.actionFitSelectedBest == null) {
            this.actionFitSelectedBest = IdeAction.get((int)_cmdId6, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionFitSelectedBest.setEnabled(true);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (this._table == null) {
            return true;
        }
        int n = ideAction.getCommandId();
        if (_cmdId1 == n) {
            ODMrColumnAutoSize.autoResizeTable(this._table, ODMrColumnAutoSize.AUTO_FIT_ON_HEADER);
        } else if (_cmdId2 == n) {
            ODMrColumnAutoSize.autoResizeTable(this._table, ODMrColumnAutoSize.AUTO_FIT_ON_DATA);
        }
        if (_cmdId3 == n) {
            ODMrColumnAutoSize.autoResizeSelectedColumns(this._table, ODMrColumnAutoSize.AUTO_FIT_ON_HEADER);
        } else if (_cmdId4 == n) {
            ODMrColumnAutoSize.autoResizeSelectedColumns(this._table, ODMrColumnAutoSize.AUTO_FIT_ON_DATA);
        }
        if (_cmdId5 == n) {
            ODMrColumnAutoSize.autoResizeTable(this._table, ODMrColumnAutoSize.AUTO_FIT_OPTIMUM);
        } else if (_cmdId6 == n) {
            ODMrColumnAutoSize.autoResizeSelectedColumns(this._table, ODMrColumnAutoSize.AUTO_FIT_OPTIMUM);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.initAction();
        EventObject eventObject = null;
        if (contextMenu.getContext().getEvent() instanceof MouseEvent) {
            eventObject = (MouseEvent)contextMenu.getContext().getEvent();
        }
        if (eventObject != null && (eventObject.getSource() instanceof JTableHeader || eventObject.getSource() instanceof ODMrResultSetTable)) {
            Object object;
            Component component = (Component)contextMenu.getContext().getEvent().getSource();
            this._table = component instanceof JTableHeader ? (ODMrResultSetTable)((JTableHeader)component).getTable() : (ODMrResultSetTable)component;
            int n = this._table.columnAtPoint(((MouseEvent)eventObject).getPoint());
            int n2 = this._table.rowAtPoint(((MouseEvent)eventObject).getPoint());
            if (n == -1) {
                return;
            }
            if (this._table.getSelectedColumnCount() == 1) {
                this._table.setCellSelectionEnabled(true);
                this._table.setColumnSelectionAllowed(true);
                this._table.setRowSelectionAllowed(true);
            }
            TableColumnModel tableColumnModel = this._table.getColumnModel();
            int n3 = this._table.getRowCount();
            if (n3 != 0 && this._table.getSelectedColumnCount() <= 1) {
                this._table.setRowSelectionInterval(n2, n2);
                this._table.setColumnSelectionInterval(n, n);
            }
            if (this._table.getSelectedColumnCount() == 0) {
                object = tableColumnModel.getSelectionModel();
                ODMrRSTableHeaderMenu.select((ListSelectionModel)object, (MouseEvent)eventObject, n);
            }
            if (this._table.getColumnCount() > 1) {
                object = ODMrColumnAutoSize.AUTO_FIT_ALL;
                menuFitAll = contextMenu.createMenu((String)object, (float)StringUtils.getMnemonicKeyCode((String)object));
                menuFitAll.add(contextMenu.createMenuItem((ToggleAction)this.actionFitAllonHeader));
                menuFitAll.add(contextMenu.createMenuItem((ToggleAction)this.actionFitAllonValue));
                menuFitAll.add(contextMenu.createMenuItem((ToggleAction)this.actionFitAllBest));
                menuFitAll.setSelected(false);
                this.actionFitAllonHeader.addController((Controller)this);
                this.actionFitAllonHeader.setEnabled(true);
                this.actionFitAllonValue.addController((Controller)this);
                this.actionFitAllonValue.setEnabled(true);
                this.actionFitAllBest.addController((Controller)this);
                this.actionFitAllBest.setEnabled(true);
                contextMenu.add((Component)menuFitAll);
            }
            if (this._table.getSelectedColumnCount() > 0) {
                object = this._table.getSelectedColumnCount() > 1 ? ODMrColumnAutoSize.AUTO_FIT_SELECTED + "s" : ODMrColumnAutoSize.AUTO_FIT_SELECTED;
                menuFitSelected = contextMenu.createMenu((String)object, (float)StringUtils.getMnemonicKeyCode((String)object));
                menuFitSelected.add(contextMenu.createMenuItem((ToggleAction)this.actionFitSelectedonHeader));
                menuFitSelected.add(contextMenu.createMenuItem((ToggleAction)this.actionFitSelectedonValue));
                menuFitSelected.add(contextMenu.createMenuItem((ToggleAction)this.actionFitSelectedBest));
                menuFitSelected.setSelected(false);
                this.actionFitSelectedonHeader.addController((Controller)this);
                this.actionFitSelectedonHeader.setEnabled(true);
                this.actionFitSelectedonValue.addController((Controller)this);
                this.actionFitSelectedonValue.setEnabled(true);
                this.actionFitSelectedBest.addController((Controller)this);
                this.actionFitSelectedBest.setEnabled(true);
                contextMenu.add((Component)menuFitSelected);
            }
        }
    }

    public static void select(ListSelectionModel listSelectionModel, MouseEvent mouseEvent, int n) {
        if (mouseEvent.isShiftDown()) {
            int n2 = listSelectionModel.getAnchorSelectionIndex();
            int n3 = listSelectionModel.getLeadSelectionIndex();
            if (n2 != -1) {
                boolean bl = listSelectionModel.getValueIsAdjusting();
                listSelectionModel.setValueIsAdjusting(true);
                boolean bl2 = listSelectionModel.isSelectedIndex(n2);
                if (n3 != -1) {
                    if (bl2) {
                        listSelectionModel.removeSelectionInterval(n2, n3);
                    } else {
                        listSelectionModel.addSelectionInterval(n2, n3);
                    }
                }
                if (bl2) {
                    listSelectionModel.addSelectionInterval(n2, n);
                } else {
                    listSelectionModel.removeSelectionInterval(n2, n);
                }
                listSelectionModel.setValueIsAdjusting(bl);
            } else {
                listSelectionModel.setSelectionInterval(n, n);
            }
        } else if (mouseEvent.isControlDown()) {
            if (listSelectionModel.isSelectedIndex(n)) {
                listSelectionModel.removeSelectionInterval(n, n);
            } else {
                listSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            listSelectionModel.setSelectionInterval(n, n);
        }
    }

    static {
        LOCK = new Object();
        CMD_AUTO_FIT_ALL_ON_HEADER = "auto fit all on header";
        CMD_AUTO_FIT_ALL_ON_VALUE = "auto fit all on value";
        CMD_AUTO_FIT_ALL_BEST = "auto fit all best";
        CMD_AUTO_FIT_SELECTED_ON_HEADER = "auto fit selected on header";
        CMD_AUTO_FIT_SELECTED_ON_VALUE = "auto fit selected on value";
        CMD_AUTO_FIT_SELECTED_BEST = "auto fit selected best";
        _cmdId1 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_ALL_ON_HEADER);
        _cmdId2 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_ALL_ON_VALUE);
        _cmdId3 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_SELECTED_ON_HEADER);
        _cmdId4 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_SELECTED_ON_VALUE);
        _cmdId5 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_ALL_BEST);
        _cmdId6 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_SELECTED_BEST);
        menuFitSelected = null;
        menuFitAll = null;
    }
}

