/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.SystemColor;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.teditor.data.ODMrDataTypesUtil;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;

public class ODMrDefaultCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        TableModel tableModel = jTable.getModel();
        ODMrResultSetTableModel oDMrResultSetTableModel = null;
        int n3 = 0;
        if (tableModel instanceof ODMrResultSetTableModel) {
            object2 = jTable.getTableHeader().getColumnModel().getColumn(n2).getHeaderValue().toString();
            oDMrResultSetTableModel = (ODMrResultSetTableModel)tableModel;
            n3 = oDMrResultSetTableModel.getType(n2);
        }
        switch (n3) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                jLabel.setHorizontalAlignment(4);
                break;
            }
            case -102: 
            case -101: 
            case 91: 
            case 92: 
            case 93: {
                jLabel.setAlignmentX(0.0f);
                break;
            }
            default: {
                jLabel.setAlignmentX(0.0f);
            }
        }
        object2 = null;
        if (oDMrResultSetTableModel != null) {
            object2 = oDMrResultSetTableModel.getConnection();
        }
        String string = null;
        try {
            if (null != object2) {
                string = ODMrDataTypesUtil.stringValue(object, (Connection)object2);
            } else if (string != null) {
                string = object.toString();
            }
            this.setText(string == null ? "" : string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            jLabel.setBackground(SystemColor.textHighlight);
        } else {
            jLabel.setBackground(SystemColor.text);
        }
        return jLabel;
    }

    private static String stringValue(Object object, Connection connection) {
        if (object == null) {
            return null;
        }
        String string = null;
        Object object2 = null;
        if (object instanceof Clob) {
            try {
                object2 = object;
                string = Translate.translate("(CLOB) ") + ((Clob)object).getSubString(1L, 10);
                if ((int)((Clob)object).length() > 10) {
                    string = string + "...";
                }
            }
            catch (SQLException sQLException) {}
        } else if (object instanceof Blob) {
            object2 = object;
            string = Translate.translate("(BLOB)");
        } else if (object instanceof RAW) {
            object2 = object;
            string = Translate.translate("(RAW)");
        } else if (object instanceof BFILE) {
            object2 = object;
            string = Translate.translate("(BFILE)");
        } else if (object instanceof TIMESTAMPTZ) {
            string = (String)NLSUtils.getValue(connection, (TIMESTAMPTZ)object);
        } else if (object instanceof TIMESTAMPLTZ) {
            string = (String)NLSUtils.getValue(connection, (TIMESTAMPLTZ)object);
        } else if (object instanceof TIMESTAMP) {
            string = (String)NLSUtils.getValue(connection, (TIMESTAMP)object);
        } else if (object instanceof DATE) {
            string = (String)NLSUtils.getValue(connection, (DATE)object);
        } else if (object instanceof Date) {
            try {
                string = NLSUtils.formatDate(new DATE((Date)object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof NUMBER) {
            string = (String)NLSUtils.getValue(connection, (NUMBER)object);
        } else if (object instanceof BigDecimal) {
            string = (String)NLSUtils.getValue(connection, (BigDecimal)object);
        } else if (object instanceof OPAQUE) {
            try {
                string = ((OPAQUE)object).getSQLTypeName().trim();
                if (string.equals("SYS.XMLTYPE")) {
                    string = XMLType.createXML((OPAQUE)((OPAQUE)object)).getStringVal();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof STRUCT) {
            try {
                string = ((STRUCT)object).getSQLTypeName().trim();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof ARRAY) {
            try {
                string = ((ARRAY)object).getBaseTypeName() + "(";
                Datum[] datumArray = ((ARRAY)object).getOracleArray();
                boolean bl = true;
                for (Datum datum : datumArray) {
                    string = string + (bl ? "" : ",") + ODMrDefaultCellRenderer.stringValue(datum, connection);
                    bl = false;
                }
                string = string + ")";
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof ResultSet) {
            string = Translate.translate("(ResultSet)");
        } else if (object instanceof List) {
            string = "{";
            List list = (List)object;
            int n = 0;
            List list2 = (List)list.get(0);
            for (Object e : list) {
                if (n > 0) {
                    string = string + "<";
                    int n2 = 0;
                    for (Object e2 : (List)e) {
                        string = string + list2.get(n2) + "=" + ODMrDefaultCellRenderer.stringValue(e2, connection) + ",";
                        ++n2;
                    }
                    string = string.substring(0, string.length() - 1);
                    string = string + ">,";
                }
                ++n;
            }
            string = string + "}";
        } else if (object instanceof Datum && !(object instanceof INTERVALDS)) {
            try {
                string = ((Datum)object).stringValue();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else {
            string = object.toString();
        }
        return string;
    }

    private static class Translate {
        private Translate() {
        }

        private static String translate(String string) {
            return new String(string);
        }
    }

    private static class NLSUtils {
        private static DateFormat _sdf = SimpleDateFormat.getDateTimeInstance(1, 1, Locale.getDefault());

        private NLSUtils() {
        }

        public static Object getValue(Connection connection, Object object) {
            if (object == null) {
                return object;
            }
            String string = "";
            try {
                string = object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof TIMESTAMP && connection != null ? NLSUtils.formatTIMESTAMP((TIMESTAMP)object) : (object instanceof TIMESTAMPTZ && connection != null ? NLSUtils.formatTIMESTAMPTZ((TIMESTAMPTZ)object) : (object instanceof TIMESTAMPLTZ && connection != null ? NLSUtils.formatTIMESTAMPLTZ((TIMESTAMPLTZ)object) : (object instanceof DATE && connection != null ? NLSUtils.formatDate((DATE)object) : (object instanceof Date && connection != null ? NLSUtils.formatDate(new DATE((Date)object)) : (object instanceof NUMBER && connection != null ? NLSUtils.formatNUMBER(connection, (NUMBER)object) : (object instanceof BigDecimal && connection != null ? NLSUtils.formatBigDecimal(connection, (BigDecimal)object) : (object instanceof INTERVALDS && connection != null ? ((INTERVALDS)object).toString() : (object instanceof Datum ? ((Datum)object).stringValue() : object.toString()))))))))));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        public static String formatBigDecimal(Connection connection, BigDecimal bigDecimal) {
            String string = null;
            string = bigDecimal.toPlainString();
            if (string.indexOf(46) != -1 && connection instanceof OracleConnection) {
                char c = '.';
                string = bigDecimal.toPlainString();
                if (c != '.') {
                    string = string.replace('.', c);
                }
            }
            return string;
        }

        public static String formatNUMBER(Connection connection, NUMBER nUMBER) {
            String string = null;
            string = nUMBER.stringValue();
            if (string.indexOf(46) != -1) {
                char c = '.';
                try {
                    BigDecimal bigDecimal = nUMBER.bigDecimalValue();
                    string = bigDecimal.toPlainString();
                    if (c != '.') {
                        string = string.replace('.', c);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return string;
        }

        public static String formatDate(DATE dATE) {
            return _sdf.format(dATE.dateValue());
        }

        private static String formatTIMESTAMP(TIMESTAMP tIMESTAMP) {
            String string = "";
            try {
                string = _sdf.format(tIMESTAMP.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }

        private static String formatTIMESTAMPTZ(TIMESTAMPTZ tIMESTAMPTZ) {
            String string = "";
            try {
                string = _sdf.format(tIMESTAMPTZ.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }

        private static String formatTIMESTAMPLTZ(TIMESTAMPLTZ tIMESTAMPLTZ) {
            String string = "";
            try {
                string = _sdf.format(tIMESTAMPLTZ.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }
    }
}

