/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;

public class ODMrDataTypesUtil {
    private static DateFormat _df = SimpleDateFormat.getTimeInstance(1, Locale.getDefault());
    private static final String SYS_DM_NESTED_NUMERICAL = "SYS.DM_NESTED_NUMERICAL";
    private static final String SYS_DM_NESTED_NUMERICALS = "SYS.DM_NESTED_NUMERICALS";
    private static final String SYS_DM_NESTED_CATEGORICAL = "SYS.DM_NESTED_CATEGORICAL";
    private static final String SYS_DM_NESTED_CATEGORICALS = "SYS.DM_NESTED_CATEGORICALS";
    private static final String SYS_DM_NESTED_BINARY_DOUBLE = "SYS.SYS_DM_NESTED_BINARY_DOUBLE";
    private static final String SYS_DM_NESTED_BINARY_DOUBLES = "SYS.SYS_DM_NESTED_BINARY_DOUBLES";
    private static final String SYS_DM_NESTED_BINARY_FLOAT = "SYS.SYS_DM_NESTED_BINARY_FLOAT";
    private static final String SYS_DM_NESTED_BINARY_FLOATS = "SYS.SYS_DM_NESTED_BINARY_FLOATS";
    private static final String ODMR_PREDICTION_NUM = "ODMRSYS.ODMR_PREDICTION_NUM";
    private static final String ODMR_PREDICTION_SET_NUM = "ODMR_PREDICTION_SET_NUM";
    private static final String ODMR_FEATURE_NUM = "ODMRSYS.ODMR_FEATURE_NUM";
    private static final String ODMR_FEATURE_SET_NUM = "ODMR_FEATURE_SET_NUM";
    private static final String ODMR_CLUSTER_NUM = "ODMRSYS.ODMR_CLUSTER_NUM";
    private static final String ODMR_CLUSTER_SET_NUM = "ODMR_CLUSTER_SET_NUM";
    private static final String ODMR_PREDICTION_NUM_COST = "ODMRSYS.ODMR_PREDICTION_NUM_COST";
    private static final String ODMR_PREDICTION_SET_NUM_COST = "ODMR_PREDICTION_SET_NUM_COST";
    private static final String ODMR_PREDICTION_CAT_COST = "ODMRSYS.ODMR_PREDICTION_CAT_COST";
    private static final String ODMR_PREDICTION_SET_CAT_COST = "ODMR_PREDICTION_SET_CAT_COST";
    private static final String ODMR_PREDICTION_CAT = "ODMRSYS.ODMR_PREDICTION_CAT";
    private static final String ODMR_PREDICTION_SET_CAT = "ODMR_PREDICTION_SET_CAT";
    private static final String ODMR_FEATURE_CAT = "ODMRSYS.ODMR_FEATURE_CAT";
    private static final String ODMR_FEATURE_SET_CAT = "ODMR_FEATURE_SET_CAT";
    private static final String ODMR_CLUSTER_CAT = "ODMRSYS.ODMR_CLUSTER_CAT";
    private static final String ODMR_CLUSTER_SET_CAT = "ODMR_CLUSTER_SET_CAT";
    private static final String ODMR_PREDICTION_NUM_COSTF = "ODMRSYS.ODMR_PREDICTION_NUM_COSTF";
    private static final String ODMR_PREDICTION_NUM_COSTD = "ODMRSYS.ODMR_PREDICTION_NUM_COSTD";
    private static final String ODMR_PREDICTION_NUM_COSTN = "ODMRSYS.ODMR_PREDICTION_NUM_COSTN";
    private static final String ODMR_PREDICTION_SET_NUM_COSTF = "ODMR_PREDICTION_SET_NUM_COSTF";
    private static final String ODMR_PREDICTION_SET_NUM_COSTD = "ODMR_PREDICTION_SET_NUM_COSTD";
    private static final String ODMR_PREDICTION_SET_NUM_COSTN = "ODMR_PREDICTION_SET_NUM_COSTN";
    private static final String ODMR_PREDICTION_NUM_F = "ODMRSYS.ODMR_PREDICTION_NUM_F";
    private static final String ODMR_PREDICTION_NUM_D = "ODMRSYS.ODMR_PREDICTION_NUM_D";
    private static final String ODMR_PREDICTION_NUM_N = "ODMRSYS.ODMR_PREDICTION_NUM_N";
    private static final String ODMR_PREDICTION_SET_NUM_F = "ODMR_PREDICTION_SET_NUM_F";
    private static final String ODMR_PREDICTION_SET_NUM_D = "ODMR_PREDICTION_SET_NUM_D";
    private static final String ODMR_PREDICTION_SET_NUM_N = "ODMR_PREDICTION_SET_NUM_N";
    private static final String ODMR_PREDICTION_CAT_COSTPD = "ODMRSYS.ODMR_PREDICTION_CAT_COSTPD";
    private static final String ODMR_PREDICTION_SET_CAT_COSTPD = "ODMR_PREDICTION_SET_CAT_COSTPD";
    private static final String ODMR_PREDICTION_CATPD = "ODMRSYS.ODMR_PREDICTION_CATPD";
    private static final String ODMR_PREDICTION_SET_CATPD = "ODMR_PREDICTION_SET_CATPD";
    private static final String ODMR_FEATURE_NUMVD = "ODMRSYS.ODMR_FEATURE_NUMVD";
    private static final String ODMR_FEATURE_SET_NUMVD = "ODMR_FEATURE_SET_NUMVD";
    private static final String ODMR_FEATURE_CATVD = "ODMRSYS.ODMR_FEATURE_CATVD";
    private static final String ODMR_FEATURE_SET_CATVD = "ODMR_FEATURE_SET_CATVD";
    private static final String ODMR_CLUSTER_NUMPD = "ODMRSYS.ODMR_CLUSTER_NUMPD";
    private static final String ODMR_CLUSTER_SET_NUMPD = "ODMR_CLUSTER_SET_NUMPD";
    private static final String ODMR_CLUSTER_CATPD = "ODMRSYS.ODMR_CLUSTER_CATPD";
    private static final String ODMR_CLUSTER_SET_CATPD = "ODMR_CLUSTER_SET_CATPD";
    private static Preferences _p = Preferences.getPreferences();
    static Map<Integer, String> dataTypesMap;
    private static final String[] ODMR_12_1_APPLY_TYPES_SUPPORTED;

    public static String stringValue(Object object, Connection connection) {
        return ODMrDataTypesUtil.stringValue(object, connection, 4000);
    }

    public static String stringValue(Object object, Connection connection, int n) {
        if (object == null) {
            return null;
        }
        String string = null;
        Object object2 = null;
        if (object instanceof Clob) {
            try {
                object2 = object;
                string = Translate.translate("(CLOB) ") + ((Clob)object).getSubString(1L, n);
                if ((int)((Clob)object).length() > n) {
                    string = string + "...";
                }
            }
            catch (SQLException sQLException) {}
        } else if (object instanceof Blob) {
            object2 = object;
            string = Translate.translate("(BLOB)");
        } else if (object instanceof RAW) {
            object2 = object;
            string = (String)NLSUtils.getValue(connection, (RAW)object);
        } else if (object instanceof BFILE) {
            object2 = object;
            string = Translate.translate("(BFILE)");
        } else if (object instanceof TIMESTAMPTZ) {
            TIMESTAMPTZ tIMESTAMPTZ = (TIMESTAMPTZ)object;
            byte[] byArray = tIMESTAMPTZ.toBytes();
            try {
                Timestamp timestamp = tIMESTAMPTZ.timestampValue(connection);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(timestamp);
                String string2 = TimeUtils.GMT + TimeUtils.getRegionName(byArray);
                TimeZone timeZone = TimeUtils.toTimeZoneFromZoneId(string2);
                gregorianCalendar.setTimeZone(timeZone);
                StringBuffer stringBuffer = new StringBuffer();
                SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormatZone();
                simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                java.util.Date date = gregorianCalendar.getTime();
                simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                String string3 = TimeUtils.removeGMT(stringBuffer.toString());
                string = string3.toString();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                string = (String)NLSUtils.getValue(connection, object);
            }
        } else if (object instanceof TIMESTAMPLTZ) {
            TIMESTAMPLTZ tIMESTAMPLTZ = (TIMESTAMPLTZ)object;
            byte[] byArray = tIMESTAMPLTZ.toBytes();
            try {
                Timestamp timestamp = TIMESTAMPLTZ.toTimestamp((Connection)connection, (byte[])byArray);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(timestamp);
                StringBuffer stringBuffer = new StringBuffer();
                SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormat();
                simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                java.util.Date date = gregorianCalendar.getTime();
                simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                string = stringBuffer.toString();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                string = (String)NLSUtils.getValue(connection, object);
            }
        } else if (object instanceof TIMESTAMP) {
            TIMESTAMP tIMESTAMP = (TIMESTAMP)object;
            try {
                Time time = tIMESTAMP.timeValue();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(time);
                StringBuffer stringBuffer = new StringBuffer();
                SimpleDateFormat simpleDateFormat = TimeUtils.getShortSimpleDateFormat();
                simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                java.util.Date date = gregorianCalendar.getTime();
                simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                string = stringBuffer.toString();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                string = (String)NLSUtils.getValue(connection, object);
            }
        } else if (object instanceof DATE) {
            try {
                string = (String)NLSUtils.getValue(connection, (DATE)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string = object.toString();
            }
        } else if (object instanceof Date) {
            try {
                string = _df.format(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string = object.toString();
            }
        } else if (object instanceof NUMBER) {
            NUMBER nUMBER = (NUMBER)object;
            DataProfilePanelSettings dataProfilePanelSettings = DataProfilePanelSettings.getInstance((PropertyStorage)_p);
            int n2 = dataProfilePanelSettings.getNumericalPrecisionLevel();
            string = NumericFormat.format(nUMBER.doubleValue(), true, n2);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            DataProfilePanelSettings dataProfilePanelSettings = DataProfilePanelSettings.getInstance((PropertyStorage)_p);
            int n3 = dataProfilePanelSettings.getNumericalPrecisionLevel();
            string = NumericFormat.format(bigDecimal.doubleValue(), true, n3);
        } else if (object instanceof OPAQUE) {
            try {
                string = ((OPAQUE)object).getSQLTypeName().trim();
                if (string.equals("SYS.XMLTYPE")) {
                    string = XMLType.createXML((OPAQUE)((OPAQUE)object)).getStringVal();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof STRUCT) {
            try {
                string = ((STRUCT)object).getSQLTypeName().trim();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof ARRAY) {
            try {
                String string4 = ((ARRAY)object).getBaseTypeName();
                if (string4.equals(SYS_DM_NESTED_NUMERICAL)) {
                    string = "SYS.DM_NESTED_NUMERICALS(";
                } else if (string4.equals(SYS_DM_NESTED_CATEGORICAL)) {
                    string = "SYS.DM_NESTED_CATEGORICALS(";
                } else if (string4.equals(SYS_DM_NESTED_BINARY_DOUBLE)) {
                    string = "SYS.SYS_DM_NESTED_BINARY_DOUBLES(";
                } else if (string4.equals(SYS_DM_NESTED_BINARY_FLOAT)) {
                    string = "SYS.SYS_DM_NESTED_BINARY_FLOATS(";
                } else if (string4.equals(ODMR_PREDICTION_NUM)) {
                    string = "ODMR_PREDICTION_SET_NUM(";
                } else if (string4.equals(ODMR_FEATURE_NUM)) {
                    string = "ODMR_FEATURE_SET_NUM(";
                } else if (string4.equals(ODMR_CLUSTER_NUM)) {
                    string = "ODMR_CLUSTER_SET_NUM(";
                } else if (string4.equals(ODMR_PREDICTION_NUM_COST)) {
                    string = "ODMR_PREDICTION_SET_NUM_COST(";
                } else if (string4.equals(ODMR_PREDICTION_CAT_COST)) {
                    string = "ODMR_PREDICTION_SET_CAT_COST(";
                } else if (string4.equals(ODMR_PREDICTION_CAT)) {
                    string = "ODMR_PREDICTION_SET_CAT(";
                } else if (string4.equals(ODMR_FEATURE_CAT)) {
                    string = "ODMR_FEATURE_SET_CAT(";
                } else if (string4.equals(ODMR_CLUSTER_CAT)) {
                    string = "ODMR_CLUSTER_SET_CAT(";
                } else if (string4.equals(ODMR_PREDICTION_NUM_COSTF)) {
                    string = "ODMR_PREDICTION_SET_NUM_COSTF(";
                } else if (string4.equals(ODMR_PREDICTION_NUM_COSTD)) {
                    string = "ODMR_PREDICTION_SET_NUM_COSTD(";
                } else if (string4.equals(ODMR_PREDICTION_NUM_COSTN)) {
                    string = "ODMR_PREDICTION_SET_NUM_COSTN(";
                } else if (string4.equals(ODMR_PREDICTION_NUM_F)) {
                    string = "ODMR_PREDICTION_SET_NUM_F(";
                } else if (string4.equals(ODMR_PREDICTION_NUM_D)) {
                    string = "ODMR_PREDICTION_SET_NUM_D(";
                } else if (string4.equals(ODMR_PREDICTION_NUM_N)) {
                    string = "ODMR_PREDICTION_SET_NUM_N(";
                } else if (string4.equals(ODMR_PREDICTION_CAT_COSTPD)) {
                    string = "ODMR_PREDICTION_SET_CAT_COSTPD(";
                } else if (string4.equals(ODMR_PREDICTION_CATPD)) {
                    string = "ODMR_PREDICTION_SET_CATPD(";
                } else if (string4.equals(ODMR_FEATURE_NUMVD)) {
                    string = "ODMR_FEATURE_SET_NUMVD(";
                } else if (string4.equals(ODMR_FEATURE_CATVD)) {
                    string = "ODMR_FEATURE_SET_CATVD(";
                } else if (string4.equals(ODMR_CLUSTER_NUMPD)) {
                    string = "ODMR_CLUSTER_SET_NUMPD(";
                } else if (string4.equals(ODMR_CLUSTER_CATPD)) {
                    string = "ODMR_CLUSTER_SET_CATPD(";
                } else {
                    if (object == null) {
                        return "";
                    }
                    return DataLrb.get("DATA_VIEWER_COLUMN_NOT_DISPLAYABLE");
                }
                Datum[] datumArray = ((ARRAY)object).getOracleArray();
                if (datumArray.length == 0) {
                    string = string + ")";
                } else {
                    ARRAY aRRAY;
                    Object object3;
                    String string5 = ODMrDataTypesUtil.stringValue(datumArray[0], connection);
                    if ((string5.toString().equals(SYS_DM_NESTED_NUMERICAL) || string5.toString().equals(SYS_DM_NESTED_CATEGORICAL) || string5.toString().equals(SYS_DM_NESTED_BINARY_DOUBLE) || string5.toString().equals(SYS_DM_NESTED_BINARY_FLOAT) || string5.toString().equals(ODMR_PREDICTION_NUM) || string5.toString().equals(ODMR_FEATURE_NUM) || string5.toString().equals(ODMR_PREDICTION_CAT_COST) || string5.toString().equals(ODMR_PREDICTION_CAT) || string5.toString().equals(ODMR_FEATURE_CAT) || string5.toString().equals(ODMR_CLUSTER_CAT) || string5.toString().equals(ODMR_PREDICTION_NUM_COST) || string5.toString().equals(ODMR_CLUSTER_NUM) || string5.toString().equals(ODMR_PREDICTION_NUM_COSTF) || string5.toString().equals(ODMR_PREDICTION_NUM_COSTD) || string5.toString().equals(ODMR_PREDICTION_NUM_COSTN) || string5.toString().equals(ODMR_PREDICTION_NUM_F) || string5.toString().equals(ODMR_PREDICTION_NUM_D) || string5.toString().equals(ODMR_PREDICTION_NUM_N) || string5.toString().equals(ODMR_PREDICTION_CAT_COSTPD) || string5.toString().equals(ODMR_PREDICTION_CATPD) || string5.toString().equals(ODMR_FEATURE_NUMVD) || string5.toString().equals(ODMR_FEATURE_CATVD) || string5.toString().equals(ODMR_CLUSTER_NUMPD) || string5.toString().equals(ODMR_CLUSTER_CATPD)) && (object3 = (aRRAY = (ARRAY)object).getArray()) instanceof Object[]) {
                        Object[] objectArray = (Object[])object3;
                        StringBuilder stringBuilder = new StringBuilder(string);
                        for (int i = 0; i < objectArray.length; ++i) {
                            StringBuilder stringBuilder2 = new StringBuilder(string5);
                            STRUCT sTRUCT = (STRUCT)objectArray[i];
                            Object[] objectArray2 = sTRUCT.getAttributes();
                            stringBuilder2.append("(");
                            for (int j = 0; j < objectArray2.length; ++j) {
                                if (j > 0) {
                                    stringBuilder2.append(",");
                                }
                                stringBuilder2.append(objectArray2[j].toString());
                            }
                            stringBuilder2.append(")");
                            if (i > 0) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append((CharSequence)stringBuilder2);
                        }
                        stringBuilder.append(")");
                        string = stringBuilder.toString();
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof List) {
            string = "{";
            List list = (List)object;
            int n4 = 0;
            List list2 = (List)list.get(0);
            for (Object e : list) {
                if (n4 > 0) {
                    string = string + "<";
                    int n5 = 0;
                    for (Object e2 : (List)e) {
                        string = string + list2.get(n5) + "=" + ODMrDataTypesUtil.stringValue(e2, connection) + ",";
                        ++n5;
                    }
                    string = string.substring(0, string.length() - 1);
                    string = string + ">,";
                }
                ++n4;
            }
            string = string + "}";
        } else if (object instanceof Datum && !(object instanceof INTERVALDS)) {
            try {
                string = ((Datum)object).stringValue();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else {
            string = object.toString();
        }
        return string;
    }

    public static String getEmptyExtendedType(Object object, int n) {
        if (object instanceof Blob || n == 2004) {
            return "empty_blob()";
        }
        if (object instanceof BFILE || n == -13) {
            return "bfilename(' ',' ')";
        }
        return "NULL";
    }

    public static String getJdbcTypeName(int n) {
        if (dataTypesMap == null) {
            dataTypesMap = new HashMap<Integer, String>();
            Field[] fieldArray = OracleTypes.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    String string = fieldArray[i].getName();
                    Integer n2 = (Integer)fieldArray[i].get(null);
                    dataTypesMap.put(n2, string);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return dataTypesMap.get(new Integer(n));
    }

    public static void main(String[] stringArray) {
    }

    public static boolean canDuplicate(Object object, int n) {
        return !(object instanceof STRUCT) && n != 2002 && !(object instanceof RAW) && n != -4 && n != -2 && n != -3 && !(object instanceof Blob) && n != 2004;
    }

    public static Object getDuplicate(Object object, Connection connection, int n) throws SQLException {
        if (ODMrDataTypesUtil.canDuplicate(object, n)) {
            if (object instanceof Clob || n == 2005) {
                if (object == null || object.equals("")) {
                    return "";
                }
                return ((Clob)object).getSubString(1L, (int)((Clob)object).length());
            }
            return ODMrDataTypesUtil.stringValue(object, connection);
        }
        return null;
    }

    public static String[] getApply_12_1_Types() {
        return ODMR_12_1_APPLY_TYPES_SUPPORTED;
    }

    static {
        ODMR_12_1_APPLY_TYPES_SUPPORTED = new String[]{ODMR_PREDICTION_SET_NUM_COSTF, ODMR_PREDICTION_SET_NUM_COSTD, ODMR_PREDICTION_SET_NUM_COSTN, ODMR_PREDICTION_SET_NUM_F, ODMR_PREDICTION_SET_NUM_D, ODMR_PREDICTION_SET_CAT_COSTPD, ODMR_FEATURE_SET_NUMVD, ODMR_FEATURE_SET_CATVD, ODMR_CLUSTER_SET_NUMPD, ODMR_CLUSTER_SET_CATPD};
    }

    private static class Translate {
        private Translate() {
        }

        public static String translate(String string) {
            if (string == null) {
                return null;
            }
            String string2 = string.replace('_', ' ');
            return string2;
        }
    }

    private static class NLSUtils {
        private static DateFormat _sdf = SimpleDateFormat.getDateTimeInstance(3, 3, Locale.getDefault());

        private NLSUtils() {
        }

        public static Object getValue(Connection connection, Object object) {
            if (object == null) {
                return object;
            }
            String string = "";
            try {
                string = object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof TIMESTAMP && connection != null ? NLSUtils.formatTIMESTAMP((TIMESTAMP)object) : (object instanceof TIMESTAMPTZ && connection != null ? NLSUtils.formatTIMESTAMPTZ((TIMESTAMPTZ)object) : (object instanceof TIMESTAMPLTZ && connection != null ? NLSUtils.formatTIMESTAMPLTZ((TIMESTAMPLTZ)object) : (object instanceof DATE && connection != null ? NLSUtils.formatDate((DATE)object) : (object instanceof Date && connection != null ? NLSUtils.formatDate(new DATE((Date)object)) : (object instanceof NUMBER && connection != null ? NLSUtils.formatNUMBER(connection, (NUMBER)object) : (object instanceof BigDecimal && connection != null ? NLSUtils.formatBigDecimal(connection, (BigDecimal)object) : (object instanceof INTERVALDS && connection != null ? ((INTERVALDS)object).toString() : (object instanceof Datum ? ((Datum)object).stringValue() : object.toString()))))))))));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        public static String formatBigDecimal(Connection connection, BigDecimal bigDecimal) {
            String string = null;
            string = bigDecimal.toPlainString();
            if (string.indexOf(46) != -1 && connection instanceof OracleConnection) {
                char c = '.';
                string = bigDecimal.toPlainString();
                if (c != '.') {
                    string = string.replace('.', c);
                }
            }
            return string;
        }

        public static String formatNUMBER(Connection connection, NUMBER nUMBER) {
            String string = null;
            string = nUMBER.stringValue();
            if (string.indexOf(46) != -1) {
                char c = '.';
                try {
                    BigDecimal bigDecimal = nUMBER.bigDecimalValue();
                    string = bigDecimal.toPlainString();
                    if (c != '.') {
                        string = string.replace('.', c);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return string;
        }

        public static String formatDate(DATE dATE) {
            return _sdf.format(dATE.dateValue());
        }

        private static String formatTIMESTAMP(TIMESTAMP tIMESTAMP) {
            String string = "";
            try {
                string = _sdf.format(tIMESTAMP.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }

        private static String formatTIMESTAMPTZ(TIMESTAMPTZ tIMESTAMPTZ) {
            String string = "";
            try {
                string = _sdf.format(tIMESTAMPTZ.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }

        private static String formatTIMESTAMPLTZ(TIMESTAMPLTZ tIMESTAMPLTZ) {
            String string = "";
            try {
                string = _sdf.format(tIMESTAMPLTZ.dateValue());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            return string;
        }
    }
}

