/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.sql.Connection;
import java.util.List;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.DataProfilePhysicalNode;
import oracle.dmt.dataminer.navigator.LogicalDataNode;
import oracle.dmt.dataminer.navigator.PhysicalDataNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataProfileNavNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelC;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelR;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataSourceViewOption;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditExpressionPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.db.DatabaseConnections;

public class DataViewerState {
    private Context _context;
    private String _connectionName;
    private ModelViewerState1 _modelViewerState;
    private String _schemaName;
    private String _tableName;
    private String _cacheTableName;
    private String _cacheSchemaName;
    private String _selectSQL;
    private Connection _conn = null;
    private ODMrResultSetTableModel _resultSetModel;
    private Node _node;
    private DataSourceViewOption _currentSourceOption = DataSourceViewOption.CACHE;
    private boolean _loadFromNode = true;

    public DataViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this.initTable();
    }

    public DataViewerState(Context context, boolean bl) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this._context = context;
        this._loadFromNode = bl;
        if (this._loadFromNode) {
            this.initTable();
        } else {
            this._resultSetModel = new ODMrResultSetTableModel();
        }
    }

    public DataViewerState(String string, String string2, String string3) {
        this._connectionName = string;
        this._context = null;
        this._loadFromNode = true;
        this._resultSetModel = new ODMrResultSetTableModel();
        this._cacheTableName = string3;
        this._cacheSchemaName = string2;
    }

    public void setTableName(String string, String string2) {
        this._schemaName = string;
        this._tableName = string2;
    }

    private void initTable() {
        BaseTreeNode baseTreeNode;
        this._node = this._context.getNode();
        assert (this._node != null) : "Tree Node is null";
        assert (this._node instanceof PhysicalDataNode || this._node instanceof GLMRModelNode || this._node instanceof DataProfileNavNode || this._node instanceof GLMCModelNode || this._node instanceof LogicalDataNode) : "Node is not acceptable with Data Viewer";
        String string = null;
        try {
            baseTreeNode = ConnectionFolder.getConnectionFolder(this._context);
            string = ((ConnectionFolder)baseTreeNode).getUserAccountName();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
        }
        if (this._node instanceof PhysicalDataNode) {
            baseTreeNode = (PhysicalDataNode)this._node;
            this._schemaName = ((DataNode)baseTreeNode).getUserName();
            this._tableName = ((PhysicalDataNode)baseTreeNode).getTableName();
            this._cacheTableName = ((DataNode)baseTreeNode).getCacheTableName();
            this._cacheSchemaName = ((DataNode)baseTreeNode).getCacheSchemaName();
            if (this._cacheTableName.length() == 0) {
                this._currentSourceOption = DataSourceViewOption.ACTUAL;
            }
        } else if (this._node instanceof GLMRModelNode) {
            baseTreeNode = (GLMRModelNode)this._node;
            RGeneralizedLinearModelType rGeneralizedLinearModelType = (RGeneralizedLinearModelType)baseTreeNode.getRepositoryData();
            this._schemaName = string;
            this._tableName = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            this._cacheSchemaName = "";
            this._cacheTableName = "";
            this._currentSourceOption = DataSourceViewOption.ACTUAL;
        } else if (this._node instanceof GLMCModelNode) {
            baseTreeNode = (GLMCModelNode)this._node;
            CGeneralizedLinearModelType cGeneralizedLinearModelType = (CGeneralizedLinearModelType)baseTreeNode.getRepositoryData();
            this._schemaName = string;
            this._tableName = cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getGLMSDIAGNOSTICSTABLENAME();
            this._cacheSchemaName = "";
            this._cacheTableName = "";
            this._currentSourceOption = DataSourceViewOption.ACTUAL;
        } else if (this._node instanceof LogicalDataNode) {
            baseTreeNode = (LogicalDataNode)this._node;
            this._schemaName = "";
            this._tableName = "";
            this._cacheTableName = ((DataNode)baseTreeNode).getCacheTableName();
            this._cacheSchemaName = ((DataNode)baseTreeNode).getCacheSchemaName();
            this._selectSQL = this.getStackedSQL();
            if (this._cacheTableName.length() == 0) {
                this._currentSourceOption = DataSourceViewOption.ACTUAL;
            }
        } else if (this._node instanceof DataProfilePhysicalNode) {
            baseTreeNode = (DataProfilePhysicalNode)this._node;
            this._schemaName = ((DataNode)baseTreeNode).getCacheSchemaName();
            this._tableName = ((DataNode)baseTreeNode).getCacheTableName();
            this._cacheTableName = ((DataNode)baseTreeNode).getCacheTableName();
            this._cacheSchemaName = ((DataNode)baseTreeNode).getCacheSchemaName();
            if (this._cacheTableName.length() == 0) {
                this._currentSourceOption = DataSourceViewOption.ACTUAL;
            }
        }
        this._resultSetModel = new ODMrResultSetTableModel();
    }

    private String getStackedSQL() {
        DataNode dataNode = (DataNode)this._context.getNode();
        WorkflowNode workflowNode = (WorkflowNode)dataNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        DataNodeType dataNodeType = (DataNodeType)dataNode.getRepositoryData();
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(dataNodeType.getId());
        if (abstractDataNode == null) {
            return null;
        }
        return abstractDataNode.getStackedSQL(workflowModel);
    }

    public String getSchema() {
        return this._schemaName;
    }

    public String getName() {
        return this._tableName;
    }

    private Connection getConnectionUsingConnectionName() {
        DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
        Connection connection = null;
        try {
            connection = databaseConnections.getUniqueConnection(this._connectionName);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
        }
        return connection;
    }

    public void load() throws Exception {
        if (this._conn == null) {
            this._conn = this._context != null ? Connections.getUniqueConnection(this._context) : this.getConnectionUsingConnectionName();
            if (this._conn != null) {
                ConnectionFolder.setConnectionAlterSessionFixes(this._conn);
            }
        }
        if (!(this._node instanceof PhysicalDataNode) && (this._node instanceof GLMRModelNode || this._node instanceof GLMCModelNode)) {
            this._modelViewerState = new ModelViewerState1(this._context);
            this._modelViewerState.load(this._conn);
            assert (this._modelViewerState.getModelDesc().isGeneralizedLinearModelAlgorithm()) : "Data Viewer accepts only models of type GLM";
            this.generateTranslationColumnNames();
        }
    }

    private String getQueryFromActual() {
        if (this._node instanceof PhysicalDataNode || this._node instanceof GLMCModelNode || this._node instanceof GLMRModelNode) {
            List list;
            Attributes attributes;
            DataNodeType dataNodeType;
            BaseTreeNode baseTreeNode = (BaseTreeNode)this._node;
            Object object = baseTreeNode.getRepositoryData();
            if (object instanceof DataNodeType && (dataNodeType = (DataNodeType)object) instanceof DataSourceNodeType && (attributes = ((DataSourceNodeType)dataNodeType).getAttributes()) != null && (list = attributes.getAttribute()) != null && !list.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder("SELECT ");
                boolean bl = true;
                for (AttributeType attributeType : list) {
                    if (!bl) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(attributeType.getAlias() != null ? StringUtils.addDoubleQuotes(attributeType.getName()) + " AS " + StringUtils.addDoubleQuotes(attributeType.getAlias()) : StringUtils.addDoubleQuotes(attributeType.getName()));
                    bl = false;
                }
                stringBuilder.append(" FROM \"" + this.getSchema() + "\".\"" + this.getName() + "\"");
                return stringBuilder.toString();
            }
            return "SELECT * FROM \"" + this.getSchema() + "\".\"" + this.getName() + "\"";
        }
        if (this._node instanceof LogicalDataNode) {
            return "select * from ( " + this._selectSQL + " )";
        }
        if (this._node instanceof DataProfilePhysicalNode) {
            String string = ((DataProfilePhysicalNode)this._node).getStatsTableName();
            return "SELECT * FROM \"" + string + "\"";
        }
        return "select 'not implemented' as NOT_IMPLEMENTED from dual";
    }

    private String getQueryFromCache() {
        return "SELECT * FROM \"" + this._cacheSchemaName + "\".\"" + this._cacheTableName + "\"";
    }

    private String getQueryFromManual() {
        return "SELECT * FROM \"" + this._schemaName + "\".\"" + this._tableName + "\"";
    }

    public String getQuery() {
        String string;
        if (this._loadFromNode) {
            switch (this._currentSourceOption) {
                case CACHE: {
                    string = this.getQueryFromCache();
                    break;
                }
                case ACTUAL: {
                    string = this.getQueryFromActual();
                    break;
                }
                default: {
                    string = "";
                    break;
                }
            }
        } else {
            string = this.getQueryFromManual();
        }
        return string;
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        if (this._conn != null) {
            try {
                this._conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._resultSetModel != null) {
            try {
                this._resultSetModel.closeConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadModel() throws Exception {
        this._resultSetModel.setResultSet(null);
        if (this._context != null) {
            this._resultSetModel.setContext(this._context);
        } else {
            this._resultSetModel.setConnection(this._conn);
        }
        String string = this.getQuery();
        if (string == null) {
            string = "SELECT '" + DataLrb.get("DATA_VIEWER_ACTUAL_NO_QUERY_AVAILABLE") + "' as MESSAGE FROM DUAL";
            this._resultSetModel.setUseStandardColumnSize(true);
            this._resultSetModel.setStandardColumnSize(800);
        } else {
            String string2 = "SELECT * FROM (" + string + ") where rownum = 1";
            AggregateEditExpressionPanel.executeSQL(this._context, string2);
        }
        this._resultSetModel.setSql(string);
        this._resultSetModel.setBindMap(null);
        this._resultSetModel.setTranslatedColNames(true);
        if (this._node instanceof GLMRModelNode || this._node instanceof GLMCModelNode) {
            this._resultSetModel.setUseStandardColumnSize(true);
            this._resultSetModel.setStandardColumnSize(100);
        }
        this._resultSetModel.setThreaded(false);
        this._resultSetModel.setVerticalDisplay(false);
        this._resultSetModel.setSortCol(-1);
    }

    public void setResultSetModel(ODMrResultSetTableModel oDMrResultSetTableModel) {
        this._resultSetModel = oDMrResultSetTableModel;
    }

    public ODMrResultSetTableModel getResultSetModel() {
        return this._resultSetModel;
    }

    public void generateTranslationColumnNames() throws Exception {
        if (this._modelViewerState.getModelDesc().isClassificationModel() && this._modelViewerState.getModelDesc().isGeneralizedLinearModelAlgorithm()) {
            GeneralizedLinearModelC generalizedLinearModelC = new GeneralizedLinearModelC();
        } else if (this._modelViewerState.getModelDesc().isRegressionModel() && this._modelViewerState.getModelDesc().isGeneralizedLinearModelAlgorithm()) {
            GeneralizedLinearModelR generalizedLinearModelR = new GeneralizedLinearModelR();
        }
    }

    public void setCurrentSourceOption(DataSourceViewOption dataSourceViewOption) throws Exception {
        this._currentSourceOption = dataSourceViewOption;
        this.reloadModel();
    }

    public void reloadModel() throws Exception {
        String string = this._resultSetModel.getWhere();
        String string2 = this._resultSetModel.getOrderBy();
        this._resultSetModel = new ODMrResultSetTableModel();
        this._resultSetModel.setWhere(string);
        this._resultSetModel.setOrderBy(string2);
        this.loadModel();
    }

    public DataSourceViewOption getCurrentSourceOption() {
        return this._currentSourceOption;
    }
}

