/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import oracle.dmt.dataminer.server.model.ModelLrb;

public class SortSpec {
    public static int SORT_ASCENDING = 1;
    public static int SORT_DECENDING = 2;
    private String _attributeName;
    private int _sortDirection;
    private boolean _useIt;
    private static final String SQL_ASCENDING = "ASC";
    private static final String SQL_DESCENDING = "DESC";

    public SortSpec(String string, int n) throws Exception {
        this(string, n, true);
    }

    public SortSpec(String string, int n, boolean bl) throws Exception {
        if (string == null) {
            throw new Exception(ModelLrb.get("SORT_ATTRIBUTE_NAME_ERROR"));
        }
        if (string.length() == 0) {
            throw new Exception(ModelLrb.get("SORT_ATTRIBUTE_NAME_ERROR"));
        }
        assert (n == SORT_ASCENDING || n == SORT_DECENDING) : "Sort Spec sort direction must be valid value";
        this._attributeName = string;
        this._sortDirection = n;
        this._useIt = bl;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public int getSortDirection() {
        return this._sortDirection;
    }

    public String getSortSQLString() {
        return this._attributeName + " " + (this.isAscending() ? SQL_ASCENDING : SQL_DESCENDING) + " ";
    }

    public boolean isAscending() {
        return this._sortDirection == SORT_ASCENDING;
    }

    public boolean isDecending() {
        return this._sortDirection == SORT_DECENDING;
    }

    public void setAttributeName(String string) {
        this._attributeName = string;
    }

    public void setSortDirection(int n) {
        this._sortDirection = n;
    }

    public void setUseIt(boolean bl) {
        this._useIt = bl;
    }

    public boolean isUseIt() {
        return this._useIt;
    }
}

