/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.MatrixInfo;
import oracle.dmt.dataminer.controls.PerformanceInfo;
import oracle.dmt.dataminer.controls.PriorsInfo;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningModelAttributes;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.javatools.util.Version;

public class Model {
    private String _modelName;
    private String _userName;
    private boolean _loaded;
    private Vector<MiningModelSettings> _modelSettings;
    private ModelGeneralDescription _modelGeneralDescription;
    private static String _SETTING_VALUE = "select SETTING_VALUE from ALL_MINING_MODEL_SETTINGS WHERE OWNER=? and MODEL_NAME=? AND SETTING_NAME=?";
    private static String _TARGET_VALUE = "TARGET_VALUE";
    private static String _ACTUAL = "ACTUAL";
    private static String _PREDICTED = "PREDICTED";
    private static String _ACTUAL_TARGET_VALUE = "ACTUAL_TARGET_VALUE";
    private static String _PREDICTED_TARGET_VALUE = "PREDICTED_TARGET_VALUE";
    private static String _PRIOR_PROBABILITY = "PRIOR_PROBABILITY";
    private static String _COST = "COST";
    private static final String COSTS_MATRIX_QRY = "select " + _ACTUAL + "," + _PREDICTED + "," + _COST + " from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(?))";
    private static String _SVM_WEIGHT_QRY = "select " + _TARGET_VALUE + ", " + _PRIOR_PROBABILITY + " from ";
    private static String _GLM_WEIGHT_QRY = "select * from ";
    private static String _SVM_COST_QRY = "select " + _ACTUAL_TARGET_VALUE + "," + _PREDICTED_TARGET_VALUE + "," + _COST + " from ";
    private static String _GLM_CLASS_REFERENCE_VALUES_COMPLEMENTARY = "select distinct CLASS from TABLE(dbms_data_mining.get_model_details_glm(?))";

    public Model(String string) {
        this(null, string);
    }

    public Model(String string, String string2) {
        this._userName = string;
        this._modelName = string2;
        this._loaded = false;
    }

    public Model() {
        this._loaded = false;
    }

    public static String getCombinedUserNameModelName(String string, String string2, boolean bl) {
        String string3 = "\"" + string + "\".\"" + string2.toUpperCase() + "\"";
        if (bl) {
            string3 = StringUtils.escapeSingleQuotesForSQL(string3);
        }
        return string3;
    }

    public ModelGeneralDescription getModelGeneralDescription() {
        assert (this._loaded) : "Accesing model details prior to loading.";
        return this._modelGeneralDescription;
    }

    public Vector<MiningModelSettings> getModelSettings() {
        assert (this._loaded) : "Accesing model details prior to loading.";
        return this._modelSettings;
    }

    public synchronized void load(Connection connection) throws Exception {
        assert (this._modelName.trim().length() > 0) : "Model name is empty. Unable to load model.";
        if (this._loaded) {
            return;
        }
        this.loadModelGeneralDescription(connection);
        this.loadModelSetting(connection);
        this._loaded = true;
    }

    private void loadModelSetting(Connection connection) throws Exception {
        this._modelSettings = this.getModelSetting(connection, this._userName, this._modelName);
    }

    public Vector<MiningModelSettings> getModelSetting(Connection connection, String string, String string2) throws Exception {
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        return this.getModelSettings(connection, string, vector);
    }

    public String getRegressionModelTarget(Connection connection, String string, String string2) throws Exception {
        String string3 = null;
        SQLHelper sQLHelper = new SQLHelper();
        String string4 = "select ATTRIBUTE_NAME  from all_mining_model_attributes WHERE OWNER = ? AND TARGET='YES' AND MODEL_NAME=?";
        try {
            sQLHelper.pstmt = connection.prepareStatement(string4);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string3 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getModelAttributes(Connection connection, String string, String string2) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = "select ATTRIBUTE_NAME  from all_mining_model_attributes WHERE OWNER = ? AND MODEL_NAME=?";
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                arrayList.add(string4);
            }
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static Vector<MiningModelSettings> getModelSettings(Connection connection, Vector<String> vector) throws Exception {
        Vector<MiningModelSettings> vector2 = new Vector<MiningModelSettings>();
        SQLHelper sQLHelper = new SQLHelper();
        String string = " SELECT OWNER  ,\n  MODEL_NAME   ,\n  SETTING_NAME ,\n  SETTING_VALUE,\n  SETTING_TYPE\n   FROM ALL_MINING_MODEL_SETTINGS\n   WHERE '\"' || OWNER || '\".\"' || MODEL_NAME || '\"' IN(<MODEL_LIST>)";
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = vector.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("'" + iterator.next() + "'");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        string2 = StringUtils.getReplacedString(string, "<MODEL_LIST>", stringBuffer.toString());
        try {
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.pstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                MiningModelSettings miningModelSettings = new MiningModelSettings(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), sQLHelper.rs.getString("SETTING_NAME"), sQLHelper.rs.getString("SETTING_VALUE"), sQLHelper.rs.getString("SETTING_TYPE"));
                vector2.add(miningModelSettings);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector2;
    }

    public Vector<MiningModelSettings> getModelSettings(Connection connection, String string, Vector<String> vector) throws Exception {
        Object object;
        Vector<MiningModelSettings> vector2 = new Vector<MiningModelSettings>();
        SQLHelper sQLHelper = new SQLHelper();
        String string2 = "select OWNER, MODEL_NAME,SETTING_NAME,SETTING_VALUE,SETTING_TYPE from ALL_MINING_MODEL_SETTINGS";
        String string3 = null;
        if (vector == null) {
            string3 = string2;
        } else {
            object = new StringBuffer("WHERE MODEL_NAME IN(");
            Iterator<String> iterator = vector.iterator();
            while (iterator.hasNext()) {
                ((StringBuffer)object).append("'" + iterator.next().toUpperCase() + "'");
                if (!iterator.hasNext()) continue;
                ((StringBuffer)object).append(",");
            }
            ((StringBuffer)object).append(")");
            ((StringBuffer)object).append(" AND OWNER = ?");
            string3 = string2 + " " + ((StringBuffer)object).toString();
        }
        try {
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = new MiningModelSettings(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), sQLHelper.rs.getString("SETTING_NAME"), sQLHelper.rs.getString("SETTING_VALUE"), sQLHelper.rs.getString("SETTING_TYPE"));
                vector2.add((MiningModelSettings)object);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector2;
    }

    public Vector<MiningModelSettings> getModelSettings(Connection connection, String string, String string2) throws Exception {
        Vector<MiningModelSettings> vector = new Vector<MiningModelSettings>();
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = "select MODEL_NAME,SETTING_NAME,SETTING_VALUE,SETTING_TYPE from ALL_MINING_MODEL_SETTINGS WHERE OWNER=? and MODEL_NAME=?";
        try {
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2);
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string3);
            while (sQLHelper.rs.next()) {
                MiningModelSettings miningModelSettings = new MiningModelSettings(string, string2, sQLHelper.rs.getString("SETTING_NAME"), sQLHelper.rs.getString("SETTING_VALUE"), sQLHelper.rs.getString("SETTING_TYPE"));
                vector.add(miningModelSettings);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    private void loadModelGeneralDescription(Connection connection) throws Exception {
        this._modelGeneralDescription = this.getModelGeneralDescription(connection, this._userName, this._modelName);
    }

    public ModelGeneralDescription getModelGeneralDescription(Connection connection, String string, String string2) throws Exception {
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        Vector<ModelGeneralDescription> vector2 = this.getModelGeneralDescriptions(connection, string, vector);
        if (vector2 == null || vector2.isEmpty()) {
            return ModelGeneralDescription._NONE;
        }
        return this.getModelGeneralDescriptions(connection, string, vector).get(0);
    }

    public Vector<ModelGeneralDescription> getModelGeneralDescriptions(Connection connection, String string, Vector<String> vector) throws Exception {
        Object object;
        Vector<ModelGeneralDescription> vector2 = new Vector<ModelGeneralDescription>();
        SQLHelper sQLHelper = new SQLHelper();
        String string2 = "select OWNER, MODEL_NAME, MINING_FUNCTION, ALGORITHM, CREATION_DATE, BUILD_DURATION, MODEL_SIZE,COMMENTS from ALL_MINING_MODELS";
        String string3 = null;
        if (vector == null) {
            string3 = string2;
        } else {
            object = new StringBuffer("WHERE MODEL_NAME IN(");
            Iterator<String> iterator = vector.iterator();
            while (iterator.hasNext()) {
                ((StringBuffer)object).append("'" + iterator.next().toUpperCase() + "'");
                if (!iterator.hasNext()) continue;
                ((StringBuffer)object).append(",");
            }
            ((StringBuffer)object).append(")");
            ((StringBuffer)object).append(" AND OWNER = ?");
            string3 = string2 + " " + ((StringBuffer)object).toString();
        }
        try {
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setFetchSize(100);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = new ModelGeneralDescription(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("MODEL_NAME"), sQLHelper.rs.getString("MINING_FUNCTION"), sQLHelper.rs.getString("ALGORITHM"), sQLHelper.rs.getDate("CREATION_DATE"), sQLHelper.rs.getBigDecimal("BUILD_DURATION"), sQLHelper.rs.getBigDecimal("MODEL_SIZE"), sQLHelper.rs.getString("COMMENTS"));
                vector2.add((ModelGeneralDescription)object);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<String> getModelNames(Connection connection, String string, String string2, boolean bl) throws Exception {
        Vector<String> vector = new Vector<String>();
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = null;
        string3 = bl ? "select MODEL_NAME from USER_MINING_MODELS " : "select MODEL_NAME from ALL_MINING_MODELS ";
        String string4 = "where MINING_FUNCTION = '" + string + "' AND " + " ALGORITHM = '" + string2 + "' ";
        String string5 = "order by MODEL_NAME";
        String string6 = string3 + string4 + string5;
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string6);
            while (sQLHelper.rs.next()) {
                vector.add(sQLHelper.rs.getString("MODEL_NAME"));
            }
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isModelExists(Connection connection, String string, String string2) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = null;
        string3 = "select MODEL_NAME from ALL_MINING_MODELS ";
        boolean bl = false;
        String string4 = "where MODEL_NAME = '" + string2 + "' " + " AND OWNER = '" + string + "' ";
        String string5 = string3 + string4;
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string5);
            if (sQLHelper.rs.next()) {
                bl = true;
            }
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    public Vector<ModelGeneralDescription> getAllModelGeneralDescriptions(Connection connection) throws Exception {
        return this.getModelGeneralDescriptions(connection, this._userName, null);
    }

    public static MiningModelAttributes getMiningModelAttributes(Connection connection, String string, String string2, List<MiningAttributeType> list) throws Exception {
        MiningModelAttributes miningModelAttributes = null;
        try {
            miningModelAttributes = MiningModelAttributes.getMiningModelAttributes(connection, string, string2, list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            miningModelAttributes = null;
        }
        if (miningModelAttributes == null) {
            try {
                Version version = ConfigUtils.getDatabaseVersion(connection);
                Version version2 = new Version("11.2.0.1.2");
                if (version.compareTo((Object)version2) < 0) {
                    miningModelAttributes = MiningModelAttributes.getMiningModelAttributes2(connection, string, string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return miningModelAttributes;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getUserName() {
        return this._userName;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CostMatrixInfo getModelCostMatrix(Connection connection, String string, String string2) throws Exception {
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_TRUE");
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(COSTS_MATRIX_QRY);
            String string3 = "\"" + string + "\".\"" + string2 + "\"";
            sQLHelper.pstmt.setString(1, string3);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString(_ACTUAL);
                String string5 = sQLHelper.rs.getString(_PREDICTED);
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(_COST);
                if (bigDecimal == null) continue;
                costMatrixInfo.setType("T");
                if (string4 == null || 0 == string4.length() || string5 == null || 0 == string5.length()) continue;
                costMatrixInfo.put(string4, string5, bigDecimal);
            }
            if (costMatrixInfo.isEmpty()) {
                costMatrixInfo = CostMatrixInfo._NONE;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            costMatrixInfo = CostMatrixInfo._NONE;
        }
        finally {
            sQLHelper.close();
        }
        return costMatrixInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerformanceInfo getGLMWeights(Connection connection, String string, String string2) throws Exception {
        String string3 = MiningModelSettings.ALL_MINING_MODEL_SETTINGS.CLAS_WEIGHTS_TABLE_NAME;
        String string4 = Model.getSettingValue(connection, string, string2, string3);
        if (string4 == null || string4.isEmpty()) {
            return null;
        }
        String string5 = string4.toUpperCase();
        if (!DatabaseMetadataUtils.isTable(connection, string, string5)) {
            return null;
        }
        Hashtable<String, String> hashtable = DatabaseMetadataUtils.getColumnTypes(connection, string, string5);
        if (hashtable == null || hashtable.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(_GLM_WEIGHT_QRY);
        stringBuffer.append("\"" + string + "\".\"" + string4 + "\"");
        PerformanceInfo performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                Enumeration<String> enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string6 = enumeration.nextElement();
                    String string7 = hashtable.get(string6);
                    Object object = null;
                    object = string7.equals("NUMBER") ? sQLHelper.rs.getBigDecimal(_TARGET_VALUE) : sQLHelper.rs.getString(_TARGET_VALUE);
                    BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(_PRIOR_PROBABILITY);
                    assert (bigDecimal != null) : "Performance value is missing!";
                    if (object != null && null != bigDecimal) {
                        performanceInfo.put(object.toString(), bigDecimal);
                        continue;
                    }
                    assert (object == null && bigDecimal == null) : "incorrect Performance  specification";
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            performanceInfo.clear();
        }
        finally {
            sQLHelper.close();
        }
        return performanceInfo;
    }

    public static PerformanceInfo getSVMWeights(Connection connection, String string, String string2) throws Exception {
        String string3 = MiningModelSettings.ALL_MINING_MODEL_SETTINGS.CLAS_PRIORS_TABLE_NAME;
        PerformanceInfo performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        Model.getWeights(connection, string, string2, string3, performanceInfo);
        if (performanceInfo.isEmpty()) {
            return null;
        }
        return performanceInfo;
    }

    public static PriorsInfo getNBPriors(Connection connection, String string, String string2) throws Exception {
        PriorsInfo priorsInfo = new PriorsInfo("Y");
        String string3 = MiningModelSettings.ALL_MINING_MODEL_SETTINGS.CLAS_PRIORS_TABLE_NAME;
        Model.getWeights(connection, string, string2, string3, priorsInfo);
        if (priorsInfo.isEmpty()) {
            return null;
        }
        return priorsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getWeights(Connection connection, String string, String string2, String string3, MatrixInfo matrixInfo) throws Exception {
        String string4 = Model.getSettingValue(connection, string, string2, string3);
        if (string4 == null || string4.isEmpty()) {
            return;
        }
        String string5 = string4.toUpperCase();
        if (!DatabaseMetadataUtils.isTable(connection, string, string5)) {
            return;
        }
        String string6 = DatabaseMetadataUtils.getColumnType(connection, string, string5, _TARGET_VALUE);
        if (string6 == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(_SVM_WEIGHT_QRY);
        stringBuffer.append("\"" + string + "\".\"" + string4 + "\"");
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                Object object = null;
                object = string6.equals("NUMBER") ? sQLHelper.rs.getBigDecimal(_TARGET_VALUE) : sQLHelper.rs.getString(_TARGET_VALUE);
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(_PRIOR_PROBABILITY);
                assert (bigDecimal != null) : "Performance value is missing!";
                if (object != null && null != bigDecimal) {
                    matrixInfo.put(object.toString(), bigDecimal);
                    continue;
                }
                assert (object == null && bigDecimal == null) : "incorrect Performance  specification";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            matrixInfo.clear();
        }
        finally {
            sQLHelper.close();
        }
    }

    private static String getSettingValue(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(_SETTING_VALUE);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string2.toUpperCase());
            sQLHelper.pstmt.setString(3, string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string4 = sQLHelper.rs.getString("SETTING_VALUE");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CostMatrixInfo getModelBuildCostMatrix(Connection connection, String string, String string2) throws Exception {
        String string3 = MiningModelSettings.ALL_MINING_MODEL_SETTINGS.CLAS_COST_TABLE_NAME;
        String string4 = Model.getSettingValue(connection, string, string2, string3);
        if (string4 == null || string4.isEmpty()) {
            return null;
        }
        String string5 = string4.toUpperCase();
        if (!DatabaseMetadataUtils.isTable(connection, string, string5)) {
            return null;
        }
        String string6 = DatabaseMetadataUtils.getColumnType(connection, string, string5, _ACTUAL_TARGET_VALUE);
        if (string6 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(_SVM_COST_QRY);
        stringBuffer.append("\"" + string + "\".\"" + string4 + "\"");
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_TRUE");
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer.toString());
            while (sQLHelper.rs.next()) {
                BigDecimal bigDecimal;
                Object object = null;
                Object object2 = null;
                if (string6.equals("NUMBER")) {
                    object = sQLHelper.rs.getBigDecimal(_ACTUAL_TARGET_VALUE);
                    object2 = sQLHelper.rs.getBigDecimal(_PREDICTED_TARGET_VALUE);
                } else {
                    object = sQLHelper.rs.getString(_ACTUAL_TARGET_VALUE);
                    object2 = sQLHelper.rs.getString(_PREDICTED_TARGET_VALUE);
                }
                if ((bigDecimal = sQLHelper.rs.getBigDecimal(_COST)) == null) continue;
                costMatrixInfo.setType("T");
                if (object == null || object2 == null) continue;
                costMatrixInfo.put(object, object2, bigDecimal);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            costMatrixInfo = CostMatrixInfo._NONE;
        }
        finally {
            sQLHelper.close();
        }
        return costMatrixInfo;
    }

    public static List<String> getGLMClassRefValues(Connection connection, String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(_GLM_CLASS_REFERENCE_VALUES_COMPLEMENTARY);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString("CLASS");
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            arrayList.clear();
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }
}

