/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.ModelLrb;

public class MiningModelSettings {
    String _owner;
    String _modelName;
    String _settingName;
    String _settingValue;
    String _settingType;

    public void setSettingValue(String string) {
        this._settingValue = string;
    }

    public void setSettingType(String string) {
        this._settingType = string;
    }

    public String getSettingType() {
        return this._settingType;
    }

    public static String translateModelSettingsName(String string) {
        return (String)ALL_MINING_MODEL_SETTINGS._SETTING_NAMES.get(string);
    }

    public static String translateModelSettingsValue(String string) {
        String string2 = (String)ALL_MINING_MODEL_SETTINGS._SETTING_VALUES.get(string);
        if (string2 == null) {
            string2 = ServerConstants.Algorithm.getUIAlgorithmName(string);
        }
        return string2;
    }

    public MiningModelSettings(String string, String string2, String string3, String string4, String string5) {
        this._owner = string;
        this._modelName = string2;
        this._settingName = string3;
        this._settingValue = string4;
        this._settingType = string5;
    }

    public static MiningModelSettings findSetting(String string, Vector<MiningModelSettings> vector) {
        MiningModelSettings miningModelSettings = null;
        for (MiningModelSettings miningModelSettings2 : vector) {
            if (!miningModelSettings2._settingName.equals(string)) continue;
            miningModelSettings = miningModelSettings2;
            break;
        }
        return miningModelSettings;
    }

    public void setOwner(String string) {
        this._owner = string;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public String getModelName() {
        return this._modelName;
    }

    public void setSettingName(String string) {
        this._settingName = string;
    }

    public String getSettingName() {
        return this._settingName;
    }

    public String getSettingValue() {
        return this._settingValue;
    }

    static class ALL_MINING_MODEL_SETTINGS {
        private static Hashtable<String, String> _SETTING_VALUES = new Hashtable();
        private static Hashtable<String, String> _SETTING_NAMES;
        public static String CLAS_WEIGHTS_TABLE_NAME;
        public static String CLAS_PRIORS_TABLE_NAME;
        public static String CLAS_COST_TABLE_NAME;

        ALL_MINING_MODEL_SETTINGS() {
        }

        static {
            _SETTING_VALUES.put("SVMS_GAUSSIAN", ModelLrb.get("SVMS_GAUSSIAN"));
            _SETTING_VALUES.put("SVMS_LINEAR", ModelLrb.get("SVMS_LINEAR"));
            _SETTING_VALUES.put("SVMS_AL_ENABLE", ModelLrb.get("SVMS_AL_ENABLE"));
            _SETTING_VALUES.put("SVMS_AL_DISABLE", ModelLrb.get("SVMS_AL_DISABLE"));
            _SETTING_VALUES.put("PREP_AUTO_OFF", ModelLrb.get("PREP_AUTO_OFF"));
            _SETTING_VALUES.put("PREP_AUTO_ON", ModelLrb.get("PREP_AUTO_ON"));
            _SETTING_VALUES.put("ON", ModelLrb.get("ON"));
            _SETTING_VALUES.put("OFF", ModelLrb.get("OFF"));
            _SETTING_VALUES.put("TREE_IMPURITY_ENTROPY", ModelLrb.get("TREE_IMPURITY_ENTROPY"));
            _SETTING_VALUES.put("TREE_IMPURITY_GINI", ModelLrb.get("TREE_IMPURITY_GINI"));
            _SETTING_VALUES.put("ODMS_MISSING_VALUE_MEAN_MODE", ModelLrb.get("ODMS_MISSING_VALUE_MEAN_MODE"));
            _SETTING_VALUES.put("ODMS_MISSING_VALUE_DELETE_ROW", ModelLrb.get("ODMS_MISSING_VALUE_DELETE_ROW"));
            _SETTING_VALUES.put("GLMS_RIDGE_REG_ENABLE", ModelLrb.get("GLMS_RIDGE_REG_ENABLE"));
            _SETTING_VALUES.put("GLMS_RIDGE_REG_DISABLE", ModelLrb.get("GLMS_RIDGE_REG_DISABLE"));
            _SETTING_VALUES.put("GLMS_VIF_RIDGE_ENABLE", ModelLrb.get("GLMS_VIF_RIDGE_ENABLE"));
            _SETTING_VALUES.put("GLMS_VIF_RIDGE_DISABLE", ModelLrb.get("GLMS_VIF_RIDGE_DISABLE"));
            _SETTING_NAMES = new Hashtable();
            _SETTING_NAMES.put("ALGO_NAME", ModelLrb.get("ALGO_NAME"));
            _SETTING_NAMES.put("SVMS_KERNEL_FUNCTION", ModelLrb.get("SVMS_KERNEL_FUNCTION"));
            _SETTING_NAMES.put("SVMS_CONV_TOLERANCE", ModelLrb.get("SVMS_CONV_TOLERANCE"));
            _SETTING_NAMES.put("SVMS_ACTIVE_LEARNING", ModelLrb.get("SVMS_ACTIVE_LEARNING"));
            _SETTING_NAMES.put("SVMS_COMPLEXITY_FACTOR", ModelLrb.get("SVMS_COMPLEXITY_FACTOR"));
            _SETTING_NAMES.put("SVMS_STD_DEV", ModelLrb.get("SVMS_STD_DEV"));
            _SETTING_NAMES.put("SVMS_KERNEL_CACHE_SIZE", ModelLrb.get("SVMS_KERNEL_CACHE_SIZE"));
            _SETTING_NAMES.put("NABS_PAIRWISE_THRESHOLD", ModelLrb.get("NABS_PAIRWISE_THRESHOLD"));
            _SETTING_NAMES.put("GLMS_CONF_LEVEL", ModelLrb.get("GLMS_CONF_LEVEL"));
            _SETTING_NAMES.put("GLMS_RIDGE_VALUE", ModelLrb.get("GLMS_RIDGE_VALUE"));
            _SETTING_NAMES.put("PREP_AUTO", ModelLrb.get("PREP_AUTO"));
            _SETTING_NAMES.put("TREE_IMPURITY_METRIC", ModelLrb.get("TREE_IMPURITY_METRIC"));
            _SETTING_NAMES.put("ODMS_MISSING_VALUE_TREATMENT", ModelLrb.get("ODMS_MISSING_VALUE_TREATMENT"));
            _SETTING_NAMES.put("TREE_TERM_MINREC_SPLIT", ModelLrb.get("TREE_TERM_MINREC_SPLIT"));
            _SETTING_NAMES.put("TREE_TERM_MINPCT_SPLIT", ModelLrb.get("TREE_TERM_MINPCT_SPLIT"));
            _SETTING_NAMES.put("GLMS_RIDGE_REGRESSION", ModelLrb.get("GLMS_RIDGE_REGRESSION"));
            _SETTING_NAMES.put("TREE_TERM_MINREC_NODE", ModelLrb.get("TREE_TERM_MINREC_NODE"));
            _SETTING_NAMES.put("NABS_SINGLETON_THRESHOLD", ModelLrb.get("NABS_SINGLETON_THRESHOLD"));
            _SETTING_NAMES.put("GLMS_VIF_FOR_RIDGE", ModelLrb.get("GLMS_VIF_FOR_RIDGE"));
            _SETTING_NAMES.put("GLMS_REFERENCE_CLASS_NAME", ModelLrb.get("GLMS_REFERENCE_CLASS_NAME"));
            _SETTING_NAMES.put("TREE_TERM_MAX_DEPTH", ModelLrb.get("TREE_TERM_MAX_DEPTH"));
            _SETTING_NAMES.put("ASSO_MAX_RULE_LENGTH", ModelLrb.get("ASSO_MAX_RULE_LENGTH"));
            _SETTING_NAMES.put("ASSO_MIN_SUPPORT", ModelLrb.get("ASSO_MIN_SUPPORT"));
            _SETTING_NAMES.put("ASSO_MIN_CONFIDENCE", ModelLrb.get("ASSO_MIN_CONFIDENCE"));
            _SETTING_NAMES.put("FEAT_NUM_FEATURES", ModelLrb.get("FEAT_NUM_FEATURES"));
            _SETTING_NAMES.put("NMFS_CONV_TOLERANCE", ModelLrb.get("NMFS_CONV_TOLERANCE"));
            _SETTING_NAMES.put("NMFS_NUM_ITERATIONS", ModelLrb.get("NMFS_NUM_ITERATIONS"));
            _SETTING_NAMES.put("NMFS_RANDOM_SEED", ModelLrb.get("NMFS_RANDOM_SEED"));
            _SETTING_NAMES.put("KMNS_BLOCK_GROWTH", ModelLrb.get("KMNS_BLOCK_GROWTH"));
            _SETTING_NAMES.put("CLUS_NUM_CLUSTERS", ModelLrb.get("CLUS_NUM_CLUSTERS"));
            _SETTING_NAMES.put("KMNS_NUM_BINS", ModelLrb.get("KMNS_NUM_BINS"));
            _SETTING_NAMES.put("KMNS_CONV_TOLERANCE", ModelLrb.get("KMNS_CONV_TOLERANCE"));
            _SETTING_NAMES.put("KMNS_MIN_PCT_ATTR_SUPPORT", ModelLrb.get("KMNS_MIN_PCT_ATTR_SUPPORT"));
            _SETTING_NAMES.put("KMNS_DISTANCE", ModelLrb.get("KMNS_DISTANCE"));
            _SETTING_NAMES.put("KMNS_SPLIT_CRITERION", ModelLrb.get("KMNS_SPLIT_CRITERION"));
            _SETTING_NAMES.put("KMNS_ITERATIONS", ModelLrb.get("KMNS_ITERATIONS"));
            _SETTING_NAMES.put("OCLT_SENSITIVITY", ModelLrb.get("OCLT_SENSITIVITY"));
            _SETTING_NAMES.put("OCLT_MAX_BUFFER", ModelLrb.get("OCLT_MAX_BUFFER"));
            CLAS_WEIGHTS_TABLE_NAME = "CLAS_WEIGHTS_TABLE_NAME";
            CLAS_PRIORS_TABLE_NAME = "CLAS_PRIORS_TABLE_NAME";
            CLAS_COST_TABLE_NAME = "CLAS_COST_TABLE_NAME";
        }
    }
}

